#include <stdio.h>
#include <assert.h>
#include "DxLib.h"
#include <math.h>

//==============================================================

// [NGÃTCYA^XN
#define WORK_SIZE 128
#define NUM_TASKS 10000
int image[16];//@摜zϐ錾
int Cr;//J[
int tama=0;//e
// ^XN̍\
struct TASK {
	
	// ֐ւ̃|C^
	void (*Func)(TASK* task);

	// Õ^XNւ̃|C^
	TASK* Prev;
	TASK* Next;
	
	// [NGA
	char Work[WORK_SIZE];
};

// ֐̌^錾
typedef void (*FUNC)(TASK* task);

// ^XN̘AXg
TASK* ActiveTask;
TASK* FreeTask;


//==============================================================

// ^XNXg̏
void InitTaskList() {
	
	// ^XNp̊m
	TASK* task=new TASK[NUM_TASKS+2];

	// ANeBu^XNXg̏
	ActiveTask=&task[0];
	ActiveTask->Prev=ActiveTask->Next=ActiveTask;

	// t[^XNXg̏
	FreeTask=&task[1];
	for (int i=1; i<NUM_TASKS+1; i++)
		task[i].Next=&task[i+1];
	task[NUM_TASKS+1].Next=FreeTask;
}

// ^XN̎s
void RunTask() {
	for (TASK *task=ActiveTask->Next, *next; 
		next=task->Next, task!=ActiveTask; task=next)
		(*task->Func)(task);
}

// ^XN̐
TASK* CreateTask(FUNC func) {

	// t[^XNXgȂΐ𒆎~
	if (FreeTask->Next==FreeTask) return NULL;

	// t[^XN1o
	TASK* task=FreeTask->Next;
	FreeTask->Next=task->Next;
	
	// ֐ƑO^XNւ̃|C^ݒ肷
	task->Func=func;
	task->Prev=ActiveTask->Prev;
	task->Next=ActiveTask;

	// O^XÑ|C^ύX
	task->Prev->Next=task;
	task->Next->Prev=task;
	
	// ^XNԂ
	return task;
}

// ^XN̍폜
void DeleteTask(TASK* task) {
	
	// ANeBu^XNXg^XN폜
	task->Prev->Next=task->Next;
	task->Next->Prev=task->Prev;
	
	// 폜^XNt[^XNXgɑ}
	task->Next=FreeTask->Next;
	FreeTask->Next=task;
}


//==============================================================
//e̊֐̃vg^Cv錾
void FuncMyShip(TASK* task);
void MyShipExplode(TASK* task);
void CreateMyShip(double x, double y, double r ,int hairetu, double ds);
// ẽ[NGA\
struct MYSHIP_WORK {
	double X, Y, VX, VY, R;//WAړʁApx
	int nXPos, nYPos, hairetu;//ˈʒuA摜Ipz
};

// ȅ֐
void FuncMyShip(TASK* task) {
	
	// assertgč\̂̃TCY`FbN
	assert(sizeof(MYSHIP_WORK)<=WORK_SIZE);

	// ėp̃[NGAւ̃|C^A
	//e[NGA\̂ւ̃|C^ɃLXg
	MYSHIP_WORK* work=(MYSHIP_WORK*)task->Work;

	// ȉł͎@[NGA\̂gāA
	// eɊւ鏈s
	work->X+=work->VX;//eړ
	work->Y+=work->VY;
	
	DrawRotaGraph( work->X,work->Y ,1.0, atan2(work->X-(work->nXPos),(work->nYPos)-work->Y) , image[work->hairetu] , TRUE  ) ;//e\
	
	if(work->X>= 572) 
		task->Func=MyShipExplode;//͂ݏoʂ
	else
	if(work->X<= 68) 
		task->Func=MyShipExplode;
	else
	if(work->Y>= 412) 
		task->Func=MyShipExplode;
	else
	if(work->Y<= 68) 
		task->Func=MyShipExplode;

}

//e̍폜
void MyShipExplode(TASK* task) {
	tama--;//e炷i\pj
		DeleteTask(task);//ANeBuXgt[Xgw
}

// e̐
void CreateMyShip(double x, double y, double r ,int hairetu, double ds) {//WxyAˊpxAI摜Ax
	// ^XN𐶐
	TASK* task=CreateTask(FuncMyShip);
	if (!task) return;
	
	// [NGAւ̃|C^LXg
	assert(sizeof(MYSHIP_WORK)<=WORK_SIZE);
	MYSHIP_WORK* work=(MYSHIP_WORK*)task->Work;

	//ȉAȅݒ
	work->R  = 0.1; //px
	work->VX = cos(r)*ds;//ړʌvZ
	work->VY = sin(r)*ds;

	// [NGAɏlݒ肷
	tama++;//e𑝂₷i\pj
	work->X=x;//W
	work->Y=y;
	work->nXPos=x;//ˈʒu
	work->nYPos=y;
	work->hairetu=hairetu;//I摜
}



//FPS̊֐̃vg^Cv錾
void CreateFps();
void fps(TASK* task);
//Fps̍\
struct FPS_WORK {
	int FpsTime[2],FpsTime_i;
    double Fps;
};

// Fps^XN̐
void CreateFps() {
	
	// ^XN𐶐
	TASK* task=CreateTask(fps);
	if (!task) return;
	
	// [NGAւ̃|C^LXg
	assert(sizeof(FPS_WORK)<=WORK_SIZE);
	FPS_WORK* work=(FPS_WORK*)task->Work;

	// [NGAɏlݒ肷
	work->FpsTime[0]=0;
	work->FpsTime[1]=0;
	work->FpsTime_i=0;
	work->Fps=0.0;
}

void fps(TASK* task){	
	// assertgč\̂̃TCY`FbN
	assert(sizeof(FPS_WORK)<=WORK_SIZE);

	// ėp̃[NGAւ̃|C^A
	// @[NGA\̂ւ̃|C^ɃLXg
	FPS_WORK* work=(FPS_WORK*)task->Work;

        if(work->FpsTime_i== 0)
                work->FpsTime[0]=GetNowCount();                           //1ڂ̎Ԏ擾
        if(work->FpsTime_i==49){
                work->FpsTime[1]=GetNowCount();                           //50ڂ̎Ԏ擾
                work->Fps = 1000.0f / ((work->FpsTime[1] - work->FpsTime[0]) / 50.0f);//肵lfpsvZ
                work->FpsTime_i=0;
        }
        else
                work->FpsTime_i++;                                          //݉ڂJEg
        if(work->Fps != 0)
        DrawFormatString(417,20,Cr,"FPS %.1f",work->Fps); //fps\
/*`*/
	Cr = GetColor( 255 , 255 , 255 ) ;	// F̒l擾
	DrawLine( 80 , 80 , 560 , 80 , Cr ) ;	// `
	DrawLine( 80 , 400, 560 ,400 , Cr ) ;	// `
	DrawLine( 80, 80  , 80  ,400 , Cr ) ;	// `
	DrawLine( 560,80  , 560 ,400 , Cr ) ;	// `
/*`悱܂*/

}


// eXgp̃C[`F
// @ƓG𐶐ēB
int WINAPI WinMain( HINSTANCE hInstance, HINSTANCE hPrevInstance,LPSTR lpCmdLine, int nCmdShow ){
char Key[256];//L[
double r=0.3;//px
double ds=3.0;//x
double r0=0.;//pxp
double r1=0.;//pxԗp
if( ChangeWindowMode(TRUE) != DX_CHANGESCREEN_OK || DxLib_Init() == -1 ) return -1; //EBhEƏ
SetDrawScreen( DX_SCREEN_BACK ) ;                                                 //`𗠉ʂɐݒ
LoadDivGraph( "tama.png" , 9 , 9 , 1 , 24 , 24 , image ) ;//摜𕪊imagezɕۑ
InitTaskList();//^XNXg
CreateFps();//Fps\

while(!ProcessMessage() && !ClearDrawScreen() && !GetHitKeyStateAll( Key ) && !Key[KEY_INPUT_ESCAPE]){
//үޏ        ʂر         ްޓ͏Ԏ擾       ESCƏI

CreateMyShip(208,228,r0+=r, 0, ds);//e
CreateMyShip(408,228,r1-=r, 1, ds);//Ԓe

/*L[{[h*/
if( Key[ KEY_INPUT_Z   ]  == 1 ) r-=0.001;//ˊԊuύX
if( Key[ KEY_INPUT_A   ]  == 1 ) r+=0.001;
if( Key[ KEY_INPUT_X   ]  == 1 ) ds=ds-0.01;//GeXs[hύX
if( Key[ KEY_INPUT_S   ]  == 1 ) ds=ds+0.01;
if(ds<0.1) ds=0.1;//0ŏZ
DrawFormatString(80,0,Cr,"ˊpx %.03f",r); //hassya\
DrawFormatString(80,20,Cr,"Gex %.02f",ds); //ds\
DrawFormatString(417,0,Cr,"Ge %d",tama); //tamakazu\
DrawString( 80,440,"AZœGeˊpxύX",Cr );
DrawString( 80,460,"SXœGexύX",Cr );
/*L[{[h*/

RunTask();//^XNs

ScreenFlip();
}
DxLib_End();
return 0;
}