
library(ggplot2)
dyn.load("test.so")


fun <- function(N) {
    
    cat("N =", N, "...\n")
    
    cat("  R...\n")
    t <- proc.time()
    out <- 0
    for (i in 1:N) {
        for (j in 1:N) {
            out <- out + i - j
        }
    }
    tr <- proc.time() - t
    tr <- tr["elapsed"]
    cat("    result =", out, "\n")
    cat("    time =", tr, "\n")
    
    
    
    cat("  python...\n")
    cmd <- paste("python test.py", N)
    t <- proc.time()
    system(cmd)
    tp <- proc.time() - t
    tp <- tp["elapsed"]
    out <- as.numeric(scan("test.out", quiet=T))
    cat("    result =", out, "\n")
    cat("    time =", tp, "\n")
    
    
    cat("  C...\n")
    t <- proc.time()
    ans <- .C("test", n=as.integer(N), out=as.integer(0))
    tc <- proc.time() - t
    tc <- tc["elapsed"]
    cat("    result =", ans$out, "\n")
    cat("    time =", tc, "\n")

    
    out <- data.frame(N, tr, tp, tc)
    return(out)
    
}



x <- NULL
for (k in seq(1000, 10000, by=1000)) {
    N <- k
    
    df <- fun(N)
    if (is.null(x)) {
        x <- df
    } else {
        x <- rbind(x, df)
    }
}

tmp <- x[,c(1,2)]
names(tmp)[2] <- "time"
tmp$program <- "R"

tmp2 <- x[,c(1,3)]
names(tmp2)[2] <- "time"
tmp2$program <- "python"
tmp <- rbind(tmp, tmp2)

tmp2 <- x[,c(1,4)]
names(tmp2)[2] <- "time"
tmp2$program <- ".C"
tmp <- rbind(tmp, tmp2)

y <- tmp
y$program <- as.factor(y$program)
a <- ggplot(y, aes(x=N, y=time))
a <- a + geom_point(size=4, aes(shape=program, colour=program))
a <- a + geom_smooth(aes(group=program))
a <- a + scale_y_log10() + scale_x_log10()
a <- a + xlab("N") + ylab("time (sec)") 
a <- a + opts(title="Time for N^2 add and subtract")
a



