#ifndef _MESSAGE_CHECKER_H_
#define _MESSAGE_CHECKER_H_
// CONFIG += console
#include <QObject>
#include <QEvent>
#include <QString>

class MessageChecker : public QObject
{
public:
	enum OUTPUT_TYPE{
		OUTPUT_MOUSEEVENT		= 0x00000001,			// }EXCxg\
		OUTPUT_KEYEVENT			= 0x00000002,			// L[Cxg\
		OUTPUT_SYSEVENT			= 0x00000004,			// EBhEɊւCxg\
		OUTPUT_PAINTEVENT		= 0x00000100,			// \֘ÃCxg
		OUTPUT_EVENTNUM			= 0x20000000,			// Cxgԍ̕\
		OUTPUT_OBJECTNAME		= 0x40000000,			// IuWFNg\
		OUTPUT_OTHER			= 0x80000000,
		OUTPUT_ALL				= 0xFFFFFFFF,			//S
	};
	explicit MessageChecker(QObject *parent = 0);		// RXgN^
	virtual ~MessageChecker(){};						// fXgN^
	static MessageChecker *instance();					// g̃|C^擾
	static void Install(QObject *obj);					// installEventFilter
	static void Uninstall(QObject *obj);				// removeEventFilter
	static void setOutputFlag(int output){				// \[h̐ݒ
		m_OutputFlag |= output;
	}
	static void removeOutputFlag(int output){			// \[hύX
		m_OutputFlag &= ~output;
	}
protected:
	// CxgtB^Cxg̋Lq
	bool eventFilter(QObject *obj, QEvent *event);		// CxgsOɗtB^
private:
	void showDebugMessage(const char *mes);
private:
	static int m_OutputFlag;								// bZ[W\tO ftHgALL
	static MessageChecker *m_safe;						// g̃|C^
	int m_drawMes;										// qDebugŃbZ[Woꍇ
};

#endif
