package collada;

import javafx.scene.Group;
import javafx.scene.Node;
import javafx.scene.transform.Affine;

/**
 * Colladaファイルのジオメトリを表すクラス
 * @author tomo
 *
 */
public class DaeGeometry extends DaeObject
{
    // メッシュのルートグループ
    Group   root        = new Group();
    
    // バインド時の変換
    Affine  bindAffine  = null;
    
    /**
     * 子要素を追加
     * @param node
     */
    public void add( Node node )
    {
        root.getChildren().add( node );
    }
    
    /**
     * バインド時変換を適用して、ジオメトリを返す
     * @return
     */
    public Group getRoot()
    {
        // 変換をクリア
        this.root.getTransforms().clear();
        
        // 変換を適用
        if( this.bindAffine != null )
        { this.root.getTransforms().add( this.bindAffine ); }
        
        return this.root;
    }
    
    // ここから下は単純なgetter/setter

    public void setBindAffine(Affine bindAffine)
    {
        this.bindAffine = bindAffine;
    }

    public void setRoot(Group root) {
        this.root = root;
    }

    public Affine getBindAffine() {
        return bindAffine;
    }

    
    
}
