package collada;

import java.io.File;
import java.math.BigInteger;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;

import org.collada._2005._11.colladaschema.COLLADA;
import org.collada._2005._11.colladaschema.COLLADA.Scene;
import org.collada._2005._11.colladaschema.CommonColorOrTextureType;
import org.collada._2005._11.colladaschema.CommonNewparamType;
import org.collada._2005._11.colladaschema.Controller;
import org.collada._2005._11.colladaschema.Effect;
import org.collada._2005._11.colladaschema.FloatArray;
import org.collada._2005._11.colladaschema.FxSampler2DCommon;
import org.collada._2005._11.colladaschema.Geometry;
import org.collada._2005._11.colladaschema.Image;
import org.collada._2005._11.colladaschema.InputLocal;
import org.collada._2005._11.colladaschema.InputLocalOffset;
import org.collada._2005._11.colladaschema.InstanceController;
import org.collada._2005._11.colladaschema.LibraryControllers;
import org.collada._2005._11.colladaschema.LibraryEffects;
import org.collada._2005._11.colladaschema.LibraryGeometries;
import org.collada._2005._11.colladaschema.LibraryImages;
import org.collada._2005._11.colladaschema.LibraryMaterials;
import org.collada._2005._11.colladaschema.LibraryVisualScenes;
import org.collada._2005._11.colladaschema.Material;
import org.collada._2005._11.colladaschema.Matrix;
import org.collada._2005._11.colladaschema.Mesh;
import org.collada._2005._11.colladaschema.Node;
import org.collada._2005._11.colladaschema.Polylist;
import org.collada._2005._11.colladaschema.ProfileCOMMON;
import org.collada._2005._11.colladaschema.ProfileCOMMON.Technique;
import org.collada._2005._11.colladaschema.ProfileCOMMON.Technique.Lambert;
import org.collada._2005._11.colladaschema.Skin;
import org.collada._2005._11.colladaschema.Source;
import org.collada._2005._11.colladaschema.VisualScene;

import javafx.scene.Group;
import javafx.scene.paint.Color;
import javafx.scene.paint.PhongMaterial;
import javafx.scene.shape.MeshView;
import javafx.scene.shape.TriangleMesh;
import javafx.scene.transform.Affine;
import javafx.scene.transform.MatrixType;

/**
 * Collada ver1.4.1を読み込むクラス
 * @author tomo
 *
 */
public class Dae141FileLoader
{   
    ///**
    // * テスト用
    // * @param args
    // * @throws JAXBException 
    // */
    //public static void main( String[] args ) throws JAXBException
    //{
    //    // ファイルから読込
    //    //File        f       = new File( "3dmodel/KioMiku_blender_20091010/Miku_1_5_1_20091010.dae" );
    //    //COLLADA     root    = JAXB.unmarshal( f , COLLADA.class );
    //    
    //    // 
    //    JAXBContext     jc              = JAXBContext.newInstance( "org.collada._2005._11.colladaschema" );
    //    Unmarshaller    unmarshaller    = jc.createUnmarshaller();
    //    COLLADA         root            = (COLLADA) unmarshaller.unmarshal( new File( "3dmodel/KioMiku_blender_20091010/Miku_1_5_1_20091010.dae" ) );
    //
    //
    //    // ノードの一覧を出力
    //    System.out.println( "ノード一覧" );
    //    root.getLibraryAnimationsAndLibraryAnimationClipsAndLibraryCameras()
    //        .stream()
    //        .filter( o -> o instanceof LibraryGeometries )
    //        .forEach( o -> ( (LibraryGeometries) o ).getGeometries()
    //                            .stream()
    //                            .forEach( o2 -> System.out.println( o2.getName() ) )
    //                       );
    //}
    
    // リソースの基準ディレクトリ
    private static File                             baseDirectory   = null; // 画像などを取得する際の基準ディレクトリ
    
    // Colladaファイル内オブジェクト用のマップ
    private static DaeIDMap                         idMap           = null;
    
    // 各種マップ
    private static Map<String,CommonNewparamType>   newparamTagMap  = null; // newparamタグのマップ
    private static Map<String,DaeNode>              nodeMap         = null; // 読み込んだDaeNodeのマップ
    
    
    /**
     * クラスのインスタンス化を防ぐ
     */
    private Dae141FileLoader(){};
    
    /**
     * daeファイルを指定して、ColladaDataを作成
     * @param fileName
     * @return
     * @throws Exception 
     */
    public static ColladaData load( String fileName ) throws Exception
    {
        // 戻り値を作成
        ColladaData data        = new ColladaData();
        COLLADA     collada     = null;
        
        // クラスを初期化
        File        f           = new File( fileName );
        init( f );
        
        // ファイルから読み込み
        try {
            // 読込パッケージを決定
            String          packageName     = "org.collada._2005._11.colladaschema";
            
            // XMLパーサを作成
            JAXBContext     jc              = JAXBContext.newInstance( packageName );
            Unmarshaller    unmarshaller    = jc.createUnmarshaller();
           
            // JAXBを利用して、ファイルからインスタンスを作成
            collada            = (COLLADA) unmarshaller.unmarshal( f );
            
        } catch (JAXBException e) {
            e.printStackTrace();
        }
        
        // タグの読込開始
        // ルートタグであるColladaから読込開始
        loadColladaTag( collada , data );
        
        // 作成したColladaDataを返す
        return data;
    }
    
    /**
     * クラス変数の初期化
     */
    private static void init( File f )
    {
        // リソースの基準ディレクトリを取得
        baseDirectory   = new File( f.getParent() );
        
        // 各種マップを初期化
        Dae141FileLoader.idMap              = new DaeIDMap();
        
        Dae141FileLoader.nodeMap            = new HashMap<>();
        
        // newparamはsidを利用するため、ここで定義
        Dae141FileLoader.newparamTagMap     = new HashMap<>();
        
    }
    
    /**
     * DAEファイルからメッシュを抽出する
     * @param collada
     * @return
     * @throws Exception 
     */
    private static void loadColladaTag( final COLLADA collada , ColladaData data ) throws Exception
    {        
        // 子要素assetを処理(1回)
        
        // 『library_○○』タグを処理(0回以上)
        for( Object o : collada.getLibraryAnimationsAndLibraryAnimationClipsAndLibraryCameras()  )
        {
            // インスタンスの変換
            if( o instanceof LibraryGeometries )
            {
                // 子要素Library_geometriesを処理
                // 型変換
                LibraryGeometries   libraryGeometries   = (LibraryGeometries) o;
                
                // タグの処理
                // プロパティidを処理
                // プロパティnameを処理
                // 子要素assetを処理(0or1)
                // 子要素extraを処理(0以上)
                
                // 子要素ジオメトリを取得
                for( Geometry geometry : libraryGeometries.getGeometries() )
                {
                    // ジオメトリを作成
                    DaeGeometry daeGeometry     = new DaeGeometry();
                    
                    // プロパティidを処理
                    daeGeometry.setId( geometry.getId() );

                    // プロパティnameを処理
                    // 子要素assetを処理(0or1)
                    // 子要素geometri_elementを処理(1)
                    {
                        // convex_mesh
                        // mesh
                        if( geometry.getMesh() != null )
                        { daeGeometry.setRoot( loadMeshTag( geometry.getMesh() , geometry.getName() ) ); }
                        
                        // spline
                        // brep
                    }
                    
                    // 子要素extraを処理(0以上)
                    
                    //登録
                    idMap.put( daeGeometry.getId() , daeGeometry );
                        
                    //debug
                    //System.out.println( "【geometry】\t" + geometry.getName() );
                    
                }
                
            }else if ( o instanceof LibraryImages )
            {
                // 子要素Library_imagesを処理
                // 型変換
                LibraryImages   libraryImages   = (LibraryImages) o;
                
                // プロパティidを処理
                // プロパティsidを処理
                // プロパティnameを処理
                // 子要素assetを処理(0or1)
                // 子要素imageを取得(1以上)
                for( Image image : libraryImages.getImages() )
                {
                    // DaeImageオブジェクトを作成
                    DaeImage    daeImage    = loadImageTag( image );
                    
                    // 登録
                    idMap.put( daeImage.getId() , daeImage );
                    
                }
                
                // 子要素extraを処理(0以上)
                
            }else if ( o instanceof LibraryEffects )
            {
                // 子要素Library_effectsを処理
                // 型変換
                LibraryEffects    libraryEffects   = (LibraryEffects) o;
                
                // プロパティidを処理
                // プロパティnameを処理
                // 子要素assetを処理(0or1)
                // 子要素effectを取得(1以上)
                for( Effect effect : libraryEffects.getEffects() )
                {
                    // effectタグを処理
                    DaeEffect   daeEffect   = loadEffectTag( effect );
                    idMap.put( daeEffect.getId() , daeEffect );
                }
                
                // 子要素extraを処理(0以上)
                
            }else if ( o instanceof LibraryMaterials )
            {
                // 子要素Library_materialsを処理
                // 型変換
                LibraryMaterials    libraryMaterials   = (LibraryMaterials) o;
                
                // プロパティidを処理
                // プロパティnameを処理
                // 子要素assetを処理(0or1)
                // 子要素materialを取得(1以上)
                for( Material material : libraryMaterials.getMaterials() )
                {
                    // Materialタグを処理
                    DaeMaterial daeMaterial = loadMaterialTag( material );
                    idMap.put( daeMaterial.getId() , daeMaterial );
                }
                
                // 子要素extraを処理(0以上)
            }else if ( o instanceof LibraryControllers )
            {
                // 子要素Library_controllersを処理
                // 型変換
                LibraryControllers  libraryControllers  = (LibraryControllers) o;
                
                //プロパティidを処理
                //プロパティnameを処理
                //子要素assetを処理(0or1)
                //子要素controllerを処理(1以上)
                for( Controller controller : libraryControllers.getControllers() )
                {
                    //コントローラを作成
                    DaeController   daeController   = new DaeController();
                    
                    //プロパティidを処理
                    daeController.setId( controller.getId() );
                    
                    //プロパティnameを処理
                    //子要素assetを処理(0or1)
                    //子要素skinを処理(?)
                    if( controller.getSkin() != null )
                    {
                        // 変数取得
                        Skin    skin        = controller.getSkin();
                        
                        //プロパティsourceを処理
                        String      url         = getLinkStr( skin.getSource() );
                        DaeGeometry daeGeometry = idMap.get( url , DaeGeometry.class ).orElseThrow( () -> new Exception("GeometryID:" + url + "が見つかりません") );
                        
                        //子要素bind_shape_matrix(0or1)
                        if( skin.getBindShapeMatrix() != null )
                        {
                            // なぜかDouble型がString型として認識されるため、処理変更
                            List<Double>    bindMatrix          = skin.getBindShapeMatrix();
                            double[]        bindMatrixArray     = new double[16];
                            for( int i=0 ; i<16 ; i++ )
                            {   String      d       = "" + bindMatrix.get( i );
                                bindMatrixArray[i]  = new Double( d ).doubleValue(); }
                            Affine          bindAffine          = new Affine( bindMatrixArray , MatrixType.MT_3D_4x4 , 0 );
                            daeGeometry.setBindAffine( bindAffine );
                        }
                        
                        //子要素source(3以上)
                        //子要素joints(1)
                        //子要素vertex_weights(1)
                        //子要素extre(0以上)
                        
                        // ジオメトリを登録
                        daeController.setDaeGeometry( daeGeometry );
                        
                    }
                    
                    //子要素morphを処理(?)
                    //子要素extraを処理
                    
                    //コントローラの登録
                    idMap.put( daeController.getId() , daeController );
                    
                }
                
                //子要素extraを処理(0以上)
                
                
            }else if ( o instanceof LibraryVisualScenes )
            {
                // 型変換
                LibraryVisualScenes libraryVisualScenes = (LibraryVisualScenes) o;
                

                // プロパティidを処理
                // プロパティnameを処理
                // 子要素Visual_sceneを処理(1以上)
                for( VisualScene visualScene : libraryVisualScenes.getVisualScenes() )
                {
                    // シーン・オブジェクトを作成
                    DaeVisualScene    daeScene    = new DaeVisualScene();
                    
                    // プロパティidを処理
                    daeScene.setId( visualScene.getId() );
                    
                    // プロパティnameを処理
                    daeScene.setName( visualScene.getName() );
                    
                    // 子要素assetを処理(0or1)
                    // 子要素nodeを処理(1以上)
                    {
                        // ルートノードを作成・登録
                        DaeNode daeNodeRoot     = new DaeNode();
                        daeScene.setDaeNodeRoot( daeNodeRoot );
                        
                        // 子ノードを作成・登録
                        for( Node nodeTag  : visualScene.getNodes() ){ daeNodeRoot.getChildren().add( loadNodeTag( nodeTag ) ); }
                        daeScene.getDaeNodeMap().putAll( nodeMap );
                    }
                    
                    // 子要素evaluate_sceneを処理(0以上)
                    // 子要素extraを処理(0以上)
                    
                    // VisualSceneを登録
                    idMap.put( daeScene.getId() , daeScene );
                }
                
                // 子要素assetを処理(0or1)
                // 子要素extraを処理(0以上)
                
            }else
            {
                // 子要素Library_animation_clipsを処理
                // 子要素Library_animationsを処理
                // 子要素Library_articulated_systemsを処理
                // 子要素Library_camerasを処理
                // 子要素Library_force_fieldsを処理
                // 子要素Library_formulasを処理
                // 子要素Library_jointsを処理
                // 子要素Library_kinematics_modelsを処理
                // 子要素Library_kinematics_scenesを処理
                // 子要素Library_lightsを処理
                // 子要素Library_nodesを処理
                // 子要素Library_physics_materialsを処理
                // 子要素Library_physics_modelsを処理
                // 子要素Library_physice_scenesを処理
            }
        }
        
        // 子要素Sceneを処理(0or1)
        if ( collada.getScene() != null )
        {
            // 変数に格納
            Scene   scene       = collada.getScene();
            
            // 子要素sceneを処理(0or1)
            // 子要素instance_physics_sceneを処理(0以上)
            // 子要素instance_visual_sceneを処理(0or1)
            if( scene.getInstanceVisualScene() != null )
            {                    
                // プロパティsidを処理
                // プロパティnameを処理
                // プロパティurlを処理
                String          url         = getLinkStr( scene.getInstanceVisualScene().getUrl() );
                DaeVisualScene  daeScene    = idMap.get( url , DaeVisualScene.class )
                                                   .orElseThrow( () -> new Exception("シーンID:"+ url + "が存在しません") );
                data.putScene( daeScene.getId() , daeScene );
                // 子要素extraを処理(0以上)
                
            }
            
            // 子要素extraを処理(0以上)
            
        }
        // 子要素extraを処理(0以上)
        
    }
    
    
    /**
     * イメージタグを読み込む
     * @param image
     * @return
     */
    private static DaeImage loadImageTag( Image image )
    {
        // 戻り値を作成
        DaeImage                    daeImage    = new DaeImage();
        
        // プロパティidを処理
        daeImage.setId( image.getId() );
        
        // プロパティnameを処理
        daeImage.setName( image.getName() );
        
        // プロパティformatを処理
        // プロパティheightを処理
        // プロパティwidthを処理
        // プロパティdepthを処理
        // 子要素assetを処理(0or1)
        // 子要素dataを処理(0or1)
        // 子要素init_fromを処理(0or1)
        if( image.getInitFrom() != null )
        {
            // 画像URLを取得
            // TODO テクスチャの直接指定。どうやら、luka.pngはテクスチャで他はエフェクト用のテクスチャ
            String  filename    = image.getInitFrom();
            String  url         = baseDirectory.toURI() + filename;
        
            // 画像読込
            javafx.scene.image.Image img = null;
            img                 = new javafx.scene.image.Image( url );
            
            // 登録
            daeImage.setImage( img );
        }
       
        // 子要素extraを処理(0以上)
        
        return daeImage;
    }
    
    /**
     * ノードタグを読み込む
     * @param node
     * @return
     * @throws Exception 
     */
    private static DaeNode loadNodeTag( Node nodeTag ) throws Exception
    {
        // ノード情報保持クラスを作成
        DaeNode    daeNode      = null;
        
        // TYPE=JOINTの場合はJointBoneクラスでインスタンス化
        if( ( nodeTag.getType() != null ) && ( nodeTag.getType().value().equalsIgnoreCase( "JOINT" ) ) )
        { daeNode   = new DaeNodeJoint(); }
        else
        { daeNode   = new DaeNode(); }
        
        // プロパティidを処理
        if( nodeTag.getId() != null ){ daeNode.setId( nodeTag.getId() ); }
        
        // プロパティnameを処理
        if( nodeTag.getName() != null ){ daeNode.setName( nodeTag.getName() ); }
        
        // プロパティsidを処理
        if( nodeTag.getSid() != null ){ daeNode.setSid( nodeTag.getSid() ); }
        
        // プロパティtypeを処理
        if( nodeTag.getType() != null ){ daeNode.setType( nodeTag.getType().value() ); }
        
        // 子要素assetを処理(0or1)
        // 子要素を処理
        for( Object o2 : nodeTag.getLookatsAndMatrixesAndRotates() )
        {
            if( o2 instanceof Matrix )
            {
                // 子要素matrixを処理(0以上)
                Matrix  matrix      = (Matrix) o2 ;
                
                // 値を取得
                double[][]  tmp     = new double[4][4];
                for( int y=0 ; y<4 ; y++ )
                    for( int x=0 ; x<4 ; x++ )
                        tmp[y][x]   = matrix.getValues().get( 4 * y + x );
                
                // ノードに値を設定
                daeNode.setMatrix( tmp );
                
            }else{
                // 子要素lookatを処理(0以上)
                // 子要素rotateを処理(0以上)
                // 子要素scaleを処理(0以上)
                // 子要素skewを処理(0以上)
                // 子要素translateを処理(0以上)
            }
            
        }
        
        // 子要素instance_cameraを処理(0以上)
        // 子要素instance_controllerを処理(0以上)
        for( InstanceController instanceController : nodeTag.getInstanceControllers() )
        {   
            //プロパティsidを処理
            //プロパティnameを処理
            //プロパティurlを処理
            String          url             = getLinkStr( instanceController.getUrl() );
            DaeController   controller      = idMap.get( url , DaeController.class ).orElseThrow( () -> new Exception("ControllerID:" + url + "を見つけられませんでした。") );
            daeNode.setGeometry( controller.getDaeGeometry() );
            
            //子要素skentonを処理(0以上)
            //子要素bind_materialを処理(0or1)
            //子要素extraを処理(0以上)
            
        }
        
        // 子要素instance_geometryを処理(0以上)
        // 子要素instance_lightを処理(0以上)
        // 子要素instance_nodeを処理(0以上)
        // 子要素extraを処理(0以上)
        
        // DaeNodeの登録
        if( daeNode.getId() != null ){ nodeMap.put( daeNode.getId() , daeNode ); }
        
        // 子要素nodeを処理(0以上)
        for( Node childNodeTag : nodeTag.getNodes() )
        {
            // NODEタイプの処理
            DaeNode  childDaeNode   = loadNodeTag( childNodeTag );
            
            // 子ノードとして登録
            if( childDaeNode != null )
            { 
                daeNode.getChildren().add( childDaeNode ); 
                childDaeNode.setParentTransform( daeNode.getGrobalTransforms() );
            }
            
        }
        
        // ジョイントの場合のみインスタンスを返す
        return daeNode;
    }
    
    /**
     * メッシュタグを処理する
     * @param mesh
     * @throws Exception 
     */
    private static Group loadMeshTag( Mesh mesh , String name ) throws Exception
    {
        // メッシュビューを作成
        Group   root        = new Group();
        root.setId( name );
        
        // 子要素sourceを処理(1以上)
        // ここでは処理せず、キーに紐付ける
        Map<String,Source>  sources = new HashMap<>();
        for( Source source : mesh.getSources() )
        {
            // ソースをIDで取得できるようマップに登録
            String  key = source.getId();
            sources.put( key , source );
        }
        
        // 子要素verticesを処理(1)
        Map<String,float[]> vertices    = new HashMap<>();
        String              verticesID  = mesh.getVertices().getId();
        {   
            // プロパティidを処理
            // プロパティnameを処理
            // 子要素inputを処理(1以上)
            for( InputLocal in : mesh.getVertices().getInputs() )
            {
                // プロパティsemanticを処理
                if( ! in.getSemantic().equalsIgnoreCase( "POSITION" ) ){ throw new RuntimeException( "対応していません。" ); }
    
                // プロパティsourceを処理
                Source  s   = sources.get( getLinkStr( in.getSource() ) );
                vertices.put( verticesID , getFloatArrayFromSourceTag( s ) );
            }
        }
        
        // 子要素extraを処理(0以上)
        
        // 子要素primitive_elementsを処理(0以上)
        for( Object o : mesh.getLinesAndLinestripsAndPolygons() )
        {
            // lines
            // linestrips
            // polygons
            // polylist
            if( o instanceof Polylist )
            {
                // Polylist型に型変換
                Polylist    polylist    = (Polylist) o;
                
                // プロパティcount(=三角形の数)を処理(1)
                int cnt         = polylist.getCount().intValue();
                
                // 頂点配列・面配列を作成
                float[]     points      = null;
                float[]     texCoords   = null;
                float[]     colors      = null;
                int[]       faces       = new int[ cnt * 2 * 3 ];
                
                // オフセットの最大値を取得
                int vertexOffset    = 0;
                int textureOffset   = 0;
                int normalOffset    = 0;
                int offsetMax       = 0;
                
                // プロパティnameを処理(0or1)
                
                // 子要素inputを処理(0以上)
                for( InputLocalOffset in : polylist.getInputs() )
                {
                    // オフセットを取得
                    int         offset  = in.getOffset().intValue();
                    
                    // 各オフセットを取得
                    if( in.getSemantic().equalsIgnoreCase( "VERTEX" ) ){
                        // 頂点情報を取得
                        points          = vertices.get( getLinkStr( in.getSource() ) );
                        vertexOffset    = offset;
                    }else if ( in.getSemantic().equalsIgnoreCase( "NORMAL" ) ){
                        // 法線情報を取得
                        normalOffset    = offset;
                    }else if( in.getSemantic().equals( "TEXCOORD" ) ){
                        // テクスチャ情報を取得
                        // colladaはマルチテクスチャに対応していないので、
                        // テクスチャ座標が複数ある場合を考慮しない
                        if( texCoords == null )
                        {
                            Source      s   = sources.get( getLinkStr( in.getSource() ) );
                            texCoords       = getFloatArrayFromSourceTag( s );
                            textureOffset   = offset;
                        }
                    }else if( in.getSemantic().equals( "COLOR" ) ){
                        // 色情報を取得
                        //TODO テクスチャ色
                        //// ただし、頂点毎に色が設定できないため代表色を利用するだけ
                        //Source      s   = sources.get( getLinkStr( in.getSource() ) );
                        //colors          = getFloatArrayFromSourceTag( s );
                    }else { throw new RuntimeException( "対応していません" + in.getSemantic() ); }
                    
                    // オフセットの最大値を更新
                    offsetMax   = ( offsetMax < offset )? offset : offsetMax ;
                    
                }
                
                // 子要素vcountを処理(0or1)
                List<BigInteger>    vcnt    = polylist.getVcount();
                
                // 子要素pを処理(0or1)＝面配列を取得
                List<BigInteger>    p       = polylist.getP();
                for( int i=0 ; i< cnt*3 ; i++ )
                {
                    // なぜかList<BigInteger>にString型が格納されているため、
                    // キャストを含めて、一時変数に落とす
                    //BigInteger tmpBig = new BigInteger( "" + vcnt.get( i ) );
                    
                    // i番目の面を指す数値が、何番目に登録されているかを計算
                    int indexV          = ( offsetMax + 1 ) * i + vertexOffset;
                    int indexT          = ( offsetMax + 1 ) * i + textureOffset;
                    
                    // なぜかList<BigInteger>にString型が格納されているため、
                    // キャストを含めて、一時変数に落とす
                    BigInteger tmpBigV  = new BigInteger( "" + p.get( indexV ) );
                    BigInteger tmpBigT  = new BigInteger( "" + p.get( indexT ) );
                    
                    // 頂点・座標のインデックスを取得
                    int     v           = tmpBigV.intValue();
                    int     t           = tmpBigT.intValue();
                    
                    // 面配列に値を追加
                    faces[ i*2 ]        = v;
                    faces[ i*2 + 1 ]    = t;
                }
                
                // 子要素extraを処理(0以上)
                                
                // メッシュを構築
                MeshView        view            = new MeshView();
                TriangleMesh    triangleMesh    = new TriangleMesh();
                if( points != null && faces != null )
                {
                    //TODO ST座標系（右手座標系・左下が[0,0]）→UT座標系（左上が[0,0]）
                    // テクスチャ座標系を修正
                    if( texCoords == null )
                    {
                        float[] defTex  = { 0.0f , 0.0f };
                        texCoords       = defTex;
                    }else{
                        for( int i = 1 ; i < texCoords.length-1 ; i = i + 2 ){ texCoords[i]    = 1.0f - texCoords[i];}
                    }
                    
                    // メッシュビューの作成
                    triangleMesh.getPoints().addAll( points );
                    triangleMesh.getTexCoords().addAll( texCoords );
                    triangleMesh.getFaces().addAll( faces );
                    view.setMesh( triangleMesh );
                    view.setId( name );
                    root.getChildren().add( view );
                    
                    //debug
                    //System.out.println( name );
//                    System.out.print( "vertex:");
//                    for( float f : points ){ System.out.print( " , " + f ); }
//                    System.out.println();
//                    
//                    System.out.print( "texCoords:");
//                    for( float f : texCoords ){ System.out.print( " , " + f ); }
//                    System.out.println();
//                    
//                    System.out.print( "faces:");
//                    for( int i : faces ){ System.out.print( " , " + i ); }
//                    System.out.println();
                    
                }
                
                // プロパティmaterialを処理(0or1)
                if( polylist.getMaterial() != null )
                {
                    // マテリアルを取得
                    String          materialID  = getLinkStr( polylist.getMaterial() );
                    DaeMaterial     daeMaterial = idMap.get( materialID , DaeMaterial.class ).orElseThrow( () -> new Exception("material ID:" + materialID + "が見つかりません") );
                    PhongMaterial   material    = daeMaterial.getMaterial();
                    
                    // 色を設定
                    //TODO テクスチャ色
                    //if( colors != null )
                    //{
                    //    
                    //    int r       = (int)( 255.0f * colors[0] );
                    //    int g       = (int)( 255.0f * colors[1] );
                    //    int b       = (int)( 255.0f * colors[2] );
                    //    material.setDiffuseColor( Color.rgb( r , g , b ) );
                    //    System.out.println( "material:" + Color.rgb( r , g , b ) );
                    //}
                        
                    // マテリアルを設定
                    view.setMaterial( material );
                    
                }
            }
            // triangles
            // trifans
            // tristrips
            
            
            
        }
        
        // 子要素extraを処理(0以上)
        
        
        
        return root;
    }
    
    
    /**
     * マテリアルタグを元に、画面適用可能なマテリアルを作成
     * @param material
     * @return
     * @throws Exception 
     */
    private static DaeMaterial loadMaterialTag( Material material ) throws Exception
    {
        // DaeMaterialを作成
        DaeMaterial daeMaterial     = new DaeMaterial();
        
        //プロパティidを処理
        daeMaterial.setId( material.getId() );
        
        //プロパティnameを処理
        daeMaterial.setName( material.getName() );
        
        //子要素assetを処理(0or1)
        //子要素instance_effectを処理(1)
        String      effectID    = getLinkStr( material.getInstanceEffect().getUrl() );
        DaeEffect   daeEffect   = idMap.get( effectID , DaeEffect.class ).orElseThrow( () -> new Exception("effect ID:" + effectID + "が見つかりません。") );
        daeMaterial.setMaterial( daeEffect.getMaterial() );
        
        //子要素extraを処理(0以上)
       
        return daeMaterial;
    }
    
    /**
     * エフェクトタグから、JavaFXに適用可能なPhongMaterialを作成する
     * @param effect
     * @return
     * @throws Exception 
     */
    private static DaeEffect loadEffectTag( Effect effect ) throws Exception
    {
        // DaeEffectの作成
        DaeEffect   daeEffect       = new DaeEffect();
        
        //プロパティidを処理
        daeEffect.setId( effect.getId() );
        
        //プロパティnameを処理
        daeEffect.setName( effect.getName() );
        
        //子要素assetを処理(0or1)
        //子要素annotateを処理(0以上)
        //子要素imageを処理(0以上)
        //子要素newparamを処理(0以上)
        //子要素profile_CGを処理(?)
        //子要素profile_GLSLを処理(?)
        //子要素profile_COMMONを処理(?)
        for( JAXBElement<?> o : effect.getFxProfileAbstracts() )
        {
            // テクスチャ対応
            // profile_COMMONタグを取得
            if( ! ( o.getValue() instanceof ProfileCOMMON ) ){ continue; }
            ProfileCOMMON   profileCommon   = (ProfileCOMMON) o.getValue();
            
            // パラメータを取得
            for( Object o2 : profileCommon.getImagesAndNewparams() )
            {
                // newparamタグのみ対応
                if( !( o2 instanceof CommonNewparamType ) )throw new RuntimeException("対応していません。");
                CommonNewparamType  newparamTag = (CommonNewparamType) o2;
                
                // マップに登録
                newparamTagMap.put( newparamTag.getSid() , newparamTag );
            }
            
            // マテリアル情報があるか確認
            Technique   technique   = profileCommon.getTechnique();
            if( technique == null ){ break; }
            Lambert     lambert     = technique.getLambert();
            if( lambert == null ){ break; }
            
            // テクスチャ情報を取得
            CommonColorOrTextureType     diffuse     = lambert.getDiffuse();
            if( diffuse != null )
            {
                // フォン・マテリアルの作成
                PhongMaterial   material    = new PhongMaterial();
                
                // 色を取得
                if( diffuse.getColor() != null )
                {
                    List<Double>    rgba    = diffuse.getColor().getValues();
                    Color           color   = new Color( rgba.get(0) , rgba.get(1) , rgba.get(2) , rgba.get(3) );
                    material.setDiffuseColor( color );
                    
                }
                
                // テクスチャを取得・設定
                if( diffuse.getTexture() != null )
                {
                    String                      textureSid  = getLinkStr( diffuse.getTexture().getTexture() );
                    javafx.scene.image.Image    textureImg  = getTextureImageFromNewparam( newparamTagMap.get( textureSid ) );
                    material.setDiffuseMap( textureImg );
                }
                
                // マテリアルを設定
                daeEffect.setMaterial( material );
            }
            
        }
        // 対応範囲を明示
        if( effect.getFxProfileAbstracts() == null ){ throw new RuntimeException("対応していません。"); }
        
        //子要素extraを処理(0以上)

        return daeEffect;
    }

    /**
     * Newparamに宣言されたSampler2Dを通して、テクスチャ画像を取得します。
     * @param newparamTag
     * @return
     * @throws Exception 
     */
    private static javafx.scene.image.Image getTextureImageFromNewparam( CommonNewparamType  newparamTag ) throws Exception
    {
        // Sampler2Dタグを取得
        FxSampler2DCommon   sampler     = newparamTag.getSampler2D();
        if( sampler == null ){ throw new RuntimeException( "Sampler2Dが見つかりません" ); }
        
        // ソースを取得
        String              linkStr     = getLinkStr( sampler.getSource() );
        CommonNewparamType  param       = newparamTagMap.get( linkStr );
        
        // 画像を取得
        Image                       imageTag    = (Image)param.getSurface().getInitFroms().get(0).getValue(); 
        String                      url         = imageTag.getId();
        DaeImage                    daeImage    = idMap.get( url , DaeImage.class ).orElseThrow( () -> new Exception( "Image ID:" + url + "が見つかりません。" ) );
        
        return daeImage.getImage();
    }
    
    /**
     * ソースタグから浮動小数点配列を取得する
     * @param source
     * @return
     */
    private static float[] getFloatArrayFromSourceTag( Source source )
    {
        // FloatArrayでない場合はエラー
        if( source.getFloatArray() == null ){ throw new RuntimeException( "float_arrayではありません" ); }
        
        // FloatArray型に型変換
        FloatArray  floatArray  = source.getFloatArray();
        
        // プロパティidを処理
        // プロパティnameを処理
        
        // 子要素assetを処理(0or1)
        // 子要素array_elementを処理(0or1)
            // float_array
            // プロパティcountを処理
            int             cnt     = floatArray.getCount().intValue();
            List<Double>    list    = floatArray.getValues();
            // プロパティidを処理(0or1)
            // プロパティnameを処理(0or1)
            // プロパティdigitsを処理(0or1)
            // プロパティmagnitudeを処理(0or1)
        // 子要素technique_commonを処理(0or1)
            // →XYZ座標の順番を変化
        // 子要素techniqueを処理(0以上)
        
        // 戻り値を作成
        float[] floats = new float[ cnt ];
        for( int i = 0 ; i < floats.length ; i++ )
        { floats[i]   = list.get( i ).floatValue(); }
                
        return floats;
    }
    
    
    
    /**
     * daeファイル内のリンク文字列（参照先）を取得する
     * 文字頭に『#』がある場合、取り除く
     * @param str
     * @return
     */
    private static String getLinkStr( String str )
    {
        return str.substring(0,1).equalsIgnoreCase( "#") ? str.substring(1) : str;
        
    }
    
    
    

}
