package collada;

import java.util.HashMap;
import java.util.Optional;

/**
 * Daeオブジェクトを格納・取得するマップクラス
 * @author tomo
 *
 */
public class DaeIDMap
{
    /**
     * オブジェクトを格納取得するマップクラス
     */
    private HashMap<String,DaeObject>   map         = new HashMap<>();

    /**
     * マップに値を格納
     * @param key
     * @param value
     */
    public void put( String key , DaeObject value )
    {
        map.put( key , value);
    }
    
    /**
     * オブジェクトクラスを指定して、キーに対応する値を取得
     * @param key
     * @param cls
     * @return
     */
    @SuppressWarnings("unchecked")
    public  <T> Optional<T>  get( String key , Class<T> cls )
    {
        // 空のOptional型の作成
        Optional<T> result      = Optional.empty();
        
        // マップから値を取得
        DaeObject   obj         = map.get( key );
        
        // クラスを照合し、異なっている場合はnullとする
        if( ( obj != null ) && ( obj.getClass() == cls ) )
        { 
            // 型変換
            T   tObj    = (T) obj;
            result      = Optional.ofNullable( tObj );
        }
        
        return result;
        
    }
    
}
