#!/usr/bin/env python
# -*- coding: utf-8 -*-


import sys

import RTC
import OpenRTM_aist

ectest_spec = ["implementation_id", "ECTest",
                  "type_name",         "ECTest",
                  "description",       "Console input component",
                  "version",           "1.0",
                  "vendor",            "Sample",
                  "category",          "example",
                  "activity_type",     "DataFlowComponent",
                  "max_instance",      "10",
                  "language",          "Python",
                  "lang_type",         "script",
                  ""]


class ECListener:
  def __init__(self):
    pass

  def onAttached(self, ec_id):
    print "ATTACHED:" + str(ec_id)
    return

  def onDetached(self, ec_id):
    print "DETACHED:" + str(ec_id)
    return


  
class POST_CAListener:
  def __init__(self):
    self.name = "POST:"
  def onInitialize(self, ec_id, ret):
    print self.name + "INITIALIZE:" + str(ec_id) + ":" + str(ret) 
    return

  def onFinalize(self, ec_id, ret):
    print self.name + "FINALIZE:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onStartup(self, ec_id, ret):
    print self.name + "STARTUP:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onShutdown(self, ec_id, ret):
    print self.name + "SHUTDOWN:" + str(ec_id) + ":" + str(ret) 
    return

  def onActivated(self, ec_id, ret):
    print self.name + "ACTIVATED:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onDeactivated(self, ec_id, ret):
    print self.name + "DEACTIVATED:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onAborting(self, ec_id, ret):
    print self.name + "ABORTING:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onError(self, ec_id, ret):
    print self.name + "ERROR:" + str(ec_id) + ":" + str(ret) 
    return

  def onReset(self, ec_id, ret):
    print self.name + "RESET:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onExcecute(self, ec_id, ret):
    print self.name + "EXECUTE:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onUpdate(self, ec_id, ret):
    print self.name + "ON_STATE_UPDATE:" + ":" + str(ec_id) + ":"  + str(ret) 
    return

  def onRateChanged(self, ec_id, ret):
    print self.name + "RATE_CHANGED:" + ":" + str(ec_id) + ":"  + str(ret) 
    return


class PRE_CAListener:
  def __init__(self):
    self.name = "RRE:"
  def onInitialize(self, ec_id):
    print self.name + "INITIALIZE:" + str(ec_id)
    return

  def onFinalize(self, ec_id):
    print self.name + "FINALIZE:" + ":" + str(ec_id) 
    return

  def onStartup(self, ec_id):
    print self.name + "STARTUP:" + ":" + str(ec_id) 
    return

  def onShutdown(self, ec_id):
    print self.name + "SHUTDOWN:" + str(ec_id)
    return

  def onActivated(self, ec_id):
    print self.name + "ACTIVATED:" + ":" + str(ec_id) 
    return

  def onDeactivated(self, ec_id):
    print self.name + "DEACTIVATED:" + ":" + str(ec_id) 
    return

  def onAborting(self, ec_id):
    print self.name + "ABORTING:" + ":" + str(ec_id) 
    return

  def onError(self, ec_id):
    print self.name + "ERROR:" + str(ec_id) 
    return

  def onReset(self, ec_id):
    print self.name + "RESET:" + ":" + str(ec_id) 
    return

  def onExcecute(self, ec_id):
    print self.name + "EXECUTE:" + ":" + str(ec_id) 
    return

  def onUpdate(self, ec_id):
    print self.name + "ON_STATE_UPDATE:" + ":" + str(ec_id) 
    return

  def onRateChanged(self, ec_id):
    print self.name + "RATE_CHANGED:" + ":" + str(ec_id) 
    return
  

class ECTest(OpenRTM_aist.DataFlowComponentBase):
  def __init__(self, manager):
    OpenRTM_aist.DataFlowComponentBase.__init__(self, manager)

    self.ECListener = ECListener()
    
    self.addExecutionContextActionListener(OpenRTM_aist.ExecutionContextActionListenerType.EC_ATTACHED,
                                                        self.ECListener.onAttached)
    self.addExecutionContextActionListener(OpenRTM_aist.ExecutionContextActionListenerType.EC_DETACHED,
                                                        self.ECListener.onDetached)

    self.POST_CAListener = POST_CAListener()
    
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_INITIALIZE,
                                                        self.POST_CAListener.onInitialize)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_FINALIZE,
                                                        self.POST_CAListener.onFinalize)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_STARTUP,
                                                        self.POST_CAListener.onStartup)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_SHUTDOWN,
                                                        self.POST_CAListener.onShutdown)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_ACTIVATED,
                                                        self.POST_CAListener.onActivated)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_DEACTIVATED,
                                                        self.POST_CAListener.onDeactivated)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_ABORTING,
                                                        self.POST_CAListener.onAborting)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_ERROR,
                                                        self.POST_CAListener.onError)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_RESET,
                                                        self.POST_CAListener.onReset)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_EXECUTE,
                                                        self.POST_CAListener.onExcecute)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_STATE_UPDATE,
                                                        self.POST_CAListener.onUpdate)
    self.addPostComponentActionListener(OpenRTM_aist.PostComponentActionListenerType.POST_ON_RATE_CHANGED,
                                                        self.POST_CAListener.onRateChanged)


    self.PRE_CAListener = PRE_CAListener()
    
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_INITIALIZE,
                                                        self.PRE_CAListener.onInitialize)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_FINALIZE,
                                                        self.PRE_CAListener.onFinalize)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_STARTUP,
                                                        self.PRE_CAListener.onStartup)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_SHUTDOWN,
                                                        self.PRE_CAListener.onShutdown)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_ACTIVATED,
                                                        self.PRE_CAListener.onActivated)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_DEACTIVATED,
                                                        self.PRE_CAListener.onDeactivated)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_ABORTING,
                                                        self.PRE_CAListener.onAborting)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_ERROR,
                                                        self.PRE_CAListener.onError)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_RESET,
                                                        self.PRE_CAListener.onReset)
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_EXECUTE,
                                                        self.PRE_CAListener.onExcecute)
    
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_STATE_UPDATE,
                                                        self.PRE_CAListener.onUpdate)
    
    self.addPreComponentActionListener(OpenRTM_aist.PreComponentActionListenerType.PRE_ON_RATE_CHANGED,
                                                        self.PRE_CAListener.onRateChanged)
    return

  def onInitialize(self):
    

    

    
    
    return RTC.RTC_OK

        
  def onExecute(self, ec_id):
    
    return RTC.RTC_OK

  

  


def ECTestInit(manager):
  profile = OpenRTM_aist.Properties(defaults_str=ectest_spec)
  manager.registerFactory(profile,
                          ECTest,
                          OpenRTM_aist.Delete)


def MyModuleInit(manager):
  ECTestInit(manager)

  # Create a component
  comp = manager.createComponent("ECTest")

def main():

  mgr = OpenRTM_aist.Manager.init(sys.argv)


  mgr.setModuleInitProc(MyModuleInit)


  mgr.activateManager()

  mgr.runManager()


if __name__ == "__main__":
  main()
