// -*- C++ -*-
/*!
 * @file TestComp.cpp
 * @brief Standalone component
 * @date $Date$
 *
 * $Id$
 */

#include <rtm/Manager.h>
#include <iostream>
#include <string>
#include <stdlib.h>
#include <coil/DynamicLib.h>


typedef int (*TestDLL)(RTC::Manager* manager);
TestDLL TestInit;
coil::DynamicLib *dl = NULL;

void MyModuleInit(RTC::Manager* manager)
{
	dl = new coil::DynamicLib();
	int ret = dl->open("test.dll");
	if(ret == 0)
	{
		std::cout << "[h" << std::endl;
	}
	else
	{
		std::cout << "[hs" << std::endl;
		return;
	}

	TestInit = (TestDLL)TestDLL(dl->symbol("TestInit"));
	if (TestInit == NULL) {
		std::cout << "֐܂" << std::endl;
		return;
	}

  TestInit(manager);
  RTC::RtcBase* comp;

  // Create a component
  comp = manager->createComponent("Test");

  if (comp==NULL)
  {
    std::cerr << "Component create failed." << std::endl;
    abort();
  }

  // Example
  // The following procedure is examples how handle RT-Components.
  // These should not be in this function.

  // Get the component's object reference
//  RTC::RTObject_var rtobj;
//  rtobj = RTC::RTObject::_narrow(manager->getPOA()->servant_to_reference(comp));

  // Get the port list of the component
//  PortServiceList* portlist;
//  portlist = rtobj->get_ports();

  // getting port profiles
//  std::cout << "Number of Ports: ";
//  std::cout << portlist->length() << std::endl << std::endl; 
//  for (CORBA::ULong i(0), n(portlist->length()); i < n; ++i)
//  {
//    PortService_ptr port;
//    port = (*portlist)[i];
//    std::cout << "Port" << i << " (name): ";
//    std::cout << port->get_port_profile()->name << std::endl;
//    
//    RTC::PortInterfaceProfileList iflist;
//    iflist = port->get_port_profile()->interfaces;
//    std::cout << "---interfaces---" << std::endl;
//    for (CORBA::ULong i(0), n(iflist.length()); i < n; ++i)
//    {
//      std::cout << "I/F name: ";
//      std::cout << iflist[i].instance_name << std::endl;
//      std::cout << "I/F type: ";
//      std::cout << iflist[i].type_name << std::endl;
//      const char* pol;
//      pol = iflist[i].polarity == 0 ? "PROVIDED" : "REQUIRED";
//      std::cout << "Polarity: " << pol << std::endl;
//    }
//    std::cout << "---properties---" << std::endl;
//    NVUtil::dump(port->get_port_profile()->properties);
//    std::cout << "----------------" << std::endl << std::endl;
//  }

  return;
}

int main (int argc, char** argv)
{
  RTC::Manager* manager;
  manager = RTC::Manager::init(argc, argv);

  // Initialize manager
  manager->init(argc, argv);

  // Set module initialization proceduer
  // This procedure will be invoked in activateManager() function.
  manager->setModuleInitProc(MyModuleInit);

  // Activate manager and register to naming service
  manager->activateManager();

  // run the manager in blocking mode
  // runManager(false) is the default.
  manager->runManager();

  // If you want to run the manager in non-blocking mode, do like this
  // manager->runManager(true);

  if(dl)
  {
		
		int ret = dl->close();
		if(ret == 0)
		{
			std::cout << "A[h" << std::endl;
		}
		else
		{
			std::cout << "A[hs" << std::endl;
			return -3;
		}
  }

  return 0;
}
