﻿<?php
	
	//検索を行うクラス
	class Dict_East{
		
		//URL
			protected $url_service='http://btonic.est.co.jp/NetDic/NetDicV09.asmx';
			protected $url_search='/SearchDicItemLite';
			protected $url_request='/GetDicItemLite';
			
		//リクエストパラメータの初期値
			protected $param_search=array(
				 'Dic'=>'wpedia'		//使用する辞書
				,'Word'=>''				//検索語句
				,'Scope'=>'HEADWORD'	//検索対象(見出しのみ/本文)
				,'Match'=>'CONTAIN'		//検索一致方法指定
				,'Merge'=>'AND'			//複数条件の結合方法
				,'Prof'=>'XHTML'		//返り値の形式
				,'PageSize'=>'10'		//1ページあたりの件数
				,'PageIndex'=>'0'		//取得するページ
			);
			protected $param_request=array(
				 'Dic'=>'wpedia'		//使用する辞書
				,'Item'=>''				//検索するID
				,'Prof'=>'XHTML'		//返り値の形式
				,'Loc'=>''				//常に空
			);
		
		//リクエストパラメータの有効な値
			private $param_search_valid=array(
				 'Dic'=>array(
					 'EdictJE'		//和英
					,'EJdict'		//英和
					,'wpedia'		//Wikipedia
				)
				,'Scope'=>array(
					 'ANYWHERE'		//全文検索
					,'HEADWORD'		//見出しのみ検索
				)
				,'Match'=>array(
					 'CONTAIN'		//部分一致
					,'EXACT'		//完全一致
					,'STARTWITH'	//前方一致
					,'ENDWITH'		//後方一致
				)
				,'Merge'=>array(
					 'AND'			//and検索
					,'OR'			//or検索
				)
				,'Prof'=>array(
					'XHTML'			//返り値の形式
				)
			);
		
		//その他内部で使用
			protected $request_search='';	//検索リクエストURL
			protected $request_request='';	//内容取得リクエストURL
			protected $ret_request='';		//内容取得リクエスト結果
		
		//コンストラクタ
			public function __construct($dictonary=false){
				$this->setDictionary($dictonary);
			}
		
		//辞書の種類をセット
			public function setDictionary($dictonary){
				if(!in_array($dictonary,$this->param_search_valid['Dic'])){
					return false;
				}
					$this->param_search['Dic']=$dictonary;
					$this->param_request['Dic']=$dictonary;
					return true;
			}
		
		//検索方法をセット
			public function setSearchScope($scope=false,$match=false){
				if(    $scope!=false
					&& !in_array($scope,$this->param_search_valid['Scope'])){
						return false;
				}
				if(    $match!=false
					&& !in_array($match,$this->param_search_valid['Match'])){
						return false;
				}
				
				$this->param_search['Scope']=$scope;
				$this->param_search['Match']=$match;
				return true;
			}
		
		//検索
			public function search($word,$page=0){
				//引数
				if(!$word){return false;}
				$page=(int)$page+0;
				//URL作成
				$this->param_search['Word']=$word;
				$this->param_search['PageIndex']=$page;
				$this->_setSearchURL();
				//取得して返す
				if(!$this->request_search){return false;}
				return new Dict_East_Search($this->request_search);
			}
		
		
		//URL組み立て
			private function _setSearchURL(){
				$this->request_search=$this->url_service.$this->url_search.'?';
				foreach($this->param_search as $key=>$val){
					//WordはUTF8でURLエンコードする
					if($key=='Word'){
						$val=urlencode(
							mb_convert_encoding($val,'UTF-8',
								mb_detect_encoding(
									$val,'UTF-8,EUC-JP,sjis-win,ASCII'
								)
							)
						);
					}
					$this->request_search .= $key.'='.$val.'&';
				}
			}
			private function _setRequestURL(){
				$this->request_request=$this->url_service.$this->url_request.'?';
				foreach($this->param_request as $key=>$val){
					$this->request_request .= $key.'='.$val.'&';
				}
			}
		
		//内容取得
			public function get($id){
				//引数
				if(!$id){return false;}
				//URL作成
				$this->param_request['Item']=$id;
				$this->_setRequestURL();
				//取得して返す
				if(!$this->request_request){return false;}
				$this->ret_request=file_get_contents($this->request_request);
				return $this->_parseRequestURL();
			}
		
		//XMLパース
			private function _parseRequestURL(){
				//simplexml
					if(!$this->ret_request){return false;}
					$simplexml=simplexml_load_string($this->ret_request);
				//xpathにはネームスペースが必要
					$namespaces=$simplexml->getDocNamespaces();
					$simplexml->registerXPathNamespace("namespace", $namespaces[""]);
					$xpath_to_head = '//namespace:GetDicItemResult/namespace:Head';
					$xpath_to_body = '//namespace:GetDicItemResult/namespace:Body';
				//各XMLの値を取得して返す
					$simplexml_head=$simplexml->xpath($xpath_to_head);
					$simplexml_body=$simplexml->xpath($xpath_to_body);
					if(!$simplexml_head || !$simplexml_body){return false;}
					$simplexml_head=$simplexml_head[0];
					$simplexml_body=$simplexml_body[0];
					$ret['simplexml_head']=$simplexml_head->asXML();
					$ret['simplexml_body']=$simplexml_body->asXML();
					return $ret;
			}
		
	#↓クラスのおわり
	}

	//Dict_East::search()の結果を入れるクラス
	class Dict_East_Search implements Iterator{
		
		//変数
			protected $request_search='';	//検索リクエストURL
			protected $ret_search=array();	//検索取得結果
			protected $xml_search=array();	//検索取得結果のパース後
			protected $xml_iterate=0;		//イテレータの現在値
		
		//コンストラクタ
			public function __construct($request_search){
				$this->request_search=$request_search;
				$this->ret_search=file_get_contents($this->request_search);
				$this->xml_search=simplexml_load_string($this->ret_search);
			}
		
		//検索対象の全件数を返す
			public function getCount(){
				return (string)$this->xml_search->TotalHitCount;
			}
		
		//イテレータ(foreachの実装)
			public function current(){
				$ret['itemID']=(string)
					$this->xml_search->TitleList->DicItemTitle[$this->xml_iterate]->ItemID;
				$ret['Title']=(string)
					$this->xml_search->TitleList->DicItemTitle[$this->xml_iterate]->Title->span;
				return $ret;
			}
			public function key(){
				return $this->xml_iterate;
			}
			public function next(){
				$this->xml_iterate=$this->xml_iterate+1;
			}
			public function valid(){
				if($this->xml_search->TitleList->DicItemTitle[$this->xml_iterate]){
					return true;
				}
				return false;
			}
			public function rewind(){
				$this->xml_iterate=0;
			}
		
	#↓クラスのおわり
	}