<?php
	/*
		したらばと通信を行ったりするクラス
		
		define
	*/
	
	//したらば情報
	
		//全体
		//したらばの文字コード
			define('SHITARABA_BBS_ENCODE','EUC-JP');
		
		//表側
			//したらばの場所
				define('SHITARABA_BBS_URL','http://jbbs.livedoor.jp/');
			//スレッド一覧
				define('SHITARABA_BBS_DAT_THREAD','subject.txt');
			//スレッド取得URL
				define('SHITARABA_BBS_DAT_RES','bbs/rawmode.cgi/');
		
		//管理画面側
			//管理画面のドメイン
				define('SHITARABA_BBS_MANAGER_CMS','http://cms.jbbs.livedoor.jp/');
				
			//ログイン
				define('SHITARABA_BBS_MANAGER_LOGIN','login/');
			//スレッド倉庫送りURL-確認送信先
				define('SHITARABA_BBS_THREAD_CONF','config/data/thread_delete');
			//スレッド倉庫送りURL-完了送信先
				define('SHITARABA_BBS_THREAD_COMP','config/data/thread_delete_confirm');
			//個別削除URL
				define('SHITARABA_BBS_RES_DEL_CONF','config/data/thread');
			//個別削除URL
				define('SHITARABA_BBS_RES_DEL_COMP','config/data/thread_confirm');
		
	//このスクリプトの文字コード
		define('SHITARABA_DEL_ENCODE','UTF-8');


//クラス
class Shitaraba_Data{
	
	//--------------------------------------------------------------------------------------
	//インスタンス変数
		//selectNGDataで使用するフィルタ
		private $NG=array();
		//NGワードチェックするかどうかのフラグ
		private $checkNGflg=false;
		//クッキー
		private $cookie=false;
	
	//--------------------------------------------------------------------------------------
	//コンストラクタ
	public function __construct(){}
	
	//--------------------------------------------------------------------------------------
	//NGデータのセッターゲッター
	public function setNGWord($ng_word=null){
		if($ng_word){
			$this->NG['ng_word']=$ng_word;
			$this->checkNGflg=true;
		}
	}
	public function setNGHost($ng_host=null){
		if($ng_host){
			$this->NG['ng_host']=$ng_host;
			$this->checkNGflg=true;
		}
	}
	public function getNG(){
		return $this->NG;
	}
	
	//--------------------------------------------------------------------------------------
	//NGワード、NGホスト対象のデータを引いてくる
	public function getNGThreadData(){
		
		//スレッドリスト取得
			$thread_data=$this->getThreadList();
			if(!$thread_data){return false;}
		
		//各スレッドに対して
			foreach($thread_data as $key=>$val){
				//NG対象のデータを引く
				$ret=$this->getThread($val['thread_id']);
				if(!$ret){
					//NG対象がなければ不要なので削除
					unset($thread_data[$key]);
				}else{
					//あれば['data']に入れる
					$thread_data[$key]['data']=$ret;
				}
			}
		
		//返却
			return $thread_data;
	}
	
	//--------------------------------------------------------------------------------------
	//全スレッドの全データを取得
	public function getAllThreadData(){
		
		//スレッドリスト取得
			$thread_data=$this->getThreadList();
			if(!$thread_data){return false;}
		
		//NGフラグを一旦回避
			$tmp_checkNGflg=$this->checkNGflg;
			$this->checkNGflg=false;
		
		//各スレッドに対して内容取得
			foreach($thread_data as $key=>$val){
				$thread_data[$key]['data']=$this->getThread($val['thread_id']);
			}
			
		//NGフラグを元に戻す
			$this->checkNGflg=$tmp_checkNGflg;
		
		//返却
			return $thread_data;
	}
	
	//--------------------------------------------------------------------------------------
	//dat落ち対象のスレッドリストを取得
	public function getDatThreadList(){
		$ret_array=array();
		
		//スレッドリストを取得
			$thread_list=$this->getThreadList();
			if($thread_list===false){return false;}
		
		//対象を選択
			foreach($thread_list as $val){
				//1000あるのは対象
				if($val['thread_num'] > 999){
					$ret_array[]=$val;
				}
			}
		
		//返却
			return $ret_array;
	}
	
	//--------------------------------------------------------------------------------------
	//スレッドのリストを取得
	public function getThreadList(){
		$ret_array=array();
		
		//URL組み立て
			$url_thread_list=
				 SHITARABA_BBS_URL.SHITARABA_BBS_DIR.'/'
				.SHITARABA_BBS_BBS.'/'.SHITARABA_BBS_DAT_THREAD;
		
		//取得
			$thread_list=@file($url_thread_list);
			if(!$thread_list){return false;}
			//なんか同じデータが入ってくることがあるので減らす
			$thread_list=array_unique($thread_list);
			
		//文字コード変換、配列に展開
			foreach($thread_list as $val){
				$val=trim(mb_convert_encoding($val,SHITARABA_DEL_ENCODE,SHITARABA_BBS_ENCODE));
				$tmp=explode('.cgi,',$val,2);
				$ret['thread_id']=$tmp[0];
				
				$tmp=preg_match('/^(.*)\(([0-9]+)\)\z/',$tmp[1],$matches);
				$ret['thread_title']=$matches[1];
				$ret['thread_num']=$matches[2];
				$ret_array[]=$ret;
				
			}
		
		//返却
			return $ret_array;
	}
	
	//--------------------------------------------------------------------------------------
	//ひとつのスレッドの内容取得
	public function getThread($thread_id){
		
		//URL組み立て
			$url_thread_dat=
				 SHITARABA_BBS_URL.SHITARABA_BBS_DAT_RES
				.SHITARABA_BBS_DIR.'/'.SHITARABA_BBS_BBS.'/'.$thread_id.'/';
		
		//取得して返却
			$ret_array=$this->_getThreadFromURL($url_thread_dat);
			return $ret_array;
	}
	
	//--------------------------------------------------------------------------------------
	//該当のデータを削除
	public function deleteNGThreadData($shitaraba_ng){
		
		//スレッド毎にforeach
		foreach($shitaraba_ng as $shitaraba_ng_key=>$shitaraba_ng_val){
			
			//スレ番
				$stitaraba_thread_id=$shitaraba_ng_val['thread_id'];
				if(!$stitaraba_thread_id){continue;}
			
			//レス番を抽出
				$stitaraba_res_id=array();
				foreach($shitaraba_ng_val['data'] as $key=>$val){
					$stitaraba_res_id[]=$key;
				}
				if(!$stitaraba_res_id){continue;}
			
			//スレ毎に削除実行	引数はスレ番、レス番array
				$this->_shitaraba_Delete($stitaraba_thread_id,$stitaraba_res_id);
		}
		return true;
	}
	
	//--------------------------------------------------------------------------------------
	//該当のスレッドを倉庫送り
	public function datThreadData($shitaraba_dat){
		
		//スレッドIDだけ抽出
			$thread_id_array=array();
			foreach($shitaraba_dat as $val){
				if($val['thread_id']){
					$thread_id_array[]=$val['thread_id'];
				}
			}
			if(!$thread_id_array){
				return false;
			}
		
		//削除して返却
			return $this->_shitaraba_DatThread($thread_id_array);
	}
	
	//--------------------------------------------------------------------------------------
	//管理画面にログイン
		protected function _shitaraba_Login(){
			
			//ログインURL
				$login_url=SHITARABA_BBS_MANAGER_CMS.SHITARABA_BBS_DIR.'/'.SHITARABA_BBS_BBS.'/'.SHITARABA_BBS_MANAGER_LOGIN;
			
			//POSTするデータ
				$login_post=array(
					 'login_password'=>SHITARABA_BBS_PW
					,'login'=>'login'
				);
			
			//POSTするお
				$ret=$this->_POST($login_url,$login_post);
				
			//返却
				return $ret;
		}
	
	//--------------------------------------------------------------------------------------
	//以下サブルーチン
	//--------------------------------------------------------------------------------------
	
	//--------------------------------------------------------------------------------------
	//POSTするお
	private function _POST($url,$post_array=false){
	
		/*
			file_get_contents、及びCurl系の関数は302のリダイレクトを正しく処理しないので
			(POSTが302で返ってきたらその先にGETで送ってしまう)
			したらばのログインにはそのままでは使用できません
			そういう設定が何処かにあるのかもしれんがよくわからん
			
			てかブラウザからとリダイレクトにGET送っててOKなのにPHPからだとエラーになるんだが何故
		*/
	
		// Zend_Http_Client
			$http = new Zend_Http_Client(); 
		
		//設定
			$http->setUri($url); 
			
			//配列で来てたらsetParameterPost、文字列で来てたら生データを入れる
			if(is_array($post_array)){
				$http->setParameterPost($post_array);
			}else{
				$http->setRawData($post_array);
			}
			
			//302に対し正しくリダイレクトを行う
			$http->setConfig(array('strictredirects' => true));
			//cookieが存在すれば追加する
			if($this->cookie){
				$http->setCookie($this->cookie);
			}
		
		//実行
			$httpResponse = $http->request('POST');
			if(!$httpResponse->isSuccessful()){return false;}
		
		//Cookieを取得してセット
			$a=$http->getLastResponse();
			$a=$a->getHeaders();
			if($a['Set-cookie']){
				$this->cookie=Zend_Http_Cookie::fromString($a['Set-cookie']);
			}
		
		//返却
			return true;
	}
	
	
	//--------------------------------------------------------------------------------------
	//スレ毎に投稿削除
	private function _shitaraba_Delete($thread_id,$res_id_array){
		//準備	引数はスレッドID、レスID配列
			if(!$thread_id || !is_array($res_id_array)){return false;}
			$form_post_string='';
		
		//管理画面にログイン
			$ret=$this->_shitaraba_Login();
			if(!$ret){return false;}
		
		//削除確認画面
			//URL
				$form_url=SHITARABA_BBS_MANAGER_CMS.SHITARABA_BBS_DIR.'/'.SHITARABA_BBS_BBS.'/'.SHITARABA_BBS_RES_DEL_CONF.'?key='.$thread_id;

			//POSTパラメータ	同名res_numのデータを送信したいが、setParameterPostにはできないのでsetRawDataを使用
				//削除するレス番号
				foreach($res_id_array as $val){
					$form_post_string.='res_num='.$val.'&';
				}
				//透明削除
				//$form_post_string.='invisible=on';
				//スレッドID
				$form_post_string.='key='.$thread_id;
		
			//POST
				$ret=$this->_POST($form_url,$form_post_string);
				if(!$ret){return false;}
		
		//削除実行
			//URL
				$form_url=SHITARABA_BBS_MANAGER_CMS.SHITARABA_BBS_DIR.'/'.SHITARABA_BBS_BBS.'/'.SHITARABA_BBS_RES_DEL_COMP;
			
			//POSTパラメータは不要なのでダミー
				$form_post_array=array('1'=>'1');
		
			//POST
				return $this->_POST($form_url,$form_post_array);
	}
	
	
	//--------------------------------------------------------------------------------------
	//スレ毎に投稿dat落ち	実行
	private function _shitaraba_DatThread($thread_id_array){
		
		//管理画面にログイン
			$ret=$this->_shitaraba_Login();
			if(!$ret){return false;}
		
		//削除準備
			$ret=$this->_shitaraba_DatThread_conf($thread_id_array);
			if(!$ret){return false;}
		
		//削除実行
			return $this->_shitaraba_DatThread_comp();
	}
	
	
	//--------------------------------------------------------------------------------------
	//スレッドdat落ち	//確認画面
	private function _shitaraba_DatThread_conf($thread_id_array){
	
		//準備	引数はスレッドID配列
			if(!$thread_id_array || !is_array($thread_id_array)){return false;}
		
		//POSTパラメータ用意
			//URL
				$form_url=SHITARABA_BBS_MANAGER_CMS.SHITARABA_BBS_DIR.'/'.SHITARABA_BBS_BBS.'/'.SHITARABA_BBS_THREAD_CONF;
			//内容
				//dat落ちするスレッドID
				foreach($thread_id_array as $val){
					$form_post_array['key_'.$val]='on';
				}
		
		//POST
			return $this->_POST($form_url,$form_post_array);
	}
	
	
	//--------------------------------------------------------------------------------------
	//スレッドdat落ち	//完了画面
	private function _shitaraba_DatThread_comp(){
		
		//POSTパラメータ用意
			//URL
				$form_url=SHITARABA_BBS_MANAGER_CMS.SHITARABA_BBS_DIR.'/'.SHITARABA_BBS_BBS.'/'.SHITARABA_BBS_THREAD_COMP;
			
			//内容
				//削除するスレはconfで送っているので不要、下記はダミー
				$form_post_array=array('a'=>'a');
		
		//POST
			return $this->_POST($form_url,$form_post_array);
	}
	
	
	
	//--------------------------------------------------------------------------------------
	//NGワードチェック	getThread用
	private function _isNGResData($thread_dat){
		//1は削除できない
			if($thread_dat['res_id']==='1'){
				return false;
			}
		//isなので合ってしまった場合true
			if(isset($this->NG['ng_word'])){
				if(strpos($thread_dat['res_value'],$this->NG['ng_word'])!==false){
					return true;
				}
			}
		/*
		//ホスト名は表からは拾えないので、実装する際はgetThreadを管理メニュー経由にする必要がある
			if(isset($this->NG['ng_host'])){
				if($thread_dat['res_host']==$this->NG['ng_host']){
					return true;
				}
			}
		*/
		return false;
	}
	
	
	//--------------------------------------------------------------------------------------
	//URLからスレッド内容取得
	public function _getThreadFromURL($url_thread_dat){
		$ret_array=array();
		
		//取得
			$thread_dat=file($url_thread_dat);
			if(!$thread_dat){return false;}
			
			//各レスに対して
			foreach($thread_dat as $val){
				
				//文字コード変換
					$val=trim(mb_convert_encoding($val,SHITARABA_DEL_ENCODE,SHITARABA_BBS_ENCODE));
				
				//配列に展開
					$tmp=explode('<>',$val,7);
					$ret['res_id']=$tmp[0];
					$ret['res_name']=$tmp[1];
					$ret['res_mail']=$tmp[2];
					$ret['res_date']=$tmp[3];
					$ret['res_value']=$tmp[4];
					$ret['res_user_id']=$tmp[6];
				
				//NGワード検査
					if($this->checkNGflg){
						if(!$this->_isNGResData($ret)){
							continue;
						}
					}
				
				//返り値をセット
				//希に不正なエンコーディングで↑が正しく取得できない場合がある。どうしたものやら
					$ret_array[$tmp[0]]=$ret;
			}
		return $ret_array;
	}
	
	
	
	
	/*
	
		http://www.monazilla.org/index.php?e=107
		http://blog.livedoor.jp/bbsnews/archives/50283526.html
		
		【スレッド一覧】
		・スレッド一覧の設置場所は次の通りです。
		http://jbbs.livedoor.jp/[カテゴリ]/[掲示板番号]/subject.txt

		・スレッド一覧の内容は次の通りです。
		[スレッド番号].cgi,[スレッドタイトル](レス数)

		・内容はEUCコードで記述されています。

		【DAT（スレッドのデータ）】
		・DATの取得には2ch用ブラウザ向けに「rawmode.cgi」が用意されています。

		・DATの取得方法は次の通りです。
		http://jbbs.livedoor.jp/bbs/rawmode.cgi/[カテゴリ]/[掲示板番号]/[スレッド番号]/

		・DATファイルの内容は次の通りです。
		[レス番号]<>[名前]<>[メール]<>[日付]<>[本文]<>[スレッドタイトル]<>[ID]

		・内容はEUCコードで記述されています。

		・Range: bytesを指定しても１レス目から返るため、差分取得にはレス番号を指定しましょう。
		http://jbbs.livedoor.jp/bbs/rawmode.cgi/[カテゴリ]/[掲示板番号]/[スレッド番号]/100-
		（例：100レス目から取得）

		・データはchunked形式で返ります。（バイト数＋データ、バイト数＋データ・・・の繰り返し）

		・HTTP レスポンスヘッダに ERROR: フィールドがあれば何らかのエラーです。

		・rawmode.cgiについての詳細はこちらをご覧下さい。
		http://blog.livedoor.jp/bbsnews/archives/50283526.html


		【レス書き込み・スレッド作成】
		・cgiのパスは以下の通りです。
		/bbs/write.cgi/

		・パラメータの値はエンコードしましょう。
		レス書き込み時
		DIR=[板ジャンル]&BBS=[板番号]&TIME=[投稿時間]&NAME=[名前]&MAIL=[メール]&MESSAGE=[本文]&KEY=[スレッド番号]&submit=書き込む

		スレッド作成時
		DIR=[板ジャンル]&BBS=[板番号]&TIME=[投稿時間]&NAME=[名前]&MAIL=[メール]&MESSAGE=[本文]&SUBJECT=[タイトル]&submit=新規スレッド作成

	*/
	
	
#↓クラスのおわり
}