// Player.h

#include "Unit.h"


enum TrainingMenu
{
    THP,            // ̗͋
    TAtk,           // U͋
    TDef,           // h͋
    TAgi            // f
};
const char *tMenu[] = {
    "̗",
    "U",
    "h",
    "f"
};


class Player : public Unit
{
public:
    bool Stay();                        // hɔ܂
    void AddMoney(int gd);              // zZ
    void ShowAllStatus();
    void Training(TrainingMenu tM);       // PiRj
    int  TrainingCost(TrainingMenu tM);   // RXg
    string getShowHP();
    string GetSaveTxt();                // Z[up̕
    int GetStayPrice();                 // ȟvZ
};

void Player::ShowAllStatus()
{
    cout << "y" << Name << "z HP:" << getShowHP() << "  Atp:" << Atp << "  Dfp:" << Dfp << "  Agi:" << Agi << "\n";
    cout << "݂̏F" << Money << "G\n";
}

void Player::AddMoney(int Gd)
{
    Money += Gd;
    cout << Name << "́A " << Gd << "S[hɓꂽI\n";
    ShowAllStatus();
}

int Player::GetStayPrice()
{
    double sp;
    sp = (( MaxHP + (Atp+Dfp+Agi)*4)/10*((1000+Atp+Dfp+Agi)/1000));

    return(static_cast<int>(sp));
}

bool Player::Stay()
{
    int price = GetStayPrice();
    if(HP == MaxHP){
        cout << "̗͖^łB@@@" << getShowHP() << "\n"
             << "܂Kv܂B\n";
    } else if(Money >= price){
        cout << Name << "́Ahɔ܂EEE\n̗͂SB\n";
        HP = MaxHP;
        Money -= price;
        return true;
    } else {
        cout << "܂I\n";
    }
    return false;
}

void Player::Training(TrainingMenu tM)
{
    int cost = TrainingCost(tM);
    int imp = 0;
    if(Money >= cost){
        Money -= cost;
        switch(tM){
            case THP:
                imp = MaxHP/12 + 1;
                MaxHP += imp;
                break;
            case TAtk:
                imp = 1;
                Atp ++;
                break;
            case TDef:
                imp = 1;
                Dfp++;
                break;
            case TAgi:
                imp = 1;
                Agi++;
                break;
        }
        cout << tMenu[tM] << " " << imp << "オB\n";
    } else {
        cout << "܂I\n";
    }
}

int Player::TrainingCost(TrainingMenu tM)
{
    int cost = 0;
    switch(tM){
        case THP:
            cost = (MaxHP/10)*5;
            break;
        case TAtk:
            cost = Atp*5;
            break;
        case TDef:
            cost = Dfp*5;
            break;
        case TAgi:
            cost = Agi*5;
            break;
    }
    return cost;
}

string Player::getShowHP()
{
    stringstream sstr;
    sstr.str("");

    sstr << "(" << HP << "/" << MaxHP << ")";

    return(sstr.str());
}

string Player::GetSaveTxt()
{
    stringstream sstr;
    sstr.str("");

    sstr << Name << " " << MaxHP << " " << Atp << " " << Dfp << " " << Agi << " " << Money;

    return(sstr.str());
}