#include <iostream>
#include <string>
#include <sstream>
#include <stdlib.h>     // 擾ɕKv 
#include <time.h>       // rand()̏ɕKv 
#include <windows.h>    // \̃EFCĝ߂ɁB
#include <list>
#include <fstream>

using namespace std;

#include "Unit.h"
#include "Player.h"
#include "OrderList.h"
#include "Histgram.h"

const int MonsterMaxNum = 99;

enum Result
{
    NONE = 0,
                    // X؍ݎ
    DEPARTURE,      // oA
    STAY,           // hɔ܂

                    // 퓬
    ATTACK,         // U
    RUNAWAY,        // S
    WIN,            // 
    LOSE,           // sk

                    // VXe
    ABORT,          // I
    UNKNOWN         // s
};

// Z[u
void Save(Player &p)
{
    ofstream ost("savedata.dat");
    ost << p.GetSaveTxt();
    ost.close();
}

void InitPlayer(Player &player)
{
    ifstream ist("savedata.dat");
    if(ist) {
        string name;
        int HP, Atp, Dfp, Agi, Money;

        ist >> name >> HP >> Atp >> Dfp >> Agi >> Money;
        ist.close();

        player.Init(name,HP,Atp,Dfp,Agi,Money);

        cout << "\n\nÕZ[uf[^܂B\n[h܂H(Y/N)F";
        char c;
        cin >> c;
        if(c == 'y' || c == 'Y') return;
    }

    string name;
    cout << "Ȃ̖OĂF";
    cin >> name;

    player.Init(name, 30, 8, 5, 6, 0);
}


int InitEnemyList(Unit (&eList)[MonsterMaxNum])
{
    int EnemyNum = 0;

    ifstream ist("monster.dat");
    if(!ist){
        cout << "cannot open monster.dat.\n";
        return 0;
    }

    string name;
    int HP, Atp, Dfp, Agi, Money;
    while((!ist.eof())&&(EnemyNum<MonsterMaxNum)){
        ist >> name;
        if(ist.eof()) break;
        ist >> HP >> Atp >> Dfp >> Agi >> Money;
        if(ist.fail()) return 0;

        eList[EnemyNum].Init(name,HP,Atp,Dfp,Agi,Money);
//      eList[EnemyNum].ShowStatus();
        ++EnemyNum;
    }
    ist.close();

//  cout << "make MonsterList " << EnemyNum << "numbers.\n"; 

    return EnemyNum;
}

int NormalAttack(Unit &lst, Unit &rst)
{
    int dmg;
    dmg = (lst.Attack() - rst.Defence());
    if(dmg <= 0) dmg = 1;

    cout << lst.getName() << "̂I\n";
    cout << rst.getName() << " " << dmg << "̃_[W^B\n";

    if(rst.Hit(dmg)){
        cout << lst.getName() << "́A" << rst.getName() << "ɂƂǂ߂I\n";
        return(-1);
    }

    return(0);
}

int pNormalAttack(Unit *lst, Unit *rst)
{
    int dmg;
    dmg = (lst->Attack() - rst->Defence());
    if(dmg <= 0) dmg = 1;

    cout << lst->getName() << "̂I\n";
    cout << rst->getName() << " " << dmg << "̃_[W^B\n";

    if(rst->Hit(dmg)){
        cout << lst->getName() << "́A" << rst->getName() << "ɂƂǂ߂I\n";
        return(-1);
    }

    return(0);
}

Result InputBattleOrder()
{
    Result res = NONE;
    int cmd,cmdcnt = 0;

    while(1){
        cout << "ǂHi1:U@2:jF";
        if(cmdcnt){ cin.clear(); cin.ignore(); }
        cin >> cmd;
        cout << "\n";

        if(cmd == 1) { res = ATTACK;  break;}
        if(cmd == 2) { res = RUNAWAY; break;}
        if(cmd == 9) { res = ABORT;   break;}
        if((++cmdcnt)>10){res = ABORT;break;}   //[vh~
    }
    return res;
}

Result Battle(Player &player, Unit &enemy)
{
    int cnt = 1;
    Result res;
    list<OrderList> order;
    list<OrderList>::iterator p;

    while(1){
        order.clear();
        Sleep(200);
        player.ShowStatus();
        enemy.ShowStatus();
        res = InputBattleOrder();
        if(res == ABORT) break;
        if(res == RUNAWAY){
            cout << player.getName() << "͓oI\n";
            break;
        }

        Unit * pPlayer = &player;
        Unit * pEnemy = &enemy;

        order.push_back(OrderList(player.GetActionPoint(),pPlayer,pEnemy));
        order.push_back(OrderList(enemy.GetActionPoint(),pEnemy,pPlayer));
        order.sort();

        for(p=order.begin(); p!=order.end(); p++)
            if(pNormalAttack(p->Arry,p->Other)) break;

        if(enemy.isDead()){res = WIN;  break;}
        if(player.isDead()){res = LOSE;  break;}

        if((++cnt)>100)break;       // [vȂ̂ŁA[vh~
    }

    return res;
}

Result TownEvent(Player& player)
{
    Result res;
    int cmd,cmdcnt = 0;
//  static int stayPrice = 10;

    cout << "\n\nXɂ܂B\n";

    while(1){
        cmd = 0;
        res = NONE;
        player.ShowAllStatus();
        cout << "\n1:o\n"
             << "2:h(" << player.GetStayPrice() << "G)      ̗ " << player.getShowHP() << "\n"
             << "3:̗͋(" << player.TrainingCost(THP) <<"G)\n"
             << "4:UP(" << player.TrainingCost(TAtk) <<"G)\n"
             << "5:hP(" << player.TrainingCost(TDef) <<"G)\n"
             << "6:f@(" << player.TrainingCost(TAgi) <<"G)\n"
             << "9:I\n"
             << "ǂH";
        if(cmdcnt){
            cin.clear();
            cin.ignore();
        }
        cin >> cmd;
        cout << "\n";
        switch(cmd){
            case 1:     // o
                res = DEPARTURE;
                break;
            case 2:     // h
                if(player.Stay())
                    Save(player);
                break;
            case 3:     // ̗͋
                player.Training(THP);
                break;
            case 4:     // UP
                player.Training(TAtk);
                break;
            case 5:     // hP
                player.Training(TDef);
                break;
            case 6:     // fP
                player.Training(TAgi);
                break;
            case 9:
                res = ABORT;
                break;
        }
        if(res!=NONE) break;
        if((++cmdcnt)>100){res = ABORT; break;}   //[vh~
    }

    return res;
}

Result Patrol(Player &player, Unit (&eList)[MonsterMaxNum], int EnemyNum)
{
    Result res;
    Unit enemy;

    cout << player.getName() << "́AXočrɌB\n";

    for(int i=0; i<EnemyNum; ++i)
    {
        Sleep(800);
        enemy = eList[i];
        cout << "\n" << enemy.getName() << " ꂽI\n";
        res = Battle(player,enemy);
        if(res==WIN){         // vC[
            cout << "B\n";
            player.AddMoney(enemy.GetMoney());
        } else break;
    }
    if(res==WIN){
        // 퓬ŏIĂĂƂ́A叟̗\
        cout << "\n\n{{@@@S@@@II@@{{\n";
        cout << "E " << player.getName() << " ̖iɏ̂邪悢B\n\n";
        res = ABORT;
    }
    if(res==LOSE){
        cout << player.getName() << " ͎SB\n\n|GAME OVER|\n";
//      DeleteFile("savedata.dat");
        res = ABORT;
    }
    return res;
}

int main()
{
    Player player;
    Unit   eList[MonsterMaxNum];
    int EnemyNum;

    srand(static_cast<unsigned int>(time(NULL)));
    
    EnemyNum = InitEnemyList(eList);
    if(EnemyNum==0){
        cout << "X^[f[^̓ǂݍ݂Ɏs܂B\n";
        Sleep(3000);
        return 0;
    }
    InitPlayer(player);

    while(1){
        if(TownEvent(player)==ABORT) break;         // X
        if(Patrol(player,eList,EnemyNum)==ABORT) break;      // 퓬
    }

    cout << "\n\nIB" << endl;
    Sleep(1500);

    return 0;
}