/*
 * DIYPad.c
 *
 * Created: 2013/08/27 22:58:07
 *  Author: K.Onoe
 */

#include <avr/io.h>
#include <avr/interrupt.h>
#include "pindefs.h"
#include "util.h"

volatile uint8_t __pollCount;
volatile uint8_t __whichWord;
uint8_t buttonState0;
uint8_t buttonState1;

/*
 *      ATmega88V-10PU @ 8 MHz  RC
 *  Fuse Bit:
 *     High=DFhCLow=E2hCExtended=01h
 *  +-------+----------+------+-------+
 *  |   |          | s | DIP28 | l
 *  +=======+==========+======+=======+
 *  |       | d (+) | VCC  |     7 | 3.3 V
 *  |       | d (-) | GND  |     8 |
 *  |       | d (+) | AVCC |    20 | 3.3 V
 *  |       | d (-) | GND  |    22 |
 *  |       | d | AREF |    21 | NC
 *  |       | Zbg | PC6  |     1 |
 *  +-------+----------+------+-------+
 *  | BLEF  |      | PC5  |    28 | 
 *  | BDOW  |      | PC4  |    27 | 
 *  | BRIG  |      | PC3  |    26 | 
 *  | BUP   |      | PC2  |    25 | 
 *  | BSTA  |      | PC1  |    24 | Start
 *  | BSEL  |      | PC0  |    23 | Select
 *  | BL2   |      | PD0  |     2 | L2
 *  | BR2   |      | PD1  |     3 | R2
 *  | BL1   |      | PD2  |     4 | L1
 *  | BR1   |      | PD3  |     5 | R1
 *  | BTRI  |      | PD4  |     6 | 
 *  | BCIR  |      | PD5  |    11 | 
 *  | BCRS  |      | PD6  |    12 | ~
 *  | BSQR  |      | PD7  |    13 | 
 *  +-------+----------+------+-------+
 *  | DATG# | o     | PB6  |     9 |
 *  | ACKG# | o     | PB7  |    10 |
 *  | ACK   | o     | PB1  |    15 |
 *  +-------+----------+------+-------+
 *  | ATT   |      | PB2  |    16 | SPI SS#
 *  | CMD   |      | PB3  |    17 | SPI MOSI
 *  | DAT   | o     | PB4  |    18 | SPI MISO
 *  | CLK   |      | PB5  |    19 | SPI SCK
 *  +-------+----------+------+-------+
 *  | LED   | o     | PB0  |    14 |
 *  +-------+----------+------+-------+
 */

/*
 *  SCPH-1010
 *  +--------+-----+---------------------------------------+------+
 *  | [h | CMD |                  DAT                  | ACK  |
 *  +========+=====+=======================================+======+
 *  |      0 | 01h |                  XXh (Don't care)     |  v  |
 *  +--------+-----+---------------------------------------+------+
 *  |      1 | 42h |                  41h                  |  v  |
 *  +--------+-----+---------------------------------------+------+
 *  |      2 | 00h |                  5Ah                  |  v  |
 *  +--------+-----+----+----+----+----+----+----+----+----+------+
 *  |      3 | 00h |  |  |  |  | St |( 1)|( 1)| Se |  v  |
 *  +--------+-----+----+----+----+----+----+----+----+----+------+
 *  |      4 | 00h |  | ~ |  |  | R1 | L1 | R2 | L2 | sv |
 *  +--------+-----+----+----+----+----+----+----+----+----+------+
 *    -  CMDCDAT  LSB t@[Xg
 *    -  e{^̃rbg 0: C1: 
 */

/** ݒ */
void setup() {
	// ---- o͐ݒ ----
	DDRD = 0x00;
	DDRB = _BV(ACKG_BIT) | _BV(DATG_BIT) | _BV(DAT_BIT) | _BV(ACK_BIT) | _BV(LED_BIT);
	DDRC = 0x00;
	
	// ---- |[g ----
	// PORTD:  (PD4) vAbv
	// PORTB: DATGCACKG ͔ʐM Hi-ZDLED ͓_ԂX^[g
	// PORTC: CCStartCSelect (PC5, 4, 1, 0) vAbv
	PORTD = _BV(BTRI_BIT);
	PORTB = _BV(ACKG_BIT) | _BV(DATG_BIT) | _BV(ACK_BIT) | _BV(LED_BIT);
	PORTC = _BV(BLEF_BIT) | _BV(BDOW_BIT) | _BV(BSTA_BIT) | _BV(BSEL_BIT);
	
	// ---- sωݐݒ ----
	// PCINT2 sω݋ (16 ԃs)
	PCICR = _BV(PCIE0);    // PCINT7`0
	PCMSK0 = _BV(PCINT2);
	
	// ---- SPI ݒ ----
	// SPI CSPI ݋
	// f[^: LSB t@[XgCNbNpXC
	// s () GbWŃZbg/s () GbWŃLv`
	SPCR = _BV(SPIE) | _BV(SPE) | _BV(DORD) | _BV(CPOL) | _BV(CPHA);
	
	__pollCount = 0;
	__whichWord = 0;
	
	// S݋
	sei();
}

/** s[` - {^͓ǂݍ */
void loop() {
	uint8_t PINCLat = PINC;
	
	buttonState0 = ((PINCLat & 0x3e) << 2) | (PINCLat & 0x01) | 0x06;
	buttonState1 = PIND;
}

/** C[` */
int main() {
	setup();
	
	while (1) {
		loop();
		delay_ms(5);
	}
	return 0;
}

/** PCINT7`0 sω݃[` */ 
ISR(PCINT0_vect) {
	if (PINB & _BV(2)) {
		// ʐMIDDATCACK  Hi-Z 
		PORTB |= _BV(ACKG_BIT) | _BV(DATG_BIT);
	} else {
		// ʐMJnDDATCACK ̃Q[gJ
		PORTB &= ~(_BV(ACKG_BIT) | _BV(DATG_BIT));
	}
}

/** SPI M݃[` */
ISR(SPI_STC_vect) {
	// Mf[^擾
	uint8_t c = SPDR;
	
	switch (__whichWord) {
	case 0:
		if (c == 0x01) {
			__whichWord = 1;
			SPDR = 0x41;
			
			// ANmbWԂ
			PORTB &= ~_BV(ACK_BIT);
			delay_us(2);
			PORTB |= _BV(ACK_BIT);
		}
		break;
	case 1:
		if (c == 0x42) {
			__whichWord = 2;
			SPDR = 0x5a;
			
			// ANmbWԂ
			PORTB &= ~_BV(ACK_BIT);
			delay_us(2);
			PORTB |= _BV(ACK_BIT);
		} else {
			__whichWord = 0;
		}
		break;
	case 2:
		if (c == 0x00) {
			__whichWord = 3;
			SPDR = buttonState0;
			
			// ANmbWԂ
			PORTB &= ~_BV(ACK_BIT);
			delay_us(2);
			PORTB |= _BV(ACK_BIT);
		} else {
			__whichWord = 0;
		}
		break;
	case 3:
		__whichWord = 4;
		SPDR = buttonState1;
		
		// ANmbWԂ
		PORTB &= ~_BV(ACK_BIT);
		delay_us(2);
		PORTB |= _BV(ACK_BIT);
		break;
	case 4:
		__pollCount++;
		WRITE_BIT(PORTB, LED_BIT, !(__pollCount & 0x10));
	default:
		__whichWord = 0;
		break;
	}
}
