/*
 * util.h
 *
 * Created: 2013/07/21 22:43:10
 *  Author: K.Onoe
 */ 

#ifndef UTIL_H_
#define UTIL_H_

#ifndef sbi
#define sbi(port, bit) (port) |= (1 << (bit))
#endif

#ifndef cbi
#define cbi(port, bit) (port) &= ~(1 << (bit))
#endif

#define WRITE_BIT(PORT, BIT, VAL) \
	if (VAL) sbi(PORT, BIT); else cbi(PORT, BIT)

void delay_ms(uint16_t);
void delay_us(uint16_t);

#endif /* UTIL_H_ */
