﻿///////////////////////////////////////
//　インてふてふver1.0
//　http://sysys.blog.shinobi.jp/Entry/18/
////////////////////////////////////

var SaveFolderPath=" eps";//ファイルの保存場所を指定　""でドキュメント保存フォルダ　１文字目半角スペースでドキュメント保存フォルダのサブフォルダ　またはフルパス
var TexExe="c:\\w32tex\\bin\\platex.exe";//TeXの実行ファイル　ちゃんとPATHが通ってればフルパスでなくていいかも　\は\\と書く
var DvipdfExe="c:\\w32tex\\bin\\dvipdfmx.exe";//dviをpdfに変換するやつ　TeXをインストールしたら一緒に入ってるはず
var GsExe="C:\\Program Files (x86)\\gs\\gs9.14\\bin\\gswin32c.exe";//Ghostscript　EPSをアレコレするやつ

var TexFontSize=0;//TEXの\fontsize{x}{y}のx　単位はpt　0:indesign上のテキストにあわせる
var TexAutoGyouokuri=150;//\fontsize{x}{y}のy=TexFontSize*TexAutoGyouokuri％
var InlineCharStyleName="インライン数式";//インライン数式のアンカーに適用する文字スタイル名　（適用しない場合は""　スタイルグループは非対応）
var InlineObjStyleName="インライン数式";//インライン数式に適用するオブジェクトスタイル名
var DisplayParaStyleName="ディスプレイ数式";//ディスプレイ数式のアンカーに適用する段落スタイル名
var DisplayObjStyleName="ディスプレイ数式";//ディスプレイ数式に適用するオブジェクトスタイル名
var FrameObjStyleName="";//フレーム数式に適用するオブジェクトスタイル名
var InlineJidouBaseline=1;//インライン数式のベースラインを自動調整　0:無効　1:有効
var InlineYOffset=0;//インライン数式のアンカーオプションのYオフセット
var DisplayJidouGyoudori=1;//ディスプレイ数式の行取りを自動調整　0:無効　1:有効
var YohakuInline=[0,-2,-0.5,-2];//インライン数式の[上,左,下,右]の余白
var YohakuDisplay=[5,0,5,0];//ディスプレイ数式の[上,左,下,右]の余白
var YohakuFrame=[0,0,0,0];//フレーム数式の[上,左,下,右]の余白

var DelTempFile=1;//中間生成ファイルを　0:消さない　1:消す
var DelNotLinkedFile=1;//SaveFolderPath下の使われていないTex*****.epsを　0:消さない　1:消す
//設定ここまで---------------------------------------------------------------------------------------------------
app.scriptPreferences.measurementUnit=MeasurementUnits.POINTS;
var myDocu=app.activeDocument;
var Sel=myDocu.selection;
if (Sel.length==0) err("何も選択されてません");
var Sel0=myDocu.selection[0];
if (!myDocu.saved) err("ドキュメントを保存して下さい（）");
if (SaveFolderPath.charAt(0)==" ") SaveFolderPath=myDocu.filePath.fsName+"\\"+SaveFolderPath.substr(1);
if (SaveFolderPath=="") SaveFolderPath=myDocu.filePath.fsName;
var SaveFolder=new Folder(SaveFolderPath);
if (!SaveFolder.exists) if (!SaveFolder.create()) err("フォルダが作れないよ");

switch (Sel0.constructor.name){
    case "Text":
    case "Character":
    case "Word":
    case "TextColumn":
    case "Paragraph":
    case "Line":
    case "TextStyleRange":
        var TexObj;
        if (TexFontSize==0) TexFontSize=Sel0.pointSize;
        while (TexObj=getTexText(myDocu.selection[0])) PlaceTex(TexObj);
        break;
     case "InsertionPoint":
        var TexObj;
        if (TexFontSize==0) TexFontSize=Sel0.pointSize;
        while (TexObj=getTexText(Sel0.parent)) PlaceTex(TexObj);
        break;
    case "Oval":
    case "Polygon":
    case "Rectangle":
        if (Sel0.parent.constructor.name=="Character" && myLabel=Sel0.label.replace(/[\n\r]/g,"").match(/%TeX\s*(.+)$/)){
            var myText=Sel0.parent.parent;
            if (TexFontSize==0) TexFontSize=Sel0.parent.pointSize;
            var n=Sel0.parent.index;
            myText.insertionPoints[n+1].contents=myLabel[1];
            Sel0.remove();
            var TexObj=getTexText(myText.characters.itemByRange(n,n+myLabel[1].length-1).getElements()[0]);
            PlaceTex(TexObj);
        } else if (myLabel=Sel0.label.replace(/[\n\r]/g,"").match(/%TeX\s*(.+)$/)){
            if (TexFontSize==0) TexFontSize=myDocu.textDefaults.pointSize;
            Sel0.place(MakeEps(myLabel[1],"Frame"));
            YohakuSet(Sel0,YohakuFrame);
            if (FrameObjStyleName!="") Sel0.applyObjectStyle(myDocu.objectStyles.item(FrameObjStyleName));
        } 
        break;
    case "TextFrame":
        var myLabel;
        if (myLabel=Sel0.parentStory.contents.match(/%TeX\s*(.+)$/)||myLabel=Sel0.label.replace(/\n/g,"").match(/%TeX\s*(.+)$/)){
            if (TexFontSize==0) TexFontSize=Sel0.characters[0].pointSize;
            Sel0.place(MakeEps(myLabel[1],"Frame"));
            YohakuSet(Sel0,YohakuFrame);
            if (FrameObjStyleName!="") Sel0.applyObjectStyle(myDocu.objectStyles.item(FrameObjStyleName));
            Sel0.label=myLabel[0];
        } 
        break;
    default : 
        break;
}
if (DelNotLinkedFile>0){
    var EpsFileList=SaveFolder.getFiles(myDocu.name.split(".",1)[0]+"Tex*.eps");
    var LinkNameList=myDocu.links.everyItem().name;
    for (var i=0;i<EpsFileList.length;i++){
        if (arrIndexOf(LinkNameList,EpsFileList[i].displayName)==-1) EpsFileList[i].remove();
    }
}
//mainここまで---------------------------------------------------------------------------------------------------
function getTexText(textObj){
    var n,m;
    if ((n=textObj.contents.indexOf("$"))>=0) {
        if ((m=textObj.contents.indexOf("$",n+1))>=0) {
            return {Code:textObj.characters.itemByRange(n,m).getElements()[0],type:"inline"};
        }
    } 
    if ((n=textObj.contents.indexOf("\\["))>=0){
        if ((m=textObj.contents.indexOf("\\]",n+1))>=0){
            return {Code:textObj.characters.itemByRange(n,m+1).getElements()[0],type:"display"};
        }
    } 
    return false;
}
function PlaceTex(Tex){
    var Onaji=arrIndexOf(Tex.Code.parent.rectangles.everyItem().label,"%TeX\r"+Tex.Code.contents);
    if (Onaji>-1){//ストーリー内に同じ数式があるかどうか
        var TexEPS=Tex.Code.insertionPoints[0].place(Tex.Code.parent.rectangles[Onaji].graphics[0].itemLink.filePath)[0];
    } else {
        var TexEpsFile=MakeEps(Tex.Code.contents,Tex.type);
        var TexEPS=Tex.Code.insertionPoints[0].place(TexEpsFile)[0];
    }
    var TexRectangle=TexEPS.parent;
    var TexAnchor=TexRectangle.parent;
    TexRectangle.label="%TeX\r"+Tex.Code.contents;
    Tex.Code.contents="";
    if (Tex.type=="inline") {
        var TexVb=TexRectangle.visibleBounds;
        var TexHorizontal=(TexAnchor.parentStory.storyPreferences.storyOrientation==StoryHorizontalOrVertical.HORIZONTAL);
        var TexHeight=TexHorizontal?(TexVb[2]-TexVb[0]):(TexVb[3]-TexVb[1]);
        if (InlineObjStyleName!="") TexRectangle.applyObjectStyle(myDocu.objectStyles.item(InlineObjStyleName));
        if (InlineCharStyleName!="") TexAnchor.applyCharacterStyle(myDocu.characterStyles.item(InlineCharStyleName));
        if (InlineJidouBaseline>0) {
            if (TexAnchor.parentStory.storyPreferences.frameType==FrameTypes.FRAME_GRID_TYPE){
                var TexTrim=(TexAnchor.parentStory.gridData.lineAki+TexAnchor.parentStory.gridData.pointSize-TexHeight)/2;
                YohakuSet(TexRectangle,TexHorizontal?[TexTrim,0,TexTrim,0]:[0,TexTrim,0,TexTrim]);
                TexRectangle.anchoredObjectSettings.anchorYoffset=InlineYOffset;
            } else {
                var TexTrim=(GetLeading(TexAnchor)-TexHeight)/2;
                YohakuSet(TexRectangle,TexHorizontal?[TexTrim,0,TexTrim,0]:[0,TexTrim,0,TexTrim]);
                TexRectangle.anchoredObjectSettings.anchorYoffset=InlineYOffset;
            }
        }
        YohakuSet(TexRectangle,YohakuInline);
    } else {
        YohakuSet(TexRectangle,YohakuDisplay);
        var TexVb=TexRectangle.visibleBounds;
        var TexHeight=(TexAnchor.parentStory.storyPreferences.storyOrientation==StoryHorizontalOrVertical.HORIZONTAL?(TexVb[2]-TexVb[0]):(TexVb[3]-TexVb[1]));
        if (DisplayObjStyleName!="") TexRectangle.applyObjectStyle(myDocu.objectStyles.item(DisplayObjStyleName));
        if (DisplayParaStyleName!="") TexAnchor.applyParagraphStyle(myDocu.paragraphStyles.item(DisplayParaStyleName));
        if (DisplayJidouGyoudori>0) {
            if (TexAnchor.parentStory.storyPreferences.frameType==FrameTypes.FRAME_GRID_TYPE){
                var GridMojiSize=TexAnchor.parentStory.gridData.pointSize;
                var GridGyouokuri=GridMojiSize+TexAnchor.parentStory.gridData.lineAki;
                TexAnchor.gridGyoudori=parseInt((TexHeight-GridMojiSize)/GridGyouokuri)+1;
            } else {
                TexAnchor.leading=TexHeight+GetLeading(TexAnchor.appliedParagraphStyle)-TexAnchor.pointSize;
                TexAnchor.pointSize=TexAnchor.leading;
            }
        }
    } 
}
function MakeEps(str,type){
    var t=new Date();
    var TempFileName=myDocu.name.split(".",1)[0]+"Tex"+t.getTime();
    var s="\\documentclass[fleqn]{jarticle}\r"
        +"\\usepackage{amsmath,amssymb}\r"
        +"\\usepackage[usenames]{color}\r"
        +"\\usepackage{enumerate}\r"
        +"\\usepackage{type1cm}\r"
        +"\\pagestyle{empty}\r"
        +"\\begin{document}\r"
        +"\\fontsize{"+TexFontSize+"pt}{"+(TexFontSize*TexAutoGyouokuri/100)+"}\\selectfont\r"
        +((type=="inline")?"\\textcolor{white}{$\\Biggl|$}\r":"")
        +str+"\r"
        +((type=="inline")?"\\textcolor{white}{$\\Biggr|$}\r":"")
        +"\\end{document}";
    var TexFile=new File(SaveFolder+"/"+TempFileName+".tex");
    if (TexFile.open("w")){
        TexFile.write(s);
        TexFile.close();
    }
    var VBS="Set Shell = CreateObject(\"WScript.Shell\")\r"
        +"Shell.CurrentDirectory=\""+SaveFolderPath+"\"\r"
        +"Shell.Run \"%ComSpec% /c \"\""+TexExe+"\"\" -kanji=sjis -interaction=nonstopmode "+TempFileName+".tex >> "+TempFileName+".txt\",0,True\r"
        +"Shell.Run \"%ComSpec% /c \"\""+DvipdfExe+"\"\" -vv -o "+TempFileName+".pdf "+TempFileName+".dvi >> "+TempFileName+".txt\",0,True\r"
        +"Shell.Run \"%ComSpec% /c \"\""+GsExe+"\"\"  -sDEVICE=epswrite -sOutputFile="+TempFileName+".eps -dNOPAUSE -dBATCH -dNOCACHE "+TempFileName+".pdf >> "+TempFileName+".txt\",0,True\r";
    //$.writeln(VBS);
    app.doScript(VBS,ScriptLanguage.VISUAL_BASIC);
    var TexEpsFile=File(SaveFolderPath+"\\"+TempFileName+".eps");
    if (!TexEpsFile.exists) err("なぜかepsファイルができてません");
    if (DelTempFile==1){
        File(SaveFolderPath+"\\"+TempFileName+".tex").remove();
        File(SaveFolderPath+"\\"+TempFileName+".dvi").remove();
        File(SaveFolderPath+"\\"+TempFileName+".pdf").remove();
        File(SaveFolderPath+"\\"+TempFileName+".aux").remove();
        File(SaveFolderPath+"\\"+TempFileName+".log").remove();
        File(SaveFolderPath+"\\"+TempFileName+".txt").remove();
    }
    return TexEpsFile;
}
function YohakuSet(Obj,Yohaku){
    var vb=Obj.visibleBounds;
    Obj.visibleBounds=[vb[0]-Yohaku[0],vb[1]-Yohaku[1],vb[2]+Yohaku[2],vb[3]+Yohaku[3]];
}
function err(s){
    alert(s);
    exit();
}
function arrIndexOf(a,s){
    for (var i=0;i<a.length;i++){
        if (a[i]===s) return i;
    }
    return -1;
}
function GetLeading(Obj){
    return (Obj.leading==Leading.AUTO?(Obj.pointSize*Obj.autoLeading/100):(Obj.leading)) 
}