﻿/////////////////////////////////////////////////
//　インてふてふver1.1
//　http://sysys.blog.shinobi.jp/Entry/18/
/////////////////////////////////////////////////

var SaveFolderPath=" eps";//ファイルの保存場所を指定　""でドキュメント保存フォルダ　１文字目半角スペースでドキュメント保存フォルダのサブフォルダ　またはフルパス
var TexExe="c:\\w32tex\\bin\\platex.exe";//TeXの実行ファイル　ちゃんとPATHが通ってればフルパスでなくていいかも　\は\\と書く
var DvipdfExe="c:\\w32tex\\bin\\dvipdfmx.exe";//dviをpdfに変換するやつ　TeXをインストールしたら一緒に入ってるはず
var GsExe="C:\\Program Files (x86)\\gs\\gs9.15\\bin\\gswin32c.exe";//Ghostscript　EPSをアレコレするやつ

var TexFontSize=0;//TEXの\fontsize{x}{y}のx　単位はpt　0:indesign上のテキストにあわせる
var TexAutoGyouokuri=150;//\fontsize{x}{y}のy=TexFontSize*TexAutoGyouokuri％
var InlineCharStyleName="";//インライン数式のアンカーに適用する文字スタイル名　（適用しない場合は""　スタイルグループは非対応）
var InlineObjStyleName="";//インライン数式に適用するオブジェクトスタイル名
var DisplayParaStyleName="";//ディスプレイ数式のアンカーに適用する段落スタイル名
var DisplayObjStyleName="";//ディスプレイ数式に適用するオブジェクトスタイル名
var FrameObjStyleName="";//フレーム数式に適用するオブジェクトスタイル名

var InlineJidouBaseline=1;//インライン数式のベースラインを自動調整　0:無効　1:有効
var InlineYOffset=0;//インライン数式のアンカーオプションのYオフセット
var DisplayJidouGyoudori=2;//ディスプレイ数式の行取りを自動調整　0:無効　1:有効　2:広め(フレームグリッドのみ)
var YohakuInline=[0,-2,-0.5,-2];//インライン数式の[上,左,下,右]の余白
var YohakuDisplay=[5,0,5,0];//ディスプレイ数式の[上,左,下,右]の余白
var YohakuFrame=[0,0,0,0];//フレーム数式の[上,左,下,右]の余白

var DelTempFile=1;//中間生成ファイルを　0:消さない　1:消す
var DelNotLinkedFile=1;//SaveFolderPath下の使われていないTex*****.epsを　0:消さない　1:消す
//設定ここまで---------------------------------------------------------------------------------------------------


if (app.scriptPreferences.version>=7) app.scriptPreferences.measurementUnit=MeasurementUnits.POINTS;
var pt={
    X:ConvertToPt(app.activeDocument.viewPreferences.horizontalMeasurementUnits),
    Y:ConvertToPt(app.activeDocument.viewPreferences.verticalMeasurementUnits),
    Line:ConvertToPt(app.activeDocument.viewPreferences[app.scriptPreferences.version<5?"lineMeasurementUnits":"strokeMeasurementUnits"]),
    Text:ConvertToPt(app.activeDocument.viewPreferences.textSizeMeasurementUnits),
    Typo:ConvertToPt(app.activeDocument.viewPreferences.typographicMeasurementUnits)
}
var Val=(app.scriptPreferences.version>=7//　Obj.isValidがtureならObj、falseならfalseを返す関数
    ?function (Obj){return Obj.isValid?Obj:false;}
    :function (Obj){
        try{
            Obj.parent;
            return Obj;
        }catch(e){
            return false;
        }
    }
);

var myDocu=app.activeDocument;
var Sel=myDocu.selection;
if (Sel.length==0) err("何も選択されてません");
var Sel0=Sel[0];
if (!myDocu.saved) err("ドキュメントを保存して下さい（）");
if (SaveFolderPath.charAt(0)==" ") SaveFolderPath=myDocu.filePath.fsName+"\\"+SaveFolderPath.substr(1);
if (SaveFolderPath=="") SaveFolderPath=myDocu.filePath.fsName;
var SaveFolder=new Folder(SaveFolderPath);
if (!SaveFolder.exists) if (!SaveFolder.create()) err("フォルダが作れないよ");

if (InlineCharStyleName!="") var InlineCharStyle=Val(myDocu.characterStyles.item(InlineCharStyleName)) || err("インライン文字スタイルが見つかりません");
if (InlineObjStyleName!="") var InlineObjStyle=Val(myDocu.objectStyles.item(InlineObjStyleName)) || err("インラインオブジェクトスタイルが見つかりません");
if (DisplayParaStyleName!="") var DisplayParaStyle=Val(myDocu.paragraphStyles.item(DisplayParaStyleName)) || err("ディスプレイ段落スタイルが見つかりません");
if (DisplayObjStyleName!="") var DisplayObjStyle=Val(myDocu.objectStyles.item(DisplayObjStyleName)) || err("ディスプレイオブジェクトスタイルが見つかりません");
if (FrameObjStyleName!="") var FrameObjStyle=Val(myDocu.objectStyles.item(FrameObjStyleName)) || err("フレームオブジェクトスタイルが見つかりません");

var myText=void 0;
switch (Sel0.constructor.name){
    case "Text":
    case "Character":
    case "Word":
    case "TextColumn":
    case "Paragraph":
    case "Line":
    case "TextStyleRange":
        myText=myDocu.selection[0];
     case "InsertionPoint":
        if (!myText) myText=Sel0.parent;
        if (TexFontSize==0) TexFontSize=Sel0.pointSize*pt.Text;
        while (PlaceTexInText(myText)) {};
        break;
    case "Oval":
    case "Polygon":
    case "Rectangle":
        if (Sel0.parent.constructor.name=="Character" && myLabel=Sel0.label.replace(/[\n\r]/g,"").match(/%TeX\s*(.+)$/)){
            var myStory=Sel0.parent.parent;
            if (TexFontSize==0) TexFontSize=Sel0.parent.pointSize*pt.Text;
            var n=Sel0.parent.index;
            myStory.insertionPoints[n+1].contents=myLabel[1];
            Sel0.remove();
            PlaceTexInText(myStory.characters.itemByRange(n,n+myLabel[1].length-1).getElements()[0]);
        } else {
            PlaceTexInFrame(Sel0,Sel0.label);
        } 
        break;
    case "TextFrame":
        PlaceTexInFrame(Sel0,Sel0.parentStory.contents) || PlaceTexInFrame(Sel0,Sel0.label);
        break;
}
if (DelNotLinkedFile>0){
    var EpsFileList=SaveFolder.getFiles(myDocu.name.split(".",1)[0]+"Tex*.eps");
    var LinkNameList=myDocu.links.everyItem().name;
    for (var i=0;i<EpsFileList.length;i++){
        if (arrIndexOf(LinkNameList,EpsFileList[i].displayName)==-1) EpsFileList[i].remove();
    }
}
//mainここまで---------------------------------------------------------------------------------------------------
function PlaceTexInText(textObj){
    var n,m;
    if ((n=textObj.contents.indexOf("$"))>=0) {
        if ((m=textObj.contents.indexOf("$",n+1))>=0) {
            var TexCode=textObj.characters.itemByRange(n,m).getElements()[0];
            var type="inline";
        }
    } else if ((n=textObj.contents.indexOf("\\["))>=0){
        if ((m=textObj.contents.indexOf("\\]",n+1))>=0){
            var TexCode=textObj.characters.itemByRange(n,m+1).getElements()[0];
            var type="display";
        }
    } else {
        return false;
    }
    var Onaji=arrIndexOf(TexCode.parent.rectangles.everyItem().label,"%TeX\r"+TexCode.contents);
    if (Onaji>-1){//ストーリー内に同じ数式があるかどうか
        var TexEPS=TexCode.insertionPoints[0].place(TexCode.parent.rectangles[Onaji].graphics[0].itemLink.filePath)[0];
    } else {
        var TexEpsFile=MakeEps(TexCode.contents,type);
        var TexEPS=TexCode.insertionPoints[0].place(TexEpsFile)[0];
    }
    var TexRectangle=TexEPS.parent;
    var TexAnchor=TexRectangle.parent;
    TexRectangle.label="%TeX\r"+TexCode.contents;
    TexCode.contents="";
    var TexHoriz=(TexAnchor.parentStory.storyPreferences.storyOrientation==StoryHorizontalOrVertical.HORIZONTAL);
    if (type=="inline") {
        var TexVb=getVB(TexRectangle);
        var TexHeight=TexHoriz?(TexVb[2]-TexVb[0]):(TexVb[3]-TexVb[1]);
        if (InlineObjStyleName!="") TexRectangle.applyObjectStyle(InlineObjStyle);
        if (InlineCharStyleName!="") TexAnchor.applyCharacterStyle(InlineCharStyle);
        if (InlineJidouBaseline>0) {
            var TexTrim=(GetLeading(TexAnchor)-TexHeight)/2;
            YohakuSet(TexRectangle,TexHoriz?[TexTrim,0,TexTrim,0]:[0,TexTrim,0,TexTrim]);
            TexRectangle.anchoredObjectSettings.anchorYoffset=InlineYOffset;
        }
        YohakuSet(TexRectangle,YohakuInline);
    } else if (type=="display") {
        YohakuSet(TexRectangle,YohakuDisplay);
        var TexVb=getVB(TexRectangle);
        var TexHeight=TexHoriz?(TexVb[2]-TexVb[0]):(TexVb[3]-TexVb[1]);
        if (DisplayObjStyleName!="") TexRectangle.applyObjectStyle(myDocu.objectStyles.item(DisplayObjStyleName));
        if (DisplayParaStyleName!="") TexAnchor.applyParagraphStyle(myDocu.paragraphStyles.item(DisplayParaStyleName));
        if (DisplayJidouGyoudori>0) {
            if (TexAnchor.parentStory.storyPreferences.frameType==FrameTypes.FRAME_GRID_TYPE){
                var GridMojiSize=TexAnchor.parentStory.gridData.pointSize*pt.Text;
                var GridGyouokuri=GridMojiSize+TexAnchor.parentStory.gridData.lineAki;
                TexAnchor.gridGyoudori=parseInt((TexHeight-GridMojiSize)/GridGyouokuri)+DisplayJidouGyoudori;
            } else {
                TexAnchor.leading=TexHeight+GetLeading(TexAnchor)-TexAnchor.pointSize*pt.Text+"pt";
                TexAnchor.pointSize=TexAnchor.leading*pt.Typo+"pt";
            }
        }
    } 
    return true;
}
function PlaceTexInFrame(myFrame,str){
    var myLabel;
    if (myLabel=str.match(/%TeX\s*(.+)$/)){
        if (TexFontSize==0) TexFontSize=(myFrame.hasOwnProperty("texts")?myFrame.texts[0]:myDocu.textDefaults).pointSize*pt.Text;
        myFrame.place(MakeEps(myLabel[1],"Frame"));
        YohakuSet(myFrame,YohakuFrame);
        if (FrameObjStyleName!="") Sel0.applyObjectStyle(FrameObjStyle);
        return true;
    } else {
        return false;
    }
}
function MakeEps(str,type){
    var t=new Date();
    var TempFileName=myDocu.name.split(".",1)[0]+"Tex"+t.getTime();
    var s="\\documentclass[fleqn]{jarticle}\r"
        +"\\usepackage{amsmath,amssymb}\r"
        +"\\usepackage[usenames]{color}\r"
        +"\\usepackage{enumerate}\r"
        +"\\usepackage{type1cm}\r"
        +"\\pagestyle{empty}\r"
        +"\\begin{document}\r"
        +"\\fontsize{"+TexFontSize+"pt}{"+(TexFontSize*TexAutoGyouokuri/100)+"}\\selectfont\r"
        +((type=="inline")?"\\textcolor{white}{$\\Biggl|$}\r":"")
        +str+"\r"
        +((type=="inline")?"\\textcolor{white}{$\\Biggr|$}\r":"")
        +"\\end{document}";
    var TexFile=new File(SaveFolder+"/"+TempFileName+".tex");
    if (TexFile.open("w")){
        TexFile.write(s);
        TexFile.close();
    }
    var VBS="Set Shell = CreateObject(\"WScript.Shell\")\r"
        +"Shell.CurrentDirectory=\""+SaveFolderPath+"\"\r"
        +"Shell.Run \"%ComSpec% /c \"\""+TexExe+"\"\" -kanji=sjis -interaction=nonstopmode "+TempFileName+".tex >> "+TempFileName+".txt\",0,True\r"
        +"Shell.Run \"%ComSpec% /c \"\""+DvipdfExe+"\"\" -vv -o "+TempFileName+".pdf "+TempFileName+".dvi >> "+TempFileName+".txt\",0,True\r"
        +"Shell.Run \"%ComSpec% /c \"\""+GsExe+"\"\"  -sDEVICE=eps2write -sOutputFile="+TempFileName+".eps -dNOPAUSE -dBATCH -dNOCACHE "+TempFileName+".pdf >> "+TempFileName+".txt\",0,True\r";
    //$.writeln(VBS);
    app.doScript(VBS,ScriptLanguage.VISUAL_BASIC);
    var TexEpsFile=File(SaveFolderPath+"\\"+TempFileName+".eps");
    if (!TexEpsFile.exists) err("なぜかepsファイルができてません");
    if (DelTempFile==1){
        File(SaveFolderPath+"\\"+TempFileName+".tex").remove();
        File(SaveFolderPath+"\\"+TempFileName+".dvi").remove();
        File(SaveFolderPath+"\\"+TempFileName+".pdf").remove();
        File(SaveFolderPath+"\\"+TempFileName+".aux").remove();
        File(SaveFolderPath+"\\"+TempFileName+".log").remove();
        File(SaveFolderPath+"\\"+TempFileName+".txt").remove();
    }
    return TexEpsFile;
}

function ConvertToPt(measurementUnit){
    if (app.scriptPreferences.version>=7) return 1;
    switch(measurementUnit){
        case MeasurementUnits.AGATES : return 5.14285714285714;
        case MeasurementUnits.AMERICAN_POINTS : return 0.99609448818898;
        case MeasurementUnits.BAI : return 6.336;
        case MeasurementUnits.CENTIMETERS : return 28.3464566929134;
        case MeasurementUnits.CICEROS : return 12.7878751998;
        case MeasurementUnits.HA : return 0.70866141732283;
        case MeasurementUnits.INCHES : return 72;
        case MeasurementUnits.INCHES_DECIMAL : return 72;
        case MeasurementUnits.MILLIMETERS : return 2.83464566929134;
        case MeasurementUnits.MILS : return 0.072;
        case MeasurementUnits.PICAS : return 12;
        case MeasurementUnits.PIXELS : return 1;
        case MeasurementUnits.POINTS : return 1;
        case MeasurementUnits.Q : return 0.70866141732283;
        case MeasurementUnits.U : return 0.792;
    }
}
function getVB(Obj){
    var vb=Obj.visibleBounds;
    return [vb[0]*pt.Y,vb[1]*pt.X,vb[2]*pt.Y,vb[3]*pt.X];
}
function YohakuSet(Obj,Yohaku){
    var vb=getVB(Obj);
    Obj.visibleBounds=[vb[0]-Yohaku[0]+"pt",vb[1]-Yohaku[1]+"pt",vb[2]+Yohaku[2]+"pt",vb[3]+Yohaku[3]+"pt"];
}

function err(s){
    alert(s);
    exit();
}
function arrIndexOf(a,s){
    for (var i=0;i<a.length;i++){
        if (a[i]===s) return i;
    }
    return -1;
}
function GetLeading(Obj){
    return (Obj.parentStory.storyPreferences.frameType==FrameTypes.FRAME_GRID_TYPE)?
        (Obj.parentStory.gridData.lineAki+Obj.parentStory.gridData.pointSize*pt.Text):
        (Obj.leading==Leading.AUTO?(Obj.pointSize*pt.Text*Obj.autoLeading/100):(Obj.leading*pt.Typo));
}