﻿/////////////////////////////////////////////////
//　選択物のサイズで新規作成ver1.0
//　http://sysys.blog.shinobi.jp/Entry/31/
/////////////////////////////////////////////////

#target "InDesign"
var myDocu=app.activeDocument;
var Sel=myDocu.selection;
if (Sel.length==0){
    var Sel0={};
    Sel0.visibleBounds=[0,0,myDocu.documentPreferences.pageHeight,myDocu.documentPreferences.pageWidth];
    Sel0.geometricBounds=Sel0.visibleBounds;
} else if (Sel.length==1){
    var Sel0=app.activeDocument.selection[0];
    if (!Sel0.hasOwnProperty("visibleBounds"))exit();
} else { 
    exit();
}
app.scriptPreferences.measurementUnit=MeasurementUnits.POINTS;
var myDiag=app.dialogs.item("選択物のサイズで新規作成");
if (!myDiag.isValid) {
    with (myDiag=app.dialogs.add({name:"選択物のサイズで新規作成"})){
        with (dialogColumns.add()){
            with(borderPanels.add().radiobuttonGroups.add()){
                radiobuttonControls.add({staticLabel:"線幅を含まないサイズ",checkedState:true});
                radiobuttonControls.add({staticLabel:"線幅を含むサイズ"});
            }
            with(borderPanels.add().radiobuttonGroups.add()){
                radiobuttonControls.add({staticLabel:"CMYK",checkedState:true});
                radiobuttonControls.add({staticLabel:"RGB"});
            }
            with(borderPanels.add().radiobuttonGroups.add()){
                radiobuttonControls.add({staticLabel:"イラレ",checkedState:true});
                radiobuttonControls.add({staticLabel:"フォトショ"});
                radiobuttonControls.add({staticLabel:"InDesign"});
            }
            with(dialogRows.add()){
                staticTexts.add({staticLabel:"dpi（フォトショ）:"});
                textEditboxes.add({editContents:"350"});
            }
        }
    }
}
if(!myDiag.show())exit();
var bounds=Sel0[myDiag.dialogColumns[0].borderPanels[0].radiobuttonGroups[0].selectedButton==0?"geometricBounds":"visibleBounds"];
var CMYKorRGB=(myDiag.dialogColumns[0].borderPanels[1].radiobuttonGroups[0].selectedButton==0?"CMYK":"RGB");
var TargetApp=myDiag.dialogColumns[0].borderPanels[2].radiobuttonGroups[0].selectedButton;
var dpi=myDiag.dialogColumns[0].dialogRows[0].textEditboxes[0].editContents;

var w=bounds[3]-bounds[1];
var h=bounds[2]-bounds[0];

var bt=new BridgeTalk;
if (TargetApp==0){
    bt.target="illustrator";
    bt.body="var dp=new DocumentPreset;\r"+
        "dp.colorMode=DocumentColorSpace."+CMYKorRGB+";\r"+
        "dp.width="+w+";\r"+
        "dp.height="+h+";\r"+
        "dp.units=RulerUnits.Millimeters;\r"+
        "app.documents.addDocument([],dp);\r";
    bt.send();
} else if (TargetApp==1){
    bt.target="photoshop";
    bt.body="app.documents.add(UnitValue("+w+",'pt'),UnitValue("+h+",'pt'),"+dpi+",undefined,NewDocumentMode."+CMYKorRGB+");";
    bt.send();
} else {
    newDocu=app.documents.add();
    newDocu.documentPreferences.pageWidth=w;
    newDocu.documentPreferences.pageHeight=h;
}