﻿/////////////////////////////////////////////////
//　段間罫線ver2.0
//　http://sysys.blog.shinobi.jp/Entry/36/
/////////////////////////////////////////////////

app.doScript(function(){
var myDocu=app.activeDocument;
var Sel=myDocu.selection;
if (Sel.length==0) exit();
var Sel0=Sel[0];
if (Sel0.constructor.name!="TextFrame") exit();
var myMeasurementUnit=app.scriptPreferences.measurementUnit;
app.scriptPreferences.measurementUnit=MeasurementUnits.POINTS;
var Keisen0=myDocu.graphicLines.item("keisen"+Sel0.id+"_"+1);
if (Keisen0.isValid){
    var Senhaba=Keisen0.extractLabel("Dankankeisen_Senhaba");
    var Hamidasi=Keisen0.extractLabel("Dankankeisen_Hamidasi");
    var Renketu=Keisen0.extractLabel("Dankankeisen_Renketu")=="true"?true:false;
    var Mawarikomi=Keisen0.extractLabel("Dankankeisen_Mawarikomi")=="true"?true:false;
    var ObjectStyleIndex=Keisen0.appliedObjectStyle.index;
    var LayerIndex=Keisen0.itemLayer.index;
} else {
    var Senhaba="";
    var Hamidasi="";
    var ObjectStyleIndex=0;
    var LayerIndex=Sel0.itemLayer.index;
    var Renketu=false;
    var Mawarikomi=true;
}
var myDiag=app.dialogs.add({name:"段間罫線.jsx"});
with (myDiag){
    with (dialogColumns.add()){
        with (dialogRows.add()){
            staticTexts.add({staticLabel:"線幅（0でオブジェクトスタイルに任せる）:"});
            var SenhabaTE=measurementEditboxes.add({editContents:Senhaba,editUnits:myDocu.viewPreferences[app.scriptPreferences.version<7?"lineMeasurementUnits":"strokeMeasurementUnits"]});
        }
        with (dialogRows.add()){
            staticTexts.add({staticLabel:"はみ出し:"});
            var HamidasiTE=measurementEditboxes.add({editContents:Hamidasi,editUnits:myDocu.viewPreferences.horizontalMeasurementUnits});
        }
        with (dialogRows.add()){
            staticTexts.add({staticLabel:"オブジェクトスタイル:"});
            var ObjctStyleDD=dropdowns.add({stringList:myDocu.objectStyles.everyItem().name, selectedIndex:ObjectStyleIndex});
        }
        with (dialogRows.add()){
            staticTexts.add({staticLabel:"レイヤー:"});
            var LayerDD=dropdowns.add({stringList:myDocu.layers.everyItem().name, selectedIndex:LayerIndex});
        }
        var MawarikomiCC=checkboxControls.add({staticLabel:"回り込みオブジェクトを避ける（縦組フレームグリッドのみ）",checkedState:Mawarikomi});
        var RenketuCC=checkboxControls.add({staticLabel:"連結フレームも",checkedState:Renketu});
        var SakujoCC=checkboxControls.add({staticLabel:"削除だけ",checkedState:false});
    }
}
if(!myDiag.show()) myExit();

Senhaba=SenhabaTE.editValue;
Hamidasi=HamidasiTE.editValue;

(function (myTextFrame) {
    var mySpread=getParentPageOrSpread(myTextFrame)
    var n,Keisen0;
    for (n=1,Keisen0=mySpread.graphicLines.item("keisen"+myTextFrame.id+"_1");Keisen0.isValid;n++,Keisen0=mySpread.graphicLines.item("keisen"+myTextFrame.id+"_"+n)) {
        if (Keisen0.itemLayer.locked){
            Keisen0.itemLayer.locked=false;
            Keisen0.remove();
            Keisen0.itemLayer.locked=true;
        } else {
            Keisen0.remove();
        }
    }

    if (!SakujoCC.checkedState && MawarikomiCC.checkedState && myTextFrame.parentStory.storyPreferences.frameType==FrameTypes.FRAME_GRID_TYPE && myTextFrame.parentStory.storyPreferences.storyOrientation==StoryHorizontalOrVertical.VERTICAL){
        var gData=getGridFrameData(myTextFrame);
        var Copi0=myTextFrame.duplicate();
        var anchoredObjects=Copi0.pageItems.everyItem().getElements();
        var delPageItems=[Copi0];
        for (var i=0;i<anchoredObjects.length;i++) {
            if (anchoredObjects[i].anchoredObjectSettings.anchoredPosition==AnchorPosition.ANCHORED){
                anchoredObjects[i].anchoredObjectSettings.releaseAnchoredObject();
                delPageItems.push(anchoredObjects[i]);
            }
        }
        Copi0.strokeColor="None";
        //Copi0.strokeWeight=0;
        Copi0.textFramePreferences.insetSpacing=[0,0,0,0];
        Copi0.textFramePreferences.textColumnCount=gData.columnsL-1;
        Copi0.parentStory.gridData.verticalScale=(gData.gutter/3)/gData.pointSize*100;
        Copi0.textFramePreferences.textColumnGutter=gData.columnHeight+gData.gutter*2/3
        Copi0.visibleBounds=[gData.columnStart[0]+gData.columnHeight+gData.gutter/3,gData.columnStart[1],gData.columnStart[0]+gData.columnHeight+gData.gutter*2/3+(gData.columnHeight+gData.gutter)*(gData.columnsL-2),gData.columnStart[1]-gData.columnWidth];
        var str="ああああああああああ";
        for (var i=0;i<gData.columnLinesL*(gData.columnsL-1)/10;i++) str+="ああああああああああ";
        with (Copi0.parentStory.texts[0]){
            contents=str;
            applyCharacterStyle(myDocu.characterStyles[0]);
            applyParagraphStyle(myDocu.paragraphStyles[0]);
            clearOverrides();
        }
        var mList=[];
        for (var n=0,m=0;n<gData.columnsL-1;n++) {
            var columnMList=[];
            if (m<Copi0.textColumns.length && Copi0.textColumns[m].characters[0].baseline<gData.columnStart[0]+(gData.columnHeight+gData.gutter)*(n+1)) {
                var lineHorizontalOffsets=Copi0.textColumns[m].lines.everyItem().horizontalOffset;
                for (var i=0,j=0;i<gData.columnLinesL;i++){
                    if (gData.columnStart[1]-gData.gyouokuri*(i+1)<lineHorizontalOffsets[j] && lineHorizontalOffsets[j]<gData.columnStart[1]-gData.gyouokuri*(i)) {
                        columnMList.push(1);
                        j++;
                    } else {
                        columnMList.push(0);
                    }
                }
                m++;
            } else {
                for (var i=0;i<gData.columnLinesL;i++) columnMList.push(0);
            }
            mList.push(columnMList);
            //$.writeln(columnMList);
        }
        for (var i=0;i<delPageItems.length;i++) delPageItems[i].remove();

        for (var n=1,m=1;n<gData.columnsL;n++) {
            var KeisenY=gData.columnStart[0]+gData.columnHeight*n+gData.gutter*(n-1/2);
            var flag=0,KeisenX0,KeisenX1;
            for (var t=0;t<gData.columnLinesL;t++){
                if (!flag && mList[n-1][t]) {
                    KeisenX0=gData.columnStart[1]+Hamidasi-gData.gyouokuri*t;
                    flag=1;
                }
                if (flag && !mList[n-1][t]) {
                    KeisenX1=gData.columnStart[1]-Hamidasi-gData.gyouokuri*t+gData.lineAki;
                    var KeisenName="keisen"+myTextFrame.id+"_"+m;
                    var Keisen=mySpread.graphicLines.add({name:KeisenName});
                    Keisen.geometricBounds=[KeisenY,KeisenX0,KeisenY,KeisenX1];
                    Keisen.applyObjectStyle(myDocu.objectStyles[ObjctStyleDD.selectedIndex],true);
                    if (Senhaba!=0) Keisen.strokeWeight=Senhaba;
                    Keisen.move(myDocu.layers[LayerDD.selectedIndex]);
                    if (m==1) setLabel(Keisen);
                    m++;
                    flag=0;
                }
            }
            if (flag){
                var KeisenName="keisen"+myTextFrame.id+"_"+m;
                var Keisen=mySpread.graphicLines.add({name:KeisenName});
                Keisen.geometricBounds=[KeisenY,KeisenX0,KeisenY,gData.columnStart[1]-gData.columnWidth-Hamidasi];
                Keisen.applyObjectStyle(myDocu.objectStyles[ObjctStyleDD.selectedIndex],true);
                if (Senhaba!=0) Keisen.strokeWeight=Senhaba;
                Keisen.move(myDocu.layers[LayerDD.selectedIndex]);
                if (m==1) setLabel(Keisen);
                m++;
            }
        }
    } else {
        if (!SakujoCC.checkedState){
            var GB=myTextFrame.geometricBounds;
            var FrameStrokeWeight=(myTextFrame.strokeColor.name=="None"?0:myTextFrame.strokeWeight);
            var Sotowaku=myTextFrame.strokeAlignment==StrokeAlignment.CENTER_ALIGNMENT?FrameStrokeWeight/2:(myTextFrame.strokeAlignment==StrokeAlignment.INSIDE_ALIGNMENT?FrameStrokeWeight:0)
            var Margin=myTextFrame.textFramePreferences.insetSpacing;
            var Dansuu=myTextFrame.textFramePreferences.textColumnCount;
            var Dankan=myTextFrame.textFramePreferences.textColumnGutter;

            if (myTextFrame.parentStory.storyPreferences.storyOrientation==StoryHorizontalOrVertical.HORIZONTAL) {
                var DanW=(GB[3]-GB[1]-Margin[3]-Margin[1]-2*Sotowaku+Dankan)/Dansuu-Dankan;
                var Dan0GB=[GB[0]+Margin[0]+Sotowaku,GB[1]+Margin[1]+Sotowaku,GB[2]-Margin[2]-Sotowaku,GB[1]+Margin[1]+Sotowaku+DanW];
                for (var n=1;n<Dansuu;n++){
                    var KeisenGB=[Dan0GB[0]-Hamidasi,Dan0GB[1]+(DanW+Dankan)*n-Dankan/2,Dan0GB[2]+Hamidasi,Dan0GB[1]+(DanW+Dankan)*n-Dankan/2];
                    var KeisenName="keisen"+myTextFrame.id+"_"+n;
                    var Keisen=mySpread.graphicLines.add({name:KeisenName});
                    Keisen.geometricBounds=KeisenGB;
                    Keisen.applyObjectStyle(myDocu.objectStyles[ObjctStyleDD.selectedIndex],true);
                    if (Senhaba!==0) Keisen.strokeWeight=Senhaba;
                    Keisen.move(myDocu.layers[LayerDD.selectedIndex]);
                    if (n==1) setLabel(Keisen);
                }
            } else {
                var DanH=(GB[2]-GB[0]-Margin[0]-Margin[2]-2*Sotowaku+Dankan)/Dansuu-Dankan;
                var Dan0GB=[GB[0]+Margin[0]+Sotowaku,GB[1]+Margin[1]+Sotowaku,GB[0]+Margin[0]+Sotowaku+DanH,GB[3]-Margin[3]-Sotowaku];
                for (var n=1;n<Dansuu;n++){
                    var KeisenGB=[Dan0GB[0]+(DanH+Dankan)*n-Dankan/2,Dan0GB[1]-Hamidasi,Dan0GB[0]+(DanH+Dankan)*n-Dankan/2,Dan0GB[3]+Hamidasi];
                    var KeisenName="keisen"+myTextFrame.id+"_"+n;
                    var Keisen=mySpread.graphicLines.add({name:KeisenName});
                    Keisen.geometricBounds=KeisenGB;
                    Keisen.applyObjectStyle(myDocu.objectStyles[ObjctStyleDD.selectedIndex],true);
                    if (Senhaba!=0) Keisen.strokeWeight=Senhaba;
                    Keisen.move(myDocu.layers[LayerDD.selectedIndex]);
                    if (n==1) setLabel(Keisen);
                }
            }
        }
    }
    if (RenketuCC.checkedState && myTextFrame.nextTextFrame!=null) arguments.callee(myTextFrame.nextTextFrame);
})(RenketuCC.checkedState?(Sel0.startTextFrame||Sel0):Sel0);
myExit();
function myExit(){
    myDiag.destroy();
    app.scriptPreferences.measurementUnit=myMeasurementUnit;
    exit();
}
function setLabel(Obj){
    Obj.insertLabel("Dankankeisen_Senhaba",""+SenhabaTE.editContents);
    Obj.insertLabel("Dankankeisen_Hamidasi",""+HamidasiTE.editContents);
    Obj.insertLabel("Dankankeisen_Renketu",""+RenketuCC.checkedState);
    Obj.insertLabel("Dankankeisen_Mawarikomi",""+MawarikomiCC.checkedState);
}
function getParentPageOrSpread(Obj){
    return (Obj.constructor.name=="Page"||Obj.constructor.name=="Spread"||Obj.constructor.name=="MasterSpread")?Obj:(Obj.constructor.name=="Application"?null:getParentPageOrSpread(Obj.parent));
}
function getGridFrameData(Obj){
    app.scriptPreferences.measurementUnit=MeasurementUnits.POINTS;
    var GData=Obj.parentStory.gridData.properties;
    GData.margin=Obj.textFramePreferences.insetSpacing;
    GData.columnsL=Obj.textFramePreferences.textColumnCount;
    GData.gutter=Obj.textFramePreferences.textColumnGutter;
    GData.isHorizontal=(Obj.parentStory.storyPreferences.storyOrientation==StoryHorizontalOrVertical.HORIZONTAL);
    GData.horizontalPointSize=GData.pointSize*GData.horizontalScale/100;
    GData.verticalPointSize=GData.pointSize*GData.verticalScale/100;
    GData.strokeWeight=(Obj.strokeColor.name=="None"?0:Obj.strokeWeight);
    var vb=Obj.visibleBounds;
    if(GData.isHorizontal){
        GData.jiokuri=GData.horizontalPointSize+GData.characterAki;
        GData.gyouokuri=GData.verticalPointSize+GData.lineAki;
        GData.columnStart=[vb[1]+GData.margin[1]+GData.strokeWeight,vb[0]+GData.margin[0]+GData.strokeWeight]
        GData.columnHeight=(vb[2]-vb[0]-GData.margin[0]-GData.margin[2]-GData.strokeWeight*2);
        GData.columnWidth=(vb[3]-vb[1]-GData.margin[1]-GData.margin[3]-GData.strokeWeight*2-GData.gutter*(GData.columnsL-1))/GData.columnsL;
        GData.lineCharactersL=(GData.columnWidth+GData.characterAki)/(GData.jiokuri);
        GData.columnLinesL=(GData.columnHeight+GData.lineAki)/(GData.gyouokuri);
    } else {
        GData.jiokuri=GData.verticalPointSize+GData.characterAki;
        GData.gyouokuri=GData.horizontalPointSize+GData.lineAki;
        GData.columnStart=[vb[0]+GData.margin[0]+GData.strokeWeight,vb[3]-GData.margin[3]-GData.strokeWeight]
        GData.columnWidth=(vb[3]-vb[1]-GData.margin[1]-GData.margin[3]-GData.strokeWeight*2);
        GData.columnHeight=(vb[2]-vb[0]-GData.margin[0]-GData.margin[2]-GData.strokeWeight*2-GData.gutter*(GData.columnsL-1))/GData.columnsL;
        GData.lineCharactersL=(GData.columnHeight+GData.characterAki)/(GData.jiokuri);
        GData.columnLinesL=(GData.columnWidth+GData.lineAki)/(GData.gyouokuri);
    }
     GData.columnCharactersL=GData.lineCharactersL*GData.columnLinesL;
     GData.charactersL=GData.columnCharactersL*GData.columnsL;
    return GData;
}

},ScriptLanguage.JAVASCRIPT,[],UndoModes.ENTIRE_SCRIPT);