﻿/////////////////////////////////////////////////
//　水平垂直比率に乗算 ver1.0
//　http://sysys.blog.shinobi.jp/Entry/37/
/////////////////////////////////////////////////
if (app.scriptPreferences.version>=7) {
    app.doScript(main,ScriptLanguage.JAVASCRIPT,[],UndoModes.ENTIRE_SCRIPT);
} else {
    main();
}
function main(){
    var SelTexts=getTextObjs(app.activeDocument.selection);
    if (SelTexts.length==0) return;
    var myDiag=app.dialogs.add({name:"水平垂直比率に乗算.jsx"});
    try {
        with (myDiag.dialogColumns.add()) {
            with (dialogRows.add()){
                staticTexts.add({staticLabel:"垂直比率×＝"});
                percentEditboxes.add({editValue:100});
            }
            with (dialogRows.add()){
                staticTexts.add({staticLabel:"水平比率×＝"});
                percentEditboxes.add({editValue:100});
            }
            checkboxControls.add({staticLabel:"整数値にする（切り捨て）",checkedState:true});
            checkboxControls.add({staticLabel:"１文字ずつ処理（※正規表現スタイル使用時）",checkedState:false});
        }
        if (!myDiag.show()) throw "";
        var VScale=myDiag.dialogColumns[0].dialogRows[0].percentEditboxes[0].editValue;
        var HScale=myDiag.dialogColumns[0].dialogRows[1].percentEditboxes[0].editValue;
        var Seisu=myDiag.dialogColumns[0].checkboxControls[0].checkedState;
        var mojigoto=myDiag.dialogColumns[0].checkboxControls[1].checkedState;

        if (Seisu) {
            for (var i=0;i<SelTexts.length;i++){
                if (SelTexts[i].contents=="") continue;
                var myTextStyleRanges=mojigoto?SelTexts[i].characters.everyItem().getElements():SelTexts[i].textStyleRanges.everyItem().getElements();
                if (!mojigoto) myTextStyleRanges[myTextStyleRanges.length-1]=SelTexts[i].parent.characters.itemByRange(myTextStyleRanges[myTextStyleRanges.length-1].characters[0],SelTexts[i].characters[-1]).getElements()[0];
                if (VScale!=100) {
                    for (var j=0;j<myTextStyleRanges.length;j++) {
                        myTextStyleRanges[j].verticalScale=parseInt(myTextStyleRanges[j].verticalScale*VScale/100);
                    }
                }
                if (HScale!=100) {
                    for (var j=0;j<myTextStyleRanges.length;j++) {
                        myTextStyleRanges[j].horizontalScale=parseInt(myTextStyleRanges[j].horizontalScale*HScale/100);
                    }
                }
            }
        } else {
            for (var i=0;i<SelTexts.length;i++){
                if (SelTexts[i].contents=="") continue;
                var myTextStyleRanges=mojigoto?SelTexts[i].characters.everyItem().getElements():SelTexts[i].textStyleRanges.everyItem().getElements();
                if (!mojigoto) myTextStyleRanges[myTextStyleRanges.length-1]=SelTexts[i].parent.characters.itemByRange(myTextStyleRanges[myTextStyleRanges.length-1].characters[0],SelTexts[i].characters[-1]).getElements()[0];
                if (VScale!=100) {
                    for (var j=0;j<myTextStyleRanges.length;j++) {
                        myTextStyleRanges[j].verticalScale*=VScale/100;
                    }
                }
                if (HScale!=100) {
                    for (var j=0;j<myTextStyleRanges.length;j++) {
                        myTextStyleRanges[j].horizontalScale*=HScale/100;
                    }
                }
            }
        }
    } catch (e) {
        if (e!="") alert(e);
    } finally {
        myDiag.destroy();
    }

    function getTextObjs(Objs) {
        var TextObjs=[];
        for (var n=0;n<Objs.length;n++){
            if (Objs[n].constructor.name=="Table") {
                TextObjs=TextObjs.concat(Objs[n].cells.everyItem().texts[0].getElements());
            } else if (Objs[n].hasOwnProperty("texts")) {
                TextObjs=TextObjs.concat(Objs[n].texts.everyItem().getElements());
            } else if (Objs[n].constructor.name=="Group") {
                TextObjs=TextObjs.concat(getTextObjs(Objs[n].pageItems.everyItem().getElements()));
            }
        }
        return TextObjs;
    }
}