﻿/////////////////////////////////////////////////
//　1000を千に ver1.1
//　http://sysys.blog.shinobi.jp/Entry/39/
/////////////////////////////////////////////////

// 選択中のテキスト、テキストフレーム、テキストフレームを含むグループ、または表のセル（複数選択可）からテキストオブジェクトを取得
// カーソルを置いてる場合はその親（ストーリー、セル、脚注など）を取得
var SelTexts=getTextObjsP(app.activeDocument.selection);

//ChangeGrepXの第1引数が検索文字列（正規表現）
//第2引数がマッチした文字列を受け取って置換文字列を返す関数
ChangeGrepX(
    "\\d+",
    function(s){
        s=s.replace(/[0０]/g,"〇");
        s=s.replace(/[1１]/g,"一");
        s=s.replace(/[2２]/g,"二");
        s=s.replace(/[3３]/g,"三");
        s=s.replace(/[4４]/g,"四");
        s=s.replace(/[5５]/g,"五");
        s=s.replace(/[6６]/g,"六");
        s=s.replace(/[7７]/g,"七");
        s=s.replace(/[8８]/g,"八");
        s=s.replace(/[9９]/g,"九");
        s=s.replace(/([〇一二三四五六七八九]+)([〇一二三四五六七八九]{20})/,"$1垓$2");
        s=s.replace(/([〇一二三四五六七八九]+)([〇一二三四五六七八九]{16})/,"$1京$2");
        s=s.replace(/([〇一二三四五六七八九]+)([〇一二三四五六七八九]{12})/,"$1兆$2");
        s=s.replace(/([〇一二三四五六七八九]+)([〇一二三四五六七八九]{8})/,"$1億$2");
        s=s.replace(/([〇一二三四五六七八九]+)([〇一二三四五六七八九]{4})/,"$1万$2");
        s=s.replace(/([〇一二三四五六七八九])([〇一二三四五六七八九]{3})/g,"$1千$2");
        s=s.replace(/([〇一二三四五六七八九])([〇一二三四五六七八九]{2})/g,"$1百$2");
        s=s.replace(/([〇一二三四五六七八九])([〇一二三四五六七八九])/g,"$1十$2");
        s=s.replace(/一([千百十])/g,"$1");//
        s=s.replace(/([千百十])〇([垓京兆億万])/g,"$1$2");
        s=s.replace(/〇[垓京兆億万千百十]/g,"");
        s=s.replace(/〇/g,"");
        return s;
    }
);

//続けて複数書いてもいいよ
//ChangeGrepX(
//    …
//)

/////////////////////////////////////////////////////////////////////////////
function ChangeGrepX(regstr,func) {
    if (app.scriptPreferences.version>=7) {
        app.doScript(ChangeGrepXMain,ScriptLanguage.JAVASCRIPT,[],UndoModes.ENTIRE_SCRIPT);
    } else {
        ChangeGrepXMain();
    }
    function ChangeGrepXMain(){
        app.findGrepPreferences=NothingEnum.nothing;
        app.findGrepPreferences.findWhat =regstr;
        for (var i=0;i<SelTexts.length;i++){
            if (SelTexts[i].contents=="") continue;
            var foundTexts=SelTexts[i].findGrep();
            for (var j=foundTexts.length-1;j>=0;j--){
                foundTexts[j].contents=func(foundTexts[j].contents);
            }
        }
    }
}
function getTextObjsP(Objs) {
    var TextObjs=[];
    for (var n=0;n<Objs.length;n++){
        if (Objs[n].constructor.name=="InsertionPoint") {
            TextObjs=TextObjs.concat(Objs[n].parent.texts[0].getElements());
        } else if (Objs[n].constructor.name=="Table") {
            TextObjs=TextObjs.concat(Objs[n].cells.everyItem().texts[0].getElements());
        } else if (Objs[n].hasOwnProperty("texts")) {
            TextObjs=TextObjs.concat(Objs[n].texts.everyItem().getElements());
        } else if (Objs[n].constructor.name=="Group") {
            TextObjs=TextObjs.concat(getTextObjs(Objs[n].pageItems.everyItem().getElements()));
        }
    }
    return TextObjs;
}
