﻿/////////////////////////////////////////////////
//　インてふてふver1.31
//　http://sysys.blog.shinobi.jp/Entry/18/
/////////////////////////////////////////////////
#target "InDesign"
#targetengine "intextex"

var SaveFolderPath=" tex";//ファイルの保存場所を指定　""でドキュメント保存フォルダ　１文字目半角スペースでドキュメント保存フォルダのサブフォルダ　またはフルパス
var TexExe="platex";//TeXの実行コマンド　いわゆる「PATHを通す」ができてなければ実行ファイルへのフルパスを書く （\は\\と書く）
var DvipdfExe="dvipdfmx";//dviをpdfに変換するやつ　TeXをインストールしたら一緒に入ってるはず
var GsExe="gswin32c";//Ghostscript　EPSをアレコレするやつ
var GsDevice="eps2write";//Ghostscriptのアウトプットデバイス名　eps2writeでうまくいかない場合はepswriteに

var TexFontSize=0;//TEXの\fontsize{x}{y}のx　単位はpt　0:indesign上のテキストにあわせる
var TexAutoGyouokuri=150;//\fontsize{x}{y}のy=TexFontSize*TexAutoGyouokuri％
var InlineBaseline=true;//インライン数式のベースラインを調整
var DisplayGyoutori=true;//ディスプレイ数式の行取りを調整
var InlineYohaku=[0,-2,-0.5,-2];//インライン数式の[上,左,下,右]の余白
var DisplayYohaku=[5,0,5,0];//ディスプレイ数式の[上,左,下,右]の余白
var FrameYohaku=[0,0,0,0];//フレーム数式の[上,左,下,右]の余白

var DelTempFile=true;//中間生成ファイルを消す
var AiKa=false;//イラレでAi化する

var InlineCharStyleIndex=0,InlineObjStyleIndex=0,DisplayParaStyleIndex=0,DisplayObjStyleIndex=0,FrameObjStyleIndex=0;

//設定ここまで---------------------------------------------------------------------------------------------------
var myDocu=app.activeDocument;
if (app.scriptPreferences.version>=7) {
    var iMeasurementUnits=app.scriptPreferences.measurementUnit;
    var iViewPreference=myDocu.viewPreferences.properties;
    app.scriptPreferences.measurementUnit=MeasurementUnits.POINTS;
    var ResetMeasurementUnits=function (){
        app.scriptPreferences.measurementUnit=iMeasurementUnits;
    }
} else {
    var iViewPreference=myDocu.viewPreferences.properties;
    myDocu.viewPreferences.horizontalMeasurementUnits=MeasurementUnits.POINTS;
    myDocu.viewPreferences.verticalMeasurementUnits=MeasurementUnits.POINTS;
    myDocu.viewPreferences[app.scriptPreferences.version<5?"lineMeasurementUnits":"strokeMeasurementUnits"]=MeasurementUnits.POINTS;
    myDocu.viewPreferences.textSizeMeasurementUnits=MeasurementUnits.POINTS;
    myDocu.viewPreferences.typographicMeasurementUnits=MeasurementUnits.POINTS;
    var ResetMeasurementUnits=function (){
        myDocu.viewPreferences.properties=iViewPreference;
    }
}
try {

if (!myDocu.saved) throw  "ドキュメントを保存して下さい（）";
if (SaveFolderPath.charAt(0)==" ") SaveFolderPath=myDocu.filePath.fsName+"\\"+SaveFolderPath.substr(1);
if (SaveFolderPath=="") SaveFolderPath=myDocu.filePath.fsName;
var SaveFolder=new Folder(SaveFolderPath);
if (!SaveFolder.exists && !SaveFolder.create()) throw "フォルダが作れないよ";

var Sel=myDocu.selection;
if (Sel.length==0) throw "何も選択されてません";
var Sel0=Sel[0];

if (isText(Sel0) || (Sel0.parent.constructor.name=="Character" && (Sel0.extractLabel("IntextexType")=="Inline" || Sel0.extractLabel("IntextexType")=="Display"))){
    
    var DocuLabel=myDocu.extractLabel("intextexT").split("$$");
    if (DocuLabel.length==17) {
        //$.writeln(DocuLabel);
        TexFontSize=DocuLabel[0]-0;
        TexAutoGyouokuri=DocuLabel[1]-0;

        InlineCharStyleIndex=(myDocu.characterStyles.item(DocuLabel[2])==null?0:myDocu.characterStyles.item(DocuLabel[2]).index);
        InlineObjStyleIndex=(myDocu.objectStyles.item(DocuLabel[3])==null?0:myDocu.objectStyles.item(DocuLabel[3]).index);
        InlineYohaku=[DocuLabel[4]-0,DocuLabel[5]-0,DocuLabel[6]-0,DocuLabel[7]-0];
        InlineBaseline=(DocuLabel[8]=="true");
        
        DisplayParaStyleIndex=(myDocu.paragraphStyles.item(DocuLabel[9])==null?0:myDocu.paragraphStyles.item(DocuLabel[9]).index);
        DisplayObjStyleIndex=(myDocu.objectStyles.item(DocuLabel[10])==null?0:myDocu.objectStyles.item(DocuLabel[10]).index);
        DisplayYohaku=[DocuLabel[11]-0,DocuLabel[12]-0,DocuLabel[13]-0,DocuLabel[14]-0];
        DisplayGyoutori=(DocuLabel[15]=="true");
        AiKa=(DocuLabel[16]=="true");
    }

    var TDiag=app.dialogs.add({name:"テキスト内数式作成＠インてふてふ1_3.jsx"});
    with (TDiag){
        with (dialogColumns.add()){
            with (dialogRows.add()){
                staticTexts.add({staticLabel:"フォントサイズ（0で周りのテキストに合わせる）:"});
                var TexFontSizeME=measurementEditboxes.add({editValue:TexFontSize,editUnits:iViewPreference.textSizeMeasurementUnits});
            }
            with (dialogRows.add()){
                staticTexts.add({staticLabel:"自動行送り値:"});
                var TexAutoGyouokuriPE=percentEditboxes.add({editValue:TexAutoGyouokuri,editUnits:iViewPreference.typographicMeasurementUnits});
            }
            with (borderPanels.add().dialogColumns.add().dialogRows.add()){
                staticTexts.add({staticLabel:"インライン数式："});
                with(dialogColumns.add()){
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"文字スタイル:"});
                        var InlineCharStyleDD=dropdowns.add({stringList:myDocu.characterStyles.everyItem().name, selectedIndex:InlineCharStyleIndex});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"オブジェクトスタイル:"});
                        var InlineObjStyleDD=dropdowns.add({stringList:myDocu.objectStyles.everyItem().name, selectedIndex:InlineObjStyleIndex});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"余白:上"});
                        var InlineYohakuMEs=measurementEditboxes;
                        InlineYohakuMEs.add({editValue:InlineYohaku[0],editUnits:iViewPreference.verticalMeasurementUnits});
                        staticTexts.add({staticLabel:"下"});
                        InlineYohakuMEs.add({editValue:InlineYohaku[2],editUnits:iViewPreference.verticalMeasurementUnits});
                        staticTexts.add({staticLabel:"左"});
                        InlineYohakuMEs.add({editValue:InlineYohaku[1],editUnits:iViewPreference.horizontalMeasurementUnits});
                        staticTexts.add({staticLabel:"右"});
                        InlineYohakuMEs.add({editValue:InlineYohaku[3],editUnits:iViewPreference.horizontalMeasurementUnits});
                    }
                    var InlineBaselineCC=checkboxControls.add({staticLabel:"ベースラインを調整",checkedState:InlineBaseline});
                }
            }
            with (borderPanels.add().dialogColumns.add().dialogRows.add()){
                staticTexts.add({staticLabel:"ディスプレイ数式："});
                with(dialogColumns.add()){
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"段落スタイル:"});
                        var DisplayParaStyleDD=dropdowns.add({stringList:myDocu.paragraphStyles.everyItem().name, selectedIndex:DisplayParaStyleIndex});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"オブジェクトスタイル:"});
                        var DisplayObjStyleDD=dropdowns.add({stringList:myDocu.objectStyles.everyItem().name, selectedIndex:DisplayObjStyleIndex});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"余白:上"});
                        var DisplayYohakuMEs=measurementEditboxes;
                        DisplayYohakuMEs.add({editValue:DisplayYohaku[0],editUnits:iViewPreference.verticalMeasurementUnits});
                        staticTexts.add({staticLabel:"下"});
                        DisplayYohakuMEs.add({editValue:DisplayYohaku[2],editUnits:iViewPreference.verticalMeasurementUnits});
                        staticTexts.add({staticLabel:"左"});
                        DisplayYohakuMEs.add({editValue:DisplayYohaku[1],editUnits:iViewPreference.horizontalMeasurementUnits});
                        staticTexts.add({staticLabel:"右"});
                        DisplayYohakuMEs.add({editValue:DisplayYohaku[3],editUnits:iViewPreference.horizontalMeasurementUnits});
                    }
                    DisplayGyoutoriCC=checkboxControls.add({staticLabel:"行取りを調整",checkedState:DisplayGyoutori});
                }
            }
            var DelTempFileCC=checkboxControls.add({staticLabel:"中間生成ファイルを削除",checkedState:DelTempFile});
            var AiKaCC=checkboxControls.add({staticLabel:"イラレでai化",checkedState:AiKa});
            var ModosuCC=checkboxControls.add({staticLabel:"数式をテキストに戻す",checkedState:false});
        }
    }

    if(!TDiag.show()) throw "";
    
    TexFontSize=TexFontSizeME.editValue;
    TexAutoGyouokuri=TexAutoGyouokuriPE.editValue;

    InlineCharStyle=myDocu.characterStyles[InlineCharStyleDD.selectedIndex];
    InlineObjStyle=myDocu.objectStyles[InlineObjStyleDD.selectedIndex];
    InlineYohaku=[InlineYohakuMEs[0].editValue,InlineYohakuMEs[2].editValue,InlineYohakuMEs[1].editValue,InlineYohakuMEs[3].editValue];
    InlineBaseline=InlineBaselineCC.checkedState;

    DisplayParaStyle=myDocu.paragraphStyles[DisplayParaStyleDD.selectedIndex];
    DisplayObjStyle=myDocu.objectStyles[DisplayObjStyleDD.selectedIndex];
    DisplayYohaku=[DisplayYohakuMEs[0].editValue,DisplayYohakuMEs[2].editValue,DisplayYohakuMEs[1].editValue,DisplayYohakuMEs[3].editValue];
    DisplayGyoutori=DisplayGyoutoriCC.checkedState;

    DelTempFile=DelTempFileCC.checkedState;
    AiKa=AiKaCC.checkedState;
    var Modosu=ModosuCC.checkedState;
    
    myDocu.insertLabel("intextexT",""+TexFontSize+"$$"+TexAutoGyouokuri+"$$"
        +InlineCharStyle.name+"$$"+InlineObjStyle.name+"$$"+InlineYohaku[0]+"$$"+InlineYohaku[1]+"$$"+InlineYohaku[2]+"$$"+InlineYohaku[3]+"$$"+InlineBaseline+"$$"
        +DisplayParaStyle.name+"$$"+DisplayObjStyle.name+"$$"+DisplayYohaku[0]+"$$"+DisplayYohaku[1]+"$$"+DisplayYohaku[2]+"$$"+DisplayYohaku[3]+"$$"+DisplayGyoutori+"$$"+AiKa);
    //$.writeln(myDocu.extractLabel("intextexF"))
        
    if (Sel0.parent.constructor.name=="Character") {
        var myLabel=Sel0.label.replace(/[\n\r]/g,"").match(/%TeX\s*(.+)$/);
        if (myLabel==null) throw "";
        var myStory=Sel0.parent.parent;
        Sel0.parent.clearOverrides();
        var n=Sel0.parent.index;
        myStory.insertionPoints[n+1].contents=myLabel[1];
        Sel0.remove();
        Sel0=myStory.characters.itemByRange(n,n+myLabel[1].length-1).getElements()[0];
        Sel0.select();
    } 
    if (Modosu) {
        var myRectangles=Sel0.rectangles;
        for (var i=myRectangles.length-1;i>=0;i--) {
            var myLabel=myRectangles[i].label.match(/%TeX\s*(.+)$/);
            if (myLabel){
                myRectangles[i].parent.clearOverrides();
                var n=myRectangles[i].parent.index-Sel0.insertionPoints[0].index;
                Sel0.insertionPoints[n+1].contents=myLabel[1];
                myRectangles[i].remove();
            }
        }
        throw "";
    }
    if (TexFontSize==0) TexFontSize=Sel0.pointSize;
    if (Sel0.contents=="") {
        var myStory=Sel0.parent
        while (PlaceTexInText(myStory)) {};
    } else {
        while (PlaceTexInText(app.activeDocument.selection[0])) {};
    }
} else {
    var DocuLabel=myDocu.extractLabel("intextexF").split("$$");
    if (DocuLabel.length==8) {
        //$.writeln(DocuLabel);
        TexFontSize=DocuLabel[0]-0;
        TexAutoGyouokuri=DocuLabel[1]-0;

        FrameObjStyleIndex=(myDocu.objectStyles.item(DocuLabel[2])==null?0:myDocu.objectStyles.item(DocuLabel[2]).index);
        FrameYohaku=[DocuLabel[3]-0,DocuLabel[4]-0,DocuLabel[5]-0,DocuLabel[6]-0];
        AiKa=(DocuLabel[7]=="true");
    }
        
    var FDiag=app.dialogs.add({name:"フレーム内数式作成＠インてふてふ1_3.jsx"});
    with (FDiag){
        with (dialogColumns.add()){
            with (dialogRows.add()){
                staticTexts.add({staticLabel:"フォントサイズ（0でテキストに合わせる）:"});
                var FTexFontSizeME=measurementEditboxes.add({editValue:TexFontSize,editUnits:iViewPreference.textSizeMeasurementUnits});
            }
            with (dialogRows.add()){
                staticTexts.add({staticLabel:"自動行送り値:"});
                var FTexAutoGyouokuriPE=percentEditboxes.add({editValue:TexAutoGyouokuri,editUnits:iViewPreference.typographicMeasurementUnits});
            }
            with (borderPanels.add().dialogColumns.add().dialogRows.add()){
                with(dialogColumns.add()){
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"オブジェクトスタイル:"});
                        var FrameObjStyleDD=dropdowns.add({stringList:myDocu.objectStyles.everyItem().name, selectedIndex:FrameObjStyleIndex});
                    }
                    with (dialogRows.add()){
                        staticTexts.add({staticLabel:"余白:上",editUnits:iViewPreference.verticalMeasurementUnits});
                        var FrameYohakuMEs=measurementEditboxes;
                        FrameYohakuMEs.add({editValue:FrameYohaku[0]});
                        staticTexts.add({staticLabel:"下",editUnits:iViewPreference.verticalMeasurementUnits});
                        FrameYohakuMEs.add({editValue:FrameYohaku[2]});
                        staticTexts.add({staticLabel:"左",editUnits:iViewPreference.horizontalMeasurementUnits});
                        FrameYohakuMEs.add({editValue:FrameYohaku[1]});
                        staticTexts.add({staticLabel:"右",editUnits:iViewPreference.horizontalMeasurementUnits});
                        FrameYohakuMEs.add({editValue:FrameYohaku[3]});
                    }
                }
            }
            var FDelTempFileCC=checkboxControls.add({staticLabel:"中間生成ファイルを削除",checkedState:DelTempFile});
            var FAiKaCC=checkboxControls.add({staticLabel:"イラレでai化",checkedState:AiKa});
            var FModosuCC=checkboxControls.add({staticLabel:"数式をテキストに戻す",checkedState:false});
        }
    }
    if (!FDiag.show()) throw "";
    
    TexFontSize=FTexFontSizeME.editValue;
    TexAutoGyouokuri=FTexAutoGyouokuriPE.editValue;
    FrameObjStyle=myDocu.objectStyles[FrameObjStyleDD.selectedIndex];
    FrameYohaku=[FrameYohakuMEs[0].editValue,FrameYohakuMEs[2].editValue,FrameYohakuMEs[1].editValue,FrameYohakuMEs[3].editValue];
    DelTempFile=FDelTempFileCC.checkedState;
    AiKa=FAiKaCC.checkedState;
    var FModosu=FModosuCC.checkedState;
    
    myDocu.insertLabel("intextexF",""+TexFontSize+"$$"+TexAutoGyouokuri+"$$"
        +FrameObjStyle.name+"$$"+FrameYohaku[0]+"$$"+FrameYohaku[1]+"$$"+FrameYohaku[2]+"$$"+FrameYohaku[3]+"$$"+AiKa);

    for (var i=0;i<Sel.length;i++){
        if (FModosu) {
            var myLabel=Sel[i].label.match(/%TeX\s*(.+)$/);
            if (myLabel && Sel[i].graphics.length>0) {
                Sel[i].graphics[0].remove();
                Sel[i].contentType=ContentType.TEXT_TYPE;
                Sel[i].getElements()[0].contents=myLabel[0];
            }
            continue;
        }
        if (Sel[i].constructor.name=="TextFrame") {
            var myLabel=Sel[i].contents.match(/%TeX\s*(.+)$/);
            if (!myLabel) continue;
            Sel[i].label=myLabel[0];
        }
        PlaceTexInFrame(Sel[i],Sel[i].label);
    }
}
//try {
} catch (e){
    if (e!="") alert(e);
} finally {
    ResetMeasurementUnits();
    if (!(TDiag==null)) TDiag.destroy();
    if (!(FDiag==null)) FDiag.destroy();
}
//mainここまで---------------------------------------------------------------------------------------------------


function PlaceTexInText(textObj){
    var n,m;
    var textContents=textObj.contents;
    var aaa=textObj.characters.length;
    if ((n=textContents.indexOf("$"))>=0) {
        if ((m=textContents.indexOf("$",n+1))>=0) {
            var TexText=textObj.characters.itemByRange(n,m).getElements()[0];
            var type="inline";
        }
    } else if ((n=textContents.indexOf("\\["))>=0){
        if ((m=textContents.indexOf("\\]",n+1))>=0){
            var TexText=textObj.characters.itemByRange(n,m+1).getElements()[0];
            var type="display";
        }
    } else {
        return false;
    }
    var TexCode=TexText.contents;
    var Onaji=arrIndexOf(TexText.parent.rectangles.everyItem().label,"%TeX\r"+TexCode);
    if (Onaji>-1){//ストーリー内に同じ数式があるかどうか
        var TexEpsFile=File(TexText.parent.rectangles[Onaji].graphics[0].itemLink.filePath);
    } else {
        var TexEpsFile=MakeEps(TexCode,type);
     }
    TexInsertionPoints=TexText.insertionPoints[0].getElements()[0];
    TexText.contents="";
    var TexEPS=TexInsertionPoints.place(TexEpsFile);
    if (TexEPS.constructor.name=="Array") TexEPS=TexEPS[0];
    var TexRectangle=TexEPS.parent;
    var TexAnchor=TexRectangle.parent;
    TexRectangle.label="%TeX\r"+TexCode;
    
    var TexHoriz=isHorizontal(TexAnchor);
    //$.writeln(TexHoriz);
    if (type=="inline") {
        var TexVb=TexRectangle.visibleBounds;
        var TexHeight=TexHoriz?(TexVb[2]-TexVb[0]):(TexVb[3]-TexVb[1]);
        TexRectangle.applyObjectStyle(InlineObjStyle);
        TexAnchor.appliedCharacterStyle=InlineCharStyle;
        TexRectangle.insertLabel("IntextexType","Inline");
        if (InlineBaseline) {
            var TexTrim=(GetLeading(TexAnchor)-TexHeight)/2;
            YohakuSet(TexRectangle,TexHoriz?[TexTrim,0,TexTrim,0]:[0,TexTrim,0,TexTrim]);
        }
        YohakuSet(TexRectangle,InlineYohaku);
    } else if (type=="display") {
        YohakuSet(TexRectangle,DisplayYohaku);
        var TexVb=TexRectangle.visibleBounds;
        var TexHeight=TexHoriz?(TexVb[2]-TexVb[0]):(TexVb[3]-TexVb[1]);
        TexRectangle.applyObjectStyle(DisplayObjStyle);
        TexAnchor.appliedParagraphStyle=DisplayParaStyle;
        TexRectangle.insertLabel("IntextexType","Display");
        if (DisplayGyoutori) {
            if (TexAnchor.parentStory.storyPreferences.frameType==FrameTypes.FRAME_GRID_TYPE){
                var GridMojiSize=TexAnchor.parentStory.gridData.pointSize;
                var GridGyouokuri=GridMojiSize+TexAnchor.parentStory.gridData.lineAki;
                TexAnchor.gridGyoudori=parseInt((TexHeight-GridMojiSize)/GridGyouokuri)+DisplayGyoutori;
            } else {
                TexAnchor.leading=TexHeight+GetLeading(TexAnchor)-TexAnchor.pointSize;
                TexAnchor.pointSize=TexAnchor.leading;
            }
        }
    } 
    if (AiKa) RelinkEpsAi(TexRectangle);
    return true;
}
function PlaceTexInFrame(myFrame,str){
    var myLabel;
    if (myLabel=str.match(/%TeX\s*(.+)$/)){
        if (TexFontSize==0) TexFontSize=(myFrame.hasOwnProperty("texts")?myFrame.texts[0]:myDocu.textDefaults).pointSize;
        myFrame.place(MakeEps(myLabel[1],"Frame"));
        YohakuSet(myFrame,FrameYohaku);
        myFrame.applyObjectStyle(FrameObjStyle);
        if (AiKa) RelinkEpsAi(myFrame.getElements()[0]);
        return true;
    } else {
        return false;
    }
}
function MakeEps(str,type){
    var TempFileName="Tex"+(new Date().getTime().toString().slice(-9,-1));
    var s="\\documentclass[fleqn]{jarticle}\r"
        +"\\usepackage{amsmath,amssymb}\r"
        +"\\usepackage[usenames]{color}\r"
        +"\\usepackage{enumerate}\r"
        +"\\usepackage{type1cm}\r"
        +"\\pagestyle{empty}\r"
        +"\\begin{document}\r"
        +"\\fontsize{"+TexFontSize+"pt}{"+(TexFontSize*TexAutoGyouokuri/100)+"}\\selectfont\r"
        +((type=="inline" && InlineBaseline)?"\\textcolor{white}{$\\Biggl|$}\r":"")
        +str+"\r"
        +((type=="inline" && InlineBaseline)?"\\textcolor{white}{$\\Biggr|$}\r":"")
        +"\\end{document}";
    var TexFile=new File(SaveFolder+"/"+TempFileName+".tex");
    if (TexFile.open("w")){
        TexFile.write(s);
        TexFile.close();
    }
    var VBS="Set Shell = CreateObject(\"WScript.Shell\")\r"
        +"Shell.CurrentDirectory=\""+SaveFolderPath+"\"\r"
        +"Shell.Run \"%ComSpec% /c \"\""+TexExe+"\"\" -kanji=sjis -interaction=nonstopmode "+TempFileName+".tex >> "+TempFileName+".txt\",0,True\r"
        +"Shell.Run \"%ComSpec% /c \"\""+DvipdfExe+"\"\" -vv -o "+TempFileName+".pdf "+TempFileName+".dvi >> "+TempFileName+".txt\",0,True\r"
        +"Shell.Run \"%ComSpec% /c \"\""+GsExe+"\"\"  -sDEVICE="+GsDevice+" -sOutputFile="+TempFileName+".eps -dNOPAUSE -dBATCH -dNOCACHE "+TempFileName+".pdf >> "+TempFileName+".txt\",0,True\r";
    //$.writeln(VBS);
    app.doScript(VBS,ScriptLanguage.VISUAL_BASIC);
    var TexEpsFile=File(SaveFolderPath+"\\"+TempFileName+".eps");
    TexEpsFile.rename(myDocu.name.split(".",1)[0]+TempFileName+".eps");
    
    if (!TexEpsFile.exists) throw "なぜかepsファイルができてません";
    if (DelTempFile==1){
        File(SaveFolderPath+"\\"+TempFileName+".tex").remove();
        File(SaveFolderPath+"\\"+TempFileName+".dvi").remove();
        File(SaveFolderPath+"\\"+TempFileName+".pdf").remove();
        File(SaveFolderPath+"\\"+TempFileName+".aux").remove();
        File(SaveFolderPath+"\\"+TempFileName+".log").remove();
        File(SaveFolderPath+"\\"+TempFileName+".txt").remove();
    }
    return TexEpsFile;
}

function YohakuSet(Obj,Yohaku){
    var vb=Obj.visibleBounds;
    Obj.visibleBounds=[vb[0]-Yohaku[0],vb[1]-Yohaku[1],vb[2]+Yohaku[2],vb[3]+Yohaku[3]];
}


function arrIndexOf(a,s){
    for (var i=0;i<a.length;i++){
        if (a[i]===s) return i;
    }
    return -1;
}
function GetLeading(Obj){
    return (Obj.parentStory.storyPreferences.frameType==FrameTypes.FRAME_GRID_TYPE)?
        (Obj.parentStory.gridData.lineAki+Obj.parentStory.gridData.pointSize):
        (Obj.leading==Leading.AUTO?(Obj.pointSize*Obj.autoLeading/100):(Obj.leading));
}
function isHorizontal(TextObj){
    if (TextObj.constructor.name=="Story") return TextObj.storyPreferences.storyOrientation==HorizontalOrVertical.HORIZONTAL;
    if (TextObj.parent.constructor.name=="Story") return TextObj.parent.storyPreferences.storyOrientation==HorizontalOrVertical.HORIZONTAL;
    if (TextObj.parent.hasOwnProperty("writingDirection")) return TextObj.parent.writingDirection==HorizontalOrVertical.HORIZONTAL;
    return null;
}

function isText(obj){
    var s=obj.constructor.name;
    if (s=="Text"||s=="Character"||s=="Word"||s=="Line"||s=="TextColumn"||s=="Paragraph"||s=="TextStyleRange"||s=="InsertionPoint") return true;
    return false;
} 
function isSplineItem(obj){
    var s=obj.constructor.name;
    if (s=="GraphicLine"||s=="Oval"||s=="Word"||s=="Polygon"||s=="Rectangle"||s=="SplineItem") return true;
    return false;
} 
function RelinkEpsAi(frame){
    if (frame.epss.length==0) return;
    var myEps=frame.epss[0];
    var EpsFilePath=myEps.itemLink.filePath;
    var bt=new BridgeTalk;
    bt.target = "illustrator";
    bt.body = uneval(function(s){
        var AiDocu=app.open(File(s));
        AiDocu.saveAs(File(s.slice(0,-3)+"ai"));
        AiDocu.close();
    })+"(\""+EpsFilePath+"\");";
    bt.onResult=function(){
        var myPdfCrop=app.pdfPlacePreferences.pdfCrop;
        app.pdfPlacePreferences.pdfCrop=PDFCrop.CROP_ART;
        myEps.itemLink.relink(File(EpsFilePath.slice(0,-3)+"ai"));
        if (DelTempFile) File(EpsFilePath).remove();
        app.pdfPlacePreferences.pdfCrop=myPdfCrop;
    }
    bt.send();
}