﻿/////////////////////////////////////////////////
//　半角英数→全角英数 for イラレ ver1.0
//　http://sysys.blog.shinobi.jp/Entry/67/
/////////////////////////////////////////////////

(function(){

var sel=app.selection; 
var selTexts=[];
if (sel.constructor.name=="TextRange") {
    selTexts.push(sel)
} else {
    (function (items){
        for (var i=0;i<items.length;i++){
            switch (items[i].constructor.name){
                case "TextRange":
                    selTexts.push(items[i])
                    break;
                case "TextFrame":
                    if (!lockedOrHidden(items[i])) selTexts=selTexts.concat(items[i].textSelection);
                    break;
                case "GroupItem":
                    if (!lockedOrHidden(items[i])) arguments.callee(items[i].pageItems);
                    break;
            }
        }
    })(sel);
}

for (var i=0;i<selTexts.length;i++){
    var str=selTexts[i].contents;
    var offset=selTexts[i].characterOffset;
    var c=selTexts[i].characters[0];
    var n,s;
    for (var j=0;j<str.length;j++){
        n=str.charCodeAt(j);
        s="";
        if (n==0x0020) s="　";
        else if (0x0021<=n && n<=0x007E) s=String.fromCharCode(n+0xFEE0);
        if (s!=="") {
            c.characterOffset=offset+j-1;
            c.contents=s;
        }
    }
}

function lockedOrHidden(pageItem){
    return pageItem.locked || pageItem.hidden || pageItem.layer.locked || pageItem.layer.hidden;
}
})();