// CsaView.cpp : CCsaView NX̓̒`s܂B
//

// TODO:vkoma()

#include "stdafx.h"
#include <mmsystem.h>
#include "Csa.h"

#include "CsaDoc.h"
#include "CsaView.h"

#include <memory.h>
#include <time.h>

#include "Logindlg.h"
#include "taikyoku.h"
#include "rs232c.h"
#include "eisei.h"
#include "CsaDll.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

#if defined(_MSC_VER)
#define snprintf	_snprintf
#endif

#define SE_SETUP	TEXT("SE/Nanoha_Setup.wav")
#define SE_START	TEXT("SE/Nanoha_Start.wav")
#define SE_WIN		TEXT("SE/Nanoha_Win.wav")
#define SE_LOSE		TEXT("SE/Nanoha_Lose.wav")

/////////////////////////////////////////////////////////////////////////////
// CCsaView

IMPLEMENT_DYNCREATE(CCsaView, CView)

BEGIN_MESSAGE_MAP(CCsaView, CView)
	//{{AFX_MSG_MAP(CCsaView)
	ON_COMMAND(IDC_PLAY_START, OnPlayStart)
	ON_UPDATE_COMMAND_UI(IDC_PLAY_START, OnUpdatePlayStart)
	ON_COMMAND(IDC_FILE_LOAD, OnFileLoad)
	ON_UPDATE_COMMAND_UI(IDC_FILE_LOAD, OnUpdateFileLoad)
	ON_COMMAND(ID_SAIGEN_P1, OnSaigenP1)
	ON_UPDATE_COMMAND_UI(ID_SAIGEN_P1, OnUpdateSaigenP1)
	ON_COMMAND(ID_SAIGEN_M3, OnSaigenM3)
	ON_UPDATE_COMMAND_UI(ID_SAIGEN_M3, OnUpdateSaigenM3)
	ON_COMMAND(ID_SAIGEN_P3, OnSaigenP3)
	ON_UPDATE_COMMAND_UI(ID_SAIGEN_P3, OnUpdateSaigenP3)
	ON_COMMAND(ID_SAIGEN_M1, OnSaigenM1)
	ON_UPDATE_COMMAND_UI(ID_SAIGEN_M1, OnUpdateSaigenM1)
	ON_COMMAND(ID_SAIGEN_P2, OnSaigenP2)
	ON_UPDATE_COMMAND_UI(ID_SAIGEN_P2, OnUpdateSaigenP2)
	ON_WM_TIMER()
	ON_COMMAND(ID_SAIGEN_M2, OnSaigenM2)
	ON_UPDATE_COMMAND_UI(ID_SAIGEN_M2, OnUpdateSaigenM2)
	ON_WM_RBUTTONDBLCLK()
	ON_WM_RBUTTONDOWN()
	ON_COMMAND(ID_FILE_SAVE, OnFileSave)
	ON_UPDATE_COMMAND_UI(ID_FILE_SAVE, OnUpdateFileSave)
	ON_COMMAND(IDC_PLAY_GIVE_UP, OnPlayGiveUp)
	ON_UPDATE_COMMAND_UI(IDC_PLAY_GIVE_UP, OnUpdatePlayGiveUp)
	ON_COMMAND(IDC_PLAY_PAUSE, OnPlayPause)
	ON_UPDATE_COMMAND_UI(IDC_PLAY_PAUSE, OnUpdatePlayPause)
	ON_WM_LBUTTONDOWN()
	ON_WM_MOUSEMOVE()
	ON_WM_LBUTTONUP()
	ON_COMMAND(IDC_INTERNET_AUTHOR, OnInternetAuthor)
	ON_COMMAND(IDC_LAN_LOGIN, OnLanLogin)
	ON_COMMAND(IDC_LAN_LOGOUT, OnLanLogout)
	ON_UPDATE_COMMAND_UI(IDC_LAN_LOGIN, OnUpdateLanLogin)
	ON_MESSAGE(WM_LAN, OnFromLan)
	ON_COMMAND(IDC_NEXT_MOVE, OnNextMove)
	ON_UPDATE_COMMAND_UI(IDC_NEXT_MOVE, OnUpdateNextMove)
	//}}AFX_MSG_MAP
	// WR}h
	ON_COMMAND(ID_FILE_PRINT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_DIRECT, CView::OnFilePrint)
	ON_COMMAND(ID_FILE_PRINT_PREVIEW, CView::OnFilePrintPreview)
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CCsaView NX̍\z/

BOOL CCsaView::PreCreateWindow(CREATESTRUCT& cs)
{
	// TODO: ̈ʒu CREATESTRUCT cs C Window NX܂̓X^C
	//  CĂB
	BOOL ret = PlaySound(SE_SETUP, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
	if (ret == FALSE) {
		MessageBox("Play failure", "PreCreateWindow");
	}
	return CView::PreCreateWindow(cs);
}

/////////////////////////////////////////////////////////////////////////////

////////////////////////////////////////////////////////////////////////////
// CCsaView NẌ

BOOL CCsaView::OnPreparePrinting(CPrintInfo* pInfo)
{
	// ftHg̈
	return DoPreparePrinting(pInfo);
}

void CCsaView::OnBeginPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: O̓ʂȏǉĂB
}

void CCsaView::OnEndPrinting(CDC* /*pDC*/, CPrintInfo* /*pInfo*/)
{
	// TODO: ̌㏈ǉĂB
}

/////////////////////////////////////////////////////////////////////////////
// CCsaView NX̐ff

#ifdef _DEBUG
void CCsaView::AssertValid() const
{
	CView::AssertValid();
}

void CCsaView::Dump(CDumpContext& dc) const
{
	CView::Dump(dc);
}

CCsaDoc* CCsaView::GetDocument() // fobO o[W̓CCłB
{
	ASSERT(m_pDocument->IsKindOf(RUNTIME_CLASS(CCsaDoc)));
	return (CCsaDoc*)m_pDocument;
}
#endif //_DEBUG

/////////////////////////////////////////////////////////////////////////////
// CCsaView NX̃bZ[W nh

static int		sikou_flag;
int				lan_init_flag;
static BOOL		LButtonDown = FALSE;
static int		save_x;
static int		save_y;
static int		mouse_no;
static int		now_tesu = -1;
static int		initial_flag = 0;
static char		*koma_kind[] =
{
				"FU", "KY", "KE", "GI", "KI", "KA", "HI", "OU",
				"TO", "NY", "NK", "NG", "KI", "UM", "RY"
};
static char				hkyokumen[] = 		// ǖ
{
			0,
			GKY, GKE, GGI, GKI, GOU, GKI, GGI, GKE, GKY,	//  1 -  9
			EMP, GKA, EMP, EMP, EMP, EMP, EMP, GHI, EMP,	// 10 - 18
			GFU, GFU, GFU, GFU, GFU, GFU, GFU, GFU, GFU,	// 19 - 27
			EMP, EMP, EMP, EMP, EMP, EMP, EMP, EMP, EMP,	// 28 - 36
			EMP, EMP, EMP, EMP, EMP, EMP, EMP, EMP, EMP,	// 37 - 45
			EMP, EMP, EMP, EMP, EMP, EMP, EMP, EMP, EMP,	// 46 - 54
			SFU, SFU, SFU, SFU, SFU, SFU, SFU, SFU, SFU,	// 55 - 63
			EMP, SHI, EMP, EMP, EMP, EMP, EMP, SKA, EMP,	// 64 - 72
			SKY, SKE, SGI, SKI, SOU, SKI, SGI, SKE, SKY,	// 73 - 81
			0,   0,   0,   0,   0,   0,   0,   0,			// 82:莝
			0,   0,   0,   0,   0,   0,   0,   0,			// 90:莝
			77,  5											// 98:ʈʒuA99:ʈʒu
};
static char     amari[] = 
{
			 0,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8,
			 0, 1, 2, 3, 4, 5, 6, 7, 8
};
static char				initial_kyokumen[100];
static int				job_no;				// Wuԍ
static int				chudan_flag;		// ΋ǒftO
static int				tesu;				// 萔
static int				end_code;			// IǃR[h	0:IA1:菟A2:菟A3:A4:n
#define END_CODE_NONE		0
#define END_CODE_SENTE_WIN	1
#define END_CODE_GOTE_WIN	2
#define END_CODE_SENNICHITE	3
#define END_CODE_JISHOGI	4
static time_t			start_sec;			// vJn(sec)
static int				timer_sec[2];		// \(ݐ)
static int				timer_sec1[2];		// \()
static char				time_moji[2][28];	// \(j
static int				i_man[2] = {1,0};	// ΐ탌x  0:lA1:Rs[^A-3:LANA-1, -2, -4, -5, -6:RS-232C
static char				sman[32];			// ΋ǎ
static char				gman[32];			// ΋ǎ
static char				ssman[16];			// ΋ǎ
static char				ggman[16];			// ΋ǎ
static char				old_man[2][32];		// \΋ǎ
static char				te_moji[28];
static int				saigen_msec;		// Č
static char				teban_moji1[28];	// ԕP
static char				teban_moji2[28];	// ԕQ
static char				men_h[100];			// ݂̋ǖ
static int				old_tesu;
static char				old_men[82];
static char				old_smochi[8];
static char				old_gmochi[8];
static char				old_select;
static int				taikyoku_job_old;
static int				taikyoku_ichi_old;
static int				taikyoku_ichi_new;
static int				taikyoku_koma_old;
static CString			kif_filename;
static int				shohi[MAX_TESU];		// (shohi[te]  te ܂ł̗ݐϕb)
static unsigned char	kifu[MAX_TESU][2];		// f[^
static int gEvalution;	// 肩猩]l
static int gEvalution_old;	// 肩猩]l̈O̒l

//extern "C" __declspec(dllimport) void sikou_ini(int* c);
//extern "C" __declspec(dllimport) int  sikou(int tesu, unsigned char kifu[][2], int* timer_sec, int* i_moto, int* i_saki, int* i_naru);
//extern "C" __declspec(dllimport) void sikou_end();

extern int	s_kiki(char* men, int ip);
extern int	g_kiki(char* men, int ip);
extern void s_total(char* ban, char* mochi, int* cnt, int* moto, int* saki, int* naru);
extern void g_total(char* ban, char* mochi, int* cnt, int* moto, int* saki, int* naru);
extern int	sictotal(char* men, int newx_w, int* m_moto, int* m_naru);
extern int	gictotal(char* men, int newx_w, int* m_moto, int* m_naru);
extern void kifuout(char* moji, int tesu, unsigned char kifu[][2], char* initial_kyokumen, int end_code);
extern BOOL rs_get_status();

int			lan_prog;
	// 0:ڑ
	// 1:connect
	// 3:END Game_SummaryM
	// 4:START҂(AGREE M 4 ɂ)
	// 5:lan_prog=4  START M

int			you_teban;	// 0:(LAN)A1:(LAN)

CRs232c	rs232c(&chudan_flag);

void init_proc(void)
{
	CWinApp*	app;

	initial_flag++;
	job_no = 0;
	end_code = END_CODE_NONE;
	timer_sec[0] = timer_sec[1] = 0;
	timer_sec1[0] = timer_sec1[1] = 0;
	saigen_msec = 950;
	teban_moji1[0] = teban_moji2[1] = '\0';
///	i_man[0] = i_man[1] = 0;
	strncpy(sman, "LAN", sizeof(sman));
	strncpy(gman, "Computer", sizeof(gman));
	ssman[0] = ggman[0] = (char)0;
	tesu = 0;
	kifu[0][0] = 0;
	memcpy(men_h, hkyokumen, sizeof(men_h));
	memcpy(initial_kyokumen, hkyokumen, sizeof(initial_kyokumen));
	app = AfxGetApp();
	kif_filename = app->GetProfileString("file name", "csa");
}

void close_proc()
{
	chudan_flag = -100;
	switch(job_no)
	{
	case 2:
	case 3:
		rs232c.rs_close(i_man);
		if (sikou_flag) {
			sikou_flag = 0;
			gCsaDll.sikou_end();
		}
		break;
	default:
		break;
	}
}

CCsaView::CCsaView()
{
	sikou_flag  = 0;
	cl_sock     = NULL;
	fp_lan      = NULL;
	lan_prog    = 0;
	lan_user[0] = '\0';
	lan_pass[0] = '\0';
	lan_game[0] = '\0';
	lan_sman[0] = '\0';
	lan_gman[0] = '\0';
}

CCsaView::~CCsaView()
{
	_lan_close();
	delete	SaveBitmap;
	delete	Mem1DC;
}

void CCsaView::_lan_close(void)
{
	if (fp_lan)
	{
		fclose(fp_lan);
		fp_lan = NULL;
	}
	if (lan_init_flag == 0)return;

	if (cl_sock)
	{
		cl_sock->Close();
		delete cl_sock;
		cl_sock = NULL;
	}
}

int CCsaView::_lan_open(const char *ip_address, int port_no, HWND oya)
{
	int			ierr;
	hostent		*pHe;
	SOCKADDR_IN cl_addr;

	if (lan_init_flag == 0)return -1;

	/**************/
	/* NX쐬 */
	/**************/

	cl_sock               = new CClSocket();
	cl_sock->parent       = oya;

	/****************************/
	/* NCAg\Pbg쐬 */
	/****************************/

	if (cl_sock->Create(0, SOCK_STREAM, FD_CONNECT | FD_CLOSE, NULL) == NULL)
	{
		_lan_close();
		return -2;
	}

	/**********************/
	/* zXgAhXϊ */
	/**********************/

	pHe = gethostbyname(ip_address);
	if (pHe == NULL)
	{
		_lan_close();
		return -3;
	}

	/********/
	/* ڑ */
	/********/

	memset(&cl_addr, 0, sizeof(cl_addr));
	cl_addr.sin_family = AF_INET;
	cl_addr.sin_port   = htons((short)port_no);
	cl_addr.sin_addr.s_addr = *((unsigned long*)pHe->h_addr);

	if (!cl_sock->Connect((LPSOCKADDR)&cl_addr, sizeof(cl_addr))) 
	{
		ierr = WSAGetLastError();
		if (ierr != WSAEWOULDBLOCK) 
		{
			_lan_close();
			return -4;
		}
	}

	return(0);
}

int CCsaView::_lan_puts(const char *buf)
{
	int		len;

	if (lan_init_flag == 0)return -1;
	if (cl_sock == NULL)return -2;
	if (cl_sock->open_flag != 1)return -3;

	len = strlen(buf);
	cl_sock->Send(buf, len);

	if (fp_lan)
	{
		fwrite("--->", 4, 1, fp_lan);
		fwrite(buf, 1, len, fp_lan);
	}
	return 0;
}

int CCsaView::_lan_gets(char *buf, int buf_size)
{
	int		len;

	if (lan_init_flag == 0)return -1;
	if (cl_sock == NULL)return -2;
	if (cl_sock->open_flag != 1)return -3;
	len = cl_sock->Receive(buf, buf_size - 1, 0);
	if (fp_lan)
	{
		fwrite(buf, len, 1, fp_lan);
	}
	buf[len] = 0;

	return len;
}

int CCsaView::get_line(char *moji, int is)
{
	while(1)
	{
		switch(moji[is])
		{
		case '\n':
			moji[is] = 0;
		case 0:
			return(is + 1);
		default:
			is++;
		}
	}
	return(is + 1);
}

int CCsaView::get_sasite(const char *moji, int *moto, int *saki, int *koma, int *sec)
{
	int		i;
	int		kotae;
	int		ix_old;
	int		iy_old;
	int		ix_new;
	int		iy_new;
	const char	*s;

	/* 1 moji-me */
	ix_old = moji[1] - '0';
	if (ix_old < 0 || ix_old > 9) {
		return -1;
	}
	/* 2moji-me */
	iy_old = moji[2] - '0';
	if (iy_old < 0 || iy_old > 9) {
		return -2;
	}
	*moto = ix_old + (iy_old - 1) * 9;

	/* 3 moji-me */
	ix_new = moji[3] - '0';
	if (ix_new < 1 || ix_new > 9) {
		return -3;
	}
	/* 4moji-me */
	iy_new = moji[4] - '0';
	if (iy_new < 1 || iy_new > 9) {
		return -4;
	}
	*saki = ix_new + (iy_new - 1) * 9;

	/* 5 & 6 moji-me */
	kotae = 0;
	for (i = 0; i < sizeof(koma_kind)/sizeof(koma_kind[0]); i++)
	{
		if (strncmp(&moji[5], koma_kind[i], 2) == 0)
		{
			kotae = i + 1;
			break;
		}
	}
	if (kotae == 0) return -5;
	if (*moto == -9)
	{
		*moto = kotae + 100;
	}
	*koma = kotae;

	/* 7 & 8 moji-me */
	if (strncmp(&moji[7], ",T", 2) != 0)
	{
		return -7;
	}

	/* 9moji-me */
	kotae = 0;
	s     = moji + 9;
	i     = 1;
	while(i)
	{
		if (isdigit(*s)) {
			kotae = kotae * 10 + *s - '0';
		} else if (*s == '\n' || *s == '\0') {
			i = 0;
		} else {
			return -9;
		}
		s++;
	}

	if (kotae == 0) return -10;
	*sec = kotae;

	switch(moji[0])
	{
	case '+':
		return(0);
	case '-':
		return(1);
	default:
		break;
	}

	return -11;
}

int CCsaView::get_sec(const char *moji)
{
	int		i;
	int		kotae;
	const char	*s;

	kotae = 0;

	for (i = 0;i < 7; i++)
	{
		if (moji[i] == 0) return(1);
	}

	/* 7 & 8 moji-me */
	if (strncmp(&moji[7], ",T", 2))
	{
		return(1);
	}

	/* 9moji-me */
	s     = moji + 9;
	i     = 1;
	while(i)
	{
		if (isdigit(*s)) {
			kotae = kotae * 10 + *s - '0';
		} else if (*s == '\n' || *s == '\0') {
			i = 0;
		} else {
			return 1;
		}
		s++;
	}

	return(kotae);
}

LRESULT CCsaView::OnFromLan(WPARAM wParam, LPARAM lParam)
{
	int		i;
	int		is;
	int		len;
	int		moto;
	int		saki;
	int		naru;
	int		koma;
	int		teban;
	int		sec;
	int		kotae;
	char	*s;
	CDC		*pDC;
	char	cmoji[128];
	char	moji[512];

	switch(lParam)
	{
	case CLSOCKET_CONNECT:
		pDC = GetDC();
		teban_disp(pDC, "LANڑ", "");
		ReleaseDC(pDC);
		lan_prog = 1;
		if (m_continuous && m_wdoor) {
			snprintf(moji, sizeof(moji), "LOGIN %s %s x1\n", lan_user, lan_pass);
		} else {
			snprintf(moji, sizeof(moji), "LOGIN %s %s\n", lan_user, lan_pass);
		}
		_lan_puts(moji);
		break;
	case CLSOCKET_RECEIVE:
		len = _lan_gets(moji, sizeof(moji));
		is = 0;
		while(is < len)
		{
			s  = moji + is;
			is = get_line(moji, is);
			if (*s == '+')
			{
				teban = tesu & 0x0001;
				if (lan_prog == 5)
				{
					if (teban)
					{
						sec   = get_sec(s);
						i     = tesu - 1;
						if (i < 2)
						{
							kotae = sec;
						}
						else
						{
							kotae = shohi[i - 2] + sec;
						}
						timer_sec[0] = shohi[i] = kotae;
						timer_sec1[0] = sec;
					}
					else
					{
						kotae = get_sasite(s, &moto, &saki, &koma, &sec);
						if (kotae == 0)
						{
							if (moto > 100)
							{
								naru = 0;
							}
							else
							{
								if (men_h[moto] == koma)
								{
									naru = 0;
								}
								else
								{
									naru = 1;
								}
							}
							timer_sec[teban] += sec;
							timer_sec1[teban] = sec;
							shohi    [tesu ]  = timer_sec[teban];
							start_time();
							kifu[tesu + 1][0] = 0;
							kifu[tesu    ][1] = moto;
							kifu[tesu    ][0] = saki + naru * 100;
							tesu++;
							sasu(men_h, teban, moto, saki, naru);
							pDC = GetDC();
							man_disp(pDC, tesu, 1);
							k_disp(pDC, men_h, 1);		// Ֆʕ\
							job_no = 2;
							if (taikyoku_check(pDC, cmoji))
							{
								ReleaseDC(pDC);
								if (m_continuous == FALSE) {
									MessageBox(cmoji, "shogi");
								}
							}
							else
							{
								ReleaseDC(pDC);
								Taikyoku();
							}
						}
					}
				}
			}
			else if (*s == '-')
			{
				if (lan_prog == 5)
				{
					teban = tesu & 0x0001;
					if (teban)
					{
						kotae = get_sasite(s, &moto, &saki, &koma, &sec);
						if (kotae == 1)
						{
							if (moto > 100)
							{
								naru = 0;
							}
							else
							{
								koma = -koma;
								if (men_h[moto] == koma)
								{
									naru = 0;
								}
								else
								{
									naru = 1;
								}
							}
							timer_sec[teban] += sec;
							timer_sec1[teban] = sec;
							shohi    [tesu ]  = timer_sec[teban];
							start_time();
							kifu[tesu + 1][0] = 0;
							kifu[tesu    ][1] = moto;
							kifu[tesu    ][0] = saki + naru * 100;
							tesu++;
							sasu(men_h, teban, moto, saki, naru);
							pDC = GetDC();
							man_disp(pDC, tesu, 1);
							k_disp(pDC, men_h, 1);		// Ֆʕ\
							job_no = 2;
							if (taikyoku_check(pDC, cmoji))
							{
								ReleaseDC(pDC);
								if (m_continuous == FALSE) {
									MessageBox(cmoji, "shogi");
								}
							}
							else
							{
								ReleaseDC(pDC);
								Taikyoku();
							}
						}
					}
					else
					{
						sec   = get_sec(s);
						i     = tesu - 1;
						if (i < 2)
						{
							kotae = sec;
						}
						else
						{
							kotae = shohi[i - 2] + sec;
						}
						timer_sec[1] = shohi[i] = kotae;
						timer_sec1[1] = sec;
					}
				}
			}
			else if (*s == '%')
			{
				if (lan_prog == 5)
				{
					if (strncmp(s, "%TORYO", 6) == 0)
					{
						teban = tesu & 0x0001;
						lan_prog = 2;
						kifu[tesu][0] = 0;
						stop_time();
						pDC = GetDC();
						if (teban == 0)
						{
							end_code = END_CODE_GOTE_WIN;
							teban_disp(pDC, "菟!", "");
						}
						else
						{
							end_code = END_CODE_SENTE_WIN;
							teban_disp(pDC, "菟!", "");
						}
						ReleaseDC(pDC);
						job_no = 0;
						PlaySound(SE_WIN, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
						if (m_continuous == FALSE) {
							MessageBox("Win!", "Shogi");
						}
						finish_shikou();
					}
					else if (strncmp(s, "%CHUDAN", 7) == 0)
					{
						lan_prog = 2;
						job_no = 0;
						end_code = END_CODE_NONE;
						kifu[tesu][0] = 0;
						stop_time();
						if (chudan_flag == 0)
						{
							pDC = GetDC();
							teban_disp(pDC, "Recieve Break", "");
							ReleaseDC(pDC);
							if (m_continuous == FALSE) {
								MessageBox("Pause Shogi!", "LAN");
							}
							pDC = GetDC();
							teban_disp(pDC, "", "");
							ReleaseDC(pDC);
						}
					}
					else if (strncmp(s, "%KACHI", 6) == 0)
					{
						lan_prog = 2;
						job_no = 0;
						end_code = END_CODE_NONE;
						kifu[tesu][0] = 0;
						stop_time();
						if (chudan_flag == 0)
						{
							pDC = GetDC();
							teban_disp(pDC, "KACHI Recieve", "");
							ReleaseDC(pDC);
							if (m_continuous == FALSE) {
								MessageBox("Victory declaration", "LAN");
							}
							pDC = GetDC();
							teban_disp(pDC, "", "");
							ReleaseDC(pDC);
						}
						finish_shikou();
					}
					else if (strncmp(s, "%HIKIWAKE", 9) == 0)
					{
						lan_prog = 2;
						job_no = 0;
						end_code = END_CODE_NONE;
						kifu[tesu][0] = 0;
						stop_time();
						if (chudan_flag == 0)
						{
							pDC = GetDC();
							teban_disp(pDC, "DRAW Recieve", "");
							ReleaseDC(pDC);
							if (m_continuous == FALSE) {
								MessageBox("Draw declaration", "LAN");
							}
							pDC = GetDC();
							teban_disp(pDC, "", "");
							ReleaseDC(pDC);
						}
						finish_shikou();
					}
				}
			}
			else if (strncmp(s, "START", 5) == 0)
			{
				if (lan_prog == 4)
				{
					job_no   = 2;
					lan_prog = 5;
					if ((i_man[0] == -3 && you_teban == 0)
						||(i_man[1] == -3 && you_teban == 1)) {
						int tmp = i_man[0];
						i_man[0] = i_man[1];
						i_man[1] = tmp;
					}
					start_time();
					PlaySound(SE_START, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
					Taikyoku();
				}
			}
			else if (strncmp(s, "END Game_Summary", 16) == 0)
			{
				lan_prog = 3;
				pDC = GetDC();
				if (you_teban)
				{
					teban_disp(pDC, "", "");
					strncpy(sman, "LAN", sizeof(sman));
					strncpy(gman, "Computer", sizeof(gman));
				}
				else
				{
					teban_disp(pDC, "", "");
					strncpy(sman, "Computer", sizeof(sman));
					strncpy(gman, "LAN", sizeof(gman));
				}
				strncpy(ssman, lan_sman, sizeof(ssman));
				strncpy(ggman, lan_gman, sizeof(ggman));
				ReleaseDC(pDC);

				char mess[6+DEF_GAME_LEN+1];
				lan_prog = 4;
				snprintf(mess, sizeof(mess), "AGREE %s\n", lan_game);
				_lan_puts(mess);
			}
			else if (strncmp(s, "LOGIN:", 6) == 0)
			{
				if (strncmp(&s[6], "incorrect", 9) == 0)
				{
					pDC = GetDC();
					teban_disp(pDC, "LOGINs", "");
					ReleaseDC(pDC);
				}
				else
				{
					snprintf(cmoji, sizeof(cmoji), "%s OK", lan_user);
					if (strcmp(&s[6], cmoji) == 0)
					{
						lan_prog = 2;
						pDC = GetDC();
						teban_disp(pDC, "LOGIN", "");
						ReleaseDC(pDC);
					}
				}
			}
			else if (strncmp(s, "LOGOUT", 6) == 0)
			{
				lan_prog = 0;
				_lan_close();
				pDC = GetDC();
				teban_disp(pDC, "LOGOUT", "");
				ReleaseDC(pDC);
			}
			else if (strncmp(s, "Game_ID:", 8) == 0)
			{
				strncpy(lan_game, &s[8], sizeof(lan_game));
			}
			else if (strncmp(s, "Name", 4) == 0)
			{
				switch(s[4])
				{
				case '+':
					strncpy(lan_sman, &s[6], sizeof(lan_sman));
					break;
				case '-':
					strncpy(lan_gman, &s[6], sizeof(lan_gman));
					break;
				default:
					break;
				}
			}
			else if (strncmp(s, "Your_Turn:", 10) == 0)
			{
				switch(s[10])
				{
				case '+':
					you_teban = 0;
					break;
				case '-':
					you_teban = 1;
					break;
				default:
					break;
				}
			}
			else if (strncmp(s, "REJECT", 6) == 0)
			{
				if (lan_prog == 4)
				{
					job_no = 0;
					finish_shikou();
				}
				lan_prog = 2;
				pDC = GetDC();
				teban_disp(pDC, "reject", "");
				ReleaseDC(pDC);
			} else if (strncmp(s, "##[LOGIN] +OK x1", 16) == 0) {
				if (m_continuous && m_wdoor) {
					snprintf(moji, sizeof(moji), "%%%%GAME %s *\n", wdoor_game);
					_lan_puts(moji);
					pDC = GetDC();
					teban_disp(pDC, "game waiting", "");
					ReleaseDC(pDC);
				}
			} else if (*s == '#') {
				if (lan_prog == 5) {
					if (strncmp(s, "#WIN", 4) == 0) {
						lan_prog = 2;
						kifu[tesu][0] = 0;
						stop_time();
						pDC = GetDC();
						if (i_man[0] == 1)
						{
							end_code = END_CODE_SENTE_WIN;
							teban_disp(pDC, "菟!", "");
						}
						else
						{
							end_code = END_CODE_GOTE_WIN;
							teban_disp(pDC, "菟!", "");
						}
						ReleaseDC(pDC);
						job_no = 0;
						PlaySound(SE_WIN, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
						if (m_continuous == FALSE) {
							MessageBox("Win!", "Shogi");
						}
						finish_shikou();
					}
					else if (strncmp(s, "#LOSE", 5) == 0)
					{
						lan_prog = 2;
						kifu[tesu][0] = 0;
						stop_time();
						pDC = GetDC();
						if (i_man[0] < 0)
						{
							end_code = END_CODE_SENTE_WIN;
							teban_disp(pDC, "菟!", "");
						}
						else
						{
							end_code = END_CODE_GOTE_WIN;
							teban_disp(pDC, "菟!", "");
						}
						ReleaseDC(pDC);
						job_no = 0;
						PlaySound(SE_LOSE, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
						if (m_continuous == FALSE) {
							MessageBox("Lose!", "Shogi");
						}
						finish_shikou();
					}
					else if (strncmp(s, "#DRAW", 5) == 0)
					{
						lan_prog = 2;
						kifu[tesu][0] = 0;
						stop_time();
						pDC = GetDC();
						end_code = END_CODE_SENNICHITE;
						teban_disp(pDC, "!", "");
						ReleaseDC(pDC);
						job_no = 0;
///						PlaySound(SE_LOSE, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
						if (m_continuous == FALSE) {
							MessageBox("Draw!", "Shogi");
						}
						finish_shikou();
					}
				}
			} else {
				// for DEBUG
				if (lan_prog == 2) {
					lan_prog = 2;
				}
				moji[0] = moji[0];
			}
		}
		break;
	default:	// ؒf
		lan_prog = 0;
		pDC = GetDC();
		teban_disp(pDC, "LANؒf", "");
		ReleaseDC(pDC);
		_lan_close();
		break;
	}
	return 0;
}

/////////////////////////////////////////////////////////////////////////////
// CCsaView NX̕`

void CCsaView::OnDraw(CDC* pDC)
{
	CBitmap	Bitmap, *pOldBitmap, Bitmap1;
	CDC		MemDC;
	int		x, y;
	int		i;
	CRect	rect;

	CCsaDoc* pDoc = GetDocument();
	ASSERT_VALID(pDoc);

	if (initial_flag == 1)
	{
		Mem1DC     = new CDC;
		Mem1DC->CreateCompatibleDC(pDC);
		SaveBitmap = new CBitmap;
		SaveBitmap->CreateCompatibleBitmap(pDC, SZ_POPUP_X, SZ_POPUP_Y);
		initial_flag = 2;
	}

	// nIDB_YUKAœhԂ
	Bitmap.LoadBitmap(IDB_YUKA);
	MemDC.CreateCompatibleDC(pDC);
	pOldBitmap = MemDC.SelectObject(&Bitmap);
	GetClientRect(&rect);				// EBhEYTCY擾
	for (y = 0; y < rect.bottom; y += SZ_YUKA_H)
	{
		for (x = 0; x < rect.right; x += SZ_YUKA_W)
		{
			pDC->BitBlt(x, y, SZ_YUKA_W, SZ_YUKA_H, &MemDC, 0, 0, SRCCOPY);
		}
	}

	// 		ban_write(pDC,   8,  30, 144, 196);
	// 			ban_write(pDC, 152,  30, 488, 400);
	// 		ban_write(pDC, 496, 235, 632, 400);
	// 
	ban_write(pDC, PS_GKOMADAI_X1, PS_GKOMADAI_Y1, PS_GKOMADAI_X2, PS_GKOMADAI_Y2);
	// 
	ban_write(pDC, PS_BOARD_X1,    PS_BOARD_Y1,    PS_BOARD_X2,    PS_BOARD_Y2);
	// 
	ban_write(pDC, PS_SKOMADAI_X1, PS_SKOMADAI_Y1, PS_SKOMADAI_X2, PS_SKOMADAI_Y2);

	// (157-481)
	for (i = 0; i < 10; i++)
	{
		vline(pDC,
			  PS_BOARD_ORG_X,                 i * SZ_MASU_H + PS_BOARD_ORG_Y,
			  PS_BOARD_ORG_X + SZ_MASU_W * 9, i * SZ_MASU_H + PS_BOARD_ORG_Y);
	}

	// (35-395)
	for (i = 0; i < 10; i++)
	{
		vline(pDC,
			  i * SZ_MASU_W + PS_BOARD_ORG_X, PS_BOARD_ORG_Y,
			  i * SZ_MASU_W + PS_BOARD_ORG_X, PS_BOARD_ORG_Y + SZ_MASU_H * 9);
	}
	teban_disp_static(pDC);
	k_disp(pDC, men_h, 0);		// Ֆʕ\
	man_disp(pDC, tesu, 0);
	MemDC.SelectObject(pOldBitmap);
}

/////////////////////////////////////////////////////////////////////////////
// CCsaView NX̐ff



/////////////////////////////////////////////////////////////////////////////
// CCsaView NX̃bZ[W nh


/************************/
/* vJEgJn */
/************************/

void CCsaView::start_time()
{
	time(&start_sec);
}

/************************/
/* vJEgI */
/************************/

void CCsaView::stop_time()
{
	time_t	stop_sec;
	int		sec;
	int		teban;

	time(&stop_sec);

	sec = stop_sec - start_sec - 1;
	if (sec <= 0)
	{
		sec = 1;
	}
	else if (tesu == 0)
	{
		if (i_man[0] < 0)sec = 1;
	}
	teban = tesu & 0x0001;
	timer_sec[teban] += sec;
	timer_sec1[teban] = sec;
	shohi[tesu]       = timer_sec[teban];

	start_sec = stop_sec;
}

/**********************************************/
/* 肩ׂĎw萔̋ǖʐ}쐬B */
/**********************************************/
void CCsaView::men_make(char* men, int tesu_x)
{
	int i;
	int moto;
	int saki;
	int naru;
	int koma;

	/******************/
	/* ǖʃRs[ */
	/******************/
	memcpy(men, initial_kyokumen, sizeof(initial_kyokumen));

	for (i = 0; i < tesu_x; i++)
	{
		/* w擾 */
		moto = (int)kifu[i][1];
		saki = (int)kifu[i][0];
		if (moto < 100)
		{
			if (saki < 100)
			{
				naru = 0;
			}
			else
			{
				naru  = 1;
				saki -= 100;
			}
			koma = men[saki];
			if (koma > 0)
			{
				men[(koma & 0x07) + 90]++;
			}
			else if (koma < 0)
			{
				men[((-koma) & 0x07) + 82]++;
			}
			if (naru == 1)
			{
				if ((i & 0x0001) == 0)
				{
					men[saki] = men[moto] + 8;
				}
				else
				{
					men[saki] = men[moto] - 8;
				}
			}
			else
			{
				koma = men[saki] = men[moto];
				switch (koma)
				{
				case 8:
					men[98] = saki;
					break;
				case -8:
					men[99] = saki;
					break;
				default:
					break;
				}
			}
			men[moto] = 0;
		}
		else
		{
			if ((i & 0x0001) == 0)
			{
				men[saki] = moto - 100;
				men[moto - 18]--;
			}
			else
			{
				men[saki] = 100 - moto;
				men[moto - 10]--;
			}
		}
	}
}

// ՁiIDB_BAN)ŎwGAh	// IWi X, Y ւ
void CCsaView::ban_write(CDC *pDC, int x_min, int y_min, int x_max, int y_max)
{
	CBitmap	Bitmap;
	CDC		MemDC;
	int		x, y;
	int		x_size, y_size;

	y_min -= 20;
	y_max -= 20;
	Bitmap.LoadBitmap(IDB_BAN);
	MemDC.CreateCompatibleDC(pDC);
	MemDC.SelectObject(&Bitmap);
	for (y = y_min; y < y_max; y += SZ_BAN_H)
	{
		y_size = y_max - y;
		if (y_size > SZ_BAN_H) y_size = SZ_BAN_H;
		for (x = x_min; x < x_max; x += SZ_BAN_W)
		{
			x_size = x_max - x;
			if (x_size > SZ_BAN_W) x_size = SZ_BAN_W;
			pDC->BitBlt(x, y, x_size, y_size, &MemDC, 0, 0, SRCCOPY);
		}
	}
}

/**************/
/* B */
/**************/	// IWi X, Y ւ{
void CCsaView::vline(CDC* pDC, int x_min, int y_min, int x_max, int y_max, int nWidth)
{
	CPen	myPen(PS_SOLID, nWidth, RGB(0, 0, 0));
	CPen*	pOldPen;

	y_min -= 20;
	y_max -= 20;
	pOldPen = pDC->SelectObject(&myPen);
	pDC->MoveTo(x_min, y_min);
	pDC->LineTo(x_max, y_max);
	pDC->SelectObject(pOldPen);
}

// wGAIDB_WHITEŖ߂(NA)	// IWi X, Y ւ
void CCsaView::vpaint(CDC *pDC, int x1, int y1, int x2, int y2)
{
	int		x, y;
	CBitmap	Bitmap;
	CDC		MemDC;
	int		x_size, y_size;

	y1 -= 20;
	y2 -= 20;
	Bitmap.LoadBitmap(IDB_WHITE);
	MemDC.CreateCompatibleDC(pDC);
	MemDC.SelectObject(&Bitmap);

	for (x = x1; x < x2; x += SZ_WHITE_W)
	{
		x_size = x2 - x	+ 1;
		if (x_size > SZ_WHITE_W) x_size = SZ_WHITE_W;
		for (y = y1; y < y2; y += SZ_WHITE_H)
		{
			y_size = y2 - y + 1;
			if (y_size > SZ_WHITE_H) y_size = SZ_WHITE_H;
			pDC->BitBlt(x, y, x_size, y_size, &MemDC, 0, 0, SRCCOPY);
		}
	} 
}

/******************/
/* TCYvZ */
/******************/
int CCsaView::moji_size(unsigned char c)
{
	if (c < 0x0020)return(0);
	if (c < 0x007f)return(1);
	if (c < 0x0081)return(0);
	if (c < 0x00a0)return(2);
	if (c < 0x00a1)return(0);
	if (c < 0x00e0)return(1);
	if (c < 0x00fd)return(2);
	return(0);
}

// IWi X, Y ւ
void CCsaView::vchar(CDC *pDC, int x, int y, char* s)
{
	y -= 20;
#if 0
	char	s1;
	while(*s)
	{
		switch (moji_size(*s))
		{
		case 1:
			s1   = s[1];
			s[1] = 0;
			pDC->TextOut(x, y, s);
			s[1] = s1;
			s++;
			x += 8;
			break;
		case 2:
			s1   = s[2];
			s[2] = 0;
			pDC->TextOut(x, y, s);
			s[2] = s1;
			s += 2;
			x += 16;
			break;
		default:
			s++;
			break;	
		}
	}
#else
	pDC->TextOut(x, y, s);
#endif
}

void CCsaView::teban_disp_static(CDC *pDC)
{
#if 0
	vpaint(pDC, PS_TEXT_AREA2_X1, PS_TEXT_AREA2_Y1, PS_TEXT_AREA2_X2, PS_TEXT_AREA2_Y2 - 1);
	if (*teban_moji1 == 0) return;
	if (*teban_moji2 == 0)
	{
		vchar(pDC, PS_TEXT_AREA2_X1 + 8, PS_TEXT_AREA2_Y1 + 14, teban_moji1);
	}
	else
	{
		vchar(pDC, PS_TEXT_AREA2_X1 + 8, PS_TEXT_AREA2_Y1 +  4, teban_moji1);
		vchar(pDC, PS_TEXT_AREA2_X1 + 8, PS_TEXT_AREA2_Y1 + 24, teban_moji2);
	}
#endif

	CFrameWnd* pFrame = (CFrameWnd*)AfxGetApp()->m_pMainWnd;
	CStatusBar* pStatusBar = pFrame ? (CStatusBar*)pFrame->GetDescendantWindow(AFX_IDW_STATUS_BAR) : NULL;
	if (pStatusBar) {
		int n = pStatusBar->CommandToIndex(ID_INDICATOR_TEXT);
		if (n >= 0) {
			char mess[sizeof(teban_moji1)+sizeof(teban_moji2)+5];
			snprintf(mess, sizeof(mess), "%s  %s", teban_moji1, teban_moji2);
			pStatusBar->SetPaneText(n, teban_moji1);
		}
	}
}

void CCsaView::teban_disp(CDC * pDC, char* s1, char* s2)
{
	strncpy(teban_moji1, s1, sizeof(teban_moji1));
	strncpy(teban_moji2, s2, sizeof(teban_moji2));
	teban_disp_static(pDC);
}

// `		// IWi X, Y ւ
//   prog		0:A1:`
//   mikata		0:A1:
//   koma		1-15F̎
void CCsaView::vkoma(CDC *pDC, int prog, int mikata, int koma, int x, int y, bool select)
{
	CBitmap	Bitmapkoma;
	CBitmap	Bitmapmask;
	CBitmap	Bitmap_ban;
	CDC		MemDC;

	y -= 20;
	if (mikata == 0)
	{
		switch (koma)
		{
		case SFU:
			Bitmapkoma.LoadBitmap(IDB_SFU);
			Bitmapmask.LoadBitmap(IDB_SFUM);
			break;
		case SKY:
			Bitmapkoma.LoadBitmap(IDB_SKYO);
			Bitmapmask.LoadBitmap(IDB_SKYOM);
			break;
		case SKE:
			Bitmapkoma.LoadBitmap(IDB_SKEI);
			Bitmapmask.LoadBitmap(IDB_SKEIM);
			break;
		case SGI:
			Bitmapkoma.LoadBitmap(IDB_SGIN);
			Bitmapmask.LoadBitmap(IDB_SGINM);
			break;
		case SKI:
			Bitmapkoma.LoadBitmap(IDB_SKIN);
			Bitmapmask.LoadBitmap(IDB_SKINM);
			break;
		case SKA:
			Bitmapkoma.LoadBitmap(IDB_SKAKU);
			Bitmapmask.LoadBitmap(IDB_SKAKUM);
			break;
		case SHI:
			Bitmapkoma.LoadBitmap(IDB_SHI);
			Bitmapmask.LoadBitmap(IDB_SHIM);
			break;
		case SOU:
			Bitmapkoma.LoadBitmap(IDB_SOU);
			Bitmapmask.LoadBitmap(IDB_SOUM);
			break;
		case STO:
			Bitmapkoma.LoadBitmap(IDB_STO);
			Bitmapmask.LoadBitmap(IDB_SFUM);
			break;
		case SNY:
			Bitmapkoma.LoadBitmap(IDB_SNKYO);
			Bitmapmask.LoadBitmap(IDB_SKYOM);
			break;
		case SNK:
			Bitmapkoma.LoadBitmap(IDB_SNKEI);
			Bitmapmask.LoadBitmap(IDB_SKEIM);
			break;
		case SNG:
			Bitmapkoma.LoadBitmap(IDB_SNGIN);
			Bitmapmask.LoadBitmap(IDB_SGINM);
			break;
		case SUM:
			Bitmapkoma.LoadBitmap(IDB_SUMA);
			Bitmapmask.LoadBitmap(IDB_SKAKUM);
			break;
		case SRY:
			Bitmapkoma.LoadBitmap(IDB_SRYU);
			Bitmapmask.LoadBitmap(IDB_SHIM);
			break;
 		default:
			break;
		}
	}
	else
	{
		switch(koma)
		{
		case -GFU:
			Bitmapkoma.LoadBitmap(IDB_GFU);
			Bitmapmask.LoadBitmap(IDB_GFUM);
			break;
		case -GKY:
			Bitmapkoma.LoadBitmap(IDB_GKYO);
			Bitmapmask.LoadBitmap(IDB_GKYOM);
			break;
		case -GKE:
			Bitmapkoma.LoadBitmap(IDB_GKEI);
			Bitmapmask.LoadBitmap(IDB_GKEIM);
			break;
		case -GGI:
			Bitmapkoma.LoadBitmap(IDB_GGIN);
			Bitmapmask.LoadBitmap(IDB_GGINM);
			break;
		case -GKI:
			Bitmapkoma.LoadBitmap(IDB_GKIN);
			Bitmapmask.LoadBitmap(IDB_GKINM);
			break;
		case -GKA:
			Bitmapkoma.LoadBitmap(IDB_GKAKU);
			Bitmapmask.LoadBitmap(IDB_GKAKUM);
			break;
		case -GHI:
			Bitmapkoma.LoadBitmap(IDB_GHI);
			Bitmapmask.LoadBitmap(IDB_GHIM);
			break;
		case -GOU:
			Bitmapkoma.LoadBitmap(IDB_GOU);
			Bitmapmask.LoadBitmap(IDB_GOUM);
			break;
		case -GTO:
			Bitmapkoma.LoadBitmap(IDB_GTO);
			Bitmapmask.LoadBitmap(IDB_GFUM);
			break;
		case -GNY:
			Bitmapkoma.LoadBitmap(IDB_GNKYO);
			Bitmapmask.LoadBitmap(IDB_GKYOM);
			break;
		case -GNK:
			Bitmapkoma.LoadBitmap(IDB_GNKEI);
			Bitmapmask.LoadBitmap(IDB_GKEIM);
			break;
		case -GNG:
			Bitmapkoma.LoadBitmap(IDB_GNGIN);
			Bitmapmask.LoadBitmap(IDB_GGINM);
			break;
		case -GUM:
			Bitmapkoma.LoadBitmap(IDB_GUMA);
			Bitmapmask.LoadBitmap(IDB_GKAKUM);
			break;
		case -GRY:
			Bitmapkoma.LoadBitmap(IDB_GRYU);
			Bitmapmask.LoadBitmap(IDB_GHIM);
			break;
 		default:
			break;
		}
	}
	MemDC.CreateCompatibleDC(pDC);
	if (select == true) {
		if (prog == 0) {
			Bitmap_ban.LoadBitmap(IDB_BAN);
		} else {
			Bitmap_ban.LoadBitmap(IDB_SELECT);
		}
		int x0 = x - (SZ_MASU_W - SZ_KOMA_W) / 2;
		int y0 = y - (SZ_MASU_H - SZ_KOMA_H) / 2;
		MemDC.SelectObject(&Bitmap_ban);
		pDC->BitBlt(x0 + 1, y0 + 1, SZ_MASU_W - 2, SZ_MASU_H - 2, &MemDC, 0, 0, SRCCOPY);
		Bitmap_ban.DeleteObject();
	}
	MemDC.SelectObject(&Bitmapmask);
	pDC->BitBlt(x, y, SZ_KOMA_W, SZ_KOMA_H, &MemDC, 0, 0, SRCAND);		// }XNf[^Ŕ
	MemDC.SelectObject(&Bitmapkoma);
	pDC->BitBlt(x, y, SZ_KOMA_W, SZ_KOMA_H, &MemDC, 0, 0, SRCPAINT);	// OR `
	if (prog == 0)
	{
		int x0 = x - (SZ_MASU_W - SZ_KOMA_W) / 2;
		int y0 = y - (SZ_MASU_H - SZ_KOMA_H) / 2;
		Bitmap_ban.LoadBitmap(IDB_BAN);
		MemDC.SelectObject(&Bitmap_ban);
		pDC->BitBlt(x0 + 1, y0 + 1, SZ_MASU_W - 2, SZ_KOMA_H - 1, &MemDC, 0, 0, SRCCOPY);
	}
	else
	{
		pDC->BitBlt(x, y, SZ_KOMA_W, SZ_KOMA_H, &MemDC, 0, 0, SRCPAINT);
	}
}

// Ղ̓_(?) `		// IWi X, Y ւ
void CCsaView::ten_write(CDC *pDC, int x, int y)
{
	CBitmap	Bitmap;
	CDC		MemDC;

#if 0
	Bitmap.LoadBitmap(IDB_TEN);
	MemDC.CreateCompatibleDC(pDC);
	MemDC.SelectObject(&Bitmap);
	pDC->BitBlt(x, y - 20, 7, 7, &MemDC, 0, 0, SRCCOPY);
#endif
	CPen	myPen(PS_SOLID, 1, RGB(0, 0, 0));
	CPen*	pOldPen;
	CBrush	myBrush(RGB(0,0,0));
	CBrush* pOldBrush;
	pOldPen = pDC->SelectObject(&myPen);
	pOldBrush = pDC->SelectObject(&myBrush);
	pDC->Ellipse(x, y - 20, x+8, y-20+8);
	pDC->SelectObject(pOldPen);
	pDC->SelectObject(pOldBrush);
}

// wGAIDB_BANŖ߂	// IWi X, Y ւ
void CCsaView::vpaint2(CDC *pDC, int x1, int y1, int x2, int y2)
{
	CBitmap		Bitmap;
	CDC			MemDC;
	int			x, y;
	int			x_size, y_size;

	y1 -= 20;
	y2 -= 20;
	Bitmap.LoadBitmap(IDB_BAN);
	MemDC.CreateCompatibleDC(pDC);
	MemDC.SelectObject(&Bitmap);
	for (x = x1; x < x2; x += SZ_BAN_W)
	{
		x_size = x2 - x + 1;
		if (x_size > SZ_BAN_W) x_size = SZ_BAN_W;
		for (y = y1; y < y2; y += SZ_BAN_H)
		{
			y_size = y2 - y + 1;
			if (y_size > SZ_BAN_H) y_size = SZ_BAN_H;    
			pDC->BitBlt(x, y, x_size, y_size, &MemDC, 0, 0, SRCCOPY);
		}
	}
}

// ̎\
void CCsaView::s_disp(CDC *pDC, char* newx, char* old)
{
	int	ic;
	int koma;
	int maisu;
	int line;
	int column;
	int m;
	int ix;
	int ix_len;
	int no;
	int max;
	int ke;

	ic = PS_SKOMADAI_X1;
	ke = 1;

	for (koma = 7; koma >= ke; koma--)
	{
		if (old[koma] == newx[koma])continue;
		if (old[koma] > 0)
		{
			switch (koma)
			{
			case SFU:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 1 - 1;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				break;
			case SKY:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 2 - 1;
				column = ic + SZ_KOMADAI_X / 2 + 2;
				max    =  SZ_KOMADAI_X / 2 - 6;
				break;
			case SKE:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 2 - 1;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				old[2] = 0;
				break;
			case SGI:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 3 - 1;
				column = ic + SZ_KOMADAI_X / 2 + 2;
				max    =  SZ_KOMADAI_X / 2 - 6;
				break;
			case SKI:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 3 - 1;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				old[4] = 0;
				break;
			case SKA:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 4 - 1;
				column = ic + SZ_KOMADAI_X / 2 + 2;
				max    =  SZ_KOMADAI_X / 2 - 6;
				break;
			case SHI:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 4 - 1;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				old[6] = 0;
				break;
			default:
				line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 5 - 1;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				old[6] = 0;
				break;
			}
			if (koma == 0)
			{
				vpaint2(pDC, column - 2, line-1, column + max - 1, line + SZ_KOMA_H);
			}
			else
			{
				vpaint2(pDC, column - 2, line-1, column + max - 1, line + SZ_KOMA_H);
			}
		}
		maisu = old[koma] = newx[koma];
		if (maisu == 0) continue;
		switch(koma)
		{
		case SFU:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 1 - 1;
			column = ic + 3;
			max    = SZ_KOMADAI_X - SZ_KOMA_W - 9;
			break;
		case SKY:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 2 - 1;
			column = ic + SZ_KOMADAI_X / 2 + 2;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case SKE:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 2 - 1;
			column = ic + 3;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case SGI:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 3 - 1;
			column = ic + SZ_KOMADAI_X / 2 + 2;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case SKI:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 3 - 1;
			column = ic + 3;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case SKA:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 4 - 1;
			column = ic + SZ_KOMADAI_X / 2 + 2;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case SHI:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 4 - 1;
			column = ic + 3;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		default:
			line   = PS_SKOMADAI_Y2 - SZ_KOMA_H * 5 - 1;
			column = ic + 3;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		}
		ix_len = SZ_KOMA_W * (maisu - 1);
		if (ix_len > max)
		{
			ix_len = max;
		}
		no = maisu;
		for (m = 0; m < maisu; m++)
		{
			no--;
			if (maisu == 1)
			{
				ix = column;
			}
			else
			{
				ix = column + ix_len * no / (maisu - 1);
			}
			if (koma == 0)
			{
				vkoma(pDC, 1, 0, 8,    ix, line);
			}
			else
			{
				vkoma(pDC, 1, 0, koma, ix, line);
			}
		}
	}
}

// ̎\
void CCsaView::g_disp(CDC *pDC, char* newx, char* old)
{
	int koma;
	int maisu;
	int line;
	int column;
	int ix;
	int ix_len;
	int no;
	int max;
	int ic;

	ic = PS_GKOMADAI_X1;
	for (koma = 1; koma < 8; koma++)
	{
		if (old[koma] == newx[koma])continue;
		if (old[koma] > 0)
		{
			switch (-koma)
			{
			case GFU:
				line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 0 + 5;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				break;
			case GKY:
				line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 1 + 5;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				old[3] = 0;
				break;
			case GKE:
				line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 1 + 5;
				column = ic + SZ_KOMADAI_X / 2;
				max    = SZ_KOMADAI_X / 2 - 6;
				break;
			case GGI:
				line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 2 + 5;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				old[5] = 0;
				break;
			case GKI:
				line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 2 + 5;
				column = ic + SZ_KOMADAI_X / 2;
				max    = SZ_KOMADAI_X / 2 - 6;
				break;
			case GKA:
				line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 3 + 5;
				column = ic + 6;
				max    = SZ_KOMADAI_X - 12;
				old[7] = 0;
				break;
			case GHI:
				line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 3 + 5;
				column = ic + SZ_KOMADAI_X / 2;
				max    = SZ_KOMADAI_X / 2 - 6;
				break;
			}
			vpaint2(pDC, column - 2, line - 1, column + max - 1, line + SZ_MASU_H - 1);
		}
		maisu = old[koma] = newx[koma];
		if (maisu == 0) continue;
		switch (-koma)
		{
		case GFU:
			line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 0 + 5;
			column = ic + SZ_KOMADAI_X - SZ_KOMA_W - 6;
			max    = SZ_KOMADAI_X - SZ_KOMA_W - 12;
			break;
		case GKY:
			line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 1 + 5;
			column = ic + SZ_KOMADAI_X / 2 - SZ_KOMA_W - 2;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case GKE:
			line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 1 + 5;
			column = ic + SZ_KOMADAI_X - SZ_KOMA_W - 6;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case GGI:
			line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 2 + 5;
			column = ic + SZ_KOMADAI_X / 2 - SZ_KOMA_W - 2;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case GKI:
			line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 2 + 5;
			column = ic + SZ_KOMADAI_X - SZ_KOMA_W - 6;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case GKA:
			line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 3 + 5;
			column = ic + SZ_KOMADAI_X / 2 - SZ_KOMA_W - 2;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		case GHI:
			line   = PS_GKOMADAI_Y1 + SZ_KOMA_H * 3 + 5;
			column = ic + SZ_KOMADAI_X - SZ_KOMA_W - 6;
			max    = SZ_KOMADAI_X / 2 - SZ_KOMA_W - 6;
			break;
		}
		ix_len = SZ_KOMA_W * (maisu - 1);
		if (ix_len > max)
		{
			ix_len = max;
		}
		for (no = 0; no < maisu; no++)
		{
			if (maisu == 1)
			{
				ix = column;
			}
			else
			{
				ix = column - ix_len * no / (maisu - 1);
			}
			vkoma(pDC, 1, 1, koma, ix, line);
		}
	}
}

// Ֆʕ\
void CCsaView::k_disp(CDC *pDC, char* men, int flag)
{
	int     ip;
	int     ix;
	int     iy;
	int     koma;
	char    men2[82];
	char    mochi[2][8];

	if (flag == 0)
	{
		memset(old_men, 0, 82);
		memset(old_smochi, 0, 8);
		memset(old_gmochi, 0, 8);
	}
	memcpy(mochi, &men[82], sizeof(mochi));
	memcpy(men2, men, sizeof(men2));

	ip = 0;
	const int x_offset = PS_BOARD_ORG_X - SZ_MASU_W + (SZ_MASU_W - SZ_KOMA_W) / 2;// 123;
	const int y_offset = PS_BOARD_ORG_Y + (SZ_MASU_H - SZ_KOMA_H) / 2;
	for (iy = 0; iy < 9; iy++)
	{
		for (ix = 0; ix < 9; ix++)
		{
			ip++;
			if (men2[ip] == old_men[ip]) continue;
			koma = old_men[ip];
			if (koma > 0)
			{
				vkoma(pDC, 0, 0,  koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset);
			}
			else if (koma < 0)
			{
				vkoma(pDC, 0, 1, -koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset);
			}

			koma = old_men[ip] = men2[ip];
			if (koma > 0)
			{
				vkoma(pDC, 1, 0,  koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset);
			}
			else if (koma < 0)
			{
				vkoma(pDC, 1, 1, -koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset);
			}
		}
	}
	if (tesu > 0) {
		int saki = kifu[tesu-1][0];
		if (old_select != saki) {
			ix = (old_select - 1) % 9;
			iy = (old_select - 1) / 9;
			koma = men2[old_select];
			if (koma > 0)
			{
				vkoma(pDC, 0, 0,  koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset, true);
				vkoma(pDC, 1, 0,  koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset);
			}
			else if (koma < 0)
			{
				vkoma(pDC, 0, 1, -koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset, true);
				vkoma(pDC, 1, 1, -koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset);
			}
		}
		saki %= 100;
		ix = (saki - 1) % 9;
		iy = (saki - 1) / 9;
		koma = men2[saki];
		old_select = saki;
		if (koma > 0) {
			vkoma(pDC, 1, 0,  koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset, true);
		} else {
			vkoma(pDC, 1, 1, -koma, (9 - ix) * SZ_MASU_W + x_offset, iy * SZ_MASU_H + y_offset, true);
		}
	}
	ten_write(pDC, PS_BOARD_ORG_X + SZ_MASU_W * 3 - 4, PS_BOARD_ORG_Y + SZ_MASU_H * 3 - 4);	// 261, 151
	ten_write(pDC, PS_BOARD_ORG_X + SZ_MASU_W * 6 - 4, PS_BOARD_ORG_Y + SZ_MASU_H * 3 - 4);	// 369, 151
	ten_write(pDC, PS_BOARD_ORG_X + SZ_MASU_W * 3 - 4, PS_BOARD_ORG_Y + SZ_MASU_H * 6 - 4);	// 261, 271
	ten_write(pDC, PS_BOARD_ORG_X + SZ_MASU_W * 6 - 4, PS_BOARD_ORG_Y + SZ_MASU_H * 6 - 4);	// 369, 271
	s_disp(pDC, &mochi[0][0], old_smochi);		// ̎\
	g_disp(pDC, &mochi[1][0], old_gmochi);		// ̎\
}

/**************/
/* 擾 */
/**************/
void CCsaView::get_moji(char* s2, char* s1, int max)
{
	int    len;
	int    iend;

	len  = 0;
	iend = 1;

	while(iend)
	{
		switch(moji_size(*s1))
		{
		case 1:
			if (len >= max)
			{
				iend = 0;
				break;
			}
			*s2++ = *s1++;
			len++;
			break;
		case 2:
			if ((len + 1) >= max)
			{
				iend = 0;
				break;
			}
			*s2++ = *s1++;
			*s2++ = *s1++;
			len += 2;
			break;
		default:
			iend = 0;
			break;
		}
	}
	*s2 = 0;
}

void CCsaView::man_moji(int m, char* moji, int len)
{
	CString tmp = "";
	if (m == 0)
	{
		if (ssman[0] != '\0') {
			tmp = ssman;
		} else {
			tmp = sman;
		}
		snprintf(moji, len, "\xFC\x01%s", (const char*)tmp);
	}
	else
	{
		if (ggman[0] != '\0') {
			tmp = ggman;
		} else {
			tmp = gman;
		}
		snprintf(moji, len, "\xFC\x02%s", (const char*)tmp);
	}
}

void CCsaView::vchar_koma(CDC *pDC, int x, int y, int prog)
{
	CBitmap	Bitmap;
	CDC		MemDC;

	if (prog == 0)
	{
		Bitmap.LoadBitmap(IDB_SKOMA);
	}
	else
	{
		Bitmap.LoadBitmap(IDB_GKOMA);
	}
	MemDC.CreateCompatibleDC(pDC);
	MemDC.SelectObject(&Bitmap);
	pDC->BitBlt(x, y, 16, 16, &MemDC, 0, 0, SRCCOPY);
}

// IWi X, Y ւ
void CCsaView::vchar_g(CDC *pDC, int x, int y, char* s)
{
	y -= 20;
//	if (strncmp(s, "", 2) == 0)				// yۑz
	if (strncmp(s, "\xFC\x01", 2) == 0)				// yۑz
	{
		vchar_koma(pDC, x, y, 0);
		x += 16;
		s += 2;
	}
//	else if (strncmp(s, "", 2) == 0)			// yۑz
	else if (strncmp(s, "\xFC\x02", 2) == 0)			// yۑz
	{
		vchar_koma(pDC, x, y, 1);
		x += 16;
		s += 2;
	}
	pDC->TextOut(x, y, s);
}

// IWi X, Y ւ
void CCsaView::vchar_h(CDC *pDC, int x, int y, char* s)
{
	y -= 20;
	pDC->TextOut(x, y, s);
}

// ACR\
void CCsaView::icon_disp(CDC *pDC)
{
	// ACR`

	int kaoN_tbl[] = {IDB_NA_MAKE, IDB_NA_FURI, IDB_NA_FUTSU, IDB_NA_YUURI, IDB_NA_KACHI};
	int kaoF_tbl[] = {IDB_FA_FUTSU, IDB_FA_FUTSU, IDB_FA_FUTSU, IDB_FA_FUTSU, IDB_FA_FUTSU};
	int xa[] = {PS_S_ICON_X1, PS_G_ICON_X1};
	int ya[] = {PS_S_ICON_Y1, PS_G_ICON_Y1};
	int furi;

	if (gEvalution < -29000) {
		//   ( ` -29001)
		furi = 0;
	} else if (gEvalution < -999) {
		// s  (-29000`-1000)
		furi = 1;
	} else if (gEvalution <= 999) {
		// ΓH(-999 ` 999)
		furi = 2;
	} else if (gEvalution <= 29000) {
		// L  (1000`29000)
		furi = 3;
	} else {
		//   (29001 ` )
		furi = 4;
	}

	CBitmap	Bitmap;
	CDC		MemDC;
	MemDC.CreateCompatibleDC(pDC);
	int i;
	for (i = 0; i < 2; i++) {
		int *tbl = kaoN_tbl;
		if (i_man[i] != 1) {
			// Ԃ̓Rs[^łȂ
			tbl = kaoF_tbl;
		}
		bool bRev = false;	// E]tO
		if (i == 0 && i_man[0] != 1) {
			bRev = true;
		}
		if (i == 1 && i_man[1] == 1) {
			bRev = true;
		}

		// Ԃ͕s𔽓]
		if (i == 1) {
			furi = 4 - furi;
		}
		Bitmap.LoadBitmap(tbl[furi]);
		CBitmap *oldBitmap = MemDC.SelectObject(&Bitmap);
		if (bRev == false) {
			// ʏ\
			pDC->StretchBlt(xa[i], ya[i] - 20, 
							SZ_NANOHA_ICON_W*2, SZ_NANOHA_ICON_H*2,
							&MemDC,
							 0, 0,
							SZ_NANOHA_ICON_W, SZ_NANOHA_ICON_H,
							 SRCCOPY);
		} else {
			// E]\
			pDC->StretchBlt(xa[i], ya[i] - 20, 
							SZ_NANOHA_ICON_W*2, SZ_NANOHA_ICON_H*2,
							&MemDC,
							 SZ_NANOHA_ICON_W-1, 0,
							-SZ_NANOHA_ICON_W, SZ_NANOHA_ICON_H,
							 SRCCOPY);
		}
		MemDC.SelectObject(oldBitmap);
		Bitmap.DeleteObject();
	}
}

void CCsaView::man_disp(CDC *pDC, int tesu_x, int flag)
{
	int     i;
	int     iy;
	int		sec;
	int		min;
	int		sec1;
	int		min1;
	int     new_tesu;
	char    moji[20];

	if (now_tesu != tesu_x) now_tesu = -1;

	switch(flag)
	{
	case 0:
		old_tesu = -1;
		break;
	case -1:
		now_tesu = tesu_x;
		return;
	default:
		break;
	}

	if (old_tesu < 0)
	{
///		vpaint(pDC, PS_TEXT_AREA1_X1, PS_TEXT_AREA1_Y1, PS_TEXT_AREA1_X2 - 1, PS_TEXT_AREA1_Y2 - 1);
		vpaint(pDC, PS_STEXT_AREA_X1, PS_STEXT_AREA_Y1, PS_STEXT_AREA_X2 - 1, PS_STEXT_AREA_Y2 - 1);
		vpaint(pDC, PS_GTEXT_AREA_X1, PS_GTEXT_AREA_Y1, PS_GTEXT_AREA_X2 - 1, PS_GTEXT_AREA_Y2 - 1);
		time_moji[0][0] = time_moji[1][0] = old_man[0][0] = old_man[1][0] = 0;
		te_moji[0] = 0;
		gEvalution_old = gEvalution - 1;
	}

	int xa[2] = {PS_STEXT_AREA_X1, PS_GTEXT_AREA_X1};
	int ya[2] = {PS_STEXT_AREA_Y1, PS_GTEXT_AREA_Y1};

	for (i = 0; i < 2; i++)
	{
		iy = ya[i] + 4;
		man_moji(i, moji, sizeof(moji));
		get_moji(moji, moji, 14);
		if (strcmp(&old_man[i][0], moji) != 0)
		{
			strcpy(&old_man[i][0], moji);
			vpaint(pDC,  xa[i]    , iy, xa[i] + SZ_TEXT_AREA_W - 1, iy + 19);
			vchar_g(pDC, xa[i] + 8, iy, moji);
		}
		iy += 20;
		sec   = timer_sec[i];
		min   = sec / 60;
		sec  %= 60;
		sec1   = timer_sec1[i];
		min1   = sec1 / 60;
		sec1  %= 60;
		snprintf(moji, sizeof(moji), "%02d:%02d / (%02d:%02d)", min1, sec1, min, sec);
		if (strcmp(&time_moji[i][0], moji) != 0)
		{
			strcpy(&time_moji[i][0], moji);
			vpaint(pDC,  xa[i]    , iy, xa[i] + SZ_TEXT_AREA_W - 1, iy + 19);
			CFont *font = (CFont*)pDC->SelectStockObject(ANSI_FIXED_FONT);
			vchar_h(pDC, xa[i] + 8, iy, moji);
			pDC->SelectObject(font);
		}
		iy += 20;
	}

	new_tesu = tesu_x;

	snprintf(moji, sizeof(moji), "%2d", new_tesu);

	if (strcmp(te_moji, moji) != 0)
	{
		strncpy(te_moji, moji, sizeof(te_moji));
		CFrameWnd* pFrame = (CFrameWnd*)AfxGetApp()->m_pMainWnd;
		CStatusBar* pStatusBar = pFrame ? (CStatusBar*)pFrame->GetDescendantWindow(AFX_IDW_STATUS_BAR) : NULL;
		int n = pStatusBar ? pStatusBar->CommandToIndex(ID_INDICATOR_TESU) : -1;
		if (n >= 0) {
			pStatusBar->SetPaneText(n, moji);
		}
///		vpaint(pDC, PS_TEXT_AREA1_X1    , iy, PS_TEXT_AREA1_X2 - 1, iy + 19);
///		vchar(pDC,  PS_TEXT_AREA1_X1 + 8, iy, moji);
	}

	if (old_tesu != tesu_x)
	{
		iy = iy + 20;
		kifuout(moji, tesu_x - 1, kifu, initial_kyokumen, end_code);
		CFrameWnd* pFrame = (CFrameWnd*)AfxGetApp()->m_pMainWnd;
		CStatusBar* pStatusBar = pFrame ? (CStatusBar*)pFrame->GetDescendantWindow(AFX_IDW_STATUS_BAR) : NULL;
		int n = pStatusBar ? pStatusBar->CommandToIndex(ID_INDICATOR_SASHITE) : -1;
		if (n >= 0) {
			pStatusBar->SetPaneText(n, moji);
		}
///		vpaint(pDC,  PS_TEXT_AREA1_X1    , iy, PS_TEXT_AREA1_X2 - 1, iy + 19);
///		vchar_h(pDC, PS_TEXT_AREA1_X1 + 8, iy, moji);
	}

	if (gEvalution_old != gEvalution)
	{
		CFrameWnd* pFrame = (CFrameWnd*)AfxGetApp()->m_pMainWnd;
		CStatusBar* pStatusBar = pFrame ? (CStatusBar*)pFrame->GetDescendantWindow(AFX_IDW_STATUS_BAR) : NULL;
		int n = pStatusBar ? pStatusBar->CommandToIndex(ID_INDICATOR_VALUE) : -1;
		if (n >= 0) {
			char mess[16];
			snprintf(mess, sizeof(mess), "%7d", gEvalution);
			pStatusBar->SetPaneText(n, mess);
		}
		gEvalution_old = gEvalution;

		icon_disp(pDC);
	}

	old_tesu = tesu_x;
}

// ǖʂ̏Ԃ`FbN
int CCsaView::taikyoku_hansoku(char* men)
{
	int     i;
	int     j;
	int     kotae;
	int     teki_ichi;

	/* `FbNsB */
	if (men[98] == -1) return(-1);
	if (men[99] == -1) return(-1);

	for (i = 1; i <= 9; i++)
	{
		switch (men[i])
		{
		case (char)1:
		case (char)2:
		case (char)3:
			return(1);
		default:
			break;
		}
	}
	for (i = 10; i <= 18; i++)
	{
		if (men[i] == (char)3) return(1);
	}
	for (i = 64; i <= 72; i++)
	{
		if (men[i] == (char)-3) return(1);
	}
	for (i = 73; i <= 81; i++)
	{
		switch (men[i])
		{
		case (char)-1:
		case (char)-2:
		case (char)-3:
			return(1);
		default:
			break;
		}
	}
	for (i = 1; i <= 9; i++)
	{
		kotae = 0;
		for (j = i + 9; j <= 81; j += 9)
		{
			if (men[j] == (char)1) kotae++;
		}
		if (kotae >= 2) return(2);
	}
	for (i = 1; i <= 9; i++)
	{
		kotae = 0;
		for (j = i; j <= 72; j += 9)
		{
			if (men[j] == (char)-1) kotae++;
		}
		if (kotae >= 2) return(2);
	}

	/*  */
	if ((tesu & 0x01) == 0)
	{
		teki_ichi = men[99];
		if (teki_ichi > 0)
		{
			if (s_kiki(men, teki_ichi) != 0) return(3);
		}
	}
	else
	{
		teki_ichi = men[98];
		if (teki_ichi > 0)
		{
			if (g_kiki(men, teki_ichi) != 0) return(3);
		}
	}
	return(0);
}

void CCsaView::OnSaigenP1() 
{
	int		teban;
	char	mess[40];
	CDC		*pDC;

	if (job_no >= 100)return;

	if(kifu[tesu][0] == 0)return;
	pDC = GetDC();
	teban = tesu & 0x0001;
	timer_sec[teban] = shohi[tesu];
	timer_sec1[teban] = shohi[tesu];
	if (tesu >= 2) {
		timer_sec1[teban] -= shohi[tesu - 2];
	}
	tesu++;
	men_make(men_h, tesu);
	k_disp(pDC, men_h, 1);		// Ֆʕ\
	man_disp(pDC, tesu, 1);
	if (kifu[tesu][0] == 0)
	{
		end_moji(mess, sizeof(mess));
		teban_disp(pDC, mess, "");
	}
	else
	{
		teban_disp(pDC, "", "");
	}
	ReleaseDC(pDC);	
}

void CCsaView::OnUpdateSaigenP1(CCmdUI* pCmdUI) 
{
	if ((job_no == 0) && (kifu[tesu][0] != 0))
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::end_moji(char* s1, int len)
{
	switch(end_code)
	{

	case END_CODE_SENTE_WIN:
		strncpy(s1, "菟!", len);
		break;
	case END_CODE_GOTE_WIN:
		strncpy(s1, "菟!", len);
		break;
	case END_CODE_SENNICHITE:
		strncpy(s1, "", len);
		break;
	case END_CODE_JISHOGI:
		strncpy(s1, "", len);
		break;
	default:
		if (tesu == 0)
		{
			*s1 = 0;
		}
		else
		{
			strncpy(s1, "w", len);
		}
		break;
	}
}

void CCsaView::OnSaigenM3() 
{
	char	mess[40];
	CDC		*pDC;

	if (job_no >= 100)return;
	tesu = 0;
	pDC = GetDC();
	timer_sec[0] = timer_sec[1] = 0;
	timer_sec1[0] = timer_sec1[1] = 0;
	men_make(men_h, tesu);
	k_disp(pDC, men_h, 1);		// Ֆʕ\
	man_disp(pDC, tesu, 1);
	if (kifu[tesu][0] == 0)
	{
		end_moji(mess, sizeof(mess));
	}
	else
	{
		*mess = 0;
	}
	teban_disp(pDC, mess, "");

	ReleaseDC(pDC);
}

void CCsaView::OnUpdateSaigenM3(CCmdUI* pCmdUI) 
{
	if ((job_no == 0) && (tesu > 0))
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::OnSaigenP3() 
{
	int		teban;
	char	mess[40];
	CDC		*pDC;

	if (job_no >= 100)return;

	if (kifu[tesu][0] == 0)return;

   	pDC = GetDC();
	teban_disp(pDC, "", "");
	while(kifu[tesu][0])
	{
		teban = tesu & 0x0001;
		timer_sec[teban] = shohi[tesu];
		timer_sec1[teban] = shohi[tesu];
		if (tesu >= 2) {
			timer_sec1[teban] -= shohi[tesu - 2];
		}
		tesu++;
	}
	men_make(men_h, tesu);
	k_disp(pDC, men_h, 1);		// Ֆʕ\
	man_disp(pDC, tesu, 1);
	end_moji(mess, sizeof(mess));
	teban_disp(pDC, mess, "");
	ReleaseDC(pDC);
}

void CCsaView::OnUpdateSaigenP3(CCmdUI* pCmdUI) 
{
	if ((job_no == 0) && (kifu[tesu][0] != 0))
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::OnSaigenP2() 
{
	if (job_no >= 100)return;

//	job_no = 5;
	OnSaigenP1();
	if (kifu[tesu][0] == 0)
	{
		if (job_no == 5)
		{
			job_no = 0;
			KillTimer(200);
		}
	}
	else if (job_no == 0)
	{
		job_no = 5;
		this->SetTimer(200, saigen_msec, NULL);
	}	
}

void CCsaView::OnUpdateSaigenP2(CCmdUI* pCmdUI) 
{
	if ((job_no == 0) && (kifu[tesu][0] != 0))
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::OnTimer(UINT nIDEvent) 
{
	if (nIDEvent == 200)
	{
//		KillTimer(nIDEvent);
		if (job_no == 5)
		{
			OnSaigenP2();
		}
	}
	else if (nIDEvent == 300)
	{
//		KillTimer(nIDEvent);
		if (job_no == 6)
		{
			OnSaigenM2();
		}
	} else if (nIDEvent == DEF_TIMER_LOGIN_ID) {
		KillTimer(nIDEvent);

		tesu = 0;
		kifu[tesu][0] = 0;
		timer_sec[0] = timer_sec[1] = 0;
		timer_sec1[0] = timer_sec1[1] = 0;
		end_code = END_CODE_NONE;
		memcpy(men_h, initial_kyokumen, sizeof(men_h));
		CDC *pDC = GetDC();
		k_disp(pDC, men_h, 1);		// Ֆʕ\
		now_tesu = -1;
		ssman[0] = ggman[0] = '\0';
		man_disp(pDC, tesu, 1);
		teban_disp(pDC, "", "");
		ReleaseDC(pDC);

		chudan_flag = 0;
		job_no      = 2;
		end_code    = END_CODE_NONE;
		pDC = GetDC();
	  	man_disp(pDC, tesu, 0);
		ReleaseDC(pDC);
		if (i_man[0] > 0)
		{
			sikou_flag = 1;
		}
		else if (i_man[1] > 0)
		{
			sikou_flag = 2;
		}
		else
		{
			sikou_flag = 0;
		}
		if (sikou_flag) gCsaDll.sikou_ini(&chudan_flag);

		// LANڑ
		if (i_man[0] == -3 || i_man[1] == -3) {
			if (m_wdoor == 0) {
				start_login(lan_server, lan_port);
			} else {
				if (m_continuous && m_wdoor) {
					char	moji[512];
					snprintf(moji, sizeof(moji), "%%%%GAME %s *\n", wdoor_game);
					_lan_puts(moji);
					pDC = GetDC();
					teban_disp(pDC, "LAN", "GAME҂");
					ReleaseDC(pDC);
				}
			}
		}
	}

	CView::OnTimer(nIDEvent); 
}

void CCsaView::OnSaigenM1() 
{
	int		tesu_x;
	int		teban;
	char	mess[40];
	CDC		*pDC;

	if (tesu <= 0)return;

	switch(job_no)
	{
	case 0:
	case 6:
		tesu--;
		break;
	default:
		return;
	}
	pDC = GetDC();
	teban = tesu & 0x0001;
	tesu_x = tesu - 2;
	if (tesu_x < 0)
	{
	  	timer_sec[teban] = 0;
	  	timer_sec1[teban] = 0;
	}
	else
	{
		timer_sec[teban] = shohi[tesu_x];
		timer_sec1[teban] = shohi[tesu_x];
		if (tesu_x >= 2) {
			timer_sec1[teban] -= shohi[tesu_x - 2];
		}
	}

	tesu_x++;
	if (tesu_x < 0)
	{
		timer_sec[1 - teban] = 0;
		timer_sec1[1 - teban] = 0;
	}
	else
	{
		timer_sec[1 - teban] = shohi[tesu_x];
		timer_sec1[1 - teban] = shohi[tesu_x];
		if (tesu_x >= 2) {
			timer_sec1[1 - teban] = shohi[tesu_x - 2];
		}
	}
	men_make(men_h, tesu);
	k_disp(pDC, men_h, 1);		// Ֆʕ\
	man_disp(pDC, tesu, 1);
	if (kifu[tesu][0] == 0)
	{
		end_moji(mess, sizeof(mess));
		teban_disp(pDC, mess, "");
	}
	else
	{
		teban_disp(pDC, "", "");
	}
	ReleaseDC(pDC);
}

void CCsaView::OnUpdateSaigenM1(CCmdUI* pCmdUI) 
{
	if ((job_no == 0) && (tesu > 0))
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::OnSaigenM2() 
{
	switch(job_no)
	{
	case 0:
		OnSaigenM1();
		if (tesu > 0)
		{
			this->SetTimer(300, saigen_msec, NULL);
			job_no = 6;
		}
		break;
	case 6:
		OnSaigenM1();
		if (tesu == 0)
		{
			job_no = 0;
			KillTimer(300);
		}
		break;
	default:
		break;
	}
}

void CCsaView::OnUpdateSaigenM2(CCmdUI* pCmdUI) 
{
	if ((job_no == 0) && (tesu > 0))
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::OnRButtonDblClk(UINT nFlags, CPoint point) 
{
	OnRButtonDown(nFlags, point);
	
	CView::OnRButtonDblClk(nFlags, point);
}

void CCsaView::OnRButtonDown(UINT nFlags, CPoint point) 
{
	CBitmap		*pOldBitmap;
	char		mess[40];
	int			teban;
	CDC			*pDC;

	if (job_no >= 100)
	{
		teban = tesu & 1;
		if (i_man[teban] >= 0)
		{	
			if (MessageBox("Pause ComputerH", "Shogi", MB_YESNO) == IDYES)
			{
				chudan_flag = 100;
			}
		}
		else
		{
			if (MessageBox("Cut Rs232cH", "Rs232c", MB_YESNO) == IDYES)
			{
				chudan_flag = 100;
			}
		}
		return;
	}

	switch(job_no)
	{
	case 5:
		KillTimer(200);
		job_no = 0;
		return;
	case 6:
		KillTimer(300);
		job_no = 0;
		return;
	default:
		break;
	}

	if (LButtonDown)return;
	pDC = GetDC();
	if (job_no == 3)
	{
		/****************************/
		/* |bvAbvʂB */
		/****************************/
		pOldBitmap = Mem1DC->SelectObject(SaveBitmap);
		pDC->BitBlt(save_x, save_y, SZ_POPUP_X, SZ_POPUP_Y, Mem1DC, 0, 0, SRCCOPY);
		if (taikyoku_popupn(pDC, -1, mess))
		{
			MessageBox(mess, "Play");
		}
		Mem1DC->SelectObject(pOldBitmap);
	}
	SetCapture();
	ReleaseDC(pDC);
	
	CView::OnRButtonDown(nFlags, point);
}

void CCsaView::OnFileLoad() 
{
	CFileDialog	dlg_file(TRUE, "csa", kif_filename, OFN_HIDEREADONLY,
							"csa file(*.csa)|*.csa|all files(*.*)|*.*||", NULL);
	CEisei		eisei;
	char		mess[50];
	CDC			*pDC;

	if (dlg_file.DoModal() == IDOK)
	{
		kif_filename = dlg_file.GetPathName();
		if (eisei.csa_load(kifu, kif_filename, shohi, &tesu,
						mess, sman, gman,
						&end_code, initial_kyokumen, hkyokumen))
		{
			MessageBox(mess, "file load");
		}
		else
		{
			ssman[0] = ggman[0] = (char)0;
			pDC = GetDC();
			timer_sec[0] = timer_sec[1] = 0;
			timer_sec1[0] = timer_sec1[1] = 0;
			memcpy(men_h, initial_kyokumen, sizeof(men_h));
			k_disp(pDC, men_h, 1);		// Ֆʕ\
			now_tesu = -1;
			man_disp(pDC, tesu, 0);
			if (kifu[tesu][0] == 0)
			{
				end_moji(mess, sizeof(mess));
				teban_disp(pDC, mess, "");
			}
			else
			{
				teban_disp(pDC, "", "");
			}
			ReleaseDC(pDC);
		}
		AfxGetApp()->WriteProfileString("file name", "csa", kif_filename);
	}	
}

void CCsaView::OnUpdateFileLoad(CCmdUI* pCmdUI) 
{
	if (job_no == 0)
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}	
}

void CCsaView::OnFileSave() 
{
	CFileDialog	dlg_file(FALSE, "csa", kif_filename, OFN_OVERWRITEPROMPT,
							"csa file(*.csa)|*.csa|all files(*.*)|*.*||", NULL);
	char		sente[28];
	char		gote[28];
	CEisei		eisei;
	char		mess[50];

	if (dlg_file.DoModal() == IDOK)
	{
		kif_filename = dlg_file.GetPathName();

		strncpy(sente, sman, sizeof(sente));
		if (strcmp(sente, "COM1") == 0)
		{
			if (ssman[0])
			{
				strncpy(sente, ssman, sizeof(sente));
			}
		}
		else if (strcmp(sente, "COM2") == 0)
		{
			if (ssman[0])
			{
				strncpy(sente, ssman, sizeof(sente));
			}
		}
		else if (strcmp(sente, "Computer") == 0)
		{
			if (ssman[0])
			{
				strncpy(sente, ssman, sizeof(sente));
			}
		}
		else if (strcmp(sente, "LAN") == 0)
		{
			if (ssman[0])
			{
				strncpy(sente, ssman, sizeof(sente));
			}
		}

		strncpy(gote, gman, sizeof(gote));
		if (strcmp(gote, "COM1") == 0)
		{
			if (ggman[0])
			{
				strncpy(gote, ggman, sizeof(gote));
			}
		}
		else if (strcmp(gote, "COM2") == 0)
		{
			if (ggman[0])
			{
				strncpy(gote, ggman, sizeof(gote));
			}
		}
		else if (strcmp(gote, "Computer") == 0)
		{
			if (ggman[0])
			{
				strncpy(gote, ggman, sizeof(gote));
			}
		}
		else if (strcmp(gote, "LAN") == 0)
		{
			if (ggman[0])
			{
				strncpy(gote, ggman, sizeof(gote));
			}
		}

		if (eisei.csa_save(kifu, kif_filename, shohi, mess,
							sente, gote, end_code, initial_kyokumen))
		{
			MessageBox(mess, "file save");
		}
		AfxGetApp()->WriteProfileString("file name", "csa", kif_filename);
	}	
}

void CCsaView::OnUpdateFileSave(CCmdUI* pCmdUI) 
{
	switch(job_no)
	{
	case 0:
	case 2:
		pCmdUI->Enable(TRUE);
		break;
	default:
		pCmdUI->Enable(FALSE);
		break;
	}		
}

void CCsaView::OnPlayGiveUp() 
{
	int		teban;
	CDC		*pDC;

	teban = tesu & 0x0001;
	switch(i_man[1 - teban])
	{
	case -1:
	case -2:
	case -4:
	case -5:
	case -6:
		rs232c.last_out(-1, i_man[1 - teban]);
		rs232c.rs_close(i_man);
		break;
	case -3:
		if (lan_prog == 5)
		{
			lan_prog = 2;
			_lan_puts("%TORYO\n");
		}
		break;
	default:
		break;
	}

	finish_shikou();

	pDC = GetDC();
	if ((tesu & 0x0001) == 0)
	{
		end_code = END_CODE_GOTE_WIN;
	}
	else
	{
		end_code = END_CODE_SENTE_WIN;
	}
	kifu[tesu][0] = 0;
	job_no = 0;
	stop_time();
	teban_disp(pDC, "", "");
	man_disp(pDC, tesu, 1);
	ReleaseDC(pDC);
}

void CCsaView::OnUpdatePlayGiveUp(CCmdUI* pCmdUI) 
{
	if (job_no == 2)
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}	
}

void CCsaView::OnPlayPause() 
{
	int		teban;
	CDC		*pDC;

	teban = tesu & 0x0001;
	switch(i_man[1 - teban])
	{
	case -1:
	case -2:
	case -4:
	case -5:
	case -6:
		rs232c.last_out(-3, i_man[1 - teban]);
		rs232c.rs_close(i_man);
		break;
	case -3:
		if (lan_prog == 5)
		{
			lan_prog = 2;
			_lan_puts("%CHUDAN\n");
		}
		break;
	}
	finish_shikou();

	pDC = GetDC();
	end_code = END_CODE_NONE;
	kifu[tesu][0] = 0;
	job_no = 0;
	stop_time();
	teban_disp(pDC, "", "");
	man_disp(pDC, tesu, 1);
	ReleaseDC(pDC);	
}

void CCsaView::OnUpdatePlayPause(CCmdUI* pCmdUI) 
{
	if (job_no == 2)
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::OnLButtonDown(UINT nFlags, CPoint point) 
{
	CBitmap*	pOldBitmap;
	char		mess[40];
	CDC			*pDC;

	if (LButtonDown)return;
	if (job_no == 0)return;

	pDC = GetDC();
	pOldBitmap = Mem1DC->SelectObject(SaveBitmap);
	switch (job_no)
	{
	case 2:
		taikyoku_LButtonDown(pDC, point);
		break;
	case 3:
		/****************************/
		/* |bvAbvʂB */
		/****************************/
		pDC->BitBlt(save_x, save_y, SZ_POPUP_X, SZ_POPUP_Y, Mem1DC, 0, 0, SRCCOPY);
		ReleaseCapture();
		if (point.x > PS_POPUP_X + SZ_POPUP_X / 2)
		{
			if (taikyoku_popupn(pDC, 1, mess))
			{
				MessageBox(mess, "Play");
			}
		}
		else
		{
			if (taikyoku_popupn(pDC, 0, mess))
			{
			 	MessageBox(mess, "Play");
			}
		}
 		break;
	default:
		break;
	}
	if (mouse_no != 0)
	{
   		save_x = point.x - SZ_KOMA_W / 2;
		save_y = point.y - SZ_KOMA_H / 2;
		Mem1DC->BitBlt(0, 0, SZ_KOMA_W, SZ_KOMA_H, pDC, save_x, save_y, SRCCOPY);
		mouse_vram_disp(pDC);
		SetCapture();
		LButtonDown = TRUE;	
	}
	Mem1DC->SelectObject(pOldBitmap);
	ReleaseDC(pDC);

	if (job_no == 2)
	{
		Taikyoku();
	}
	
	CView::OnLButtonDown(nFlags, point);
}

void CCsaView::taikyoku_LButtonDown(CDC *pDC, CPoint point)
{
	int	teban;

	pmouse(point, &taikyoku_job_old, &taikyoku_ichi_old);
	teban = tesu & 0x0001;
	switch (taikyoku_job_old)
	{
	case 2:								/* Ֆ */
		mouse_no = taikyoku_koma_old = (int)men_h[taikyoku_ichi_old]; 
		if (teban == 0)
		{
			if (mouse_no <= 0)
			{
				mouse_no = 0;
				break;
			}
		}
		else
		{
			if (mouse_no >= 0)
			{
				mouse_no = 0;
				break;
			}
		}
		men_h[taikyoku_ichi_old] = 0;
		k_disp(pDC, men_h, 1);		// Ֆʕ\
		break;
	case 0:								/*  */
		if (teban == 1)break;
		if (men_h[82 + taikyoku_ichi_old] == 0)
		{
			mouse_no = 0;
			break;
		}
		men_h[82 + taikyoku_ichi_old]--;
		k_disp(pDC, men_h, 1);		// Ֆʕ\
		mouse_no = taikyoku_ichi_old;
		taikyoku_koma_old = taikyoku_ichi_old;
		break;
	case 1:								/*  */
		if (teban == 0)break;
		if (men_h[90 + taikyoku_ichi_old] == 0)	break;
		men_h[90 + taikyoku_ichi_old]--;
		k_disp(pDC, men_h, 1);		// Ֆʕ\
		mouse_no = -taikyoku_ichi_old;
		taikyoku_koma_old = -taikyoku_ichi_old;
		break;
	default:
		break;
	}
}

/************************/
/* }EẌʒuԂB */
/************************/
void CCsaView::pmouse(CPoint point, int* job, int* ichi)
{
	int		ix;
	int		iy;
	int		kotae;

	/* }EXʒu擾 */
	ix = point.x;
	iy = point.y + 20;
	*job = -1;

	/* ʒumF (157, 35) - (481, 395)  ix  [157, 481), iy  [35, 395) */
	if ( (PS_BOARD_ORG_X <= ix) && (ix < PS_BOARD_ORG_X + SZ_MASU_W * 9)
		 && (PS_BOARD_ORG_Y <= iy) && (iy < PS_BOARD_ORG_Y + SZ_MASU_H * 9) )
	{
		*job = 2;						// Ֆ
		ix = ((PS_BOARD_ORG_X + SZ_MASU_W * 9 - 1) - ix) / SZ_MASU_W;
		iy = (iy - PS_BOARD_ORG_Y) / SZ_MASU_H;
		kotae = iy * 9 + ix + 1;
		*ichi = kotae;
	}
	/* ʒumF (496, 235) - (632, 400)  ix  [496, 632), iy  [235, 400) */
	else if ( (PS_SKOMADAI_X1 <= ix) && (ix < PS_SKOMADAI_X2)
			 && (PS_SKOMADAI_Y1 <= iy) && (iy < PS_SKOMADAI_Y2) )
	{
		*job = 0;					// 
		if (iy >= PS_SKOMADAI_Y2 - SZ_MASU_H * 1)		// 359
		{
			*ichi = SFU;					// 
		}
		else if (iy >= PS_SKOMADAI_Y2 - SZ_MASU_H * 2)	// 319
		{
			if (ix >= PS_SKOMADAI_X1 + SZ_KOMADAI_X / 2)	// 562
			{
				*ichi = SKY;				// 
			}
			else
			{
				*ichi = SKE;				// j
			}
		}
		else if (iy >= PS_SKOMADAI_Y2 - SZ_MASU_H * 3)	// 279
		{
			if (ix >= PS_SKOMADAI_X1 + SZ_KOMADAI_X / 2)	// 562
			{
				*ichi = SGI;				// 
			}
			else
			{
				*ichi = SKI;				// 
			}
		}
		else
		{
			if (ix >= PS_SKOMADAI_X1 + SZ_KOMADAI_X / 2)	// 562
			{
				*ichi = SKA;				// p
			}
			else
			{
				*ichi = SHI;				// 
			}
		}
	}
	/* ʒumF (8, 30) - (144, 196)  ix  [8, 144), iy  [30, 196) */
	else if ( (PS_GKOMADAI_X1 <= ix) && (ix < PS_GKOMADAI_X2)
			 && (PS_GKOMADAI_Y1 <= iy) && (iy < PS_GKOMADAI_Y2) )
	{
		*job = 1;					// 
		if (iy < PS_GKOMADAI_Y1 + SZ_MASU_H * 1 + 5)	//  75
		{
			*ichi = -GFU;					// 
		}
		else if (iy < PS_GKOMADAI_Y1 + SZ_MASU_H * 2 + 5)	// 115
		{
			if (ix >= PS_GKOMADAI_X1 + SZ_KOMADAI_X / 2)	//  76
			{
				*ichi = -GKE;				// j
			}
			else
			{
				*ichi = -GKY;				// 
			}
		}
		else if (iy < PS_GKOMADAI_Y1 + SZ_MASU_H * 3 + 5)	// 155
		{
			if (ix >= PS_GKOMADAI_X1 + SZ_KOMADAI_X / 2)	//  76
			{
				*ichi = -GKI;				// 
			}
			else
			{
				*ichi = -GGI;				// 
			}
		}
		else
		{
			if (ix >= PS_GKOMADAI_X1 + SZ_KOMADAI_X / 2)	//  76
			{
				*ichi = -GHI;				// 
			}
			else
			{
				*ichi = -GKA;				// p
			}
		}
	}
}

BOOL CCsaView::taikyoku_popupn(CDC *pDC, int prog, char* mess)
{
	int		teban;

 	/********************/
	/* Ֆʂɖ߂B */
	/********************/
	men_h[taikyoku_ichi_old] = (char)taikyoku_koma_old;

	/********************************/
	/* VʒuɎĂB */
	/********************************/

	if (prog >= 0)						// Ֆ
	{
		teban = tesu & 0x0001;
		sasu(men_h, teban, taikyoku_ichi_old, taikyoku_ichi_new, prog);
	   	kifu[tesu + 1][0] = 0;
		kifu[tesu    ][1] = (char)taikyoku_ichi_old;
		kifu[tesu    ][0] = (char)(taikyoku_ichi_new + prog * 100);
		stop_time();
	  	tesu++;
		switch(i_man[1 - teban])
		{
		case -1:
		case -2:
		case -4:
		case -5:
		case -6:
			/* br`vgR[ */
			rs232c.tushin_send(men_h, tesu, kifu);
			break;
		case -3:
			_lan_send(men_h, tesu, kifu);
			break;
		default:
			break;
		}
		man_disp(pDC, tesu, 1);
	}
	k_disp(pDC, men_h, 1);		// Ֆʕ\
	job_no = 2;
	return(taikyoku_check(pDC, mess));
}

/****************************************/
/* đ΋ǉ\ǂ`FbNB */
/****************************************/
BOOL CCsaView::taikyoku_check(CDC *pDC, char* mess)
{
	int		m_moto[600];
	int		m_saki[600];
	int		m_naru[600];
	int		teban;

	if (sennitite(men_h, tesu) >= 4)
	{
		teban_disp(pDC, "", "");
		strcpy(mess, "Sennichite");
		kifu[tesu][0] = 0;
		job_no = 0;
		stop_time();
		end_code = END_CODE_SENNICHITE;
		rs232c.rs_close(i_man);
		finish_shikou();
		return(TRUE);
	}

	if (tesu >= MAX_TESU-1)					// 萔`FbN
	{
		teban_disp(pDC, "", "");
		strcpy(mess, "Game is over!");
		kifu[tesu][0] = 0;
		job_no = 0;
		stop_time();
		end_code = END_CODE_NONE;
		teban = tesu & 0x0001;
		switch(i_man[1 - teban])
		{
		case -1:
		case -2:
		case -4:
		case -5:
		case -6:
			rs232c.last_out(-3, i_man[1 - teban]);
			rs232c.rs_close(i_man);
			break;
		case -3:
			if (lan_prog == 5)
			{
				lan_prog = 2;
				_lan_puts("%CHUDAN\n");
			}
			break;
		default:
			break;
		}
		finish_shikou();
		return(TRUE);
	}

	if (total(men_h, m_moto, m_saki, m_naru, tesu, kifu, 3) == 0)
	{
		teban_disp(pDC, "", "");
		if ((tesu & 0x0001) == 0)
		{
			strcpy(mess, "Gote win.");
			end_code = END_CODE_GOTE_WIN;
		}
		else
		{
			strcpy(mess, "Sente win.");
			end_code = END_CODE_SENTE_WIN;
		}
		kifu[tesu][0] = 0;
		stop_time();
		job_no = 0;
		teban = tesu & 0x0001;
		switch(i_man[1 - teban])
		{
		case -1:
		case -2:
		case -4:
		case -5:
		case -6:
			rs232c.last_out(-1, i_man[1 - teban]);
			rs232c.rs_close(i_man);
			break;
		case -3:
			if (lan_prog == 5)
			{
				lan_prog = 2;
				_lan_puts("%TORYO\n");
			}
			break;
		default:
			break;
		}
		finish_shikou();
		return(TRUE);
	}
	return(FALSE);
}

/* 蔻f[` */
int CCsaView::sennitite(char* kyokumen, int tesu_x)
{
	int         kaisu;
	int         teban;
	char        men[100];
	int         i_moto;
	int         i_saki;
	int         i_naru;
	int         i_teban;
	int         te;

	memcpy(men, initial_kyokumen, sizeof(men));
	teban = tesu_x & 0x01;
	kaisu = 1;
	for (te = 0; te < tesu_x; te++)
	{
		i_teban = te & 0x01;
		if (i_teban == teban)
		{
			if (memcmp(kyokumen, men, 98) == 0)
			{
				kaisu++;
			}
		}
		i_moto = kifu[te][1];
		i_saki = kifu[te][0];
		if (i_saki > 100)
		{
			i_saki -= 100;
			i_naru  = 1;
		}
		else
		{
			i_naru  = 0;
		}
		sasu(men, i_teban, i_moto, i_saki, i_naru);
	}
	return(kaisu);
}

/**************/
/* ۂɎw */
/**************/
void CCsaView::sasu(char* men, int teban, int i_moto, int i_saki, int i_naru)
{
	char	koma;

	if (i_moto > 100)
	{
		if (teban  == 0)
		{
			men[i_moto - 18]--;
			men[i_saki] = i_moto - 100;
		}
		else
		{
			men[i_moto - 10]--;
			men[i_saki] = 100 - i_moto;
		}
	}
	else
	{
		koma = men[i_saki];
		if (koma > 0)
		{
			koma &= 0x07;
			men[koma + 90]++;
		}
		else if (koma < 0)
		{
			koma = (-koma) & 0x07;
			men[koma + 82]++;
		}

		if (i_naru == 0)
		{
			men[i_saki] = men[i_moto];
			switch(men[i_moto])
			{
			case (char)8:
				men[98] = i_saki;
				break;
			case (char)-8:
				men[99] = i_saki;
				break;
			default:
				break;
			}
		}
		else if (teban == 0)
		{
			men[i_saki] = men[i_moto] + 8;
		}
		else
		{
			men[i_saki] = men[i_moto] - 8;
		}

		men[i_moto] = 0;
	}
}

/**********************************/
/* w\Ȏ݂̂𐶐B */
/**********************************/
int CCsaView::total(char *men, int* m_moto, int* m_saki, int* m_naru,
		  int tesu_x, unsigned char kifu[][2], int max)
{
	int     teban;
	int     moto;
	int     saki;
	int     naru;
	int     mikata_ichi;
	int     teki_ichi;
	int     i;
	int     j;
	int     cnt;
	char    men2[100];

	teban  = tesu_x & 1;                  /* Ԑݒ */

	if (teban == 0)
	{
		/* ׂĂ̎wisj𐶐B */
		s_total(men, &men[82], &cnt, m_moto, m_saki, m_naru);

		teki_ichi = men[99];
		j = 0;
		for (i = 0; i < cnt; i++)
		{
			moto = m_moto[i];
			saki = m_saki[i];
			if (moto > 100)
			{
				naru = 0;
			}
			else
			{
				naru = m_naru[i];
			}

			/* Gʎ擾 */
			if (men[saki] == (char)-8)
			{
				m_moto[j  ] = moto;
				m_saki[j  ] = saki;
				m_naru[j++] = naru;
				continue;
			}

			/* ŕl`FbN */
			if (moto == 101)
			{
				if (uchifu(men, teban, saki) != 0)continue;
			}

			/* ǖʐ}쐬 */
			memcpy(men2, men, sizeof(men2));
			sasu(men2, teban, moto, saki, naru);

			/* `FbN */
			mikata_ichi = men2[98];
			if (g_kiki(men2, mikata_ichi) != 0)continue;

			/* `FbN */
			if (s_kiki(men2, teki_ichi) != 0)
			{
				if (senten(men2, tesu_x, kifu, max) == -20000)continue;
			}

			/* i */
			m_moto[j  ] = moto;
			m_saki[j  ] = saki;
			m_naru[j++] = naru;
		}
	}
	else
	{
		/* w萶 */
		g_total(men, &men[90], &cnt, m_moto, m_saki, m_naru);

		teki_ichi = men[98];
		j = 0;
		for (i = 0; i < cnt; i++)
		{
			moto = m_moto[i];
			saki = m_saki[i];
			if (moto > 100)
			{
				naru = 0;
			}
			else
			{
				naru = m_naru[i];
			}

			/* Gʎ擾 */
			if (men[saki] == (char)8)
			{
				m_moto[j  ] = moto;
				m_saki[j  ] = saki;
				m_naru[j++] = naru;
				continue;
			}

			/* ŕl`FbN */
			if (moto == 101)
			{
				if (uchifu(men, teban, saki) != 0)continue;
			}

			/* ǖʐ}쐬 */
			memcpy(men2, men, sizeof(men2));
			sasu(men2, teban, moto, saki, naru);

			/* `FbN */
			mikata_ichi = men2[99];
			if (s_kiki(men2, mikata_ichi) != 0) continue;

			/* `FbN */
			if (g_kiki(men2, teki_ichi) != 0)
			{
				if (senten(men2, tesu_x, kifu, max) == -20000) continue;
			}

			/* i */
			m_moto[j  ] = moto;
			m_saki[j  ] = saki;
			m_naru[j++] = naru;
		}
	}
	return(j);
}

int CCsaView::uchifu(char* men, int teban, int saki)
{
	int     gyoku_pnt;
	int     cnt;
	int     i;
	int     ix;
	int     kekka;
	char    koma_old;
	int     m_moto[20];
	int     m_naru[20];
	int     moto;

	/*  */
	if (teban == 0)
	{
		gyoku_pnt = saki - 9;
		if (men[gyoku_pnt] != (char)-8)return(0); /* łȂI */
		moto = 0;
		/* 茟 */
		cnt = gictotal(men, saki, m_moto, m_naru);
		for (i = 0; i < cnt; i++)
		{
			if (moto == m_moto[i])continue;
			moto      = m_moto[i];
			koma_old  = men[moto];
			men[moto] = 0;
			if (gyoku_pnt == moto)
			{
				kekka     = s_kiki(men, saki);
			}
			else
			{
				men[saki] = (char)-1;
				kekka     = s_kiki(men, gyoku_pnt);
				men[saki] = (char)0;
			}
			men[moto] = koma_old;
			if (kekka == 0)return(0);
		}
		/* ʈړł̎󂯂lB */
		ix = amari[gyoku_pnt];
		men[gyoku_pnt] = (char)0;
		men[saki]      = (char)1;

		if (ix != 0)
		{
			if (men[gyoku_pnt + 8] >= 0)
			{
				if (s_kiki(men, gyoku_pnt + 8) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)-8;
					return(0);
				}
			}
			if (men[gyoku_pnt - 1] >= 0)
			{
				if (s_kiki(men, gyoku_pnt - 1) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)-8;
					return(0);
				}
			}
			if (gyoku_pnt >= 10)
			{
				if (men[gyoku_pnt - 10] >= 0)
				{
					if (s_kiki(men, gyoku_pnt - 10) == 0)
					{
						men[saki]      = (char)0;
						men[gyoku_pnt] = (char)-8;
						return(0);
					}
				}
			}
		}

		if (ix != 8)
		{
			if (men[gyoku_pnt + 10] >= 0)
			{
				if (s_kiki(men, gyoku_pnt + 10) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)-8;
					return(0);
				}
			}
			if (men[gyoku_pnt + 1] >= 0)
			{
				if (s_kiki(men, gyoku_pnt + 1) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)-8;
					return(0);
				}
			}
			if (gyoku_pnt >= 10)
			{
				if (men[gyoku_pnt - 8] >= 0)
				{
					if (s_kiki(men, gyoku_pnt - 8) == 0)
					{
						men[saki]      = (char)0;
						men[gyoku_pnt] = (char)-8;
						return(0);
					}
				}
			}
		}

		if (gyoku_pnt >= 10)
		{
			if (men[gyoku_pnt - 9] >= 0)
			{
				if (s_kiki(men, gyoku_pnt - 9) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)-8;
					return(0);
				}
			}
		}
		men[saki]      = (char)0;
		men[gyoku_pnt] = (char)-8;
	}
	/*  */
	else
	{
		gyoku_pnt = saki + 9;
		if (men[gyoku_pnt] != (char)8)return(0); /* łȂI */
		moto = 0;
		/* 茟 */
		cnt = sictotal(men, saki, m_moto, m_naru);
		for (i = 0; i < cnt; i++)
		{
			if (moto == m_moto[i])continue;
			moto      = m_moto[i];
			koma_old  = men[moto];
			men[moto] = 0;
			if (gyoku_pnt == moto)
			{
				kekka     = g_kiki(men, saki);
			}
			else
			{
				men[saki] = (char)1;
				kekka     = g_kiki(men, gyoku_pnt);
				men[saki] = (char)0;
			}
			men[moto] = koma_old;
			if (kekka == 0)return(0);
		}
		/* ʈړł̎󂯂lB */
		ix = amari[gyoku_pnt];
		men[gyoku_pnt] = (char)0;
		men[saki]      = (char)-1;

		if (ix != 0)
		{
			if (men[gyoku_pnt - 10] <= 0)
			{
				if (g_kiki(men, gyoku_pnt - 10) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)8;
					return(0);
				}
			}
			if (men[gyoku_pnt - 1] <= 0)
			{
				if (g_kiki(men, gyoku_pnt - 1) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)8;
					return(0);
				}
			}
			if (gyoku_pnt <= 72)
			{
				if (men[gyoku_pnt + 8] <= 0)
				{
					if (g_kiki(men, gyoku_pnt + 8) == 0)
					{
						men[saki]      = (char)0;
						men[gyoku_pnt] = (char)8;
						return(0);
					}
				}
			}
		}

		if (ix != 8)
		{
			if (men[gyoku_pnt - 8] <= 0)
			{
				if (g_kiki(men, gyoku_pnt - 8) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)8;
					return(0);
				}
			}
			if (men[gyoku_pnt + 1] <= 0)
			{
				if (g_kiki(men, gyoku_pnt + 1) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)8;
					return(0);
				}
			}
			if (gyoku_pnt <= 72)
			{
				if (men[gyoku_pnt + 10] <= 0)
				{
					if (g_kiki(men, gyoku_pnt + 10) == 0)
					{
						men[saki]      = (char)0;
						men[gyoku_pnt] = (char)8;
						return(0);
					}
				}
			}
		}

		if (gyoku_pnt <= 72)
		{
			if (men[gyoku_pnt + 9] <= 0)
			{
				if (g_kiki(men, gyoku_pnt + 9) == 0)
				{
					men[saki]      = (char)0;
					men[gyoku_pnt] = (char)8;
					return(0);
				}
			}
		}
		men[saki]      = (char)0;
		men[gyoku_pnt] = (char)8;
	}
	return(-1);
}

/********************/
/* ǖʌ_ */
/********************/
int CCsaView::senten(char* men2, int tesu_x, unsigned char kifu[][2], int max)
{
	int         i;
	int         is;
	int         ie;
	int         teban;
	int         ten;
	int         kaisu;
	int         flag;
	int         te_start;
	int         te;
	int         moto;
	int         saki;
	int         naru;
	int         koma;
	int         koma_old;
	int         o_point;
	char        men[100];

	teban = tesu_x & 0x0001;
	/******************/
	/* ǖʃRs[ */
	/******************/
	memcpy(men, initial_kyokumen, sizeof(men));

	ten = kaisu = 0;
	for (te = 0; te < tesu_x; te++)
	{
		/* Ԃ𒲂ׂB */
		if ((te & 0x0001) != teban)
		{
			if (memcmp(men, men2, 82) == 0)
			/********************/
			/* Տ㓯ǖʔ */
			/********************/
			{
				if (teban == 0)
				{
					is = 89;
					ie = 83;
				}
				else
				{
					is = 97;
					ie = 91;
				}
				flag = 0;
				for (i = is; i >= ie; i--)
				{
					if (men2[i] > men[i])
					{
						flag = 1;
						break;
					}
					if (men2[i] < men[i])flag--;
				}
				if (flag <= 0)
				{
					if (ten == 0)
					{
						ten = -2;
					}
					else
					{
						ten -= 12;
					}
				}
				if (flag == 0)          /* Sǖ */
				{
					if (kaisu == 0)te_start = te - 1;
					kaisu++;
				}
			}
		}
		/* w擾 */
		moto = kifu[te][1];
		saki = kifu[te][0];
		if (moto < 100)
		{
			koma_old  = men[moto];
			men[moto] = 0;
			if (saki >= 100)
			{
				naru  = 1;
				saki -= 100;
			}
			else
			{
				naru  = 0;
			}
			koma = men[saki];
			if (koma < 0)
			{
				men[82 + ((-koma) & 0x0007)]++;
			}
			else if (koma > 0)
			{
				men[90 + (koma & 0x0007)]++;
			}
			if (naru == 0)
			{
				men[saki] = koma_old;
			}
			else if (koma_old > 0)
			{
				men[saki] = koma_old + 8;
			}
			else
			{
				men[saki] = koma_old - 8;
			}
		}
		else
		{
			if ((te & 0x0001) == 0)
			{
				men[saki] = moto - 100;
				men[moto - 18]--;
			}
			else
			{
				men[saki] = 100 - moto;
				men[moto - 10]--;
			}
		}
	}

	if (kaisu == 0)return(0);

	/**************************************/
	/* A̐肩ǂfB */
	/**************************************/
	memcpy(men, men2, sizeof(men));

	if (teban == 0)
	{
		o_point = men2[99];
	}
	else
	{
		o_point = men2[98];
	}

	for (te = te_start; te < tesu_x; )
	{
		/* 肩ǂׂB */
		if (teban == 0)
		{
			if (s_kiki(men, o_point) == 0)return(ten);
		}
		else
		{
			if (g_kiki(men, o_point) == 0)return(ten);
		}

		ten--;
		/* 󂯑̋𓮂B         */
		te++;
		moto = kifu[te][1];
		saki = kifu[te][0];
		if (moto < 100)
		{
			if (saki >= 100)saki -= 100;/* 󂯑Ȃ̂ŁAtO𖳎 */
			men[saki] = koma = men[moto];
			men[moto] = 0;
			if (koma == -8)
			{
				o_point = saki;
			}
			else if (koma == 8)
			{
				o_point = saki;
			}
		}
		else if (teban == 0)
		{
			men[saki] = -1;
		}
		else
		{
			men[saki] = 1;
		}
		/* Uߑ̋𓮂B */
		te++;
		moto = kifu[te][1];
		saki = kifu[te][0];
		if (moto < 100)
		{
			if (saki < 100)
			{
				men[saki] = men[moto];
			}
			else if (teban == 0)
			{
				men[saki - 100] = men[moto] + 8;	// 1999/01/15 WHiwEoO
			}
			else
			{
				men[saki - 100] = men[moto] - 8;	// 1999/01/15 WHiwEoO
			}
			men[moto] = (char)0;					// 1999/01/15 WHiwEoO
		}
		else if (teban == 0)
		{
			men[saki] = moto - 100;
		}
		else
		{
			men[saki] = 100 - moto;
		}
	}
	if (kaisu >= max)return(-20000);
	return(ten);
}

void CCsaView::mouse_vram_disp(CDC *pDC)
{
	CBitmap	Bitmapkoma;
	CBitmap	Bitmapmask;
	CDC		MemDC;

	switch (mouse_no)
	{
	case EMP:
		return;
	case SFU:
		Bitmapkoma.LoadBitmap(IDB_SFU);
		Bitmapmask.LoadBitmap(IDB_SFUM);
		break;
	case SKY:
		Bitmapkoma.LoadBitmap(IDB_SKYO);
		Bitmapmask.LoadBitmap(IDB_SKYOM);
		break;
	case SKE:
		Bitmapkoma.LoadBitmap(IDB_SKEI);
		Bitmapmask.LoadBitmap(IDB_SKEIM);
		break;
	case SGI:
		Bitmapkoma.LoadBitmap(IDB_SGIN);
		Bitmapmask.LoadBitmap(IDB_SGINM);
		break;
	case SKI:
		Bitmapkoma.LoadBitmap(IDB_SKIN);
		Bitmapmask.LoadBitmap(IDB_SKINM);
		break;
	case SKA:
		Bitmapkoma.LoadBitmap(IDB_SKAKU);
		Bitmapmask.LoadBitmap(IDB_SKAKUM);
		break;
	case SHI:
		Bitmapkoma.LoadBitmap(IDB_SHI);
		Bitmapmask.LoadBitmap(IDB_SHIM);
		break;
	case SOU:
		Bitmapkoma.LoadBitmap(IDB_SOU);
		Bitmapmask.LoadBitmap(IDB_SOUM);
		break;
	case STO:
		Bitmapkoma.LoadBitmap(IDB_STO);
		Bitmapmask.LoadBitmap(IDB_SFUM);
		break;
	case SNY:
		Bitmapkoma.LoadBitmap(IDB_SNKYO);
		Bitmapmask.LoadBitmap(IDB_SKYOM);
		break;
	case SNK:
		Bitmapkoma.LoadBitmap(IDB_SNKEI);
		Bitmapmask.LoadBitmap(IDB_SKEIM);
		break;
	case SNG:
		Bitmapkoma.LoadBitmap(IDB_SNGIN);
		Bitmapmask.LoadBitmap(IDB_SGINM);
		break;
	case SUM:
		Bitmapkoma.LoadBitmap(IDB_SUMA);
		Bitmapmask.LoadBitmap(IDB_SKAKUM);
		break;
	case SRY:
		Bitmapkoma.LoadBitmap(IDB_SRYU);
		Bitmapmask.LoadBitmap(IDB_SHIM);
		break;
	case GFU:
		Bitmapkoma.LoadBitmap(IDB_GFU);
		Bitmapmask.LoadBitmap(IDB_GFUM);
		break;
	case GKY:
		Bitmapkoma.LoadBitmap(IDB_GKYO);
		Bitmapmask.LoadBitmap(IDB_GKYOM);
		break;
	case GKE:
		Bitmapkoma.LoadBitmap(IDB_GKEI);
		Bitmapmask.LoadBitmap(IDB_GKEIM);
		break;
	case GGI:
		Bitmapkoma.LoadBitmap(IDB_GGIN);
		Bitmapmask.LoadBitmap(IDB_GGINM);
		break;
	case GKI:
		Bitmapkoma.LoadBitmap(IDB_GKIN);
		Bitmapmask.LoadBitmap(IDB_GKINM);
		break;
	case GKA:
		Bitmapkoma.LoadBitmap(IDB_GKAKU);
		Bitmapmask.LoadBitmap(IDB_GKAKUM);
		break;
	case GHI:
		Bitmapkoma.LoadBitmap(IDB_GHI);
		Bitmapmask.LoadBitmap(IDB_GHIM);
		break;
	case GOU:
		Bitmapkoma.LoadBitmap(IDB_GOU);
		Bitmapmask.LoadBitmap(IDB_GOUM);
		break;
	case GTO:
		Bitmapkoma.LoadBitmap(IDB_GTO);
		Bitmapmask.LoadBitmap(IDB_GFUM);
		break;
	case GNY:
		Bitmapkoma.LoadBitmap(IDB_GNKYO);
		Bitmapmask.LoadBitmap(IDB_GKYOM);
		break;
	case GNK:
		Bitmapkoma.LoadBitmap(IDB_GNKEI);
		Bitmapmask.LoadBitmap(IDB_GKEIM);
		break;
	case GNG:
		Bitmapkoma.LoadBitmap(IDB_GNGIN);
		Bitmapmask.LoadBitmap(IDB_GGINM);
		break;
	case GUM:
		Bitmapkoma.LoadBitmap(IDB_GUMA);
		Bitmapmask.LoadBitmap(IDB_GKAKUM);
		break;
	case GRY:
		Bitmapkoma.LoadBitmap(IDB_GRYU);
		Bitmapmask.LoadBitmap(IDB_GHIM);
		break;
 	default:
		break;
	}
	MemDC.CreateCompatibleDC(pDC);
	MemDC.SelectObject(&Bitmapmask);
	pDC->BitBlt(save_x, save_y, SZ_KOMA_W, SZ_KOMA_H, &MemDC, 0, 0, SRCAND);		// }XNf[^Ŕ
	MemDC.SelectObject(&Bitmapkoma);
	pDC->BitBlt(save_x, save_y, SZ_KOMA_W, SZ_KOMA_H, &MemDC, 0, 0, SRCPAINT);		// OR `
}

void CCsaView::OnMouseMove(UINT nFlags, CPoint point) 
{
	CBitmap*	pOldBitmap;
	CPoint		point_old;
	CDC			*pDC;
	
	pDC = GetDC();
	if (job_no == 3)					// |bvAbv
	{
		point_old = point;
		if(point.x < PS_POPUP_X) point.x = PS_POPUP_X;
		if(point.x > PS_POPUP_X + SZ_POPUP_X - 2) point.x = PS_POPUP_X + SZ_POPUP_X;
		if(point.y < PS_POPUP_Y) point.y = PS_POPUP_Y;
		if(point.y > PS_POPUP_Y + SZ_POPUP_Y - 2) point.y = PS_POPUP_Y + SZ_POPUP_Y - 2;
		if (point_old != point)
		{
			ClientToScreen(&point);
			SetCursorPos(point.x, point.y);
		}
	}
	else if (LButtonDown)
	{
		pOldBitmap = Mem1DC->SelectObject(SaveBitmap);
		pDC->BitBlt(save_x, save_y, SZ_KOMA_W, SZ_KOMA_H, Mem1DC, 0, 0, SRCCOPY);
		save_x = point.x - (SZ_KOMA_W / 2);
		save_y = point.y - (SZ_KOMA_H / 2); 
		Mem1DC->BitBlt(0, 0, SZ_KOMA_W, SZ_KOMA_H, pDC, save_x, save_y, SRCCOPY);
		mouse_vram_disp(pDC);
		Mem1DC->SelectObject(pOldBitmap);
	}
	ReleaseDC(pDC);
	
	CView::OnMouseMove(nFlags, point);
}

void CCsaView::OnLButtonUp(UINT nFlags, CPoint point) 
{
	CBitmap*	pOldBitmap;
	char		mess[40];
	CDC			*pDC;

	pDC = GetDC();
	if (LButtonDown)
	{
		pOldBitmap = Mem1DC->SelectObject(SaveBitmap);
		pDC->BitBlt(save_x, save_y, SZ_KOMA_W, SZ_KOMA_H, Mem1DC, 0, 0, SRCCOPY);
		if (job_no == 2)
		{	// ΋ǃ[h
			if(taikyoku_LButtonUp(pDC, point, mess, Mem1DC))
			{
				MessageBox(mess, "shogi");
			}
			if (job_no == 3)
			{
				point.x = 343;
				point.y = 196;
				ClientToScreen(&point);
				SetCursorPos(point.x, point.y);
			}
		}
//		if (mouse_no != 0)::SetCursor(::LoadCursor(NULL, IDC_ARROW));
		mouse_no = 0;
		if(job_no != 3)ReleaseCapture();
		Mem1DC->SelectObject(pOldBitmap);
	}
	ReleaseDC(pDC);
	LButtonDown = FALSE;
	if (job_no == 2)
	{
		Taikyoku();
	}
	
	CView::OnLButtonUp(nFlags, point);
}

BOOL CCsaView::taikyoku_LButtonUp(CDC *pDC, CPoint point, char *mess, CDC* Mem1DC)
{
	int		job;
	int		ip;
	int		ichi_old;
	int		cnt;
	int		i;
	int		j;
	int		teban;
	int		m_moto[600];
	int		m_saki[600];
	int		m_naru[600];

	if (mouse_no == 0)return(FALSE);

	teban = tesu & 0x0001;

	pmouse(point, &job, &ip);

	/********************/
	/* Ֆʂɖ߂B */
	/********************/

	switch (taikyoku_job_old)
	{
	case 2:								// Ֆ
		men_h[taikyoku_ichi_old] = (char)taikyoku_koma_old;
		break;
	case 0:								// 
		men_h[82 + taikyoku_ichi_old]++;
		break;
	case 1:								// 
		men_h[90 + taikyoku_ichi_old]++;
		break;
	default:
		break;
	}

	/********************************/
	/* VʒuɎĂB */
	/********************************/

	if (job == 2)						// Ֆ
	{
		if (taikyoku_job_old == 2)		// Ֆ
		{
			ichi_old = taikyoku_ichi_old;
		}
		else							// 
		{
			ichi_old = taikyoku_ichi_old + 100;
		}

		cnt = total(men_h, m_moto, m_saki, m_naru, tesu, kifu, 3);

		j = 0;
		for (i = 0; i < cnt; i++)
		{
			if (m_moto[i] != ichi_old)continue;
			if (m_saki[i] != ip)  continue;
			m_moto[j]   = ichi_old;
			m_saki[j]   = ip;
			m_naru[j++] = m_naru[i];
		}
		cnt = j;
		switch(cnt)
		{
		case 0:
			break;
		case 2:
			men_h[taikyoku_ichi_old] = (char)0;
			// |bvAbvʒủ摜Z[u
			save_x = PS_POPUP_X;
			save_y = PS_POPUP_Y;
			Mem1DC->BitBlt(0, 0, SZ_POPUP_X, SZ_POPUP_Y, pDC, save_x, save_y, SRCCOPY);
			// |bvAbvʂ̕\
			vpaint(pDC, PS_POPUP_X,                  PS_POPUP_Y+20,                  PS_POPUP_X + SZ_POPUP_X - 1, PS_POPUP_Y+20 + SZ_POPUP_Y - 2);
			vline(pDC,  PS_POPUP_X + SZ_POPUP_X - 1, PS_POPUP_Y+20,                  PS_POPUP_X + SZ_POPUP_X - 1, PS_POPUP_Y+20 + SZ_POPUP_Y - 1, 1);	// |bvAbv̉EɃC
			vline(pDC,  PS_POPUP_X,                  PS_POPUP_Y+20 + SZ_POPUP_Y - 1, PS_POPUP_X + SZ_POPUP_X - 1, PS_POPUP_Y+20 + SZ_POPUP_Y - 1, 1);	// |bvAbv̉ɃC
			if (mouse_no > 0)
			{
				vkoma(pDC, 1, 0,  mouse_no  , PS_POPUP_KOMA1_X, PS_POPUP_Y + 30);	// 286
				vkoma(pDC, 1, 0,  mouse_no+8, PS_POPUP_KOMA2_X, PS_POPUP_Y + 30);	// 327
			}
			else
			{
				vkoma(pDC, 1, 1, -mouse_no  , PS_POPUP_KOMA1_X, PS_POPUP_Y + 30);	// 286
				vkoma(pDC, 1, 1, -mouse_no+8, PS_POPUP_KOMA2_X, PS_POPUP_Y + 30);	// 327
			}
			taikyoku_ichi_new = ip;
			job_no = 3;
			k_disp(pDC, men_h, 1);		// Ֆʕ\
			return(FALSE);
		default:
			sasu(men_h, teban, m_moto[0], m_saki[0], m_naru[0]);
			kifu[tesu][1] = m_moto[0];
			kifu[tesu][0] = m_saki[0] + m_naru[0] * 100;
			stop_time();
			tesu++;
			kifu[tesu][0] = 0;
			switch(i_man[1 - teban])
			{
			case -1:
			case -2:
			case -4:
			case -5:
			case -6:
				/* br`vgR[ */
				rs232c.tushin_send(men_h, tesu, kifu);
				break;
			case -3:
				_lan_send(men_h, tesu, kifu);
				break;
			default:
				break;
			}
			man_disp(pDC, tesu, 1);
			break;
		}
	}
	k_disp(pDC, men_h, 1);		// Ֆʕ\
	return(taikyoku_check(pDC, mess));
}

void CCsaView::_lan_send(char* men, int tesu, unsigned char kifu[][2])
{
	char        moji[12];
	int         i_moto;
	int         i_saki;
	int         koma;

	tesu--;
	if ((tesu & 0x01) == 0)
	{
		moji[0] = '+';
	}
	else
	{
		moji[0] = '-';
	}
	i_moto = kifu[tesu][1];
	if (i_moto > 100)
	{
		moji[1] = moji[2] = '0';
	}
	else
	{
		sprintf(&moji[1], "%d%d", (i_moto - 1) % 9 + 1,
							      (i_moto - 1) / 9 + 1);
	}
	i_saki = kifu[tesu][0];
	if (i_saki > 100) i_saki -= 100;
	sprintf(&moji[3], "%d%d", (i_saki - 1) % 9 + 1,
						      (i_saki - 1) / 9 + 1);
	koma = men[i_saki];
	if (koma < 0)koma = -koma;
	sprintf(&moji[5], "%s\n", koma_kind[koma - 1]);
	_lan_puts(moji);
}

void CCsaView::Taikyoku()
{
	int		teban;
	int		kotae;
	int		i_moto;
	int		i_saki;
	int		i_naru;
	int		cnt;
	int		i;
	char	men[100];
	char	mess[100];
	char	rbuf[20];
	int		m_moto[600];
	int		m_saki[600];
	int		m_naru[600];
	CDC		*pDC;

	chudan_flag = 0;
	while(1)
	{
		pDC = GetDC();
		teban = tesu & 0x0001;
		if (i_man[teban] == 0)
		{
			// lԂ̎
			job_no = 2;
			teban_disp(pDC, "͑҂", "");
			ReleaseDC(pDC);
			break;
		}
		else if (i_man[teban] > 0)
		{
			// Rs[^̎
			job_no = 102;
			teban_disp(pDC, "l", "");
			ReleaseDC(pDC);
			memset(m_moto, 0, sizeof(m_moto));
			memset(m_saki, 0, sizeof(m_saki));
			memset(m_naru, 0, sizeof(m_naru));
			kotae = gCsaDll.sikou(tesu, kifu, timer_sec, m_moto, m_saki, m_naru);
			// TEST
			gEvalution += 15;
			if (kotae > 100000) {
				gEvalution = kotae - 200000;
				if (teban != 0) {
					// Ԃ̂Ƃ͔]
					gEvalution = -gEvalution;
				}
			}
			if(chudan_flag == -100)
			{
				rs232c.rs_close(i_man);
				finish_shikou();
				job_no = 0;
				return;
			}
			else if (chudan_flag > 0)
			{
				pDC = GetDC();
				switch(i_man[1 - teban])
				{
				case -1:
				case -2:
				case -4:
				case -5:
				case -6:
					rs232c.last_out(-3, i_man[1 - teban]);
					teban_disp(pDC, "Output break", "");
					break;
				case -3:
					if (lan_prog == 5)
					{
						lan_prog = 2;
						_lan_puts("%CHUDAN\n");
					}
					teban_disp(pDC, "Output break", "");
					break;
				default:
					teban_disp(pDC, "", "");
					break;
				}
				ReleaseDC(pDC);
				job_no = 0;
			}
			if (chudan_flag == 0)
			{
				job_no = 2;
			}
			else
			{
				rs232c.rs_close(i_man);
				finish_shikou();
				return;
			}
			// v~߂B
			stop_time();

			if (kotae > 0 || kotae < -5)
			{
				if (kotae < -5) {
					::MessageBox(NULL, "]l", "Error!", MB_OK);
				}
				// O ||| m_moto, m_saki, m_naru Ɏw肪ĂB
				sasu(men_h, teban, m_moto[0], m_saki[0], m_naru[0]);
	   			kifu[tesu + 1][0] = 0;
				kifu[tesu    ][1] = m_moto[0];
				if (m_moto[0] > 100)
				{
					kifu[tesu][0] = m_saki[0];
				}
				else
				{
					kifu[tesu][0] = m_saki[0] + m_naru[0] * 100;
				}
				tesu++;

				memcpy(men, men_h, sizeof(men));
				switch(i_man[1 - teban])
				{
				case -1:
				case -2:
				case -4:
				case -5:
				case -6:
					rs232c.tushin_send(men, tesu, kifu);
					break;
				case -3:
					_lan_send(men, tesu, kifu);
					break;
				default:
					break;
				}
				pDC = GetDC();
				man_disp(pDC, tesu, 1);
				k_disp(pDC, men_h, 1);		// Ֆʕ\
				ReleaseDC(pDC);
			}
			else if (kotae == 0)
			{
				// O ||| 
				kifu[tesu][0] = 0;
				pDC = GetDC();
				if (teban == 0)
				{
					gEvalution = -30000;
					end_code = END_CODE_GOTE_WIN;
					teban_disp(pDC, "菟", "");
					switch(i_man[1])
					{
					case -1:
					case -2:
					case -4:
					case -5:
					case -6:
						rs232c.last_out(-1, i_man[1]);
						break;
					case -3:
						if (lan_prog == 5)
						{
							lan_prog = 2;
							_lan_puts("%TORYO\n");
						}
						break;
					default:
						break;
					}
				}
				else
				{
					gEvalution = +30000;
					end_code = END_CODE_SENTE_WIN;
					teban_disp(pDC, "菟", "");
					switch(i_man[0])
					{
					case -1:
					case -2:
					case -4:
					case -5:
					case -6:
						rs232c.last_out(-1, i_man[0]);
						break;
					case -3:
						if (lan_prog == 5)
						{
							lan_prog = 2;
							_lan_puts("%TORYO\n");
						}
						break;
					default:
						break;
					}
				}
				man_disp(pDC, tesu, 1);
				ReleaseDC(pDC);
				PlaySound(SE_LOSE, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
				job_no = 0;
				if (m_continuous == FALSE) {
					MessageBox("Give up.", "Computer");
				}
				rs232c.rs_close(i_man);
				finish_shikou();
				break;
			}
			else if (kotae == -5)
			{
				// |T ||| 錾sBiXWN[j
				kifu[tesu][0] = 0;
				pDC = GetDC();
				if (teban == 0)
				{
					teban_disp(pDC, "菟錾!", "");
				}
				else
				{
					teban_disp(pDC, "菟錾!", "");
				}
				end_code = END_CODE_NONE;
				switch(i_man[1 - teban])
				{
				case -1:
				case -2:
				case -4:
				case -5:
				case -6:
					rs232c.last_out(-5, i_man[1 - teban]);
					break;
				case -3:
					if (lan_prog == 5)
					{
						lan_prog = 2;
						_lan_puts("%KACHI\n");
					}
					break;
				default:
					break;
				}
				ReleaseDC(pDC);
				job_no = 0;
				if (m_continuous == FALSE) {
					MessageBox("Computer win!", "shogi");
				}
				rs232c.rs_close(i_man);
				finish_shikou();
				break;
			}
			else if (kotae == -4)
			{
				// |S ||| 錾sBiXWN[j
				kifu[tesu][0] = 0;
				pDC = GetDC();
				teban_disp(pDC, "!", "");
				end_code = END_CODE_NONE;
				switch(i_man[i - teban])
				{
				case -1:
				case -2:
				case -4:
				case -5:
				case -6:
					rs232c.last_out(-4, i_man[1 - teban]);
					break;
				case -3:
					if (lan_prog == 5)
					{
						lan_prog = 2;
						_lan_puts("%HIKIWAKE\n");
					}
					break;
				default:
					break;
				}
				ReleaseDC(pDC);
				job_no = 0;
				if (m_continuous == FALSE) {
					MessageBox("Computer said Even!", "Shogi");
				}
				rs232c.rs_close(i_man);
				finish_shikou();
				break;
			}
		}
		else if (i_man[teban] == -3)
		{
			teban_disp(pDC, "LANM҂", "");
			ReleaseDC(pDC);
			job_no = 102;
			return;
		}
		else
		{
			teban_disp(pDC, "RS232CM҂", "");
			ReleaseDC(pDC);
			job_no = 102;
			while(1)
			{
				dispatch();
				if(rs_get_status())break;
				if (chudan_flag == -100)
				{
					rs232c.rs_close(i_man);
					finish_shikou();
					job_no = 0;
					return;
				}
				if (chudan_flag != 0)break;
			}
			/* br`vgR[ */
			kotae = rs232c.tushin(men_h, teban, m_moto, m_saki, m_naru, rbuf);
			if (kotae == -1)            /*  */
			{
				kifu[tesu][0] = 0;
				stop_time();
				pDC = GetDC();
				if (teban == 0)
				{
					end_code = END_CODE_GOTE_WIN;
					teban_disp(pDC, "菟!", "");
				}
				else
				{
					end_code = END_CODE_SENTE_WIN;
					teban_disp(pDC, "菟!", "");
				}
				ReleaseDC(pDC);
				PlaySound(SE_WIN, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
				job_no = 0;
				if (m_continuous == FALSE) {
					MessageBox("Win!", "Shogi");
				}
				rs232c.rs_close(i_man);
				finish_shikou();
				return;
			}
			else if (kotae == -2)       /* ҂ */
			{
				if (tesu >= 2)
				{
					tesu -= 2;
					kifu[tesu][0] = 0;
					pDC = GetDC();
					men_make(men_h, tesu);
					k_disp(pDC, men_h, 1);		// Ֆʕ\
					timer_sec[teban] = shohi[tesu];
					timer_sec1[teban] = shohi[tesu];
					if (tesu >= 1)
					{
						timer_sec[1 - teban] = shohi[tesu - 1];
						timer_sec1[1 - teban] = shohi[tesu - 1];
						if (tesu >= 2) {
							timer_sec1[teban] -= shohi[tesu - 2];
						}
						if (tesu >= 3) {
							timer_sec1[1 - teban] -= shohi[tesu - 3];
						}
					}
					else
					{
///						timer_sec[1 - teban] = shohi[tesu - 1];
					}
					man_disp(pDC, tesu, 1);
					ReleaseDC(pDC);
					start_time();
				}
			}
			else if (kotae == -3)       /* f */
			{
				job_no = 0;
				end_code = END_CODE_NONE;
				kifu[tesu][0] = 0;
				stop_time();
				if (chudan_flag == 0)
				{
					pDC = GetDC();
					if (rbuf[0] == 0)
					{
						teban_disp(pDC, "Recieve Break", "");
					}
					else
					{
						teban_disp(pDC, "Recieve invalid", rbuf);
					}
					ReleaseDC(pDC);
					if (m_continuous == FALSE) {
						MessageBox("Pause Shogi!", "Rs232c");
					}
					pDC = GetDC();
					teban_disp(pDC, "", "");
					ReleaseDC(pDC);
				}
				else if (chudan_flag > 0)
				{
					switch(i_man[1 - teban])
					{
					case -1:
					case -2:
					case -4:
					case -5:
					case -6:
						rs232c.last_out(-3, i_man[1 - teban]);
						break;
					case -3:
						if (lan_prog == 5)
						{
							lan_prog = 2;
							_lan_puts("%CHUDAN\n");
						}
						break;
					default:
						break;
					}
					pDC = GetDC();
					teban_disp(pDC, "Send Break", "");
					ReleaseDC(pDC);
				}
				rs232c.rs_close(i_man);
				finish_shikou();
				return;
			}

			i_moto = m_moto[kotae];
			i_saki = m_saki[kotae];
			if (i_moto > 100)
			{
				i_naru = 0;
			}
			else
			{
				i_naru = m_naru[kotae];
			}

			cnt = total(men_h, m_moto, m_saki, m_naru, tesu, kifu, 3);
			for (i = 0; i < cnt; i++)
			{
				if (i_moto != m_moto[i])continue;
				if (i_saki != m_saki[i])continue;
				if (i_moto > 100)
				{
					if (i_naru != m_naru[i])continue;
				}
				kotae = -1;
				break;
			}

			if (kotae < 0)
			{
				stop_time();
				kifu[tesu][1] = i_moto;
				kifu[tesu][0] = i_saki + i_naru * 100;
				tesu++;
				kifu[tesu][0] = 0;
				sasu (men_h, teban, i_moto, i_saki, i_naru);
				pDC = GetDC();
				k_disp(pDC, men_h, 1);		// Ֆʕ\
				man_disp(pDC, tesu, 1);
				ReleaseDC(pDC);
			}
			else
			{
				job_no = 0;
				kifu[tesu][0] = 0;
				stop_time();
				switch(i_man[1 - teban])
				{
				case -1:
				case -2:
				case -4:
				case -5:
				case -6:
					rs232c.last_out(-3, i_man[1 - teban]);
					break;
				case -3:
					if (lan_prog == 5)
					{
						lan_prog = 2;
						_lan_puts("%CHUDAN\n");
					}
					break;
				default:
					break;
				}
				pDC = GetDC();
				teban_disp(pDC, "recieve invalid", "");
				ReleaseDC(pDC);
				MessageBox("Pause shogi!", "shogi");
				pDC = GetDC();
				teban_disp(pDC, "", "");
				ReleaseDC(pDC);
				rs232c.rs_close(i_man);
				finish_shikou();
				return;
			}
		}
		pDC = GetDC();
		if (taikyoku_check(pDC, mess))
		{
			ReleaseDC(pDC);
			MessageBox(mess, "shogi");
			job_no = 0;
			rs232c.rs_close(i_man);
			break;
		}
		else
		{
			ReleaseDC(pDC);
		}
	}
}

/******************/
/* ^XN`FW */
/******************/
void CCsaView::dispatch()
{
	MSG		Message;

	if(::PeekMessage(&Message, NULL, 0, 0, PM_REMOVE))
	{
		::TranslateMessage(&Message);
		::DispatchMessage (&Message);
	}
}

void CCsaView::OnInternetAuthor() 
{
	ShellExecute(m_hWnd, "open", "http://vivio.blog.shinobi.jp/", NULL, NULL, SW_SHOW);
}

void CCsaView::OnLanLogin() 
{
	CLogindlg	dlg;

	if (job_no)return;

	if (dlg.DoModal() == IDOK)
	{
		strncpy(lan_server, dlg.m_server, sizeof(lan_server));
		lan_port = dlg.m_port;
		strncpy(lan_user, dlg.m_user, sizeof(lan_user));
		strncpy(lan_pass, dlg.m_pass, sizeof(lan_pass));

		start_login(lan_server, lan_port);
	}
}

void CCsaView::OnLanLogout() 
{
	CDC		*pDC;

	if (lan_prog)
	{
		_lan_puts("LOGOUT\n");
		pDC = GetDC();
		teban_disp(pDC, "", "");
		ReleaseDC(pDC);
	}
}

void CCsaView::OnUpdateLanLogin(CCmdUI* pCmdUI) 
{
	if (job_no == 0)
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}	
}

void CCsaView::OnPlayStart() 
{
	CDC			*pDC;
	CTaikyoku	dlg;
	char		mess[10+DEF_GAME_LEN+1];
//	char		server[32];

	if (tesu > 0)
	{
		switch(MessageBox("Initialize Board ?", "Play Start", MB_YESNOCANCEL))
		{
		case IDYES:
			tesu = 0;
			kifu[tesu][0] = 0;
			timer_sec[0] = timer_sec[1] = 0;
			timer_sec1[0] = timer_sec1[1] = 0;
			end_code = END_CODE_NONE;
			pDC = GetDC();
			memcpy(men_h, initial_kyokumen, sizeof(men_h));
			k_disp(pDC, men_h, 1);		// Ֆʕ\
			now_tesu = -1;
			man_disp(pDC, tesu, 1);
			teban_disp(pDC, "", "");
			ReleaseDC(pDC);
			break;
		case IDNO:
			break;
		default:
			return;
		}
	}

	if (taikyoku_hansoku(men_h) != 0)
	{
		MessageBox("We can not play shogi !", "Play Start");
		return;
	}

	dlg.m_sman  = sman;
	dlg.m_gman  = gman;
	dlg.m_ssman = ssman;
	dlg.m_ggman = ggman;
	if (dlg.DoModal() == IDOK)
	{
		strncpy(sman, dlg.m_sman, sizeof(sman));
		strncpy(gman, dlg.m_gman, sizeof(gman));
		i_man[0] = dlg.m_man[0];
		i_man[1] = dlg.m_man[1];
		strncpy(ssman, dlg.m_ssman, sizeof(ssman));
		strncpy(ggman, dlg.m_ggman, sizeof(ggman));
		chudan_flag = 0;
		job_no      = 2;
		end_code    = END_CODE_NONE;
		pDC = GetDC();
	  	man_disp(pDC, tesu, 0);
		ReleaseDC(pDC);
		if (rs232c.rs_init(i_man, mess))
		{
			MessageBox(mess, "rs232c");
			job_no = 0;
			return;
		}
		if (i_man[0] > 0)
		{
			sikou_flag = 1;
		}
		else if (i_man[1] > 0)
		{
			sikou_flag = 2;
		}
		else
		{
			sikou_flag = 0;
		}
		if (sikou_flag) {
			gCsaDll.sikou_ini(&chudan_flag);
		}

		// LANڑ
		if (i_man[0] == -3 || i_man[1] == -3) {
			m_continuous = dlg.m_continuous;
			m_wdoor = dlg.m_wdoor;
			strncpy(lan_server, dlg.m_server, sizeof(lan_server));
			lan_port = dlg.m_port;
			strncpy(lan_user, dlg.m_userid, sizeof(lan_user));
			strncpy(lan_pass, dlg.m_password, sizeof(lan_pass));
			strncpy(wdoor_game, dlg.m_gamename, sizeof(wdoor_game));

			start_login(lan_server, lan_port);
		} else {
			start_time();
			PlaySound(SE_START, NULL, SND_ASYNC | SND_FILENAME | SND_NODEFAULT);
			Taikyoku();
		}
#if 0
		if (lan_prog == 3)
		{
			if (i_man[1 - you_teban] == -3)
			{
				lan_prog = 4;
				snprintf(mess, sizeof(mess), "AGREE %s\n", lan_game);
				_lan_puts(mess);
				return;
			}
			else
			{
				lan_prog = 2;
				snprintf(mess, sizeof(mess), "REJECT %s\n", lan_game);
				_lan_puts(mess);
			}
		}
		start_time();
		Taikyoku();
#endif
	}
	else
	{
		if (lan_prog == 3)
		{
			lan_prog = 2;
			snprintf(mess, sizeof(mess), "REJECT %s\n", lan_game);
			_lan_puts(mess);
		}
	}
}

void CCsaView::OnUpdatePlayStart(CCmdUI* pCmdUI) 
{
	if (job_no == 0)
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}

void CCsaView::start_login(const char *server, const int port)
{
	CDC	*pDC;
	int ierr = 0;
	char moji[128];

	if (fp_lan == NULL)
	{
		time_t t;
		struct tm *p;
		time(&t);
		p = localtime(&t);
		if (p) {
			snprintf(moji, sizeof(moji), "%s_%02d%02d%02d_%02d%02d.txt", lan_user,
					p->tm_year % 100, p->tm_mon+1, p->tm_mday, p->tm_hour, p->tm_min);
		} else {
			snprintf(moji, sizeof(moji), "%s.txt", lan_user);
		}
		fp_lan = fopen(moji, "wb");
	}
	ierr = _lan_open(server, port, GetSafeHwnd());
	switch(ierr)
	{
	case -1:
		MessageBox("Socket initialize error", "LAN");
		break;
	case -2:
		MessageBox("Socket create error", "LAN");
		break;
	case -3:
		MessageBox("server not found", "LAN");
		break;
	case -4:
		MessageBox("connect error", "LAN");
		break;
	default:
		pDC = GetDC();
		teban_disp(pDC, "", "");
		ReleaseDC(pDC);
		break;
	}
}

void CCsaView::finish_shikou()
{
	if (sikou_flag) {
		sikou_flag = 0;
		gCsaDll.sikou_end();
	}
	if ((i_man[0] < 0 || i_man[1] < 0) && m_continuous && end_code != END_CODE_NONE) {
		CWinApp*	app;
		app = AfxGetApp();
		kif_filename = app->GetProfileString("file name", "csa");
		int ps = kif_filename.ReverseFind('\\');
		if (ps < 0) {
			ps = kif_filename.ReverseFind('/');
		}
		if (ps >= 0) {
			kif_filename = kif_filename.Left(ps);
		} else {
			kif_filename = "";
		}

		time_t t;
		char moji[128];
		struct tm *p;
		time(&t);
		p = localtime(&t);
		if (p) {
			snprintf(moji, sizeof(moji), "kifu_%02d%02d%02d_%02d%02d.csa",
					p->tm_year % 100, p->tm_mon+1, p->tm_mday, p->tm_hour, p->tm_min);
		} else {
			snprintf(moji, sizeof(moji), "kifu.csa");
		}
		kif_filename += "\\";
		kif_filename += moji;
		save_kifu();

		if (m_wdoor == 0) {
			_lan_puts("LOGOUT\n");
		}
		CDC *pDC = GetDC();
		teban_disp(pDC, "", "");
		ReleaseDC(pDC);
		this->SetTimer(DEF_TIMER_LOGIN_ID, DEF_TIMER_LOGIN_TIME, NULL);
	}
}

void CCsaView::save_kifu()
{
	char		sente[28];
	char		gote[28];
	CEisei		eisei;
	char		mess[50];

	strncpy(sente, sman, sizeof(sente));
	if (strcmp(sente, "COM1") == 0)
	{
		if (ssman[0])
		{
			strncpy(sente, ssman, sizeof(sente));
		}
	}
	else if (strcmp(sente, "COM2") == 0)
	{
		if (ssman[0])
		{
			strncpy(sente, ssman, sizeof(sente));
		}
	}
	else if (strcmp(sente, "Computer") == 0)
	{
		if (ssman[0])
		{
			strncpy(sente, ssman, sizeof(sente));
		}
	}
	else if (strcmp(sente, "LAN") == 0)
	{
		if (ssman[0])
		{
			strncpy(sente, ssman, sizeof(sente));
		}
	}

	strncpy(gote, gman, sizeof(gote));
	if (strcmp(gote, "COM1") == 0)
	{
		if (ggman[0])
		{
			strncpy(gote, ggman, sizeof(gote));
		}
	}
	else if (strcmp(gote, "COM2") == 0)
	{
		if (ggman[0])
		{
			strncpy(gote, ggman, sizeof(gote));
		}
	}
	else if (strcmp(gote, "Computer") == 0)
	{
		if (ggman[0])
		{
			strncpy(gote, ggman, sizeof(gote));
		}
	}
	else if (strcmp(gote, "LAN") == 0)
	{
		if (ggman[0])
		{
			strncpy(gote, ggman, sizeof(gote));
		}
	}

	if (eisei.csa_save(kifu, kif_filename, shohi, mess,
						sente, gote, end_code, initial_kyokumen))
	{
		MessageBox(mess, "file save");
	}
	AfxGetApp()->WriteProfileString("file name", "csa", kif_filename);
}

void CCsaView::OnNextMove() 
{
	// TODO: ̈ʒuɃR}h nhp̃R[hǉĂ
	static int m_moto[600];
	static int m_saki[600];
	static int m_naru[600];
	static char	men[100];
	chudan_flag = 0;
	gCsaDll.sikou_ini(&chudan_flag);
	int kotae = gCsaDll.sikou(tesu, kifu, timer_sec, m_moto, m_saki, m_naru);
	int eval = 0;
	if (kotae > 100000) {
		int eval = kotae - 200000;
		if (tesu & 1) {
			// Ԃ͕]
			eval = -eval;
		}
	}
	if (kotae > 0) {
		int teban = tesu & 0x0001;
		memcpy(men, men_h, sizeof(men));
		sasu(men, teban, m_moto[0], m_saki[0], m_naru[0]);
		char moji[12];
		if (teban == 0) {
			moji[0] = '+';
		} else {
			moji[0] = '-';
		}
		int i_moto = m_moto[0];
		if (m_moto[0] > 100) {
			moji[1] = moji[2] = '0';
		} else {

			snprintf(&moji[1], sizeof(moji)-1, "%d%d", (i_moto - 1) % 9 + 1,
													   (i_moto - 1) / 9 + 1);
		}
		int i_saki = m_saki[0];
		if (i_saki > 100) i_saki -= 100;
		snprintf(&moji[3], sizeof(moji) - 3, "%d%d", (i_saki - 1) % 9 + 1,
							      (i_saki - 1) / 9 + 1);
		int koma = men[i_saki];
		if (koma < 0)koma = -koma;
		snprintf(&moji[5], sizeof(moji) - 5, "%s\n", koma_kind[koma - 1]);
		CString mes;
		mes.Format("̎ %s(]l=%d)", moji, eval);
		MessageBox(mes, "̈", MB_OK);

	} else if (kotae == 0) {
		MessageBox("", "̈", MB_OK);
	} else if (kotae == -5) {
		MessageBox("ʐ錾", "̈", MB_OK);
	}
	gCsaDll.sikou_end();
}

void CCsaView::OnUpdateNextMove(CCmdUI* pCmdUI) 
{
	// TODO: ̈ʒu command update UI nhp̃R[hǉĂ
	if (job_no == 0)
	{
		pCmdUI->Enable(TRUE);
	}
	else
	{
		pCmdUI->Enable(FALSE);
	}
}
