// Eisei.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Csa.h"
#include "Eisei.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CEisei

CEisei::CEisei()
{
}

CEisei::~CEisei()
{
}


BEGIN_MESSAGE_MAP(CEisei, CStatic)
	//{{AFX_MSG_MAP(CEisei)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CEisei bZ[W nh
static char koma[] = "  FUKYKEGIKIKAHIOUTONYNKNG  UMRY";

static int koma_code(char* s)
{
    int koma;

    switch(*s++)
    {
    case 'F':
        koma = 1;
        break;
    case 'K':
        switch(*s)
        {
        case 'Y':
            koma = 2;
            break;
        case 'E':
            koma = 3;
            break;
        case 'I':
            koma = 5;
            break;
        default:
            koma = 6;
            break;
        }
        break;
    case 'G':
        koma = 4;
        break;
    case 'H':
        koma = 7;
        break;
    case 'O':
        koma = 8;
        break;
    case 'T':
        koma = 9;
        break;
    case 'N':
        switch(*s)
        {
        case 'Y':
            koma = 10;
            break;
        case 'K':
            koma = 11;
            break;
        default:
            koma = 12;
            break;
        }
        break;
    case 'U':
        koma = 14;
        break;
    case 'R':
        koma = 15;
        break;
    default:
        koma = 0;
        break;
    }
    return(koma);
}

/******************/
/* TCYvZ */
/******************/
static int moji_size(unsigned char c)
{
    if (c < 0x0020)return(0);
    if (c < 0x007f)return(1);
    if (c < 0x0081)return(0);
    if (c < 0x00a0)return(2);
    if (c < 0x00a1)return(0);
    if (c < 0x00e0)return(1);
    if (c < 0x00fd)return(2);
    return(0);
}

/**************/
/* 擾 */
/**************/
static void get_moji(char* s2,char* s1,int max)
{
    int    len;
    int    iend;

    len  = 0;
    iend = 1;

    while(iend)
    {
        switch(moji_size(*s1))
        {
        case 1:
            if (len >= max)
            {
                iend = 0;
                break;
            }
            *s2++ = *s1++;
            len++;
            break;
        case 2:
            if ((len + 1) >= max)
            {
                iend = 0;
                break;
            }
            *s2++ = *s1++;
            *s2++ = *s1++;
            len += 2;
            break;
        default:
            iend = 0;
            break;
        }
    }
    *s2 = 0;
}

/******************************************************/
/* \[Xt@CǂݍށBi}bLgbVΉj */
/******************************************************/
static int mgets(char* moji,int len,FILE* fp)
{
	int		i;
	char	c;

	len--;
	i = 0;
	while(1)
	{
		if (i >= len)break;
		if (fread(&c,1,1,fp) <= 0)break;
		if (c == (char)0x0a)
		{
			if (i > 0)break;
		}
		else if (c == (char)0x0d)
		{
			if (i > 0)break;
		}
		else
		{
			moji[i++] = c;
		}
	}
	moji[i] = 0;
	return(i);
}

/****************************************/
/* br``̊t@CǂݍށB */
/****************************************/
BOOL CEisei::csa_load(unsigned char kifu[][2],CString name,int* shohi,int* xtesu,
						char* mess,char* sman,char* gman,
						int* end_code,char* initial_kyokumen,char* hkyokumen)
{
    FILE        *fp;
    int         iprog;
    int         i;
	int			k;
    int         tesu;
    int			v;
    int         old;
    int         newx;
    int         x;
    int         y;
    int         ip;
	int			mochi_flag;
	int			flag;
    char        moji[80];
    char        ssman[28];
    char        ggman[28];
    char        men [100];
	char		imen[100];
    char        *s;

	fp = fopen(name,"rb");
	if (fp == NULL)
	{
		strcpy(mess,"This file not exist !");
        return(TRUE);
    }
    ssman[0] = ggman[0] = 0;
    iprog = tesu = 0;
    memset(imen,0,100);
    flag = mgets(moji,sizeof(moji),fp);
    while(flag)
    {
        switch(iprog)
        {
		case 1:
			if (moji[0] == 'N')
			{
				if (moji[1] == '-')
				{
					get_moji(ggman,&moji[2],20);
				}
			}
			iprog++;
			break;
        case 0:
			if (moji[0] == 'N')
			{
				if (moji[1] == '+')
				{
					get_moji(ssman,&moji[2],20);
					iprog++;
					break;
				}
			}
        case 2:
			if (moji[1] == 'I')break;
        case 3:
        case 4:
        case 5:
        case 6:
        case 7:
        case 8:
        case 9:
		case 10:
		case 11:
            if (moji[0] == 'P')
            {
				if (iprog <= 2)
				{
					iprog = 3;
				}
				else
				{
                	iprog++;
				}
                s = moji + 2;
                ip = (iprog - 2) * 9;
                for (i = 0 ; i < 9 ; i++)
                {
                    switch(*s++)
                    {
                    case '+':
                        imen[ip--] = koma_code(s);
                        break;
                    case '-':
                        imen[ip--] = -koma_code(s);
                        break;
                    default:
                        imen[ip--] = 0;
                        break;
                    }
                    s += 2;
                }
				break;
            }
		case 13:
            if (moji[0] == '+')
            {
				if (iprog <= 2)
				{
					memcpy(imen,hkyokumen,100);
				}
				else
				{
					imen[98] = imen[99] = -1;
					for (i = 1 ; i <= 81 ;i++)
					{
						switch(imen[i])
						{
						case (char)8:
							imen[98] = i;
							break;
						case (char)-8:
							imen[99] = i;
							break;
						default:
							break;
						}
					}
				}
                tesu = 0;
				iprog = 14;
            }	  
			else if (moji[0] == '-')
			{
				flag = 0;
				break;
			}
			if (iprog == 14)
			{
				for (i = 1; i < 82;i++)
				{
					if (imen[i] < 0)
					{
						men[i] = -imen[i];
					}
					else
					{
						men[i] = imen[i];
					}
				}
			}
            if (moji[1] == 0)break;
        case 14:                        /* w */
            switch (moji[0])
            {
            case '%':
				if (tesu > 0)
				{
					if (mochi_flag == 0)
					{
						tesu++;
					}
				}
				if (moji[1] == 'T')
				{
					if ((tesu & 0x0001)  == 0)
					{
                		*end_code = 2;
					}
					else
					{
						*end_code = 1;
					}
				}
				else
				{
					*end_code = 0;
				}
				kifu[tesu][0] = 0;
                flag = 0;
                break;
			case 'T':			// 
				mochi_flag = 1;
				v = atoi(&moji[1]);
				if (tesu >= 2)
				{
					shohi[tesu] = v + shohi[tesu - 2];
				}
				else
				{
					shohi[tesu] = v;
				}
				tesu++;
				break;
			case '+':
				mochi_flag = 0;
				if ((tesu & 0x0001) != 0)
				{
					shohi[tesu++] = 0;
				}
                if (tesu >= 1000)
                {
                    flag = 0;
                    *end_code = 0;
					break;
                }
				k = koma_code(&moji[5]); 
                v = atoi(&moji[1]);
				if (v < 100)
                {
                    kifu[tesu][1] = 100 + k;
                    x = v / 10;
                    y = v % 10;
					ip = (y - 1) * 9 + x;
                    kifu[tesu][0] = ip;
                }
                else
                {
				    old  = v / 100;
                	newx = v % 100;
                    x = old / 10;
                    y = old % 10;
					i = (y - 1) * 9 + x;
                    kifu[tesu][1] = (y - 1) * 9 + x;
                    x = newx / 10;
                    y = newx % 10;
					ip = (y - 1) * 9 + x;
                    kifu[tesu][0] = ip;
					if (men[i] != k)
					{
                    	kifu[tesu][0] += 100;
					}
                }
				men[ip] = k;
//                iprog++;
                break;
			case '-':
				mochi_flag = 0;
				if ((tesu & 0x0001) == 0)
				{
					shohi[tesu++] = 0;
				}
				k = koma_code(&moji[5]); 
                v = atoi(&moji[1]);
				if (v < 100)
                {
                    kifu[tesu][1] = 100 + k;
                    x = v / 10;
                    y = v % 10;
					ip = (y - 1) * 9 + x;
                    kifu[tesu][0] = ip;
                }
                else
                {
				    old  = v / 100;
                	newx = v % 100;
                    x = old / 10;
                    y = old % 10;
					i = (y - 1) * 9 + x;
                    kifu[tesu][1] = (y - 1) * 9 + x;
                    x = newx / 10;
                    y = newx % 10;
					ip = (y - 1) * 9 + x;
                    kifu[tesu][0] = ip;
					if (men[i] != k)
					{
                    	kifu[tesu][0] += 100;
					}
                }
				men[ip] = k;
//                iprog++;
                break;
            }
            break;
        default:                        /*  */
	        break;
        }
        if (flag == 0)break;
        flag = mgets(moji,sizeof(moji),fp);
    }
    fclose(fp);

    if (iprog == 14)
    {
        strcpy(sman,ssman);
        strcpy(gman,ggman);
        *xtesu = 0;
        kifu[tesu][0] = 0;
		memcpy(initial_kyokumen,imen,100);
        return(FALSE);
    }
    else
    {
		strcpy(mess,"Invalid file !");
        return(TRUE);
    }
}

/**************************************/
/* br``t@CށB */
/**************************************/

BOOL CEisei::csa_save(unsigned char kifu[][2],CString name,int* shohi,
						char* mess,char* sman,char* gman,int end_code,
						char* initial_kyokumen)
{
    FILE        *fp;
    int         te;
    int         i;
    int         j;
    int         jj;
    int         k;
    int         old;
    int         newx;
    int         x;
    int         y;
    int			sec;
    char        men[84];

	for (i = 83 ; i < 98; i++)
	{
		if (initial_kyokumen[i] > 0)
		{
			strcpy(mess,"This Program Can not save data !");
			return(TRUE);
		}
	}

	/****************/
	/* ݊Jn */
	/****************/

    fp = fopen(name,"w");
    if (fp == 0)
    {
        strcpy(mess,"Can not make file !");
        return(TRUE);
    }

	/******************/
	/* ΋ǎҏ */
	/******************/

    fprintf(fp,"N+%s\n",sman);
    fprintf(fp,"N-%s\n",gman);
 
    /******************/
    /* ǖʐ} */
    /******************/
    memcpy(men,initial_kyokumen,84);
    for (i = 9 ; i <= 81 ; i += 9)
    {
        fprintf(fp,"P%d",i / 9);
        for (j = 0 ; j < 9; j++)
        {
            jj = i - j;
            k  = men[jj];
            if (k == 0)
            {
                fprintf(fp," * ");
            }
            else
            {
                if (k > 0)
                {
                    fprintf(fp,"+");
                }
                else
                {
                    fprintf(fp,"-");
                    k = -k;
					men[jj] = k;
                }
                k *= 2;
                fprintf(fp,"%c%c",koma[k],koma[k + 1]);
            }
        }
        fprintf(fp,"\n");
    }

	/****************/
	/* ԏ */
	/****************/

	fprintf(fp,"+\n");

	/****************/
	/*  */
	/****************/
    te  = 0;
    while(kifu[te][0])
    {
		if ((te & 0x0001) == 0)
		{
			fprintf(fp,"+");
		}
		else
		{
			fprintf(fp,"-");
		}
        old  = kifu[te][1];
        newx = kifu[te][0];
        if (old > 100)
        {
            y = (newx + 8) / 9;
            x = newx - 9 * (y - 1);
            fprintf(fp,"00%d%d",x,y);
			k = old - 100; 
        }
        else
        {
            y = (old + 8) / 9;
            x = old - 9 * (y - 1);
            fprintf(fp,"%d%d",x,y);
			k = men[old];
            if (newx > 100)
            {
                newx -= 100;
				k    += 8;
			}
            y = (newx + 8) / 9;
            x = newx - 9 * (y - 1);
			fprintf(fp,"%d%d",x,y);
 		}
		men[newx] = k;
		k *= 2;
        fprintf(fp,"%c%c\n",koma[k],koma[k + 1]);
        if (te >= 2)
		{
			sec = shohi[te] - shohi[te - 2];
		}
		else
		{
			sec = shohi[te];
		}
        fprintf(fp,"T%ld\n",sec);
        te++;
    }

    if ((end_code == 1) || (end_code == 2))
    {
		fprintf(fp,"%cTORYO\n",'%');
    }
	else
	{
		fprintf(fp,"%cCHUDAN\n",'%');
	}
    fclose(fp);
	return(FALSE);
}

void kifuout(char* moji,int tesu,unsigned char kifu[][2],char* initial_kyokumen,int end_code)
{
	int		men[84];
	int		i;
	int		k;
	int		ix_old;
	int		iy_old;
	int		newx;
	int		old;
	char	c;

	if (tesu < 0)
	{
		*moji = 0;
		if (end_code == 2)
		{
			if (kifu[0][0] == 0)
			{
				strcpy(moji,"%TORYO");
			}
		}
		return;
	}

	/* ǖʂ̍쐬 */
	for (i = 1; i < 82 ;i++)
	{
		if (initial_kyokumen[i] >= 0)
		{
			men[i] = (int)initial_kyokumen[i];
		}
		else
		{
			men[i] = -(int)initial_kyokumen[i];
		}
	}

	/* ̋ǖʂ܂ŕׂB */
	for (i = 0; i < tesu ;i++)
	{
        newx = kifu[i][0];
		if (newx == 0)
		{
			*moji = 0;
			return;
		}
		old  = kifu[i][1];
		if (old > 100)
		{
			men[newx] = old - 100;
		}
		else if (newx > 100)
		{
			newx -= 100;
			men[newx] = men[old] + 8;
			men[old ] = 0;
		}
		else
		{
			men[newx] = men[old];
			men[old ] = 0;
		}
	}

	/* ϊR[h𓾂B */
	newx = kifu[tesu][0];
	if (newx == 0)
	{
		switch(end_code)
		{
		case 1:
		case 2:
			strcpy(moji,"%TORYO");
			break;
		default:
			strcpy(moji,"%CHUDAN");
			break;
		}
	}
	else
	{
		old = kifu[tesu][1];
		if (old > 100)
		{
			k = old - 100;
			ix_old = iy_old = 0;
		}
		else
		{
			k = men[old];
			old--;
			ix_old = (old % 9) + 1;
			iy_old = (old / 9) + 1;
			if (newx > 100)
			{
				k    += 8;
				newx -= 100;
			}
		}
		k *= 2;
		newx--;
		if ((tesu & 0x0001) == 0)
		{
			c = '+';
		}
		else
		{
			c = '-';
		}
		sprintf(moji,"%c%d%d%d%d%c%c",c,ix_old,iy_old,
										(newx % 9) +1,(newx / 9) + 1,
										koma[k],koma[k + 1]);
	}
}
