// Rs232c.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Csa.h"
#include "Rs232c.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// CRs232c

CRs232c::CRs232c(int* c)
{
	chudan_flag = c;
}

CRs232c::~CRs232c()
{
}


BEGIN_MESSAGE_MAP(CRs232c, CStatic)
	//{{AFX_MSG_MAP(CRs232c)
		//  - ClassWizard ͂̈ʒuɃ}bsOp̃}Nǉ܂͍폜܂B
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CRs232c bZ[W nh
extern void s_total(char* men,char* mochi,int* cnt,int* m_moto,int* m_saki,int* m_naru);
extern void g_total(char* men,char* mochi,int* cnt,int* m_moto,int* m_saki,int* m_naru);

void CRs232c::dispatch()
{
	MSG		Message;

	if(::PeekMessage(&Message,NULL,0,0,PM_REMOVE))
	{
		::TranslateMessage(&Message);
		::DispatchMessage (&Message);
	}
}

static	HANDLE	hCom;

/************************************/
/* RS-232C  iWindows95pj */
/************************************/
BOOL CRs232c::rs_init_95(int port,char* mess)
{
	BOOL	fSuccess;
	DCB		dcb;

	switch (port)
	{
	case 1:
		hCom = CreateFile("COM1",
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						NULL,
						NULL);
		break;
	case 2:
		hCom = CreateFile("COM2",
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						NULL,
						NULL);
		break;
	case 3:
		hCom = CreateFile("COM3",
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						NULL,
						NULL);
		break;
	case 4:
		hCom = CreateFile("COM4",
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						NULL,
						NULL);
		break;
	case 5:
		hCom = CreateFile("COM5",
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						NULL,
						NULL);
		break;
	case 6:
		hCom = CreateFile("COM6",
						GENERIC_READ | GENERIC_WRITE,
						0,
						NULL,
						OPEN_EXISTING,
						NULL,
						NULL);
		break;
	default:
		break;
	}
	if (hCom == INVALID_HANDLE_VALUE)
	{
		strcpy(mess,"Can not open rs232c !");
		return(TRUE);
	}

	fSuccess = GetCommState(hCom,&dcb);
	if (!fSuccess)
	{
		strcpy(mess,"Can not make DCB !");
		CloseHandle(hCom);
		return(TRUE);
	}

	dcb.BaudRate = CBR_1200;
	dcb.ByteSize = 8;
	dcb.Parity   = NOPARITY;
	dcb.StopBits = ONESTOPBIT;
	fSuccess = SetCommState(hCom,&dcb);

	if (!fSuccess)
	{
		strcpy(mess,"Can not set DCB status !");
		CloseHandle(hCom);
		return(TRUE);
	}
	return(FALSE);
}

BOOL CRs232c::rs_init(int* i_man,char* mess)
{
    int i;

    for (i = 0 ; i < 2 ; i++)
    {
        switch(i_man[i])
        {
        case -1:                        /* COM1 PORT */
			return(rs_init_95(1,mess));
        case -2:                        /* COM2 PORT */
			return(rs_init_95(2,mess));
        case -3:                        /* COM3 PORT */
//			return(rs_init_95(3,mess));
			break;
        case -4:                        /* COM4 PORT */
			return(rs_init_95(4,mess));
        case -5:                        /* COM5 PORT */
			return(rs_init_95(5,mess));
        case -6:                        /* COM6 PORT */
			return(rs_init_95(6,mess));
		default:
			break;
		}
    }
	return(FALSE);
}

void CRs232c::rs_close(int* i_man)
{
	switch(i_man[0])
	{
	case -1:
	case -2:
//	case -3:
	case -4:
	case -5:
	case -6:
		CloseHandle(hCom);
		return;
	default:
		break;
	}
	switch(i_man[1])
	{
	case -1:
	case -2:
//	case -3:
	case -4:
	case -5:
	case -6:
		CloseHandle(hCom);
		return;
	default:
		break;
	}
}

/******************************/
/* qr|QRQb@o */
/******************************/
void CRs232c::rs_puts_95(char *s)
{
	DWORD	len;
	DWORD	len2;

	len = strlen(s);
	WriteFile(hCom,s,len,&len2,NULL);
}

/******************************/
/* qr|QRQb@ */
/******************************/
int CRs232c::rs_gets_95(char* s,int e)
{
	COMSTAT		stat;
	DWORD		ierr;
	char		moji[16];
    int         i;
	DWORD		j;
	char		c;
	DWORD		len;

	i = 0;
	c = 0;
	while(i < 14)
	{
		dispatch();
		if (*chudan_flag != 0)break;
		ClearCommError(hCom,&ierr,&stat);
		if (stat.cbInQue > 0)
		{
			if (stat.cbInQue > 14)stat.cbInQue = 14;
			ReadFile(hCom,moji,stat.cbInQue,&len,NULL);
			if (len < 0)break;
			for (j = 0; j < len ; j++)
			{
				s[i++] = c = moji[j];
				if (i >= 14)break;
				if (c == e)break;
			}
			if (c == e)break;
		}
	}
	s[i] = 0;
	return(i);
}

/****************************/
/* qr|QRQb@MmF */
/****************************/
BOOL rs_get_status()
{
	COMSTAT		stat;
	DWORD		ierr;

	ClearCommError(hCom,&ierr,&stat);
	if (stat.cbInQue > 0)
	{
		return(TRUE);
	}
	return(FALSE);
}

/************************/
/* br`C^tF[X */
/************************/

static char *koma_kind[] =
                { "FU" , "KY" , "KE" , "GI" , "KI" , "KA" , "HI" , "OU" ,
                  "TO" , "NY" , "NK" , "NG" , "  " , "UM" , "RY" };
int CRs232c::tushin(char* men,int teban,int* m_moto,int* m_saki,int* m_naru,char* mess)
{
	int		cnt;
    int     i_moto;
    int     i_saki;
    int     i_naru;
    int     i;
    int     ix_old;
    int     iy_old;
    int     ix_new;
    int     iy_new;
    char    moji[20];
    int     koma;
    int     koma_old;
    char    *s;

	mess[0] = 0;

	if (teban == 0)
	{
		s_total(men,&men[82],&cnt,m_moto,m_saki,m_naru);
	}
	else
	{
		g_total(men,&men[90],&cnt,m_moto,m_saki,m_naru);
	}

    while(1)
    {
		rs_gets_95(moji,0x0a);
		if (*chudan_flag != 0)return(-3);
        s = moji;
        if (strncmp(moji,"%TORYO",6) == 0)
        {
            return(-1);
        }
		else if (strncmp(moji,"%GIVEUP",7) == 0)
		{
			return(-1);
		}
        else if (strncmp(moji,"%MATTA",6) == 0)
        {
            return(-2);
        }
        else if (strncmp(moji,"%CHUDAN",7) == 0)
        {
            return(-3);
        }
		else if (strncmp(moji,"%HIKIWAKE",9) == 0)
        {
            return(-4);
        }
		else if (strncmp(moji,"%KACHI",6) == 0)
        {
            return(-5);
        }
/* 1 moji-me */
        i_moto = 0;
        switch(moji[1])
        {
        case '0':
            ix_old = 0;
            break;
        case '1':
            ix_old = 1;
            break;
        case '2':
            ix_old = 2;
            break;
        case '3':
            ix_old = 3;
            break;
        case '4':
            ix_old = 4;
            break;
        case '5':
            ix_old = 5;
            break;
        case '6':
            ix_old = 6;
            break;
        case '7':
            ix_old = 7;
            break;
        case '8':
            ix_old = 8;
            break;
        case '9':
            ix_old = 9;
            break;
        default:
            i_moto = -1;
            break;
        }
/* 2moji-me */
        switch(moji[2])
        {
        case '0':
            iy_old = 0;
            break;
        case '1':
            iy_old = 1;
            break;
        case '2':
            iy_old = 2;
            break;
        case '3':
            iy_old = 3;
            break;
        case '4':
            iy_old = 4;
            break;
        case '5':
            iy_old = 5;
            break;
        case '6':
            iy_old = 6;
            break;
        case '7':
            iy_old = 7;
            break;
        case '8':
            iy_old = 8;
            break;
        case '9':
            iy_old = 9;
            break;
        default:
            if(i_moto == 0)i_moto = -1;
            break;
        }
        if (i_moto == 0)i_moto = ix_old + (iy_old - 1) * 9;
/* 3 moji-me */
        i_saki = 0;
        switch(moji[3])
        {
        case '1':
            ix_new = 1;
            break;
        case '2':
            ix_new = 2;
            break;
        case '3':
            ix_new = 3;
            break;
        case '4':
            ix_new = 4;
            break;
        case '5':
            ix_new = 5;
            break;
        case '6':
            ix_new = 6;
            break;
        case '7':
            ix_new = 7;
            break;
        case '8':
            ix_new = 8;
            break;
        case '9':
            ix_new = 9;
            break;
        default:
            i_saki = -1;
            break;
        }
/* 4moji-me */
        switch(moji[4])
        {
        case '1':
            iy_new = 1;
            break;
        case '2':
            iy_new = 2;
            break;
        case '3':
            iy_new = 3;
            break;
        case '4':
            iy_new = 4;
            break;
        case '5':
            iy_new = 5;
            break;
        case '6':
            iy_new = 6;
            break;
        case '7':
            iy_new = 7;
            break;
        case '8':
            iy_new = 8;
            break;
        case '9':
            iy_new = 9;
            break;
        default:
            if(i_saki == 0)i_saki = -1;
            break;
        }
        if (i_saki == 0)i_saki = ix_new + (iy_new - 1) * 9;
/* 5 & 6 moji-me */
        for (i = 0 ; i < 15; i++)
        {
            if (strncmp(&moji[5],koma_kind[i],2) == 0)
            {
                koma = i + 1;
                break;
            }
        }
        if (i_moto == -9)
        {
            i_moto = koma + 100;
            i_naru = 0;
        }
        else
        {
            koma_old = men[i_moto];
            if (koma_old < 0)koma_old = -koma_old;
            if (koma_old == koma)
            {
                i_naru = 0;
            }
            else
            {
                i_naru = 1;
            }
        }
        for (i = 0 ; i < cnt ; i++)
        {
            if (i_saki != m_saki[i])continue;
            if (i_moto != m_moto[i])continue;
            if (i_moto < 100)
            {
                if (i_naru != m_naru[i])continue;
            }
            return(i);
        }
		strcpy(mess,moji);
		return(-3);
    }
	return(0);
}

void CRs232c::tushin_send(char* men,int tesu,unsigned char kifu[][2])
{
    char        moji[12];
    int         i_moto;
    int         i_saki;
    int         koma;

    tesu--;
    if ((tesu & 0x01) == 0)
    {
        moji[0] = '+';
    }
    else
    {
        moji[0] = '-';
    }
    i_moto = kifu[tesu][1];
    if (i_moto > 100)
    {
        moji[1] = moji[2] = '0';
    }
    else
    {
        sprintf(&moji[1],"%d%d",(i_moto - 1) % 9 + 1
                               ,(i_moto - 1) / 9 + 1);
    }
    i_saki = kifu[tesu][0];
    if (i_saki > 100) i_saki -= 100;
    sprintf(&moji[3],"%d%d",(i_saki - 1) % 9 + 1
                           ,(i_saki - 1) / 9 + 1);
    koma = men[i_saki];
    if (koma < 0)koma = -koma;
    sprintf(&moji[5],"%s\n",koma_kind[koma - 1]);
    rs_puts_95(moji);
}

void CRs232c::last_out(int i_code,int ii_man)
{
	switch(ii_man)
	{
	case -1:
	case -2:
//	case -3:
	case -4:
	case -5:
	case -6:
		switch(i_code)
		{
		case -1:                            /*  */
			rs_puts_95("%TORYO\n");			/* br`vgR[ */
			break;
		case -2:                            /* ҂ */
			rs_puts_95("%MATTA\n");
			break;
		case -3:                            /* f */
			rs_puts_95("%CHUDAN\n");
			break;
		case -4:							/* 錾 */
			rs_puts_95("%HIKIWAKE\n");
			break;
		case -5:							/* 錾 */
			rs_puts_95("%KACHI\n");
			break;
		default:
			break;
		}
		break;
	default:
		break;
	}
}
