// Taikyoku.cpp : Cve[V t@C
//

#include "stdafx.h"
#include "Csa.h"
#include "Taikyoku.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

extern int	lan_prog;
extern int	you_teban;

static char	*man_moji[] = 
{
	"You",			// 0
	"Computer",		// 1
	"COM1",			// 2
	"COM2",			// 3
	"LAN",			// 4
	"COM4",			// 5
	"COM5",			// 6
	"COM6"			// 7
};

//  username ǂ`FbNB
// ('0'-'9')Ap啶('A'-'Z')Ap('a'-'z')AA_[XRA('_')A
// nCt('-')̂ꂩ̕p32oCgȓ̃NCAgʂ邽߂̕
static bool isRightUsername(const char *p)
{
	bool ret = true;
	if (*p == '\0') return false;
	do {
		if (!isdigit(*p) && !isalpha(*p) && *p != '_' && *p != '-' && *p != '.' && *p != '@') {
			ret = false;
			break;
		}
	} while (*++p);

	return ret;
}

//  password ǂ`FbNB
static bool isRightPassword(const char *p)
{
	bool ret = true;
	if (*p == '\0') return false;
	do {
		if (*p == ' ') {
			ret = false;
			break;
		}
	} while (*++p);

	return ret;
}

/////////////////////////////////////////////////////////////////////////////
// CTaikyoku _CAO

CTaikyoku::CTaikyoku(CWnd* pParent /*=NULL*/)
	: CDialog(CTaikyoku::IDD, pParent)
{
	CWinApp		*pApp;

	MySection2 = _T("Settings");
	pApp       = AfxGetApp();

	//{{AFX_DATA_INIT(CTaikyoku)
	m_gman = _T("");
	m_sman = _T("");
	m_ggman = _T("");
	m_ssman = _T("");
	m_wdoor = pApp->GetProfileInt(MySection2, _T("WDOOR"), 1);
	m_gamename = pApp->GetProfileString(MySection2, _T("GAMENAME"), _T("floodgate-900-0"));
	m_password = pApp->GetProfileString(MySection2, _T("PASSWORD"));
	m_port = pApp->GetProfileInt(MySection2, _T("PORT"),4081);
	m_server = pApp->GetProfileString(MySection2, _T("SERVER"), _T("wdoor.c.u-tokyo.ac.jp"));
	m_userid = pApp->GetProfileString(MySection2, _T("USER"));
	m_continuous = pApp->GetProfileInt(MySection2, _T("CONTINUOUS"), 1);
	//}}AFX_DATA_INIT
}

void CTaikyoku::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(CTaikyoku)
	DDX_CBString(pDX, IDC_CMB_GOTE, m_gman);
	DDX_CBString(pDX, IDC_CMB_SENTE, m_sman);
	DDX_Text(pDX, IDC_EDIT_GMAN, m_ggman);
	DDX_Text(pDX, IDC_EDIT_SMAN, m_ssman);
	DDX_Check(pDX, IDC_CHECK_WDOOR, m_wdoor);
	DDX_Text(pDX, IDC_EDIT_GAMENAME, m_gamename);
	DDX_Text(pDX, IDC_EDIT_PASSWORD, m_password);
	DDX_Text(pDX, IDC_EDIT_PORT, m_port);
	DDV_MinMaxInt(pDX, m_port, 1024, 32767);
	DDX_Text(pDX, IDC_EDIT_SERVER, m_server);
	DDX_Text(pDX, IDC_EDIT_USER, m_userid);
	DDX_Check(pDX, IDC_CHECK_CONTINUOUS, m_continuous);
	//}}AFX_DATA_MAP
}

BEGIN_MESSAGE_MAP(CTaikyoku, CDialog)
	//{{AFX_MSG_MAP(CTaikyoku)
	ON_BN_CLICKED(IDC_CHECK_WDOOR, OnCheckWdoor)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// CTaikyoku bZ[W nh

BOOL CTaikyoku::OnInitDialog() 
{
	int		i;

	CComboBox* pCB_Sente  = (CComboBox*)GetDlgItem(IDC_CMB_SENTE);
	CComboBox* pCB_Gote   = (CComboBox*)GetDlgItem(IDC_CMB_GOTE);

	for (i = 0 ; i < sizeof(man_moji)/sizeof(man_moji[0]) ; i++)
	{
		pCB_Sente->InsertString(-1, man_moji[i]);
		pCB_Gote->InsertString (-1, man_moji[i]);
	}

	// wdoor[hp
	CButton* pCB_Wdoor  = (CButton*)GetDlgItem(IDC_CHECK_WDOOR);
	pCB_Wdoor->SetCheck(m_wdoor);
//	OnCheckWdoor();

	return CDialog::OnInitDialog();
}

void CTaikyoku::OnOK()
{
	int		i;
	bool ret = false;

	if (UpdateData(TRUE))
	{
		m_man[0] = m_man[1] = 0;
		for ( i = 1 ; i < sizeof(man_moji)/sizeof(man_moji[0]) ; i++)
		{
			if (strcmp(m_sman, man_moji[i]) == 0)
			{
				m_man[0] = i;
			}
			if (strcmp(m_gman, man_moji[i]) == 0)
			{
				m_man[1] = i;
			}
		}
		if (m_man[0] >= 2) m_man[0] = 1 - m_man[0];
		if (m_man[1] >= 2) m_man[1] = 1 - m_man[1];

		if ((m_man[0] < 0) && (m_man[1] < 0))
		{
			// ʐMꍇ
			MessageBox("As for communication, this program cannot use both!", "Play Start");
		}
		else if (m_man[0] == -3 || m_man[1] == -3)
		{
			// ǂ炩 LAN ̏ꍇ
			if (isRightUsername(LPCTSTR(m_userid)) == false) {
				MessageBox("Username letters include '0'-'9', 'A'-'Z', 'a'-'z', '_' or '-'.", "Play Start");
				return;
			}
			if (isRightPassword(LPCTSTR(m_password)) == false) {
				MessageBox("Password is wrong.", "Play Start");
				return;
			}

#if 0
			switch(lan_prog)
			{
			case 0:
			case 1:
				MessageBox("Login is required.","LAN");
				break;
			case 2:
				MessageBox("I did  not recieve the game conditions.","LAN");
				break;
			case 3:
				if (you_teban && m_man[0] == -3)
				{
					MessageBox("LAN is not second","LAN");
				}
				else if (you_teban == 0 && m_man[1] == -3)
				{
					MessageBox("LAN is not first","LAN");
				}
				else
				{
					ret = true;
				}
				break;
			case 4:
				MessageBox("waiting for a start","LAN");
				break;
			case 5:
				MessageBox("play now","LAN");
				break;
			default:
				break;
			}
#endif
		ret = true;
		}
		else
		{
			ret = true;
		}
	}

	if (ret == true) {
		CWinApp		*pApp = AfxGetApp();
		pApp->WriteProfileString(MySection2, _T("SERVER"), m_server);
		pApp->WriteProfileInt(MySection2, _T("PORT"), m_port);
		pApp->WriteProfileString(MySection2, _T("USER"), m_userid);
		pApp->WriteProfileString(MySection2, _T("PASSWORD"), m_password);
		pApp->WriteProfileInt(MySection2, _T("CONTINUOUS"), m_continuous);
		pApp->WriteProfileInt(MySection2, _T("WDOOR"), m_wdoor);
		pApp->WriteProfileString(MySection2, _T("GAMENAME"), m_gamename);

		EndDialog(IDOK);
	}
}

void CTaikyoku::OnCheckWdoor() 
{
	// TODO: ̈ʒuɃRg[ʒmnhp̃R[hǉĂ
	CButton* pCB_Wdoor  = (CButton*)GetDlgItem(IDC_CHECK_WDOOR);
	CEdit *pED_Gamename = (CEdit*)GetDlgItem(IDC_EDIT_GAMENAME);
	CStatic *pSt_Gamename = (CStatic*)GetDlgItem(IDC_STATIC_GAMENAME);

	if (pCB_Wdoor->GetCheck() == 0) {
		pED_Gamename->EnableWindow(FALSE);
		pSt_Gamename->EnableWindow(FALSE);
	} else {
		pED_Gamename->EnableWindow(TRUE);
		pSt_Gamename->EnableWindow(TRUE);
	}
}
