#include <stdio.h>
#include <time.h>

int popcnt_a(unsigned int u)
{
	int cnt=0;
	for (; u; u &= u-1) cnt++;
	return cnt;
}

int popcnt_b(unsigned int u)
{
	u = (u & 0x55555555) + ((u >>  1) & 0x55555555);
	u = (u & 0x33333333) + ((u >>  2) & 0x33333333);
	u = (u & 0x0F0F0F0F) + ((u >>  4) & 0x0F0F0F0F);
	u = (u & 0x00FF00FF) + ((u >>  8) & 0x00FF00FF);
	u = (u & 0x0000FFFF) + ((u >> 16) & 0x0000FFFF);
	return u;
}

void binprint(unsigned int u)
{
	int i;
	for (i = 31; i >= 0; i--) {
		printf("%d", (u & (1 << i)) ? 1 : 0);
	}
}

#define LOOPS (1000*1000)
void chk_func(int (*func)(unsigned int), const char *name, unsigned int u)
{
	clock_t start = clock();
	unsigned int i, n;
	unsigned int u1;
	for (n = 0; n < LOOPS; n++) {
		for (i = 0; i < 0x100; i++) {
			func(u);
		}
	}
	clock_t end = clock();
	printf("%s:", name);
	binprint(u);
	printf(":%7.4f sec\n", (end - start) / (double)CLOCKS_PER_SEC);
}

#define CHK_FUNC(f,u)	chk_func(f, #f, u)

int main()
{
	unsigned int u;

	printf("LbVɏ悹邽߂̌ʂ͖\n");
	u = 0x00000000;
	CHK_FUNC(popcnt_a, u);
	printf("\n{\n");
	CHK_FUNC(popcnt_a, u);
	CHK_FUNC(popcnt_b, u);
	u = 0x00000001;
	CHK_FUNC(popcnt_a, u);
	CHK_FUNC(popcnt_b, u);
	u = 0x00000011;
	CHK_FUNC(popcnt_a, u);
	CHK_FUNC(popcnt_b, u);
	u = 0x00001111;
	CHK_FUNC(popcnt_a, u);
	CHK_FUNC(popcnt_b, u);
	u = 0x11111111;
	CHK_FUNC(popcnt_a, u);
	CHK_FUNC(popcnt_b, u);
	u = 0x55555555;
	CHK_FUNC(popcnt_a, u);
	CHK_FUNC(popcnt_b, u);
	u = 0xFFFFFFFF;
	CHK_FUNC(popcnt_a, u);
	CHK_FUNC(popcnt_b, u);

	return 0;
}
