// $Id: attack.c,v 1.2 2010-03-29 01:23:29 eiki Exp $

#include <assert.h>
#include <stdlib.h>
#include "bonasse.h"
#include "shogi.h"


unsigned int
is_pinned_on_white_king( const tree_t * restrict ptree, int isquare,
			int idirec )
{
  unsigned int ubb_attacks;
  bitboard_t bb_attacks, bb_attacker;

  switch ( idirec )
    {
    case direc_rank:
      ubb_attacks = AttackRank( isquare );
      if ( ubb_attacks & (BB_WKING.p[aslide[isquare].ir0]) )
	{
	  return ubb_attacks & BB_B_RD.p[aslide[isquare].ir0];
	}
      break;

    case direc_file:
      bb_attacks = AttackFile( isquare );
      if ( BBContract( bb_attacks, BB_WKING ) )
	{
	  BBAnd( bb_attacker, BB_BLANCE, abb_plus_rays[isquare] );
	  BBOr( bb_attacker, bb_attacker, BB_B_RD );
	  return BBContract( bb_attacks, bb_attacker );  /* return! */
	}
      break;

    case direc_diag1:
      bb_attacks = AttackDiag1( isquare );
      if ( BBContract( bb_attacks, BB_WKING ) )
	{
	  return BBContract( bb_attacks, BB_B_BH );      /* return! */
	}
      break;

    default:
      assert( idirec == direc_diag2 );
      bb_attacks = AttackDiag2( isquare );
      if ( BBContract( bb_attacks, BB_WKING ) )
	{
	  return BBContract( bb_attacks, BB_B_BH );      /* return! */
	}
      break;
    }
  
  return 0;
}


unsigned int
is_pinned_on_black_king( const tree_t * restrict ptree, int isquare,
			int idirec )
{
  unsigned int ubb_attacks;
  bitboard_t bb_attacks, bb_attacker;

  switch ( idirec )
    {
    case direc_rank:
      ubb_attacks = AttackRank( isquare );
      if ( ubb_attacks & (BB_BKING.p[aslide[isquare].ir0]) )
	{
	  return ubb_attacks & BB_W_RD.p[aslide[isquare].ir0];
	}
      break;

    case direc_file:
      bb_attacks = AttackFile( isquare );
      if ( BBContract( bb_attacks, BB_BKING ) )
	{
	  BBAnd( bb_attacker, BB_WLANCE, abb_minus_rays[isquare] );
	  BBOr( bb_attacker, bb_attacker, BB_W_RD );
	  return BBContract( bb_attacks, bb_attacker );      /* return! */
	}
      break;

    case direc_diag1:
      bb_attacks = AttackDiag1( isquare );
      if ( BBContract( bb_attacks, BB_BKING ) )
	{
	  return BBContract( bb_attacks, BB_W_BH );          /* return! */
	}
      break;

    default:
      assert( idirec == direc_diag2 );
      bb_attacks = AttackDiag2( isquare );
      if ( BBContract( bb_attacks, BB_BKING ) )
	{
	  return BBContract( bb_attacks, BB_W_BH );          /* return! */
	}
      break;
    }
  return 0;
}


/* perpetual check detections are omitted. */
int
is_mate_b_pawn_drop( tree_t * restrict ptree, int sq_drop )
{
  bitboard_t bb, bb_sum, bb_move;
  int iwk, ito, iret, ifrom, idirec;

  BBAnd( bb_sum, BB_WKNIGHT, abb_b_knight_attacks[sq_drop] );

  BBAndOr( bb_sum, BB_WSILVER, abb_b_silver_attacks[sq_drop] );
  BBAndOr( bb_sum, BB_WTGOLD, abb_b_gold_attacks[sq_drop] );

  AttackBishop( bb, sq_drop );
  BBAndOr( bb_sum, BB_W_BH, bb );

  AttackRook( bb, sq_drop );
  BBAndOr( bb_sum, BB_W_RD, bb );

  BBOr( bb, BB_WHORSE, BB_WDRAGON );
  BBAndOr( bb_sum, bb, abb_king_attacks[sq_drop] );

  while ( BBToU( bb_sum ) )
    {
      ifrom  = FirstOne( bb_sum );
      Xor( ifrom, bb_sum );

      if ( IsDiscoverWK( ifrom, sq_drop ) ) { continue; }
      return 0;
    }

  iwk  = SQ_WKING;
  iret = 1;
  Xor( sq_drop, BB_BOCCUPY );
  XorFile( sq_drop, OCCUPIED_FILE );
  XorDiag2( sq_drop, OCCUPIED_DIAG2 );
  XorDiag1( sq_drop, OCCUPIED_DIAG1 );
  
  BBNot( bb_move, BB_WOCCUPY );
  BBAnd( bb_move, bb_move, abb_king_attacks[iwk] );
  while ( BBToU( bb_move ) )
    {
      ito = FirstOne( bb_move );
      if ( ! is_white_attacked( ptree, ito ) )
	{
	  iret = 0;
	  break;
	}
      Xor( ito, bb_move );
    }

  Xor( sq_drop, BB_BOCCUPY );
  XorFile( sq_drop, OCCUPIED_FILE );
  XorDiag2( sq_drop, OCCUPIED_DIAG2 );
  XorDiag1( sq_drop, OCCUPIED_DIAG1 );

  return iret;
}


int
is_mate_w_pawn_drop( tree_t * restrict ptree, int sq_drop )
{
  bitboard_t bb, bb_sum, bb_move;
  int ibk, ito, ifrom, iret, idirec;

  BBAnd( bb_sum, BB_BKNIGHT, abb_w_knight_attacks[sq_drop] );

  BBAndOr( bb_sum, BB_BSILVER, abb_w_silver_attacks[sq_drop] );
  BBAndOr( bb_sum, BB_BTGOLD,  abb_w_gold_attacks[sq_drop] );

  AttackBishop( bb, sq_drop );
  BBAndOr( bb_sum, BB_B_BH, bb );

  AttackRook( bb, sq_drop );
  BBAndOr( bb_sum, BB_B_RD, bb );

  BBOr( bb, BB_BHORSE, BB_BDRAGON );
  BBAndOr( bb_sum, bb, abb_king_attacks[sq_drop] );

  while ( BBToU( bb_sum ) )
    {
      ifrom  = FirstOne( bb_sum );
      Xor( ifrom, bb_sum );

      if ( IsDiscoverBK( ifrom, sq_drop ) ) { continue; }
      return 0;
    }

  ibk  = SQ_BKING;
  iret = 1;
  Xor( sq_drop, BB_WOCCUPY );
  XorFile( sq_drop, OCCUPIED_FILE );
  XorDiag2( sq_drop, OCCUPIED_DIAG2 );
  XorDiag1( sq_drop, OCCUPIED_DIAG1 );
  
  BBNot( bb_move, BB_BOCCUPY );
  BBAnd( bb_move, bb_move, abb_king_attacks[ibk] );
  while ( BBToU( bb_move ) )
    {
      ito = FirstOne( bb_move );
      if ( ! is_black_attacked( ptree, ito ) )
	{
	  iret = 0;
	  break;
	}
      Xor( ito, bb_move );
    }

  Xor( sq_drop, BB_WOCCUPY );
  XorFile( sq_drop, OCCUPIED_FILE );
  XorDiag2( sq_drop, OCCUPIED_DIAG2 );
  XorDiag1( sq_drop, OCCUPIED_DIAG1 );

  return iret;
}


bitboard_t
attacks_to_piece( const tree_t * restrict ptree, int sq )
{
#ifndef USE_SSE
  bitboard_t bb_ret, bb_attacks, bb;

  BBIni( bb_ret );
  if ( sq < rank9*nfile && BOARD[sq+nfile] == pawn )
    {
      bb_ret = abb_mask[sq+nfile];
    }
  if ( sq >= nfile && BOARD[sq-nfile] == -pawn )
    {
      BBOr( bb_ret, bb_ret, abb_mask[sq-nfile] );
    }

  BBAndOr( bb_ret, BB_BKNIGHT, abb_w_knight_attacks[sq] );
  BBAndOr( bb_ret, BB_WKNIGHT, abb_b_knight_attacks[sq] );

  BBAndOr( bb_ret, BB_BSILVER, abb_w_silver_attacks[sq] );
  BBAndOr( bb_ret, BB_WSILVER, abb_b_silver_attacks[sq] );

  BBAndOr( bb_ret, BB_BTGOLD,  abb_w_gold_attacks[sq] );
  BBAndOr( bb_ret, BB_WTGOLD,  abb_b_gold_attacks[sq] );

  BBOr( bb, BB_B_HDK, BB_W_HDK );
  BBAndOr( bb_ret, bb, abb_king_attacks[sq] );

  BBOr( bb, BB_B_BH, BB_W_BH );
  AttackBishop( bb_attacks, sq );
  BBAndOr( bb_ret, bb, bb_attacks );

  BBOr( bb, BB_B_RD, BB_W_RD );
  bb_ret.p[aslide[sq].ir0]
    |= bb.p[aslide[sq].ir0] & AttackRank( sq );
  
  BBAndOr( bb, BB_BLANCE, abb_plus_rays[sq] );
  BBAndOr( bb, BB_WLANCE, abb_minus_rays[sq] );
  bb_attacks = AttackFile( sq );
  BBAndOr( bb_ret, bb, bb_attacks );
  
  return bb_ret;
#else
  __m128i bb_ret, bb_attacks, bb;

  BBIniS( bb_ret );
  if ( sq < rank9*nfile && BOARD[sq+nfile] == pawn )
    {
      bb_ret = castbb(abb_mask[sq+nfile]);
    }
  if ( sq >= nfile && BOARD[sq-nfile] == -pawn )
    {
      BBOrS( bb_ret, bb_ret, abb_mask[sq-nfile] );
    }

  BBAndOrS( bb_ret, BB_BKNIGHT, abb_w_knight_attacks[sq] );
  BBAndOrS( bb_ret, BB_WKNIGHT, abb_b_knight_attacks[sq] );

  BBAndOrS( bb_ret, BB_BSILVER, abb_w_silver_attacks[sq] );
  BBAndOrS( bb_ret, BB_WSILVER, abb_b_silver_attacks[sq] );

  BBAndOrS( bb_ret, BB_BTGOLD,  abb_w_gold_attacks[sq] );
  BBAndOrS( bb_ret, BB_WTGOLD,  abb_b_gold_attacks[sq] );

  BBOrS( bb, BB_B_HDK, BB_W_HDK );
  BBAndOrS( bb_ret, bb, abb_king_attacks[sq] );

  BBOrS( bb, BB_B_BH, BB_W_BH );
  AttackBishopS( bb_attacks, sq );
  BBAndOrS( bb_ret, bb, bb_attacks );

  BBOrS( bb, BB_B_RD, BB_W_RD );

  //bb_ret.p[aslide[sq].ir0]
  //  |= bb.p[aslide[sq].ir0] & AttackRank( sq );
  bb_ret = _mm_or_si128( bb_ret, _mm_and_si128( bb, AttackRankS( sq ) ) );
  
  BBAndOrS( bb, BB_BLANCE, abb_plus_rays[sq] );
  BBAndOrS( bb, BB_WLANCE, abb_minus_rays[sq] );
  bb_attacks = AttackFileS( sq );
  BBAndOrS( bb_ret, bb, bb_attacks );
  
  return castmm(bb_ret);
#endif
}


unsigned int
is_white_attacked( const tree_t * restrict ptree, int sq )
{
#ifndef USE_SSE
  bitboard_t bb;
  unsigned int u;

  u  = BBContract( BB_BPAWN_ATK, abb_mask[sq] );
  u |= BBContract( BB_BKNIGHT,   abb_w_knight_attacks[sq] );
  u |= BBContract( BB_BSILVER,   abb_w_silver_attacks[sq] );
  u |= BBContract( BB_BTGOLD,    abb_w_gold_attacks[sq] );
  u |= BBContract( BB_B_HDK,     abb_king_attacks[sq] );

  AttackBishop( bb, sq );
  u |= BBContract( BB_B_BH, bb );

  u |= BB_B_RD.p[aslide[sq].ir0] & AttackRank( sq );

  bb = AttackFile( sq );
  u |= ( ( BB_BLANCE.p[0] & abb_plus_rays[sq].p[0] )
	 | BB_B_RD.p[0] ) & bb.p[0];
  u |= ( ( BB_BLANCE.p[1] & abb_plus_rays[sq].p[1] )
	       | BB_B_RD.p[1] ) & bb.p[1];
  u |= ( ( BB_BLANCE.p[2] & abb_plus_rays[sq].p[2] )
	       | BB_B_RD.p[2] ) & bb.p[2];

  return u;
#else
  bitboard_t btb;
  __m128i bb, u, bb2;
  int u0, u1, u2, u3, u4, u5;

  BBAndS(u, BB_BPAWN_ATK, abb_mask[sq] );
  BBAndOrS( u, BB_BKNIGHT,   abb_w_knight_attacks[sq] );
  BBAndOrS( u, BB_BSILVER,   abb_w_silver_attacks[sq] );
  BBAndOrS( u, BB_BTGOLD ,   abb_w_gold_attacks[sq] );
  BBAndOrS( u, BB_B_HDK   ,   abb_king_attacks[sq] );

  AttackBishopS( bb, sq );
  BBAndOrS( u, BB_B_BH   ,   bb );

  bb = AttackRankS( sq );
  BBAndOrS( u, BB_B_RD   ,   bb );

  bb = AttackFileS( sq );
  BBAndS(bb2, BB_BLANCE , abb_plus_rays[sq] );
  BBOrS(bb2, BB_B_RD , bb2 );
  BBAndOrS( u, bb2   ,   bb );

#ifndef USE_SSE4
  //return ((u != MMZERO) ? 1 : 0);
  u0 = _mm_extract_epi16(u, 0);
  u1 = _mm_extract_epi16(u, 1);
  u2 = _mm_extract_epi16(u, 2);
  u3 = _mm_extract_epi16(u, 3);
  u4 = _mm_extract_epi16(u, 4);
  u5 = _mm_extract_epi16(u, 5);
  return (((u0 | u1 | u2 | u3 | u4 | u5) != 0) ? 1 : 0); // BBContract() may be faster?
#else
  return BBToUS(u);
#endif
#endif
}


unsigned int
is_black_attacked( const tree_t * restrict ptree, int sq )
{
#ifndef USE_SSE
  bitboard_t bb;
  unsigned int u;

  u  = BBContract( BB_WPAWN_ATK, abb_mask[sq] );
  u |= BBContract( BB_WKNIGHT,   abb_b_knight_attacks[sq] );
  u |= BBContract( BB_WSILVER,   abb_b_silver_attacks[sq] );
  u |= BBContract( BB_WTGOLD,    abb_b_gold_attacks[sq] );
  u |= BBContract( BB_W_HDK,     abb_king_attacks[sq] );

  AttackBishop( bb, sq );
  u |= BBContract( BB_W_BH, bb );

  u |= BB_W_RD.p[aslide[sq].ir0] & AttackRank( sq );

  bb = AttackFile( sq );
  u |= ( ( BB_WLANCE.p[0] & abb_minus_rays[sq].p[0] )
	 | BB_W_RD.p[0] ) & bb.p[0];
  u |= ( ( BB_WLANCE.p[1] & abb_minus_rays[sq].p[1] )
	       | BB_W_RD.p[1] ) & bb.p[1];
  u |= ( ( BB_WLANCE.p[2] & abb_minus_rays[sq].p[2] )
	       | BB_W_RD.p[2] ) & bb.p[2];

  return u;
#else
  bitboard_t btb;
  __m128i bb, u, bb2;
  int u0, u1, u2, u3, u4, u5;

  BBAndS(u, BB_WPAWN_ATK, abb_mask[sq] );
  BBAndOrS( u, BB_WKNIGHT,   abb_b_knight_attacks[sq] );
  BBAndOrS( u, BB_WSILVER,   abb_b_silver_attacks[sq] );
  BBAndOrS( u, BB_WTGOLD ,   abb_b_gold_attacks[sq] );
  BBAndOrS( u, BB_W_HDK   ,   abb_king_attacks[sq] );

  AttackBishopS( bb, sq );
  BBAndOrS( u, BB_W_BH   ,   bb );

  bb = AttackRankS( sq );
  BBAndOrS( u, BB_W_RD   ,   bb );

  bb = AttackFileS( sq );
  BBAndS(bb2, BB_WLANCE , abb_minus_rays[sq] );
  BBOrS(bb2, BB_W_RD , bb2 );
  BBAndOrS( u, bb2   ,   bb );

#ifndef USE_SSE4
  //return ((u != MMZERO) ? 1 : 0);
  u0 = _mm_extract_epi16(u, 0);
  u1 = _mm_extract_epi16(u, 1);
  u2 = _mm_extract_epi16(u, 2);
  u3 = _mm_extract_epi16(u, 3);
  u4 = _mm_extract_epi16(u, 4);
  u5 = _mm_extract_epi16(u, 5);
  return (((u0 | u1 | u2 | u3 | u4 | u5) != 0) ? 1 : 0); // BBContract() may be faster?
#else
  return BBToUS(u);
#endif
#endif
}
