// $Id: diffeval.c,v 1.18 2010-05-10 10:56:58 eiki Exp $
#include "shogi.h"

#define DBG_DIFEV 0

#if !defined(_MSC_VER)
#define max(a,b) ((a)>(b) ? (a) : (b))
#define min(a,b) ((a)<(b) ? (a) : (b))
#endif

#define PcPcOnSqAny( k, i, j )  PcPcOnSq(k, max(i, j), min(i, j))

static const int prompoint[8] = { 0,
 MT_PRO_PAWN,
 MT_PRO_LANCE,
 MT_PRO_KNIGHT,
 MT_PRO_SILVER,
 0,
 MT_PRO_BISHOP,
 MT_PRO_ROOK
};

static const int cappoint[16] = { 0,
 MT_CAP_PAWN,
 MT_CAP_LANCE,
 MT_CAP_KNIGHT,
 MT_CAP_SILVER,
 MT_CAP_GOLD,
 MT_CAP_BISHOP,
 MT_CAP_ROOK,
 0,
 MT_CAP_PRO_PAWN,
 MT_CAP_PRO_LANCE,
 MT_CAP_PRO_KNIGHT,
 MT_CAP_PRO_SILVER,
 0,
 MT_CAP_HORSE,
 MT_CAP_DRAGON 
};

static const int pc2suf[31] = {
 e_dragon, e_horse, e_gold, e_gold, e_gold, e_gold, e_gold, 0,
 e_rook, e_bishop, e_gold, e_silver, e_knight, e_lance, e_pawn,
 0,
 f_pawn, f_lance, f_knight, f_silver, f_gold, f_bishop, f_rook, 0,
 f_gold, f_gold, f_gold, f_gold, f_gold, f_horse, f_dragon
};

static const int handbase[14] = {
 f_hand_pawn, e_hand_pawn,
 f_hand_lance, e_hand_lance,
 f_hand_knight, e_hand_knight,
 f_hand_silver, e_hand_silver,
 f_hand_gold, e_hand_gold,
 f_hand_bishop, e_hand_bishop,
 f_hand_rook, e_hand_rook 
};

static const int kkphandbase[8] = {
 0,
 kkp_hand_pawn, 
 kkp_hand_lance,
 kkp_hand_knight,
 kkp_hand_silver,
 kkp_hand_gold,
 kkp_hand_bishop,
 kkp_hand_rook 
};

static const int kkpbase[16] = {
 0,
 kkp_pawn, 
 kkp_lance,
 kkp_knight,
 kkp_silver,
 kkp_gold,
 kkp_bishop,
 kkp_rook,
 0,
 kkp_gold, 
 kkp_gold,
 kkp_gold,
 kkp_gold,
 kkp_gold,
 kkp_horse,
 kkp_dragon
};

 //****

static int doapc(tree_t * restrict ptree, int pc0, int sq0,
                 int *list0, int *list1, int nlist) {
 int /*sq,*/ i, kkpv;
 int sum = 0;
 int suf0b = pc2suf[15+pc0] + sq0;
 int suf0w = pc2suf[15-pc0] + Inv(sq0);
 int sq_bk0 = SQ_BKING;
 int sq_wk0 = SQ_WKING;
 int sq_bk1 = Inv(sq_wk0);
 int sq_wk1 = Inv(sq_bk0);
 int sq_bk  = sq_bk0;
 int sq_wk  = sq_bk1;

 if (DBG_DIFEV)
   printf("dopc : pc %d sq %d%d sqbk %d%d sqwk %d%d sufb %d sufw %d\n",
                   pc0, 9-sq0%9, 1+sq0/9, sq2x(sq_bk), sq2y(sq_bk),
                               sq2x(sq_wk), sq2y(sq_wk), suf0b, suf0w);

#if 0
 for(sq=0; sq<=80; sq++) {
   int pc = BOARD[sq];
   if (pc&7) {  // omit kings and empty
     int pcsufb = pc2suf[15+pc] + sq;
     int pcsufw = pc2suf[15-pc] + Inv(sq);
     int vp = PcPcOnSqAny( sq_bk, suf0b, pcsufb );
     int vm = PcPcOnSqAny( sq_wk, suf0w, pcsufw );
     sum += vp - vm;
     if (0 && DBG_DIFEV) {
       int b1 = max(suf0b, pcsufb);
       int b2 = min(suf0b, pcsufb);
       int w1 = max(suf0w, pcsufw);
       int w2 = min(suf0w, pcsufw);
       //intf("vp %d: pc %d sq %d%d pcsufb %d\n", vp, pc, 9-sq%9,1+sq/9,pcsufb);
       //intf("vm %d:               pcsufw %d\n", vm,                   pcsufw);
       printf("k0 %s   l0 %s   vp %4d\n", kpptrans(b1), kpptrans2(b2), vp);
       printf("k1 %s   l1 %s   vm %4d\n", kpptrans(w1), kpptrans2(w2), vm);

     }
   }
 }
#else
 for(i=14; i<nlist; i++) {
     int vp = PcPcOnSqAny( sq_bk, suf0b, list0[i]);
     int vm = PcPcOnSqAny( sq_wk, suf0w, list1[i]);
     sum += vp - vm;
     if (1 && DBG_DIFEV) {
       //intf("vp %d: i %d list0i %d\n", vp, i, list0[i]);
       //intf("vm %d:      list1i %d\n", vm,    list1[i]);
       printf("k0 %s   l0 %s   vp %4d\n", kpptrans(suf0b), kpptrans2(list0[i]), vp);
       printf("k1 %s   l1 %s   vm %4d\n", kpptrans(suf0w), kpptrans2(list1[i]), vm);
     }
 }
#endif

 for(i=0; i<=13; i++) {
     int vp = PcPcOnSq( sq_bk, suf0b, list0[i]);
     int vm = PcPcOnSq( sq_wk, suf0w, list1[i]);
     sum += vp - vm;
     if (1 && DBG_DIFEV) {
       //intf("vp %d: i %d list0i %d\n", vp, i, list0[i]);
       //intf("vm %d:      list1i %d\n", vm,    list1[i]);
       printf("k0 %s   l0 %s   vp %4d\n", kpptrans(suf0b), kpptrans2(list0[i]), vp);
       printf("k1 %s   l1 %s   vm %4d\n", kpptrans(suf0w), kpptrans2(list1[i]), vm);
     }
 }

 assert(abs(pc0) != king);
 kkpv = 0;
 if (pc0>0)
   kkpv =  kkp[sq_bk0][sq_wk0][ kkpbase[pc0] + sq0 ];
 if (pc0<0)
   kkpv = -kkp[sq_bk1][sq_wk1][ kkpbase[-pc0] + Inv(sq0) ];
 if (pc0!=0)
   sum += kkpv;

 if (DBG_DIFEV)
   printf("dopc returning: sum %d  kkpv %d\n", sum, kkpv);

 return sum;
}

 //****

static int doacapt(tree_t * restrict ptree, int pc0, int sd0,
                 int *list0, int *list1, int* curhand, int nlist) {
 int /*sq,*/ i, kkpv;
 int sum = 0;
 int suf0b = list0[ (pc0-1) * 2 + sd0 ];
 int suf0w = list1[ (pc0-1) * 2 + 1 - sd0 ];
 int sq_bk0 = SQ_BKING;
 int sq_wk0 = SQ_WKING;
 int sq_bk1 = Inv(sq_wk0);
 int sq_wk1 = Inv(sq_bk0);
 int sq_bk  = sq_bk0;
 int sq_wk  = sq_bk1;
 assert(0<pc0 && pc0<8);
 if (DBG_DIFEV)
   printf("docapt: pc %d sd %d\n", pc0, sd0);

#if 0
 for(sq=0; sq<=80; sq++) {
   int pc = BOARD[sq];
   if (pc&7) {  // omit kings and empty
     int pcsufb = pc2suf[15+pc] + sq;
     int pcsufw = pc2suf[15-pc] + Inv(sq);
     sum += PcPcOnSq( sq_bk, pcsufb, suf0b );
     sum -= PcPcOnSq( sq_wk, pcsufw, suf0w );
   }
 }
#else
 for(i=14; i<nlist; i++) {
     sum += PcPcOnSq( sq_bk, list0[i], suf0b);
     sum -= PcPcOnSq( sq_wk, list1[i], suf0w);
 }
#endif

 for(i=0; i<=13; i++) {
     sum += PcPcOnSqAny( sq_bk, list0[i], suf0b);
     sum -= PcPcOnSqAny( sq_wk, list1[i], suf0w);
 }

 if (!sd0)
   kkpv =  kkp[sq_bk0][sq_wk0][ kkphandbase[pc0] + curhand[2*(pc0-1)  ] ];
 else
   kkpv = -kkp[sq_bk1][sq_wk1][ kkphandbase[pc0] + curhand[2*(pc0-1)+1] ];
 sum += kkpv;

 if (DBG_DIFEV)
   printf("docapt returning: sum %d  kkpv %d\n", sum, kkpv);

 return sum;
}


 //****

#ifdef INANIWA_SHIFT
//int inaniwaSide;   // set in client_next_game() in sckt.c  B:0 W:1 else:-1
 // after this many move, eval adjust for inaniwa is turned off
//#define MAX_INANIWA_NREP  70
 // in inaniwa mode, EY value decreased this much, F value increased this much
#define EYF_ADJUST       210

static int  calcInaniwaAdjust(tree_t * restrict ptree, int turn) {
 int ey, f, x;
 f  = PopuCount(BB_BPAWN) + PopuCount(BB_BPRO_PAWN) + I2HandPawn(HAND_B)
    -(PopuCount(BB_WPAWN) + PopuCount(BB_WPRO_PAWN) + I2HandPawn(HAND_W));
 ey = PopuCount(BB_BLANCE) + PopuCount(BB_BPRO_LANCE) + I2HandLance(HAND_B)
    -(PopuCount(BB_WLANCE) + PopuCount(BB_WPRO_LANCE) + I2HandLance(HAND_W))
    + PopuCount(BB_BKNIGHT) + PopuCount(BB_BPRO_KNIGHT) + I2HandKnight(HAND_B)
    -(PopuCount(BB_WKNIGHT) + PopuCount(BB_WPRO_KNIGHT) +I2HandKnight(HAND_W));
 x = (f - ey) * EYF_ADJUST;
 return (turn ? -x : x);
}
#endif

int
evaluate( tree_t * restrict ptree, int ply, int turn )
{
   // TURN is current turn. i.e. move was made by (1-TURN)

  int list0[52], list1[52], curhand[14];
  //int nlist, score, sq_bk, sq_wk, k0, k1, l0, l1, i, j, sum, lastmv, pcmv;
  int nlist, score, lastmv, pcmv;
  int lastScore, sq_bk0, sq_bk1, sq_wk0, sq_wk1, fr, to, prom, cap, dstpc;
  int tgtpc, srcpc, droppc, sq;
#ifdef INANIWA_SHIFT
  int inaniwaAdjust;
#endif
  int correctval;  // for debug
  short scaledScore;

  lastmv = MOVE_LAST;

  if (DBG_DIFEV) {
    fr = I2From(lastmv);
    to = I2To(lastmv);
    prom = I2IsPromote(lastmv);
    cap = UToCap(lastmv);
    dstpc = BOARD[to];
    droppc = From2Drop(fr);
    lastScore = ptree->stand_pat[ply-1];
    printf("\neval start: ply %d last %d  mv: %d%d%d%d%d\n", ply, lastScore, 
            (prom?1:0), 9-fr%9, fr/9+1, 9-to%9, 1+to/9);
    //if (lastmv == MOVE_PASS)
    //  printf("WARNING: mv is a pass\n");
  }

  ptree->neval_called++;

#ifdef INANIWA_SHIFT
  inaniwaAdjust = 0;
  if (inaniwaSide >= 0 /* fighting against inaniwa */ &&
      root_nrep < MAX_INANIWA_NREP)
    inaniwaAdjust = calcInaniwaAdjust(ptree, turn);
#endif

  if ( ptree->stand_pat[ply] != score_bound )
    {
      if (DBG_DIFEV)
        printf("eval returning: ply %d standpat %d\n",
               ply, (int)ptree->stand_pat[ply]);
      //return (int)ptree->stand_pat[ply] + inaniwaAdjust;
      return (int)ptree->stand_pat[ply];
    }

  if ( ehash_probe( HASH_KEY, HAND_B, &score ) )
    {
      scaledScore = (short)(MATERIAL + (score - MATERIAL*FV_SCALE) / FV_SCALE);
      score                 = turn ? -score : score;
      scaledScore                 = turn ? -scaledScore : scaledScore;
#ifdef INANIWA_SHIFT
      scaledScore                += inaniwaAdjust;
#endif
      //scaledScore           = (short)(score / FV_SCALE);
      ptree->stand_pat[ply] = scaledScore;
      ptree->stand_pat_full[ply] = score;

      if (DBG_DIFEV)
        printf("eval returning: ply %d ehash %d\n", ply, score);
      return scaledScore;
    }

  //****

  lastmv = MOVE_LAST;
  pcmv = I2PieceMove(lastmv);
  lastScore = ptree->stand_pat_full[ply-1];
  if (ply <= 1 || lastScore == score_bound*FV_SCALE // last score cannot be used
               || pcmv == king             ) {
    score = evaluateScratch( ptree, ply, turn ); // std_pat, ehash set inside
    return score;   // evalScr does turn-flip
  }

  if (lastmv == MOVE_PASS) {
#if 1
    assert(0);   // null prune case; must hit stand_pat
#else
    lastScore = -lastScore;
    ptree->stand_pat_full[ply] = lastScore;
    scaledScore = lastScore / FV_SCALE;
    ptree->stand_pat[ply] = scaledScore;
#ifndef NDEBUG
    correctval = evaluateScratch(ptree, ply, turn);
    if (DBG_DIFEV) {
      printf("val: %d  correct: %d\n", scaledScore, correctval);
      fflush(NULL);
    }
    assert(scaledScore == correctval);
#endif
    return scaledScore;
#endif
  }

  if (!turn)
    lastScore = -lastScore;

   // ply-1 value available.  now calculate differential
  nlist = 14;
  score  = 0;
  sq_bk0 = SQ_BKING;
  sq_wk0 = SQ_WKING;
  sq_bk1 = Inv(SQ_WKING);
  sq_wk1 = Inv(SQ_BKING);
  
  list0[ 0] = f_hand_pawn   + I2HandPawn(HAND_B);
  list0[ 1] = e_hand_pawn   + I2HandPawn(HAND_W);
  list0[ 2] = f_hand_lance  + I2HandLance(HAND_B);
  list0[ 3] = e_hand_lance  + I2HandLance(HAND_W);
  list0[ 4] = f_hand_knight + I2HandKnight(HAND_B);
  list0[ 5] = e_hand_knight + I2HandKnight(HAND_W);
  list0[ 6] = f_hand_silver + I2HandSilver(HAND_B);
  list0[ 7] = e_hand_silver + I2HandSilver(HAND_W);
  list0[ 8] = f_hand_gold   + I2HandGold(HAND_B);
  list0[ 9] = e_hand_gold   + I2HandGold(HAND_W);
  list0[10] = f_hand_bishop + I2HandBishop(HAND_B);
  list0[11] = e_hand_bishop + I2HandBishop(HAND_W);
  list0[12] = f_hand_rook   + I2HandRook(HAND_B);
  list0[13] = e_hand_rook   + I2HandRook(HAND_W);

  list1[ 0] = f_hand_pawn   + I2HandPawn(HAND_W);
  list1[ 1] = e_hand_pawn   + I2HandPawn(HAND_B);
  list1[ 2] = f_hand_lance  + I2HandLance(HAND_W);
  list1[ 3] = e_hand_lance  + I2HandLance(HAND_B);
  list1[ 4] = f_hand_knight + I2HandKnight(HAND_W);
  list1[ 5] = e_hand_knight + I2HandKnight(HAND_B);
  list1[ 6] = f_hand_silver + I2HandSilver(HAND_W);
  list1[ 7] = e_hand_silver + I2HandSilver(HAND_B);
  list1[ 8] = f_hand_gold   + I2HandGold(HAND_W);
  list1[ 9] = e_hand_gold   + I2HandGold(HAND_B);
  list1[10] = f_hand_bishop + I2HandBishop(HAND_W);
  list1[11] = e_hand_bishop + I2HandBishop(HAND_B);
  list1[12] = f_hand_rook   + I2HandRook(HAND_W);
  list1[13] = e_hand_rook   + I2HandRook(HAND_B);

  curhand[ 0] = I2HandPawn(HAND_B);
  curhand[ 1] = I2HandPawn(HAND_W);
  curhand[ 2] = I2HandLance(HAND_B);
  curhand[ 3] = I2HandLance(HAND_W);
  curhand[ 4] = I2HandKnight(HAND_B);
  curhand[ 5] = I2HandKnight(HAND_W);
  curhand[ 6] = I2HandSilver(HAND_B);
  curhand[ 7] = I2HandSilver(HAND_W);
  curhand[ 8] = I2HandGold(HAND_B);
  curhand[ 9] = I2HandGold(HAND_W);
  curhand[10] = I2HandBishop(HAND_B);
  curhand[11] = I2HandBishop(HAND_W);
  curhand[12] = I2HandRook(HAND_B);
  curhand[13] = I2HandRook(HAND_W);

  fr = I2From(lastmv);
  to = I2To(lastmv);
  dstpc = BOARD[to];

  for(sq=0; sq<=80; sq++) {
   int pc = BOARD[sq];
   if (sq==fr || sq==to) continue;  // omit dst and src

   if (pc&7) {  // omit kings and empty
     int pcsufb = pc2suf[15+pc] + sq;
     int pcsufw = pc2suf[15-pc] + Inv(sq);
     list0[nlist  ] = pcsufb;
     list1[nlist++] = pcsufw;
   }
  }

  {   // dst comes last
     int pcsufb;
     int pcsufw;
     sq=to;
     pcsufb = pc2suf[15+dstpc] + sq;
     pcsufw = pc2suf[15-dstpc] + Inv(sq);
     list0[nlist  ] = pcsufb;
     list1[nlist++] = pcsufw;
  }

  prom = I2IsPromote(lastmv);
  cap = UToCap(lastmv);
  //droppc = fr - nsquare + 1;
  droppc = From2Drop(fr);

  if (DBG_DIFEV) 
    printf("difev start\n");

   // add dst
  score += doapc(ptree, dstpc, to, list0, list1, nlist);

   // remove dst
  //BOARD[to] = empty;
  nlist--;

  if (fr >= nsquare) {  // drop case
    assert(droppc == abs(dstpc));
    if (DBG_DIFEV)
      printf("eval : drop case\n");

    // add capt
    score += doacapt(ptree, droppc, 1-turn, list0, list1, curhand, nlist);

    // incr capt
    list0[2*(droppc-1) + 1 - turn]++;
    list1[2*(droppc-1) +     turn]++;
    curhand[2*(droppc-1) + 1 - turn]++;

    // sub capt+1
    score -= doacapt(ptree, droppc, 1-turn, list0, list1, curhand, nlist);

  } else {  // slide case
    int pcsufb, pcsufw;

    if (DBG_DIFEV)
        printf("eval : slide case fr=%d\n", fr);

    if (cap) {  // tgt exists
      int capnoprom = cap & ~promote;
      if (DBG_DIFEV)
        printf("eval : take case\n");
      // add capt
      score += doacapt(ptree, capnoprom, 1-turn, list0, list1, curhand, nlist);

      // decr capt
      list0[2*(capnoprom-1) + 1 - turn]--;
      list1[2*(capnoprom-1) +     turn]--;
      curhand[2*(capnoprom-1) + 1 - turn]--;

      // sub capt-1
      score -= doacapt(ptree, capnoprom, 1-turn, list0, list1, curhand, nlist);

      // put tgt  NOTE tgt is TURN's pc (not (1-TURN)'s)
      tgtpc = (turn ? -cap : cap);
      //BOARD[to] = tgtpc;
      pcsufb = pc2suf[15+tgtpc] + to;
      pcsufw = pc2suf[15-tgtpc] + Inv(to);
      list0[nlist  ] = pcsufb;
      list1[nlist++] = pcsufw;

      // sub tgt
      score -= doapc(ptree, tgtpc, to, list0, list1, nlist);
    }

    // put src
    srcpc = (turn ? pcmv : -pcmv);
    //BOARD[fr] = srcpc;
    {
      int pcsufb = pc2suf[15+srcpc] + fr;
      int pcsufw = pc2suf[15-srcpc] + Inv(fr);
      list0[nlist  ] = pcsufb;
      list1[nlist++] = pcsufw;
    }

    // sub src
    score -= doapc(ptree, srcpc, fr, list0, list1, nlist);

    // restore src
    //BOARD[fr] = empty;

  } // end slide case

   // restore dst
  //BOARD[to] = dstpc;

  //****

  //score /= FV_SCALE;

  if (prom) {
    if (turn)
      score += prompoint[pcmv] * FV_SCALE;
    else
      score -= prompoint[pcmv] * FV_SCALE;
  }

  if (cap) {
    if (turn)
      score += cappoint[cap] * FV_SCALE;
    else
      score -= cappoint[cap] * FV_SCALE;
  }

  score += lastScore;

#if ! defined(MINIMUM)
  if ( abs(score) > score_max_eval  * FV_SCALE)
    {
      out_warning( "A score at evaluate() is out of bounce." );
    }
#endif

  ehash_store( HASH_KEY, HAND_B, score );

  scaledScore = (short)(MATERIAL + (score - MATERIAL * FV_SCALE) / FV_SCALE);

  score = turn ? -score : score;
  //scaledScore = (short)(score / FV_SCALE);
  scaledScore = turn ? -scaledScore : scaledScore;
#ifdef INANIWA_SHIFT
  scaledScore += inaniwaAdjust;
#endif

#ifndef NDEBUG
  correctval = evaluateScratch(ptree, ply, turn);
  if (DBG_DIFEV) {
    printf("val: %d  correct: %d\n", scaledScore, correctval);
    fflush(NULL);
  }
  //assert(abs(score - correctval) <= ply);
  assert(scaledScore == correctval);
#endif

  ptree->stand_pat[ply] = scaledScore;
  ptree->stand_pat_full[ply] = score;

  return scaledScore;

}

