//
// floodgate̊w\tgm̑΋ǂ̊W񂷂
//
// Bonanzagrecords.csa`ɂȂ
//
#include <windows.h>
#include <vector>
#include <string>
#include <iostream>
#include <fstream>
#include <algorithm>
#include <stdio.h>
#include <time.h>

#define OUTFILE "records0.csa"	// o̓t@C(ߑł)

bool erase_comment = true;	// truêƂRg폜

typedef std::vector<std::string> PlayerList;

PlayerList player;

// g
void Usage()
{
	std::cerr << "fggather [-c] playerlist folder1 [folder2 [folderr3]]" << std::endl
	          << "   -c          RgȂ" << std::endl
	          << "   playerlist  oΏۂLڂt@C" << std::endl
	          << "   folder1     *.csat@CĂfBNgw肷" << std::endl;

	exit(1);
}

// w肳ꂽt@CΏۃ\tgplayerɐݒ肷
int load_player(const char *filename, PlayerList& player)
{
	std::ifstream file;
	file.open(filename);
	if (!file.is_open()) {
		std::cerr << "Error!:" << filename << " cannot open!" << std::endl;
		return -1;
	}

	std::string name;
	while (getline(file, name)) {
		player.push_back(name);
	}
	file.close();
	return 0;
}

// pXƃt@Cێ
//    hoge1\hoge2\file.csa ƂꍇApXɁuhoge1\hoge2vAt@CɁufile.csavݒ肷
struct Filepath {
	std::string path;	// pX
	std::string file;	// t@C
	std::string player1;	// ΋ǎ1
	std::string player2;	// ΋ǎ2
};

// w肳ꂽtH_*.csat@Clistɗ񋓂B̍ہATutH_ċAIɒT
void enumerate_file(const char *path, std::vector<Filepath>& list)
{
	char subpath[MAX_PATH];
	char temp[MAX_PATH];
	WIN32_FIND_DATA lp;
	Filepath a;

	std::cout << "Checking " << path << std::endl;

	// ܂A*.csa񋓂
	sprintf(temp, "%s\\*.csa", path);
	HANDLE h = FindFirstFile(temp, &lp);
	if (h != INVALID_HANDLE_VALUE) {
		do {
			if((lp.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY) != FILE_ATTRIBUTE_DIRECTORY)
			{
				// lp.cFilenameŃt@C
				a.path = path;
				a.file = lp.cFileName;
				list.push_back(a);
			}
		} while (FindNextFile(h, &lp));
		FindClose(h);
	}

	// ɃTutH_ċAIɒT
	sprintf(temp, "%s\\*", path);
	h = FindFirstFile(temp, &lp);
	if (h == INVALID_HANDLE_VALUE) {
		printf("Fail2:[%s]\n", temp);
		return;
	}

	do {
		if((lp.dwFileAttributes & FILE_ATTRIBUTE_DIRECTORY)
		    && strcmp(lp.cFileName, "..") != 0 && strcmp(lp.cFileName, ".") != 0) {
			printf("  find:[%s]\n", lp.cFileName);
			//subpathŃfBNg̃tpX
			sprintf(subpath, "%s\\%s", path, lp.cFileName);
			enumerate_file(subpath, list);
		}
	} while(FindNextFile(h, &lp));

	FindClose(h);
}

// list̊eR[h̃t@Clistɑ΋ǎ҂Zbg
//  t@Cwdoorn܂A'+'؂̌TCgzz̃tH[}bgƉ肵Ă
void find_player(std::vector<Filepath>& list)
{
	char work[MAX_PATH];
	char *s;
	char tmp[5][MAX_PATH];	// tmp[0]:wdoor, tmp[1]:floodgate-900-0, tmp[2]:player1, tmp[3]:player2, tmp[4]:date

	for (std::vector<Filepath>::iterator it = list.begin(); it != list.end(); it++) {
		memset(tmp, 0, sizeof(tmp));
		strcpy(work, it->file.c_str());
		if (it->file.find("wdoor") == 0) {
			s = strtok(work, "+");
			int i;
			for (i = 0; i < 5 && s; i++) {
				strcpy(tmp[i], s);
				s = strtok(NULL, "+");
			}
		}
		if (strstr(tmp[4], ".csa") != NULL) {
			it->player1 = tmp[2];
			it->player2 = tmp[3];
		} else {
			printf("NG [%s\\%s]\n", it->path.c_str(), it->file.c_str());
			it->player1 = "";
			it->player2 = "";
		}
	}
}

// fŎw肳(pX{t@C)t@C̓eĝf
// ̓ecsaɓǂݍށB
// FZ萔łȂ&& {AAԐ؂A錾̂ǂꂩ}
bool is_ok(const Filepath& f, std::vector<std::string>& csa)
{
	char filename[MAX_PATH];
	sprintf(filename, "%s\\%s", f.path.c_str(), f.file.c_str());

	std::ifstream file;
	std::string oneline;
	int n = 0;
	file.open(filename);
	bool bErr = true;
	if (file.is_open()) {
		bErr = false;
		while (getline(file, oneline)) {
			if (oneline[0] == '+' || oneline[0] == '-') n++;
			if (oneline.find("summary") != std::string::npos) {
				// In.
				//   Z萔ł̌(萔5070͓Kj
				//   (萔قȂ)
				//   ([gmł͏ȂĂȂ??)
				if (n > 50 && oneline.find(":toryo:") != std::string::npos) {
					// Z萔̓͑ՑIłĂB
				} else if (n > 50 && oneline.find(":kachi:") != std::string::npos) {
					// Rs[^̓ʊ͂Ȃ
				} else if (n > 70 && oneline.find(":sennichite:") != std::string::npos) {
					// ͏ꍇɂĂ͏قH
				} else if (n > 70 && oneline.find(":time up:") != std::string::npos) {
					// Ԑ؂͎w莩̂ɂ͖Ȃ͂
					// (vlԂZƂɂ鐸xቺ͂ɂc)
				} else {
					// ُn
					// abnormal
					// illegal move
					// oute_sennichite
					bErr = true;
					if (oneline.find(":abnormal:") != std::string::npos) {
					} else if (oneline.find(":illegal move:") != std::string::npos) {
					} else if (oneline.find(":oute_sennichite:") != std::string::npos) {
					} else if (oneline.find(":toryo:") != std::string::npos) {
					} else if (oneline.find(":sennichite:") != std::string::npos) {
					} else if (oneline.find(":time up:") != std::string::npos) {
					} else
					std::cout << "[" << oneline << "]:n=" << n << std::endl;
				}
			}
			if (oneline == "V2") continue;
			if (erase_comment && oneline[0] == '\'') continue;
			csa.push_back(oneline);
		}
		file.close();
	}
	if (bErr) {
		csa.clear();
	}
	return bErr == false;
}

// o̓t@Ccsaœnǉ
void add_csa(const std::vector<std::string>& csa)
{
	std::ofstream file;
	file.open(OUTFILE, std::ios::app);
	if (file.is_open()) {
		for (std::vector<std::string>::const_iterator it = csa.begin(); it != csa.end(); it++) {
			file << *it << std::endl;
		}
		file << "/" << std::endl;
		file.close();
	}
}

// list̃t@CꗗɓKo̓t@CɏW񂷂
int out_csa(const std::vector<Filepath>& list)
{
	PlayerList::iterator p1, p2;
	std::vector<std::string> csa;
	int n = 0;

	// open()/close()邱ƂŁAt@C̃TCYOɂ
	{
		std::ofstream file;
		file.open(OUTFILE);
		file.close();
	}

	for (std::vector<Filepath>::const_iterator it = list.begin(); it != list.end(); it++) {
		if (it->player1 == "") continue;
		if (it->player2 == "") continue;
		p1 = std::find(player.begin(), player.end(), it->player1);
		p2 = std::find(player.begin(), player.end(), it->player2);
		if (p1 != player.end() && p2 != player.end()) {
			// w肳ꂽ\tgm̑΋ǂis_ok()ŖȂƔf
			csa.clear();
			csa.reserve(2000);
			if (is_ok(*it, csa)) {
				add_csa(csa);
				n++;
				if (n % 10 == 0) {
					// ix
					std::cout << ".";
					std::cout.flush();
				}
			}
		}
	}
	std::cout << std::endl;

	return n;
}

int main(int argc, char **argv)
{
	std::vector<Filepath> list;
	clock_t start = clock();

	// `FbN(2ȏKv)
	if (argc < 3) Usage();

	// '-'Ŏn܂IvV̏(A'-c' ̂)
	while (--argc) {
		++argv;
		if (**argv == '-') {
			if (strcmp(*argv, "-c") == 0) {
				erase_comment = false;
				continue;
			} else {
				Usage();
			}
		} else {
			break;
		}
	}

	// Ώۃ\tgŎw肳ꂽt@Cǂݍ݁Aplayerɐݒ肷
	if (argc < 2) Usage();
	if (load_player(*argv, player) < 0) exit(1);
	std::cout << "Player=" << player.size() << std::endl;

	// Ŏw肳ꂽtH_ȉ*.csaɊւpXAt@CAAlistɐݒ肷
	list.reserve(200000);
	while (--argc) {
		enumerate_file(*++argv, list);
	}
	find_player(list);
	std::cout << "t@CF" <<list.size() << std::endl;

	// t@Co
	int n = out_csa(list);
	std::cout << "processed "<< n << " files." << std::endl;

	clock_t end = clock();
	std::cout << "time " << (end-start)/CLOCKS_PER_SEC << " s" << std::endl;

	return 0;
}
