/*   ExportSheet_CS4 v2.0   2009.05.09

      ・TimeSheet_forMac(Win)関係のAE CS4スクリプト用エクスポート・スクリプト。
      ・アクティブコンポ内のスライダのあるレイヤーのキー情報を、AE CS4 の [ 親フォルダ < _SheetData < SheetData.txt ] に書き込み。
      ・保存したシートファイルは、TimeSheet_forWin(Mac).exe(app)で読み込みが可能。 (実行後に自動的に起動)
      ・Windows & Mac 両対応。
      
      
      AfterEffects CS4 のみ動作確認済
      Windows XP Professional SP3 / MacOS 10.5.6 のみ動作確認済
*/



//==========File Path ※違う場合は必ず書き換えてください=====================================================================

var scFile = null;
var tsFile = null;
if(File.fs == "Windows"){
	
                 //親フォルダのパス(Win)
                 scFile = "C:/Program Files/Adobe/Adobe After Effects CS4/Support Files/Scripts/TimeSheet_CS4_forWin";
    	
                 //TimeSheet.exe(Win) のパス
                 tsFile = "C:/Program Files/Adobe/Adobe After Effects CS4/Support Files/Scripts/TimeSheet_CS4_forWin/TimeSheet_forWin.exe";
    
}else if(File.fs == "Macintosh"){
	
                 //親フォルダのパス(Mac)
                 scFile  = "/Applications/Adobe After Effects CS4/Scripts/TimeSheet_CS4_forMac";
    
                //TimeSheet.app(Mac) のパス
                tsFile = "/Applications/Adobe After Effects CS4/Scripts/TimeSheet_CS4_forMac/TimeSheet_forMac.app";
    
}	

//=======================================================================================

var dirFol = null;
var actComp = app.project;
var actItem = actComp.activeItem;
var fRate = actItem.frameRate;   
var cName = actItem.name.toString();
var actLys = actItem.selectedLayers;
var allLys = actItem.layers;
var compLys = new Array();
var lyTime = actItem.duration;
var lyFr = Math.floor(lyTime*actItem.frameRate);
var valD = false;
var valE = false;

var compLysQ = new Array();
var numSL = new Array();
var lyNames = new Array();
var outData = new Array();
var wData;
var PrData = new Array();
var valEXE = false;

//===========main script===================================================================


    //レイヤーを選択していた場合
    if(actLys.length > 0)
    {
    		//インデックス順に並び替え
    	    iii=0;
    	    for(i=0;i<allLys.length;i++)
    	    {
    		    for(ii=0;ii<actLys.length;ii++)
    		    {
    		     	if(i+1 == actLys[ii].index)
    		     	{
    		    		    compLys[iii] = actLys[ii];
    				        iii++
    			    }
    		    }
    	    }
    //レイヤーが選択されていない場合(全てのレイヤーが対象)
    }else
    {
    	    for(i=0;i<allLys.length;i++)
    	    {
    		    compLys[i] = allLys[i+1];
    	    }
    }
    
    getLyName();

    if(! valE)
    {
            getData();
            dataTS();
            exportTS();
            
            if(! valE){
                activeLys();
                
                exeChk();
                //TimeSheet_forWin.exeが立ち上がっていない場合
                if(! valEXE){
                	//TimeSheetを起動
                    File(tsFile).execute();
                }
            }
    }


//*********FUNCTION**************************************************************

function offDeb(){
	
//JavaScript Debuggerが有効だったら、無効にする
	
	 var j = app.preferences.getPrefAsLong("Main Pref Section","Pref_JAVASCRIPT_DEBUGGER");
    //alert(j);

    if(j == 1)
    {
            app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 0);
            app.preferences.saveToDisk();
            app.preferences.reload();        
        
            valD = true;
    }
	
}

//********************************************************************************

function reDeb(){

//JavaScript Debuggerの設定を変えてたら、元に戻す

	   if(valD)
	   {
	           app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 1);
               app.preferences.saveToDisk();
               app.preferences.reload();
	   }        

}

//********************************************************************************

function slChk(){
	
//スライダのあるレイヤーのみ取得

	//デバッカーがONだったらOFF
	offDeb();

	ee=0;
	for(cc=0;cc<compLys.length;cc++)
	{
		
		try{
	            if(compLys[cc].effect.property("TS_スライダ制御").canSetEnabled)
	            {
	        	        //キーの数を取得
	        	        chkNum = compLys[cc].effect("TS_スライダ制御")["スライダ"].numKeys;
	        	        //alert(chkNum);
	        	        
	        	        //キーがある場合
	        	        if(chkNum > 0)
	        	        {
                                compLysQ[ee] = compLys[cc];
                                numSL[ee] = compLys[cc].index;
                                ee++;
	        	        }
	            }	       
		}
		catch(e)
		{
			    //alert("******aaa******");
		}	   
	}
	//alert(compLysQ[0].name);
	
	//デバッカー設定を戻す
	reDeb();
}

//********************************************************************************

function getLyName(){
	
//各レイヤーの名前を取得
	
	slChk();
	
	if(compLysQ.length > 0)
	{

	    nn=0;
	    while(nn<compLysQ.length)
	    {
	    	    //レイヤーの名前の中に "_ " がどこにあるか検索
	    	    numL = compLysQ[nn].name.indexOf("_");
	    	    //無かった場合
	    	    if(numL == -1)
	    	    {
	    		        //名前が4文字以内ならそのまま表示
	    		        if(compLysQ[nn].name.length < 4)
	    		        {
	                            numL = compLysQ[nn].name.length;
	                    //4文字以上なら4文字まで表示
	    	            }else{
	    		                numL = 4;
	    	            }
	    	//あった場合で、4文字以上なら "_" の左側の４文字まで表示、4文字以内なら "_" の左側をそのまま表示
	    	}else if(numL > 4)
	    	{
	    		    numL = 4;
	    	}
	    	
	        lyNames[nn] = numSL[nn] + "_" +compLysQ[nn].name.substring(0,numL);

	        //alert(lyNames[nn]);
	        nn++;
	    }
	}else{
		    alert("******レイヤーにキーがありません******");
		    valE = true;
	}

}

//********************************************************************************

function getData(){
	
//スライダのキー情報を取得	

	for(iCol=0;iCol<lyNames.length;iCol++)
	{
		outData[iCol] = new Array();

		//キーの総数
		numK = compLysQ[iCol].effect("TS_スライダ制御")["スライダ"].numKeys;
		//現在のキー番号
		 nk=1;
	    for(iRow=0;iRow<lyFr;iRow++)
	    {
	    //各キーのフレーム番号を取得
           //現在のキーがキーの総数以内の場合
	    	if(nk <= numK){
	    		//現在のキーのフレームＮｏ
	    	    numD = Math.floor(compLysQ[iCol].effect("TS_スライダ制御")["スライダ"].keyTime(nk)*actItem.frameRate);
	      //現在のキーがキーの総数を越えた場合
	    	}else{
	    		numD = lyFr;
	    	}
	    //ここからキー情報
	    	//１フレーム目
            if(iRow == 0){
                outData[iCol][0] = compLysQ[iCol].effect("TS_スライダ制御")["スライダ"].keyValue(nk);
                nk++;
            //２フレーム目以降    
            }else{
            	//iRowが現在のキーのフレーム番号より小さい場合
            	if(iRow < numD){
            		//現在のキーがキーの総数以内の場合
            		if(nk <= numK){
	        	        outData[iCol][iRow] = compLysQ[iCol].effect("TS_スライダ制御")["スライダ"].keyValue(nk-1);
	        	    //現在のキーがキーの総数を１越えた場合
            		}else{          			
            			outData[iCol][iRow] = compLysQ[iCol].effect("TS_スライダ制御")["スライダ"].keyValue(nk-1);
            		}
	        	//iRowが現在のキーのフレーム番号と同じ場合
            	}else if(iRow == numD){
            		outData[iCol][iRow] = compLysQ[iCol].effect("TS_スライダ制御")["スライダ"].keyValue(nk);
            		//現在のキーが総数に満たない場合は、繰上げ
            		if(nk <= numK){
	        		    nk++;	   
            		}     		
	            }    		
	    	}	        
	    }
	    //alert(outData[iCol][0]);
	}
}



//********************************************************************************

function dataTS(){
	
//書き出し用テキスト作成

    //改行コード用(Win & Mac 両対応)
    var CF;
	if($.os.indexOf("Windows")==0){
		//Windows
		CF = "\n";
	}else{
		//Mac
		CF = "\r";
	}	
	
    //レイヤーの下から取得
	for(rr=outData.length-1;rr>=0;rr--)
	{
		for(ww=0;ww<lyFr;ww++)
		{
			if(rr==outData.length-1 && ww==0){
			    wData = outData[rr][ww] + ",";
			    //alert(wData);
			}else{
				wData += outData[rr][ww] + ",";
			}			
		}
		
		if(rr>0){
			//セル情報の最後にレイヤーの名前
		    wData += lyNames[rr]  + CF;
		}else{
			//最後にカットの名前 + フレームレート
			wData += lyNames[rr]+ CF + cName + CF + fRate ;
		}
	}
	
}

//********************************************************************************

function exportTS(){
	
//"SheetData.txt" に書き込み

      filename = scFile;
           
      fileObj = new File(filename + "/_SheetData/SheetData.txt");
      //UTF-8にエンコード
      fileObj.encoding = "UTF-8";

      flag = fileObj.open("w");
      if (flag == true)
      {
          text = wData;
          //複数行を一気に書き込み
          fileObj.writeln(text);
          fileObj.close();
          
          impPref();
          exportPref();
          
          if(! valE){
                  //現在表示されている情報を消去 
                  clearOutput();          
                  //情報パネルに文字列を表示
                  writeLn( "保存しました" );
          }

      }else{
          alert("******保存できませんでした******");
      }	
		
}

//********************************************************************************

function activeLys(){
	
//キーを入力したレイヤーのみ選択状態にする
	
	for(i=0;i<compLysQ.length;i++){

		    compLysQ[i].selected = true;	

	}
	
}

//********************************************************************************

function impPref(){
	
//シートデータを読み込んで配列化
	
	if(! valE)
	{       
        fileObj = new File(filename + "/_Pref/preferance.txt");

     //シートファイルがない場合
        if(! fileObj.exists){
        	alert("******環境設定が見つかりません******");
        	valE = true;
        }else{
        	PrData = new Array();
             if (fileObj.open("r"))
             {

	        //行(セル)ごとに読み込み 
	            try{
                     for(rr=0;rr<9;rr++)
                     {
                                 txt = new Array();
                                 txt = fileObj.readln();
                     	 if(rr==2){                             
                                 PrData[0] = txt.split("Directory :");                 	
                         }else if(rr==4){
                                 PrData[1] = txt.split("Window Pos value :");      
                         }else if(rr==6){
                                 PrData[2] = txt.split("Window Pos :");       
                         }        
	                 }
	                 
	            }catch(e){
	        	    alert("******読み込みに失敗しました******");
	        	    valE = true;
	            }

            }else{
	           valE = true;
            }
      }
   }
		
}

//********************************************************************************

function exportPref(){
	
//"SheetData.txt" に書き込み


    //改行コード用(Win & Mac 両対応)
    var CF;
	if(File.fs == "Windows"){
		//Windows
		CF = "\n";
	}else if(File.fs == "Macintosh"){
		//Mac
		CF = "\r";
	}	

     var wPrData = "======TimeSheet.exe(app) 環境設定======" + CF +
                        CF +
                        "Directory :" + PrData[0][1] + CF +
                        CF +
                        "Window Pos value :" + PrData[1][1] + CF +
                        CF +
                        "Window Pos :" + PrData[2][1] + CF +
                        CF +
                        "Import Chk :true";


      filename = scFile;
           
      fileObj = new File(filename + "/_Pref/preferance.txt");
      //UTF-8にエンコード
      fileObj.encoding = "UTF-8";

      flag = fileObj.open("w");
      if (flag == true)
      {
          text = wPrData;
          //複数行を一気に書き込み
          fileObj.writeln(text);
          fileObj.close();
  
      }else{
          alert("******環境設定を保存できませんでした******");
          valE = true;
      }	
		
}

//********************************************************************************

function exeChk(){

//TimeSheet_forWin.exeが立ち上がってるか判別

        fileObj = new File(filename + "/_Pref/exeON.txt");

     //シートファイルがない場合
        if(fileObj.exists){
        	valEXE = true;	
        }
	
}

//********************************************************************************