/*   setFX_Sheet_CS4 v2.0   2012.07.03

      ・TimeSheet_CS4_forMac(Win)関係のAE スクリプト用セットアップ・スクリプト。(TimeSheet_CS4_forMac(Win)のver.2.0)
      ・コンポ内の選択レイヤー(連番ファイル)に対して各エフェクトを適用後、情報を書き出しTimeSheetアプリを起動します。
      ・既に該当のエフェクトが適用されている場合や、何もレイヤーを選択していない状態だと、既にエフェクトがあるレイヤーのみ
      ・情報を書き出してTimeSheetへ移行します。
      ・Windows & Mac 両対応 & CS4 対応版

*/




(function()
{
    setFX(this);


    function setFX(thisObj)
    {

        function runScr()
        {
            this.actComp = app.project;
            this.actItem = this.actComp.activeItem;
            this.fRate = this.actItem.frameRate;
            this.valSM = null;
            this.activeCompDuration = this.actItem.duration;
            //smooth PlugIn
            this.smPlugIn = "OLMSmoother";
            this.smName = "OLM Smoother";
            this.smVal = false;
        }

        runScr.prototype =
        {
            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                var verVal = parseInt(app.version.split(".")[0]) - 5;
                if(verVal < 5){
                    this.exSL = "スライダ制御";
                }else{
                    this.exSL = "スライダー制御";
                }
                if(verVal == 5){
                    if(parseInt(app.version.split(".")[1].charAt(0)) == 5){
                        verVal = 5.5;
                    }
                }
                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //OSが64bitでCS4の場合
                    if(verVal == 4 && $.os.indexOf("64") != -1){
                    //AE CS4 Scriptsフォルダパス<64bit OS時>
                        this.aePath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                        //プラグインフォルダのパス<64bit OS時>
                        this.plPath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Plug-ins/";
                    //上記以外
                    }else{
                        //AE Scriptsフォルダパス
                        this.aePath = "C:/Program Files/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                        //プラグインフォルダのパス(Win)
                        this.plPath = "C:/Program Files/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Plug-ins/";
                    }
                    //TimeSheet フォルダ
                    this.tsPath = this.aePath + "TimeSheet_CS4_forWin/";
                    //カレントディレクトリ
                    this.curDir = this.aePath;
                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = "/Applications/Adobe After Effects CS" + verVal + "/Scripts/";
                    //プラグインフォルダのパス(Mac)
                    this.plPath = "/Applications/Adobe After Effects CS" + verVal + "/Plug-ins/";
                    //TimeSheet フォルダ
                    this.tsPath = this.aePath + "TimeSheet_CS4_forMac/";
                    //サーバーディレクトリ
                    this.curDir = "/Volumes/";
                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }
                //tab space
                this.tabS = "\t";

                //alert(new Folder(this.curDir).exists);
            },

            //smooth PlugIn 判別
            chkSM: function(target)
            {
                var lists = new Array();
                //ファイルリストを取得
                lists = new Folder(target).getFiles();
                for each(var oList in lists)
                {
                    //フォルダかどうか(win仕様)
                    if(new Folder(oList).getFiles() == ""){
                        //フォルダ以外だったら判別
                        if(oList.fsName.indexOf(this.smPlugIn) != -1){
                            this.smVal = true;
                            break;
                        }
                    }else{
                        //フォルダだったら再帰処理
                        this.chkSM(oList);
                    }
                }
            },

            //TSエフェクトの適用状態をチェック
            chkTSFX_SM: function(tsFxflag2, curLayer ,valSM){
                if(valSM){
                    tsFxflag2 = [0,0,0,0];
                    for( f = 1; f <= curLayer.property("Effects").numProperties; f++ )
                    {
                        switch ( curLayer.property("Effects")(f).name )
                        {
                            case "TS_" + this.exSL         : tsFxflag2[0] = f; break;
                            case "TS_トランスフォーム"   : tsFxflag2[1] = f; break;
                            case "TS_カラーキー"      : tsFxflag2[2] = f; break;
                            case "TS_" + this.smPlugIn      : tsFxflag2[3] = f; break;

                            case "TS_Slider Control" : tsFxflag2[0] = f; break;
                            case "TS_Geometry2" : tsFxflag2[1] = f; break;
                            case "TS_Color Key" : tsFxflag2[2] = f; break;
                            case "TS_" + this.smPlugIn : tsFxflag2[3] = f; break;
                        }
                    }
                }else{
                    var tsFxflag2 = [0,0,0];
                    for( f = 1; f <= curLayer.property("Effects").numProperties; f++ )
                    {
                        switch ( curLayer.property("Effects")(f).name )
                        {
                            case "TS_" + this.exSL         : tsFxflag2[0] = f; break;
                            case "TS_トランスフォーム"   : tsFxflag2[1] = f; break;
                            case "TS_カラーキー"      : tsFxflag2[2] = f; break;

                            case "TS_Slider Control" : tsFxflag2[0] = f; break;
                            case "TS_Geometry2" : tsFxflag2[1] = f; break;
                            case "TS_Color Key" : tsFxflag2[2] = f; break;
                        }
                    }
                }

                return tsFxflag2
            },

            //タイムリマップとTSエフェクトを適用
            appTSFX_SM: function(actLys, valSM)
            {
                if(actLys[0].property("Effects").numProperties == 0 && valSM){
                    valSM = this.smDlg_Bld();
                }else if(actLys[0].property("Effects").numProperties == 3 && valSM){
                    valSM = false;
                }

                for( i = 0; i < actLys.length; i++ )
                {
                    var curLayer = actLys[i];

                    if ( curLayer.canSetTimeRemapEnabled == true )
                    {
                        if ( curLayer.timeRemapEnabled != true )
                        {
                            curLayer.timeRemapEnabled = true;
                            curLayer.timeRemap.removeKey(2);
                            curLayer.startTime = 0;
                            curLayer.outPoint = this.activeCompDuration;
                        }
                    }
                    else
                    {
                        curLayer.startTime = 0;
                        curLayer.outPoint = this.activeCompDuration;
                    }

                    var tsFxflag = new Array();
                    tsFxflag = this.chkTSFX_SM(tsFxflag, curLayer, valSM);
                    //alert(tsFxflag.toString());

                    var tsTransformExp = "if ( effect("+"\""+"TS_Slider Control"+"\""+")("+"\""+"ADBE Slider Control-0001"+"\""+") == 0 ) { 0 } else { 100 }";
                    var tsTimeRimapExp = "( effect("+"\""+"TS_Slider Control"+"\""+")("+"\""+"ADBE Slider Control-0001"+"\""+") - 1 ) * ( this_comp.frame_duration )";

                    if ( tsFxflag[0] == 0 )
                    {
                        var curFx = curLayer.property("ADBE Effect Parade").addProperty("ADBE Slider Control");
                        curFx.name = "TS_Slider Control";
                        curFx(1).addKey(0);
                        curFx.moveTo(1);
                        if ( tsFxflag[1] != 0 && curLayer.property("ADBE Effect Parade")("TS_Geometry2")(9).expression.indexOf("TS_Slider Control") != -1 )
                        {
                            curLayer.property("ADBE Effect Parade")("TS_Geometry2")(9).expressionEnabled = true;
                        }
                    }

                    if ( tsFxflag[1] == 0 )
                    {
                        var curFx = curLayer.property("ADBE Effect Parade").addProperty("ADBE Geometry2");
                        curFx.name = "TS_Geometry2";
                        curFx(9).expression = tsTransformExp;
                        curFx.moveTo(curLayer.property("ADBE Effect Parade")("TS_Slider Control").propertyIndex+1);
                    }

                    if ( tsFxflag[2] == 0 )
                    {
                        var curFx = curLayer.property("ADBE Effect Parade").addProperty("ADBE Color Key");
                        curFx.name = "TS_Color Key";
                        curFx(1).setValue([1,1,1,1]);
                        curFx.moveTo(curLayer.property("ADBE Effect Parade")("TS_Geometry2").propertyIndex+1);
                    }

                    if(tsFxflag.length == 4){
                        if ( tsFxflag[3] == 0 )
                        {
                            var curFx = curLayer.property("ADBE Effect Parade").addProperty(this.smName);
                            curFx.name = "TS_" + this.smPlugIn;
                            curFx(1).setValue(false);
                            curFx(3).setValue(1);
                            curFx.moveTo(curLayer.property("ADBE Effect Parade")("ADBE Color Key").propertyIndex+1);
                        }
                    }

                    if ( curLayer.canSetTimeRemapEnabled == true && curLayer.timeRemap.expressionEnabled != true )
                    { curLayer.timeRemap.expression = tsTimeRimapExp; }
                }
            },

            //スクリプトファイルの実行
            scriptExecute: function(){
                var scriptFileName = new File(this.tsPath + "(TS_Scripts)/exportSheet_CS4.jsx");
                if(scriptFileName.exists){
                    try{
                        //#includepath scriptFileName
                        //#include "exportSheet_CS4.jsx"

                        scriptFileName.open();
                        eval(scriptFileName.read());
                        scriptFileName.close();
                    }catch(e){

                    }
                }
            },

            //Smooth-PlugIn ダイアログ
            smDlg_Bld: function()
            {
                var smSel = confirm(this.smName + " を適用？");
                return smSel;
            },

            runFunc: function()
            {
                this.osChk();

                if(this.actItem != "[object CompItem]" || this.actItem == null)
                {
                        alert("******コンポが選ばれていません******");
                }else
                {
                    if(this.fRate != 24 && this.fRate != 30){
                        alert("******コンポのフレームレートを 24fr か 30fr にしてください******");
                    }else
                    {

                       var selLys = this.actItem.selectedLayers;
                       var allLys = this.actItem.layers;
                       var lyTime = this.actItem.duration;
                       var lyFr = lyTime * this.actItem.frameRate;


                       if(selLys.length > 11){
                            alert("******レイヤーの選択数を１１以下にしてください******");
                       }else{

                           this.chkSM(this.plPath);

                           app.beginUndoGroup("setFX_Sheet");

                           //レイヤーを選択していた場合、エフェクトを適用
                           if(selLys.length > 0)
                           {
                               this.appTSFX_SM(selLys, this.smVal);
                           }

                           //"export_Sheet.jsx" を実行 (レイヤー選択の有無に関係なく)
                           this.scriptExecute();

                           app.endUndoGroup();

                       }
                    }

                }
            }
        }

        //main******************************************************
        var RS = new runScr(thisObj);

        //アプリのバージョン確認
        //alert(parseFloat(app.version));
        if (parseFloat(app.version) < 8)
        {
            //alert(pUI.strErr, "blind pnl UI");
            return;
        }else{
            exUI = RS.runFunc(thisObj);
        }
        //**********************************************************
    }
})();