/*   ImportSheet v2.0   2009.05.09

      ・TimeSheet_forMac(Win)関係のAE6.5スクリプト用インポート・スクリプト。
      ・AE6.5 の [ Scripts < _SheetData < SheetData_AE.txt を読み込んで各レイヤーのスライダにキーを入力します。
      ・あらかじめ、[ setFX_Sheet ]で対象のレイヤーにスライダが適用されていることが必要。
      ・Windows & Mac 両対応。
      
      
      
      AfterEffects 6.5 のみ動作確認済
      Windows XP Professional SP3 / MacOS 10.4.11 10.5.6 のみ動作確認済
*/


//ボタン登録用名前
thisExpButtonName = "ImportSheet";


//==========File Path=====================================================================

var filename = null;
if($.os.indexOf("Windows")==0){
    //親フォルダのパス(Win)
    filename = "C:/Program Files/Adobe/After Effects 6.5/Support Files/Scripts/TimeSheet_forWin";
}else{
    //親フォルダのパス(Mac)
    filename  = "/Applications/Adobe After Effects 6.5/Scripts/TimeSheet_forMac";
}

//=======================================================================================


var dirFol = null;
var actComp = app.project;
var actItem = actComp.activeItem;
var fRate = actItem.frameRate;
var compLys = new Array();
var keyType=KeyframeInterpolationType.HOLD;
var valFr = null;
var valK = null;
var valE = false;
var valC = false;

var compLysQ = new Array();
var numSL = new Array();
var pClip;
var kData = new Array();
var celName = new Array();
var lCel = new Array();
var valD = false;
var LastSave = null;
var kFr = new Array();

if(fRate == 24){
	
    //0Fr.～24Fr.までの確定値==============================================================

     kFr = [
             0,
             0.0416667,
             0.0833333,
             0.125,
             0.1660667,
             0.208333,
             0.25,
             0.291667,
             0.333333,
             0.375,
             0.416667,
             0.458333,
             0.5,
             0.541667,
             0.583333,
             0.625,
             0.666667,
             0.708333,
             0.75,
             0.791667,
             0.833333,
             0.875,
             0.916667,
             0.958333,
             1
             ];
             
}else if(fRate == 30){
	
	    //0Fr.～30Fr.までの確定値==============================================================
	    
     kFr = [
             0,
             0.0333333,
             0.0666666,
             0.1,
             0.133333,
             0.166666,
             0.2,
             0.233333,
             0.266666,
             0.3,
             0.333333,
             0.366666,
             0.4,
             0.433333,
             0.466666,
             0.5,
             0.533333,
             0.566666,
             0.6,
             0.633333,
             0.666666,
             0.7,
             0.733333,
             0.766666,
             0.8,
             0.833333,
             0.866666,  
             0.9,
             0.933333,
             0.966666,                         
             1
             ];
             
}
             
//===========main script===================================================================


    if(actItem != "[object CompItem]" || actItem == null){
        alert("******コンポが選ばれていません******");
    }else{    	
       if(fRate != 24 && fRate !=30){
       	   alert("******コンポのフレームレートを 24fr か 30fr にしてください******");
       }else{
           var actLys = actItem.selectedLayers;
           var allLys = actItem.layers;
           var lyTime = actItem.duration;
           var lyFr = lyTime*fRate;    	
    	
    	
    	    //レイヤーを選択していた場合
    	    if(actLys.length > 0){
    		    //インデックス順に並び替え
    	        iii=0;
         	    for(i=0;i<allLys.length;i++){
    	        	for(ii=0;ii<actLys.length;ii++){
    	    	    	if(i+1 == actLys[ii].index){
    		            	compLys[iii] = actLys[ii];
    		    	    	iii++
    		    	    }
    		        }
    	        }
            //レイヤーが選択されていない場合(全てのレイヤーが対象)
    	    }else{
    	    	for(i=0;i<allLys.length;i++){
    		        compLys[i] = allLys[i+1];
    		    }
    	    }
    	
    	    offDeb();
    	
            slChk();
        
            reDeb();
        
            //レイヤーにスライダがあった場合
            if(compLysQ.length > 0){       
            	impSheet();    
            
            //シートファイルを読み込んだ場合
               if(! valE){           	
                    setDialog();
             
                 //割り振りがある場合   
                    if(! valE){
                    	app.beginUndoGroup("ImportSheet");
                        setLys();
                       //OKの場合
                        if(! valC){
                            activeLys();
                        }
                        app.endUndoGroup();
                    }else{
                    	alert("******レイヤーに入力されませんでした******");
                    }
                }
            }else{
            	alert("******レイヤーに[スライダ]がありません******");
            }
       }
    }





//*********FUNCTION**************************************************************

function offDeb(){
	
//JavaScript Debuggerが有効だったら、無効にする
	
	 var j = app.preferences.getPrefAsLong("Main Pref Section","Pref_JAVASCRIPT_DEBUGGER");
    //alert(j);

    if(j == 1){
        app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 0);
        app.preferences.saveToDisk();
        app.preferences.reload();        
        
        valD = true;
    }
	
}

//********************************************************************************

function reDeb(){

//JavaScript Debuggerの設定を変えてたら、元に戻す

	   if(valD){
	       app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 1);
           app.preferences.saveToDisk();
           app.preferences.reload();	    
	   }        

}

//********************************************************************************

function slChk(){

//スライダのあるレイヤーのみ取得

	ee=0;
	for(cc=0;cc<compLys.length;cc++){
		
		compLys[cc].selected = false;
		try{
	        if(compLys[cc].effect.property("TS_スライダ制御").canSetEnabled){
	        	compLysQ[ee] = compLys[cc];
	        	numSL[ee] = compLys[cc].index;
	        	ee++;
	        }	       
		}
		catch(e)
		{
			//alert("******aaa******");
		}	   
	}
	//alert(compLysQ[0].name);
	
}

//********************************************************************************

function impSheet(){
	
//シートデータを読み込んで配列化
	
	if(! valE)
	{       
        fileObj = new File(filename + "/_SheetData/SheetData_AE.txt");

     //シートファイルがない場合
        if(! fileObj.exists){
        	alert("******シートファイルが見つかりません******");
        	valE = true;
        }else{
             if (fileObj.open("r"))
             {
	            ff = 0;
	        //行(セル)ごとに読み込み 
	            try{
                     do
                     {
                         txt = new Array();
                       //読み込んだ行(セル)を配列化
                         txt = fileObj.readln();
                         kData[ff] = txt.split(",");
                         ff++;
                         //alert(txt.split(","));
	                 }while(txt.split(",").length != 1);
	                 
	            }catch(e){
	        	    alert("******読み込みに失敗しました******");
	            }
	            
	            getCelName();
	             
            }else{
	           valE = true;
            }
      }
   }
		
}

//********************************************************************************

function getCelName(){

//シートデータのセル名を取得(最後の "カットＮｏ" と "false" は読み込まないので -1)

	for(vv=0;vv<kData.length-1;vv++){
		celName[vv] = kData[vv][kData[vv].length-1];	
		//alert(celName[vv]);
	}

}

//********************************************************************************

function setDialog(){
	
//ダイアログ
	
	var RB = new Array();
	var LB = new Array();
	var LBs = new Array();
	var addC = 0;

	
	if(compLysQ.length > 13){
		addC = compLysQ.length-13;
	}else if(celName.length > 13){
		addC = celName.length-13;
	}


    //拡張サイズ	
        setDlg = new Window ( "dialog" , "Import Sheet" , [0,0,640,400 + (20 * addC)] );       

 	    pnlSub2 =setDlg.add( "panel" , [10,20,330,360 + (20 * addC)] , "Link Cell" );
 	    var subL = pnlSub2.add( "panel" , [10,20,210,330 + (20 * addC)] , "Comp Lys" );
  	    var subLs =  subL.add( "panel" , [110,10,190,300 + (20 * addC)] , "Linked" );   
  	
    //コンポレイヤー用テキスト
 	    for(ww=0;ww<compLysQ.length;ww++){
	    	var aPos = (30+(ww*20));
	    	var bPos = (50+(ww*20));	    	
	    	
            LB[ww] = subL.add( "statictext" , [5, aPos ,100, bPos] , numSL[ww] +"_"+ compLysQ[ww].name.substr(0,6) ); LB[ww].justify="left";
    //入力テキスト
            var cName = "0";
            for(cc=0;cc<celName.length;cc++){
            	if(celName[cc]==LB[ww].text.substr(0,celName[cc].length)){
            		cName = cc+1;
            	}
            }
 	    	LBs[ww] = subLs.add( "edittext" , [5, aPos-10 ,75, bPos-10] , cName.toString(),{enterKeySignalOnChange:true} ); LBs[ww].justify="left";
 	    		LBs[0].active = true;
 	    }

        var subR = pnlSub2.add( "panel" , [220,20,310,330 + (20 * addC)] , "Sheet Cell" );	
    //シートセル用テキスト
        for(gg=0;gg<celName.length+1;gg++){
        	var cPos = ( ( 30 + (celName.length*20) ) - (gg*20) );
        	var dPos = ( ( 50 + (celName.length*20) ) - (gg*20) );
        	      	
    //Non用
            if(gg==0){
                RB[gg] = subR.add( "statictext" , [5, cPos+1 ,65, dPos+1] ,"0_Non" ); RB[gg].justify="left";
            }else{
                RB[gg] = subR.add( "statictext" , [5, cPos ,85, dPos] , gg + "_"+ celName[gg-1].substr(0,5) ); RB[gg].justify="left";
            }
       }

        pstPnl2 = setDlg.add( "panel" , [340,20,630,135] , "Read Me" );
        clpText2 = pstPnl2.add( "edittext" , [10,25,280,110],"コンポレイヤー ( 左側 ) に対してシートのセル   " +
    		" ( 右側 ) の数字を割り当ててください。              " +
    		"[ Linked ]に表示されている数字のセルデータを    " +
    		"各レイヤーに入力します。                             ",{multiline:true ,readonly:true}); clpText2.justify="left";
                       
       
       cancelBtn2 = setDlg.add( "button" , [20, 360+(20 * addC) ,120,390 + (20 * addC)] , "Cansel" , {name:"cancel"} );
       okBtn2 = setDlg.add( "button" , [130, 360+(20 * addC) ,230,390 + (20 * addC)] , "OK" , {name:"ok"} );
       cancelBtn2.onClick = function() { valC = true; Btnon = "Cancel"; }
       okBtn2.onClick = function() { linkData(LBs); Btnon = "OK"; }       


    setDlg.center();
    setDlg.show();		
	
	
}

//********************************************************************************

function linkData(LBs){
	
//レイヤーとセルのリンク情報を取得
	
	valE = true;
    //各コンポレイヤーに割り振ったセルを取得
	for(LL=0;LL<LBs.length;LL++){
		
        lCel[LL] = LBs[LL].text;

	}
    //"0"じゃない場合       
        if(lCel.length > 0){
        	valE = false;
        }	
		
}

//********************************************************************************

function setLys(){
		
//各レイヤーにキーをセット
		
	var cNum=0;	
    //各コンポレイヤーに入力
	for(ss=0;ss<lCel.length;ss++){
		
		if(lCel[ss] != 0){

	       //スライダーのキー番号
	       var nKey = 1;			
			
	           for(i=0;i<kData[lCel[ss]-1].length;i++){
	           	 if(i == kData[lCel[ss]-1].length-1){
	            		//compLys[qq].name = kFr[i];
	             }else{
	           	   //フレーム数がフレームレート以下の場合
	                if(i+1 <  fRate){
	           	    	    valFr = kFr[i];
	           	    	    
                   //フレーム数がフレームレートより上の場合(フレームレートで割った整数と、確定値に変換した余りを足算)
	           	    }else{
	           	    	if((i+1) % fRate == 0){
	           	    		valFr = Math.floor((i+1) / fRate) + kFr[fRate -1] - 1;
	           	    	}else{
	           	           valFr = Math.floor((i+1) / fRate) + kFr[((i+1) % fRate)-1];
	           	    	}
	           	    }

	             	//alert(valFr);
                   //1フレーム目の場合
                    if(i == 0){
                    	
                    	//２つ以上キーがあったら削除
                    	rKey = compLysQ[ss].effect("TS_スライダ制御")["スライダ"].numKeys;
                    	if(rKey > 1){
                    		for(nn=1;nn<rKey;nn++){
                    		    compLysQ[ss].effect("TS_スライダ制御")["スライダ"].removeKey(2);
                    		}
                    	}
                    	//レイヤーの[インポイント]からキーを打つ
                        compLysQ[ss].effect("TS_スライダ制御")["スライダ"].setValueAtTime(compLysQ[ss].inPoint + valFr,kData[lCel[ss]-1][i]);
                        //キーをホールド
                        compLysQ[ss].effect("TS_スライダ制御")["スライダ"].setInterpolationTypeAtKey(nKey,keyType); 
                        nKey++;
                        
                   //2フレーム目以降の場合     
                    }else{
                    	//前フレームと違うセルならキーを打つ
	             	     if(kData[lCel[ss]-1][i] != kData[lCel[ss]-1][i-1]){

                                compLysQ[ss].effect("TS_スライダ制御")["スライダ"].setValueAtTime(compLysQ[ss].inPoint + valFr,kData[lCel[ss]-1][i]);
                                //キーをホールド
                                compLysQ[ss].effect("TS_スライダ制御")["スライダ"].setInterpolationTypeAtKey(nKey,keyType); 
                                nKey++;
	             	     }
                    }
                 }
	           }	
		}else{
			cNum++;
		}
				
	}
	
	if(cNum == lCel.length){
		valC = true;
		alert("******レイヤーに入力されませんでした******");
	}
	          		          					
}

//********************************************************************************

function activeLys(){
	
//キーを入力したレイヤーのみ選択状態にする
	
	for(i=0;i<compLysQ.length;i++){
		if(lCel[i] != 0){
		    compLysQ[i].selected = true;	
		}	
	}
	
}

//*********FUNCTION_END**************************************************************