//   setRenQ.jsx   2010.02.19
//
//
//    選択したコンポ(複数可)をレンダーキューに追加します。
//　　その際に、あらかじめ登録してある保存先のパスを任意選択できます。
//
//
//    =動作確認=
//
//    AfterEffects CS4
//
//    windows XP sp3  &  mac OS 10.5.6
//
//
//   curryegg
//   mail curry_eggs@yahoo.co.jp      blog http://curryegg.blog.shinobi.jp/
//
//



//名前に文字を追加する条件のデフォルト指定  0 = non, 1 = cellフォルダ名のみ, 2 = cellフォルダ名とファイル名, 3 = ファイル名のみ
var addStrNo = 0;

//追加する文字のデフォルト指定用配列 [ non, cellフォルダ名のみ, cellフォルダ名とファイル名, ファイル名のみ ]
var addStr = ["", "", "",""];



var valE = false;
var actProj = app.project;
var allItems = new Array();
var selComps = new Array();
var fList = new Array();
var fPath = new Array();
var curFol = null;
var temps = new Array();
var defIndex = null;
var valD = false;
var moIndex = null;
var valMK = true;
var addNameList = ["non", "cellフォルダ名のみに追加", "cellフォルダ名とファイル名に追加", "ファイル名のみに追加"];
var addName;

//************* Path *****************************************************************

			//==========File Path ※違う場合は必ず書き換えてください===================================================
			
			if($.os.indexOf("Windows")==0){
				
				var cN = "\\";
				//親フォルダのパス(Win)
				var curPath = "C:/Program Files/Adobe/Adobe After Effects CS4/Support Files/Scripts";
				var CF = "\n";
				
			}else{
				
				var cN = "/";
				//親フォルダのパス(Mac)
				var curPath = "/Applications/Adobe After Effects CS4/Scripts";
				var CF = "\r";
				
			}
			aNN = 0;
			bNN = String(unescape(new File($.fileName).fsName)).lastIndexOf(cN);
			//var scQPath = String(unescape(new File($.fileName).fsName)).substring(aNN, bNN);
			//alert(scQPath);
			var tPath = curPath + "/setRenQ_pref.txt";
//************************************************************************************




// **** Main Script ***************************************************************************************************************

app.beginUndoGroup("setRenQ");

getInfo();

if(!valE){
    impPath();

	if(!valE){
		
		getTemp();
		
		BuildUI();
		
	}
}

app.endUndoGroup();




// **** FUNCTION ******************************************************************************************************************

function getInfo()
{
	
	if(actProj.file == null){
		alert("******プロジェクトを保存してください******");
	}else{
		aepName = actProj.file.name.split(".aep");
		actProj.name = aepName[0];
		//alert(actProj.name);
		
        allItems = actProj.items;

        var ii = 0;
        for(var i=1;i<=allItems.length;i++){
        	if(allItems[i].selected){
        		if(allItems[i] == "[object CompItem]"){
	        		selComps[ii] = allItems[i];
	        		ii++
        		}
        	}
        }
        
        if(selComps.length ==0){
        	alert("******コンポが選択されていません******");
        	valE = true;
        }
	}
    
}

//********************************************************************************

function impPath()
{
	var impFile = new File(tPath);

	if(!impFile.exists){
		alert("******Brush_RenQ_pref.txt がありません******");
		valE = true;
	}else{
		if(impFile.open("r")){
			try{
                var i = 0;
                do{
                	
                	var txtArray = new Array();
					txt = impFile.readln();
					txtArray = txt.split(",");
					
					if(i > 0){
			            fList[i-1] = txtArray[0];
			            fPath[i-1] = txtArray[1];
                	}
		            i++;
                }while(txt.split(",").length != 1);
			}catch(e){
				alert("******読み込みに失敗しました******");
				 valE = true;
			}
		}else{
			alert("******読み込み出来ませんでした******");
			valE = true;
		}
		
		if(fPath.length == 0){
			alert("******パスが登録されていません******");
			valE = true;
		}
	}
	
}

//********************************************************************************

function BuildUI()     //  UI
{

    buildB = [100,50,590,330];
    blObj = new Window("palette"," setRenderQ ", buildB);

	blObj.ddlObj = null;
	blObj.ddlObj = undefined;
	
	ReBuildUI(blObj);
	
}

//********************************************************************************

function ReBuildUI(reObj)     //  パネル内UI
{
	

    reObj.ddlGroup = reObj.add("panel", [10, 5, 480, 80]);
	reObj.ddlInfo = reObj.ddlGroup.add("statictext",[10, 10, 480, 30], "保存フォルダのパスを選択");
	reObj.ddlInfo.helpTip = "指定した保存フォルダ内に、プロジェクト名のCutフォルダを作成します";
	reObj.ddlObj = reObj.ddlGroup.add("dropdownlist",[30, 35, 430, 60], fList);
	
	reObj.ddlGroup2 = reObj.add("panel", [10, 90, 480, 165]);
	reObj.ddlInfo2 = reObj.ddlGroup2.add("statictext",[10, 10, 480, 30], "出力モジュールを選択");
	reObj.ddlObj2 = reObj.ddlGroup2.add("dropdownlist",[30, 35, 430, 60], temps);
	reObj.ddlObj2.selection = reObj.ddlObj2.items[defIndex];
	
	reObj.chkBox = reObj.add("checkbox", [30, 170, 170, 200], "コンポ名のフォルダを作成");
	reObj.chkBox.active = false;
	reObj.chkBox.value = valMK;
	if(reObj.chkBox.value){
		reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、コンポ名のCellフォルダを作成し、その中にファイルを保存します";
	}else{
		reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、直接ファイルを保存します";
	}
	reObj.chkBox.onClick = function()
												{
													if(reObj.chkBox.value){
														reObj.chkBox.active = false;
														reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、コンポ名のCellフォルダを作成し、その中にファイルを保存します";
														
														reObj.ddlObj3.selection = reObj.ddlObj3.items[addStrNo];
													}else{
														reObj.chkBox.active = false;
														reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、直接ファイルを保存します";
														
														reObj.ddlObj3.selection = reObj.ddlObj3.items[0];
													}
											    };
	
	reObj.ddlGroup3 = reObj.add("panel", [180, 175, 480, 230]);
	reObj.ddlInfo3 = reObj.ddlGroup3.add("statictext",[10, 5, 180, 25], "名前に文字を追加");
	reObj.ddlInfo3.helpTip = "選んだ条件で、名前に右で指定した文字を追加します";
	reObj.ddlInfo4 = reObj.ddlGroup3.add("statictext",[190, 5, 280, 25], "追加する文字");
	reObj.ddlObj3 = reObj.ddlGroup3.add("dropdownlist",[10, 25, 180, 45], addNameList);
	if(reObj.chkBox.value){
		reObj.ddlObj3.selection = reObj.ddlObj3.items[addStrNo];
	}else{
		reObj.ddlObj3.selection = reObj.ddlObj3.items[0];
	}
	reObj.editTxt = reObj.ddlGroup3.add("edittext",[190, 25, 280, 45]);
	reObj.editTxt.text = addStr[reObj.ddlObj3.selection.index];
	reObj.ddlObj3.onChange = function()
													{
														if(!reObj.chkBox.value){
															if(reObj.ddlObj3.selection == reObj.ddlObj3.items[1] || reObj.ddlObj3.selection == reObj.ddlObj3.items[2]){
																reObj.ddlObj3.selection = reObj.ddlObj3.items[0];
															}
														}
														
														reObj.editTxt.text = addStr[reObj.ddlObj3.selection.index];
													};
   
	
	reObj.txtEdBtn = reObj.add( "button" , [30, 240, 190, 270] , "パス登録用テキストを編集" );
	reObj.txtEdBtn.helpTip = "パス登録用テキストを開きます。" +CF+
	                               "その際、ダイアログは閉じます。";
	reObj.txtEdBtn.onClick = function()
													{
														txtEdit();
														reObj.close();
													};
	
	reObj.cancelBtn = reObj.add( "button" , [260, 240, 360, 270] , "Cancel" , {name:"cancel"} );
	reObj.cancelBtn.onClick = function()
													{
														reObj.Btnon = "Cansel";
														reObj.close();
													};
													
	reObj.okBtn = reObj.add( "button" , [370, 240, 480, 270] , "OK" , {name:"ok"} );
	reObj.okBtn.onClick = function()
													{
														reObj.Btnon = "OK";
														
														nL = reObj.ddlObj.selection;
					                                    if(nL == null){
					                                    	alert("******保存フォルダが選ばれていません******");
					                                    }else{
															reObj.close();
					                                    }
													};
	
	reObj.onClose = function()
							{
								//  "OK" なら、取得
								if(reObj.Btnon == "OK"){
                                    nL = reObj.ddlObj.selection;
                                    nM = reObj.ddlObj2.selection;
                                    valMK = reObj.chkBox.value;

                                	curFol = fPath[nL.index];
                                	//alert(curFol);
                                	moIndex = nM.index;
                                	
									addName = {
													No : reObj.ddlObj3.selection.index,
		                                    		txt : reObj.editTxt.text
													};
                                	
                                	addRenQ();
								}
							};
	
	
	
	reObj.center();
	reObj.show();
	
}

//********************************************************************************

function addRenQ()
{
	
	var cFol = curFol + "/" + actProj.name;
	//保存用Cutフォルダを作成
	nFol = new Folder(cFol);
	if(!nFol.exists){
		nFol.create();
	}
	
	if(nFol.exists){
			//セルフォルダを作成する場合
			if(valMK){
				for(var i=0;i<selComps.length;i++){
				    var ceFol = null;
				    if(addName.No == 1 || addName.No == 2){
						ceFol = cFol + "/" + selComps[i].name + addName.txt;
				    }else{
				    	ceFol = cFol + "/" + selComps[i].name;
				    }
					//保存用cellフォルダを作成
					var nnFol = null;
					nnFol = new Folder(ceFol);
					if(!nnFol.exists){
						nnFol.create(); 
					}
					
					if(nnFol.exists){
						curQ = app.project.renderQueue.items.add(selComps[i]);
				        curOM = curQ.outputModule(1);
		                curOM.applyTemplate(temps[moIndex]);
		                var celName = null;
		                if(addName.No == 2 || addName.No == 3){
					        celName = selComps[i].name + addName.txt;
		                }else{
		                	celName = selComps[i].name;
		                }
		
		                //offDeb();
		                
		                try{
				            curOM.file = new File(ceFol + "/" + celName + "_[####]");
		                }catch(e){
		                	
		                }
			            
			            //reDeb();
					}
				}
			//セルフォルダを作成しない場合
			}else{
				for(var i=0;i<selComps.length;i++){
				    var ceFol = null;
					ceFol = cFol;
					
					curQ = app.project.renderQueue.items.add(selComps[i]);
			        curOM = curQ.outputModule(1);
	                curOM.applyTemplate(temps[moIndex]);
	                var celName = null;
	                if(addName.No == 2 || addName.No == 3){
				        celName = selComps[i].name + addName.txt;
	                }else{
	                	celName = selComps[i].name;
	                }

	                //offDeb();
	                
	                try{
			            curOM.file = new File(ceFol + "/" + celName + "_[####]");
	                }catch(e){
	                	
	                }
		            
		            //reDeb();
				}
			}

	}
	
}

//********************************************************************************

function getTemp()
{
	//出力モジュールをリスト化
	
	testQ = app.project.renderQueue.items.add(selComps[0]);
    curTemps = testQ.outputModule(1).templates;

    //隠れてる設定を除外
    var qq = 0;
    for(var q=0;q<curTemps.length;q++){
    	if(curTemps[q].indexOf("_HIDDEN") == -1){
    		temps[qq] = curTemps[q];
    		qq++;
    	}
    }

    //デフォルトの設定を取得
    for(var q=0;q<temps.length;q++){
    	if(testQ.outputModule(1).name == temps[q]){
    		defIndex = q;
    		break;
    	}
    }
    
    testQ.remove();
    //alert(defIndex);
}

//********************************************************************************

function txtEdit()
{
    exFile = new File(tPath);
    File(exFile).execute();
}

//********************************************************************************

function offDeb(){
	
//JavaScript Debuggerが有効だったら、無効にする
	
	 var j = app.preferences.getPrefAsLong("Main Pref Section","Pref_JAVASCRIPT_DEBUGGER");
    //alert(j);

    if(j == 1){
        app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 0);
        app.preferences.saveToDisk();
        app.preferences.reload();        
        
        valD = true;
    }
	
}

//********************************************************************************

function reDeb(){

//JavaScript Debuggerの設定を変えてたら、元に戻す

	   if(valD){
	       app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 1);
           app.preferences.saveToDisk();
           app.preferences.reload();
           
           valD = false;
	   }        

}

//********************************************************************************