


function blindPnlUI(thisObj)
{
	
	function UIObj()
	{
		//イメージ読み込み
		this.mapS = new File( "../ScriptUI Panels"+"/(UI_png)"+"/color_S.png");
		this.mapB = new File( "../ScriptUI Panels"+"/(UI_png)"+"/color_B.png");
		this.mapP = new File( "../ScriptUI Panels"+"/(UI_png)"+"/mappoint.png");
		this.clickTrOn = new File( "../ScriptUI Panels"+"/(UI_png)"+"/trDown.png");
		this.clickTrOff = new File( "../ScriptUI Panels"+"/(UI_png)"+"/trRight.png");
		this.sepLine = new File( "../ScriptUI Panels"+"/(UI_png)"+"/sepLine01.png");
		this.slBack = new File( "../ScriptUI Panels"+"/(UI_png)"+"/slBack.png");
		this.slBar = new File( "../ScriptUI Panels"+"/(UI_png)"+"/slBar.png");
		this.slUp = new File( "../ScriptUI Panels"+"/(UI_png)"+"/slUp.png");
		this.slDown = new File( "../ScriptUI Panels"+"/(UI_png)"+"/slDown.png");
		
		
		//パネル
		this.pal = null;
		//パネル全体のデフォルト縦サイズ
		this.boundsH = 240;
		//パネル全体のローカルY座標
		this.uiLocY = 2;
		//スクロールバー
		this.valS = false;
		this.clickY = 0;
		this.clickLY = 0;
		this.moveY = 0;
		this.curBar = 14;
		this.uiM = 0;
	}
	
	UIObj.prototype =
	{
		//スクロールバー ジャンプ値＆ステップ値
		scl_JumpDelta: 50,
		scl_StepDelta: 10,
		
		//アプリバージョン確認・エラーコメント
		strErr: "Could not launch script '%s' because it no longer exists on disk.",
		
		//OSが、Win か Mac か
		osCHK: function()
							{
								if($.os.indexOf("Windows")==0){
									this.os = "Win";
									//パスのバックスラッシュ(Win)
									this.cN = "\\";
								}else if($.os.indexOf("Mac")==0){
									this.os = "Mac";
									//パスのバックスラッシュ(Mac)
									this.cN = "\n";
								}	
							},
							
		//外部スクリプトファイル情報
		scriptArray: function()
		{
			//外部スクリプト ファイル名
			this.scArray = new Array();
			this.scArray = ["A","B","C","D","E","F","G"];  //テスト
			//三角ON/OFFバリュー
			this.valC = new Array();
		},
							
		blindPnl_BuildUI: function(thisObj)
							{
									this.osCHK();
									this.scriptArray();
									
									pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", "blind pnl UI", [200, 200, 410, 200 + (this.scArray.length * 26) + this.boundsH], {resizeable: true});
									
									if(pal != null){
										//全体のパネル (これ自体をスクロール)
										pal.uiGrp = pal.add("group", [2, 2, 224 - 17, (this.scArray.length * 26) + this.boundsH - 2]);
										//スクロールバー
										this.sclBuild(pal);
										
										//各項目(スクリプトとか)
										pal.scGrp = new Array();
										pal.scIndex = new Array();
										pal.iconTr = new Array();
										pal.uiIndex = new Array();
										pal.sep = new Array();
										pal.scriptPnl = new Array();
										pal.info = new Array();
										pal.info2 = new Array();
										for(var i=0;i<this.scArray.length;i++){
											this.scBuildUI(pal, i);
										}
										
										//リサイズ時の処理は、今後追記予定
										bSelf = this;
										pal.onResize = function()
																	{
																		posX = pal.size.width;
																		posY = pal.size.height;
																		//alert(posX);
																		uiPos = pal.uiGrp.bounds;
																		pal.uiGrp.bounds = [2, uiPos[1], posX - 17, uiPos[3]];
																		pal.scriptPnl.bounds = [2, 26, posX - 17, 240];
																		pal.sclGrp.bounds = [posX - 15, 2, posX - 1, 240];
																	 };
										
									}
									
									return pal;
									
							},
							
		//各外部スクリプト
		scBuildUI: function(pnlObj, num)
							{
								
								var scNum = num;
								this.valC[scNum] = "OFF";
								//スクリプトファイル名を取得
								//aN = String(unescape(new File($.fileName).fsName)).lastIndexOf(this.cN);
								//bN =String(unescape(new File($.fileName).fsName)).length;
								//var tabName = String(unescape(new File($.fileName).fsName)).substring(aN+1, bN).replace(/.jsx(bin)?$/, "");
								
								pSelf = this;
								uiW = pnlObj.uiGrp.size.width;
								
								//スクリプトごとのグループ
								pnlObj.scGrp[scNum] = pnlObj.uiGrp.add("group", [2, 2 + (scNum * 24), uiW,  24 + (scNum * 24)]);
								pnlObj.scIndex[scNum] = pnlObj.scGrp[scNum].location[1];
								pnlObj.scGrp[scNum].id = scNum;
								scGrpW = pnlObj.scGrp[scNum].size.width;
								scGrpH = pnlObj.scGrp[scNum].size.height;
								//項目の表示
								pnlObj.iconTr[scNum] = pnlObj.scGrp[scNum].add("iconbutton", [0, 2, 10, 12], this.clickTrOff, {style:"toolbutton"});
								pnlObj.iconTr[scNum].id = scNum;
								pnlObj.iconTr[scNum].onClick = function()
																		{
																			if(pSelf.valC[this.id] == "ON"){
																				pnlObj.iconTr[this.id].image = pSelf.clickTrOff;
																				pSelf.valC[this.id] = "OFF";
																				pSelf.doBlindPnl(pnlObj, this.id);
																			}else{
																				pnlObj.iconTr[this.id].image = pSelf.clickTrOn;
																				pSelf.valC[this.id] = "ON";
																				pSelf.doBlindPnl(pnlObj, this.id);
																			}
																		};
								pnlObj.uiIndex[scNum] = pnlObj.scGrp[scNum].add("statictext", [13, 0, scGrpW, 18], this.scArray[scNum]);
								pnlObj.sep[scNum] = pnlObj.scGrp[scNum].add("image", [0, 19, scGrpW, 21], this.sepLine);
								
								
								//ここから項目の内容 (スクリプトとか)
								pnlObj.scriptPnl[scNum] = pnlObj.scGrp[scNum].add("panel", [0, 24, scGrpW, 240]);
								pnlObj.scriptPnl[scNum].visible = false;
								
								//座標チェック用テキスト
								pnlObj.info[scNum] = pnlObj.scriptPnl[scNum].add("statictext", [2,2,100,22],"barY: ");
								pnlObj.info2[scNum] = pnlObj.scriptPnl[scNum].add("statictext", [2,24,100,44],"uiY:  ");
							},
							
							
		//スクロールバー
		sclBuild: function(pnlObj)
							{
								
								sSelf = this;
								
								posX = pnlObj.uiGrp.size.width;
								//alert(posX);
								pnlObj.sclGrp = pnlObj.add("group", [posX +4, 2, posX + 18, 240]);
								
								pnlObj.sclGrp.addEventListener('mousedown',this.sclFunc1);
								pnlObj.sclGrp.addEventListener('mouseup',this.sclFunc2);
								pnlObj.sclGrp.addEventListener('mousemove',this.sclFunc3);
								pnlObj.sclGrp.addEventListener('click',this.sclFunc4);
								pnlObj.sclGrp.addEventListener('mouseout',this.sclFunc5);
								
								
								//スクロールバー・バー (Win と Mac で順番を入れ替え)
								if(this.os == "Win"){
									pnlObj.scl_Bar = pnlObj.sclGrp.add("image", [0, 14, 14, 84], this.slBar);
									pnlObj.scl_Back = pnlObj.sclGrp.add("image", [0, 14, 14, 224], this.slBack);
								}else if(this.os == "Mac"){
									pnlObj.scl_Back = pnlObj.sclGrp.add("image", [0, 14, 14, 224], this.slBack);
									pnlObj.scl_Bar = pnlObj.sclGrp.add("image", [0, 14, 14, 84], this.slBar);
								}
								
								//スクロールバーの△
								pnlObj.scl_Up = pnlObj.sclGrp.add("iconbutton", [0, 0, 14, 14], this.slUp, {style:"toolbutton"});
								pnlObj.scl_Up.onClick = function()
																		{
																			//alert(pnlObj.uiGrp.location[1]);
																			sSelf.uiLocY = pnlObj.uiGrp.location[1];
																			sSelf.curBar = pnlObj.scl_Bar.location[1];
																			sSelf.uiM = pnlObj.uiGrp.size[1] / (224 - 70);
																			if(sSelf.curBar - sSelf.scl_StepDelta < 14){
																				pnlObj.scl_Bar.location = [0, 14];
																				pnlObj.uiGrp.location = [2, 2];
																			}else{
																				pnlObj.scl_Bar.location = [0, sSelf.curBar - sSelf.scl_StepDelta];
																				pnlObj.uiGrp.location = [2, 2 - (sSelf.uiM * (pnlObj.scl_Bar.location[1] - 14))];
																			}
																		};
								
								//スクロールバーの▽
								pnlObj.scl_Down = pnlObj.sclGrp.add("iconbutton", [0, 224, 14, 238], this.slDown, {style:"toolbutton"});
								pnlObj.scl_Down.onClick = function()
																		{
																			//alert(pnlObj.uiGrp.location[1]);
																			sSelf.uiLocY = pnlObj.uiGrp.location[1];
																			sSelf.curBar = pnlObj.scl_Bar.location[1];
																			sSelf.uiM = pnlObj.uiGrp.size[1] / (224 - 70);
																			if(sSelf.curBar + sSelf.scl_StepDelta > (224 - 70)){
																				pnlObj.scl_Bar.location = [0, (224 - 70)];
																				pnlObj.uiGrp.location = [2, 2 - sSelf.boundsH];
																			}else{
																				pnlObj.scl_Bar.location = [0, sSelf.curBar + sSelf.scl_StepDelta];
																				pnlObj.uiGrp.location = [2, 2 - (sSelf.uiM * (pnlObj.scl_Bar.location[1] - 14))];
																			}
																		};
								
							},
							
							
			//*****ここからファンクション*****
			//
			
			//各パネルの開閉
			doBlindPnl: function(pnlObj, scNum)
							{
								if(this.valC[scNum] == "ON"){
									valOFF = false;
									//他が開いてたら、閉じる
									for(var ii=0;ii<this.valC.length;ii++){
										if(!valOFF){
											if(ii != scNum){
												if(this.valC[ii] == "ON"){
													pnlObj.iconTr[ii].image = this.clickTrOff;
													this.valC[ii] = "OFF";
													pnlObj.scriptPnl[ii].visible = false;
													curB = new Array();
													curB = pnlObj.scGrp[ii].bounds;
													pnlObj.scGrp[ii].bounds = [curB[0], curB[1], curB[2], curB[3] - 218];
													valOFF = true;
												}
											}
										//以降のものをずらす
										}else{
											curL = new Array();
											curL = pnlObj.scGrp[ii].location;
											pnlObj.scGrp[ii].location = [curL[0], curL[1] - 218];
										}
									}
								}
								
								valOFF = false;
								valON = false;
								//クリックされたものの処理
								for(var ii=0;ii<this.valC.length;ii++){
									if(!valOFF && !valON){
										if(ii == scNum){
											if(this.valC[ii] == "ON"){
												curB = new Array();
												curB = pnlObj.scGrp[ii].bounds;
												pnlObj.scGrp[ii].bounds = [curB[0], curB[1], curB[2], curB[3] + 218];
												pnlObj.scriptPnl[ii].visible = true;
												valON = true;
											}else{
												pnlObj.scriptPnl[ii].visible = false;
												curB = new Array();
												curB = pnlObj.scGrp[ii].bounds;
												pnlObj.scGrp[ii].bounds = [curB[0], curB[1], curB[2], curB[3] - 218];
												valOFF = true;
											}
										}
									//以降のものをずらす
									}else{
										if(valON){
											curB = new Array();
											curB = pnlObj.scGrp[ii].location;
											pnlObj.scGrp[ii].location = [curB[0], curB[1] + 218];
										}else if(valOFF){
											curL = new Array();
											curL = pnlObj.scGrp[ii].location;
											pnlObj.scGrp[ii].location = [curL[0], curL[1] - 218];
										}
									}
								}
								
								//バーとパネルの移動量の変数
								this.uiM = pnlObj.uiGrp.size[1] / (224 - 70);
								//開いた時は、その項目を最上位で表示
								if(valON){
									pnlObj.uiGrp.location = [2, 4 - pnlObj.scIndex[scNum]];
									pal.scl_Bar.location = [0, 14 + Math.abs(pnlObj.uiGrp.location[1]) / this.uiM];
								//閉じた時(全てがOFF)は、パネルを最上位で表示
								}else if(valOFF){
									pnlObj.uiGrp.location = [2, 2];
									pal.scl_Bar.location = [0, 14];
								}
							},
							
			//スクロールバー マウスイベント(down)
			sclFunc1: function(bd)
							{
								this.valS = true;
								
								//クリック時のスクリーン座標
								this.clickY = bd.screenY;
								//クリック時のローカル座標
								this.clickLY = bd.clientY;
								//クリック時のバーのY座標
								this.curBar = pal.scl_Bar.location[1];
								//クリック時のパネルのローカル座標
								this.uiLocY = pal.uiGrp.location[1];
							},
							
			//スクロールバー マウスイベント(up)
			sclFunc2: function(bu)
							{
								//初期化
								this.valS = false;
								this.moveY = 0;
							},
			
			//スクロールバー マウスイベント(move)
			sclFunc3: function(m)
							{
								this.boundsH = 240.;
								//スクリーン座標Y上の移動距離
								this.moveY = m.screenY - this.clickY;
								//移動後のバーのY座標
								lBar = this.curBar + this.moveY;
								//バーとパネルの移動量の変数
								this.uiM = (pal.scIndex[pal.scIndex.length - 1] - 4) / (224 - 70);
								
								//ドラッグ中の処理
								if(this.valS){
									if(lBar < 14){
										pal.scl_Bar.location = [0, 14];
										pal.uiGrp.location = [2, 2];
									}else if(lBar + 70 > 224){
										pal.scl_Bar.location = [0, 224 - 70];
										//pal.uiGrp.location = [2, 4 - pal.scIndex[pal.scIndex.length-1]]
									}else{
										pal.scl_Bar.location = [0, lBar];
										
										uiMoveY = this.uiLocY - (this.moveY * this.uiM);
										pal.uiGrp.location = [2, uiMoveY];
									}
								}
								
								//座標チェック用テキスト
								for(var iii=0;iii<pal.info.length;iii++){
									pal.info[iii].text = "barY: " + pal.scl_Bar.location[1];
									pal.info2[iii].text = "uiY:  " + pal.uiGrp.location[1];
								}
							},
							
			//スクロールバー マウスイベント(click)
			sclFunc4: function(c)
							{
								//リリース時のバーのY座標
								curBar2 = pal.scl_Bar.location[1];
								
								//ドラッグじゃなかった場合
								if(this.curBar == curBar2){
									//左クリック (バー以外をクリックしたらジャンプ)
									if(c.button == 0){
										this.boundsH = 240.;
										this.scl_JumpDelta = 50;
										//バーとパネルの移動量の変数
										this.uiM = (pal.scIndex[pal.scIndex.length - 1] - 4) / (224 - 70);
										
										if(this.clickLY < this.curBar && this.clickLY > 14){
											if(this.curBar - this.scl_JumpDelta < 14){
												pal.scl_Bar.location = [0, 14];
												pal.uiGrp.location = [2, 2];
											}else{
												pal.scl_Bar.location = [0, this.curBar - this.scl_JumpDelta];
												pal.uiGrp.location = [2, 2 - (this.uiM * (pal.scl_Bar.location[1] - 14))];
											}
										}else if(this.clickLY  > this.curBar + 70 && this.clickLY < 224){
											if(this.curBar + this.scl_JumpDelta > 224 - 70){
												pal.scl_Bar.location = [0, 224 - 70];
												pal.uiGrp.location = [2, 2 - this.boundsH]
											}else{
												pal.scl_Bar.location = [0, this.curBar + this.scl_JumpDelta];
												pal.uiGrp.location = [2, 2 - (this.uiM * (pal.scl_Bar.location[1] - 14))];
											}
										}
										
										
										//座標チェック用テキスト
										for(var iii=0;iii<pal.info.length;iii++){
											pal.info[iii].text = "barY: " + pal.scl_Bar.location[1];
											pal.info2[iii].text = "uiY:  " + pal.uiGrp.location[1];
										}
									}
								}
								
								//初期化
								this.valS = false;
								this.moveY = 0;
							},
							
			//スクロールバー マウスイベント(out)
			sclFunc5: function(o)
							{
								//初期化
								this.valS = false;
								this.moveY = 0;
							}
	}
	
	var pUI = new UIObj(thisObj);
	
	//アプリのバージョン確認
	if (parseFloat(app.version) < 9)
	{
		alert(pUI.strErr, "blind pnl UI");
		return;
	}else{
		pUI.blindPnl_BuildUI(thisObj);
	}
	
}

blindPnlUI(this);

