// getDir_TreeView.jsx  ver.1.0  2012.01.16
//
// <_tweenAE_Lib.jsx>を使用したサンプルスクリプトです
// AfterEffects の [Scripts]フォルダ内に<_tweenAE_Lib.jsx>が無いと動きません
//
// 指定のディレクトリからスタートできるTreeViewです
// 右クリックで任意のフォルダをエクスプローラーで開きます
// フォルダのみ表示する仕様にしています
// 表示するフォルダが多いと処理が重くなります
//
//
// 動作確認
// AfterEffects CS4  /  windows XP 64bit
//
// ※Macでは最終的な結果として移動しますが、途中のアニメーションはしません
//
//
//
//   Copyright: @curryegg  All rights reserved.
//   email:   curry_eggs@yahoo.co.jp       blog:   http://curryegg.blog.shinobi.jp/        twitter account:   curry_eggs
//
//


{

    getDir_TreeView(this);


    function getDir_TreeView(thisObj)
    {
        function runScp()
        {
            this.titleList = new Array();
            this.curX = 0;
            this.curY = 0;
            this.valCL = false;
            this.valE = false;
        }

        runScp.prototype =
        {
            //アプリバージョン確認・エラーコメント
			strErr: "****** CS4 以上じゃないですよっと ******",

			//OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                var verVal = parseInt(app.version.split(".")[0]) - 5;
                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    if(app.version.indexOf("9") == 0 && $.os.indexOf("64") != -1){
                    //AE CS4 Scriptsフォルダパス<64bit OS>
                        this.aePath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                    }else{
                        //AE Scriptsフォルダパス
                        this.aePath = "C:/Program Files/Adobe/Adobe After Effects CS" + verVal + "/Support Files/Scripts/";
                    }
                    //カレントディレクトリ
                	this.curDir = this.aePath;
                	//Windows
                	this.OS = "Win";
                	//改行コード
                	this.CF = "\r\n";
                	//パスのバックスラッシュ
                    this.cN = "\\";

                    if(new File(this.aePath +"_tweenAE_Lib.jsx").exists){
                        //_tweenAE_Lib 読み込み
                        #includepath this.aePath
                        #include "_tweenAE_Lib.jsx"
                    }else{
                        alert("******[Scripts]フォルダ内に<_tweenAE_Lib.jsx>がありません******");
                        this.valE = true;
                    }
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = "/Applications/Adobe After Effects CS" + verVal + "/Scripts/";
                    //サーバーディレクトリ
                	this.curDir = "/Volumes/";
                	//Mac
                	this.OS = "Mac";
                	//改行コード
                	this.CF = "\r";
                	//パスのバックスラッシュ
                    this.cN = "/";

                    if(new File(this.aePath +"_tweenAE_Lib.jsx").exists){
                        //_tweenAE_Lib 読み込み
                        #includepath this.aePath
                        #include "_tweenAE_Lib.jsx"
                    }else{
                        alert("******[Scripts]フォルダ内に<_tweenAE_Lib.jsx>がありません******");
                        this.valE = true;
                    }
                }
                //tab space
                this.tabS = "\t";
            },

            win_Bld: function()
            {
                var wSelf = this;

                pal = (thisObj instanceof Panel) ? thisObj : new Window("palette", "", [ 0, 0, 800, 605 ]);
                this.UI_bgColor255(pal, [40,40,40]);

                pal.mnGrp = pal.add("group", [0,0,pal.size[0],54]);
                this.UI_bgColor255(pal.mnGrp, [60,60,60]);

                infoA = pal.mnGrp.add("statictext", [10,2,160,18], "Current Directory Path");
                this.UI_fgColor255(infoA, [220,220,220]);
                this.UI_font(infoA, "Arial","BOLD", 12);

                pal.Lbtn = pal.mnGrp.add("group", [580,2,630,19]);
                this.UI_bgColor255(pal.Lbtn, [90,90,90]);
                pal.Llabel = pal.Lbtn.add("statictext", [1,1,48,16], "＜"); pal.Llabel.justify="center";
                pal.Llabel.OB = this;
                pal.Llabel.val = "L";
                this.UI_fgColor255(pal.Llabel, [220,220,220]);
                this.UI_font(pal.Llabel, "Arial","BOLD", 14);
                //マウスリスナー
    		    pal.Llabel.addEventListener('mousedown',wSelf.mdFunc2);

                pal.Tbtn = pal.mnGrp.add("group", [635,2,685,19]);
                this.UI_bgColor255(pal.Tbtn, [90,90,90]);
                pal.Tlabel = pal.Tbtn.add("statictext", [1,1,48,16], "∧"); pal.Tlabel.justify="center";
                pal.Tlabel.OB = this;
                pal.Tlabel.val = "T";
                this.UI_fgColor255(pal.Tlabel, [220,220,220]);
                this.UI_font(pal.Tlabel, "Arial","BOLD", 14);
                //マウスリスナー
    		    pal.Tlabel.addEventListener('mousedown',wSelf.mdFunc2);

                pal.Bbtn = pal.mnGrp.add("group", [690,2,740,19]);
                this.UI_bgColor255(pal.Bbtn, [90,90,90]);
                pal.Blabel = pal.Bbtn.add("statictext", [1,1,48,16], "∨"); pal.Blabel.justify="center";
                pal.Blabel.OB = this;
                pal.Blabel.val = "B";
                this.UI_fgColor255(pal.Blabel, [220,220,220]);
                this.UI_font(pal.Blabel, "Arial","BOLD", 14);
                //マウスリスナー
    		    pal.Blabel.addEventListener('mousedown',wSelf.mdFunc2);

                pal.Rbtn = pal.mnGrp.add("group", [745,2,795,19]);
                this.UI_bgColor255(pal.Rbtn, [90,90,90]);
                pal.Rlabel = pal.Rbtn.add("statictext", [1,1,48,16], "＞"); pal.Rlabel.justify="center";
                pal.Rlabel.OB = this;
                pal.Rlabel.val = "R";
                this.UI_fgColor255(pal.Rlabel, [220,220,220]);
                this.UI_font(pal.Rlabel, "Arial","BOLD", 14);
                //マウスリスナー
    		    pal.Rlabel.addEventListener('mousedown',wSelf.mdFunc2);


                pal.txED = pal.mnGrp.add("edittext", [20,24,650, 49]);
                this.UI_fgColor255(pal.txED, [240,120,80]);
                this.UI_font(pal.txED, "Arial","BOLD", 14);
                pal.txED.text = this.curDir;

                pal.startBtn = pal.mnGrp.add("button", [660,22,780,49], "Open TreeView");

                pal.bgGrp = pal.add("group", [0,55,pal.size[0],pal.size[1]]);
                this.UI_bgColor255(pal.bgGrp, [60,60,60]);

                pal.scGrp = pal.bgGrp.add("group", [0,0,pal.bgGrp.size[0],pal.bgGrp.size[1]]);
                pal.scGrp.maxSY = new Array();
                this.UI_bgColor255(pal.scGrp, [60,60,60]);

                pal.startBtn.onClick = function()
                                                {
                                                    wSelf.titleList = wSelf.getTitle(pal.txED.text);
                                                    if(pal.scGrp.children.length == 0){
                                                        if(wSelf.titleList.length>0){
                                                            var addBtn = wSelf.setDirBtn(pal.scGrp , wSelf.titleList, 15, 5);
                                                            if(addBtn.length>0){
                                                                wSelf.moveBtn(addBtn, pal.scGrp);
                                                            }
                                                        }
                                                    }else{
                                                        wSelf.reMoveBtn(pal.scGrp);
                                                        if(wSelf.titleList.length>0){
                                                            var addBtn = wSelf.setDirBtn(pal.scGrp , wSelf.titleList, 15, 5);
                                                            if(addBtn.length>0){
                                                                wSelf.moveBtn(addBtn, pal.scGrp);
                                                            }
                                                        }
                                                    }
                                                }

                pal.center();
                pal.show();
            },

            //カレントディレクトリ内のフォルダリストを取得
            getTitle: function(targetDir)
            {
                var defFol = new Folder(targetDir);
                var allList = defFol.getFiles();
                var tList = new Array();
                var ii=0;
                for (var i= 0; i < allList.length; i++) {
                    //フォルダじゃないもの排除
                    if(new Folder(allList[i]).getFiles() != ""){
                        tList[ii] = allList[i];
                        ii++;
                    }
                }
                //alert(tList.length);
                return tList;
            },

            //ボタンセットアップ
            setDirBtn: function(scG, btnList, valX,valY)
            {
                if(btnList.length>0){
                    var pSelf = this;
                    makeBtn = new Array(btnList.length);
                    for(var i=0;i<makeBtn.length;i++){
                        makeBtn[i] = scG.add("group", [valX, valY, valX + 170, valY + 20]);
                        makeBtn[i].fsN = btnList[i];
                        makeBtn[i].sel = false;
                        makeBtn[i].OB = this;
                        this.UI_bgColor255(makeBtn[i], [100,100,100]);
                        fName = makeBtn[i].add("statictext", [2,2,168,18], File.decode(btnList[i].name));
                        fName.helpTip = "[RightClick: Open Folder]";
                        this.UI_fgColor255(fName, [240,240,240]);
                        this.UI_font(fName, "Arial","BOLD", 11);

                        //マウスリスナー
    					makeBtn[i].addEventListener('mousedown',pSelf.mdFunc1);
                    }

                    if(makeBtn[0].location.x + 175 > 800){
                        var bVal = scG.size[0];
                        scG.size = [makeBtn[0].location.x + 175, scG.size[1]];
                        var nVal = Math.abs(scG.size[0] - bVal);
                        app.tweenAE([scG], ["location.x"], [nVal * -1], 0.3, ["easeOut"]);
                    }else if(scG.location.x < 0){
                        app.tweenAE([scG], ["location.x"], [0 - scG.location.x], 0.3, ["easeOut"]);
                        scG.location.x = 0;
                        scG.size = [800, scG.size[1]];
                    }
                    return makeBtn;
                }
            },

            //ボタンアニメーション
            moveBtn: function(btnObj, scG)
            {
                if(btnObj.length>1){
                    var arrBtn = new Array();
                    var lastBtn = null;
                    arrBtn = btnObj;
                    while(arrBtn.length>0)
                    {
                        arrBtn.shift();
                        if(arrBtn.length>1){
                            app.tweenAE(arrBtn, ["location.y"], [23], 0.01, ["Linear"]);
                        }else if(arrBtn.length==1){
                            app.tweenAE(arrBtn, ["location.y"], [23], 0.15, ["easeOut"]);
                            lastBtn = arrBtn[0];
                        }
                    }

                    if(lastBtn.location.y + 25 > 550){
                        scG.size = [scG.size[0], lastBtn.location.y + 25];
                        scG.maxSY.push(scG.size[1]);
                        var nVal = Math.abs(scG.size[1] - 550);
                        app.tweenAE([scG], ["location.y"], [nVal * -1], 0.3, ["easeOut"]);
                    }else if(scG.location.y < 0){
                        app.tweenAE([scG], ["location.y"], [0 - scG.location.y], 0.3, ["easeOut"]);
                        scG.location.y = 0;
                        scG.size = [scG.size[0], 550];
                    }
                }
            },

            //ボタンアニメーション
            reMoveBtn: function(scG)
            {
                if(scG.location.y < 0){
                    app.tweenAE([scG], ["location.y"], [0 - scG.location.y], 0.3, ["easeOut"]);
                    scG.location.y = 0;
                    scG.size = [scG.size[0], 550];
                }

                var arrBtn2 = new Array();
                var cc=0;
                while(cc<scG.children.length)
                {
                    arrBtn2[cc] = scG.children[cc];
                    cc++;
                }
                var aB=0;
                while(arrBtn2.length>0)
                {
                    arrBtn2.shift();
                    if(arrBtn2.length>1){
                        app.tweenAE(arrBtn2, ["location.y"], [-23], 0.01, ["Linear"]);
                    }else{
                        app.tweenAE(arrBtn2, ["location.y"], [-23], 0.15, ["easeOut"]);
                    }
                }

                while(scG.children.length>0)
                {
                    scG.children[0].remove(0);
                    scG.remove(0);
                }
                scG.maxSY = new Array();
            },

            //ボタンアニメーション
            closeBtn: function(scG, thisXVal)
            {
                var arrBtn2 = new Array();
                var btnNum = new Array();
                var cc=0;
                while(cc<scG.children.length)
                {
                    if(scG.children[cc].location.x > thisXVal){
                        arrBtn2.push(scG.children[cc]);
                        btnNum.push(cc);
                    }
                    cc++;
                }

                if(arrBtn2.length>0){
                    if(arrBtn2.length>1){
                        var aB=0;
                        var arrBtn3 = arrBtn2;
                        while(arrBtn3.length>0)
                        {
                            arrBtn3.shift();
                            if(arrBtn3.length>1){
                                app.tweenAE(arrBtn3, ["location.y"], [-23], 0.01, ["Linear"]);
                            }else{
                                app.tweenAE(arrBtn3, ["location.y"], [-23], 0.15, ["easeOut"]);
                            }
                        }
                    }

                    var cc=scG.children.length - 1;
                    while(cc>=0)
                    {
                        if(scG.children[cc].location.x > thisXVal){
                            scG.children[cc].remove(0);
                            scG.remove(btnNum[btnNum.length-1]);
                            btnNum.reverse();
                            btnNum.shift();
                            btnNum.reverse();
                        }
                        cc--;
                    }
                }

                if(scG.children.length>0){
                    scG.maxSY.reverse();
                    scG.maxSY.shift();
                    scG.maxSY.reverse();
                    var arrSY = scG.maxSY;
                    arrSY.sort();
                    var maxValY = arrSY[arrSY.length-1];
                    scG.size = [scG.size[0], maxValY];

                    if(Math.abs(scG.children[scG.children.length-1].location.x)<620 && maxValY<550){
                        if(scG.location.x <= 0 && scG.location.y <= 0){
                            app.tweenAE([scG], ["location.x", "location.y"], [0 - scG.location.x, 0 - scG.location.y], 0.3, ["easeOut", "easeOut"]);
                            scG.location = [0,0];
                            scG.size = [800, 550];
                        }else if(scG.location.x <= 0){
                            app.tweenAE([scG], ["location.x"], [0 - scG.location.x], 0.3, ["easeOut"]);
                            scG.location.x = 0;
                            scG.size = [800, scG.size[1]];
                        }else if(scG.location.y <= 0){
                            app.tweenAE([scG], ["location.y"], [0 - scG.location.y], 0.3, ["easeOut"]);
                            scG.location.y = 0;
                            scG.size = [scG.size[0], 550];
                        }
                    }else if(scG.children[scG.children.length-1].location.x<620){
                        if(scG.location.x <= 0){
                            app.tweenAE([scG], ["location.x"], [0 - scG.location.x], 0.3, ["easeOut"]);
                            scG.location.x = 0;
                            scG.size = [800, scG.size[1]];
                        }
                    }else if(maxValY<550){
                        if(scG.location.y <= 0){
                            app.tweenAE([scG], ["location.y"], [0 - scG.location.y], 0.3, ["easeOut"]);
                            scG.location.y = 0;
                            scG.size = [scG.size[0], 550];
                        }
                    }
                }
            },

            //マウスイベント(mousedown)
            mdFunc1: function(e)
            {
                switch(e.button)
                {
                    case 0: for(var mN=0;mN<this.parent.children.length;mN++){
                                if(this.parent.children[mN].sel){
                                    this.OB.UI_bgColor255(this.parent.children[mN], [100,100,100]);
                                    this.parent.children[mN].sel = false;
                                }
                            }

                            this.OB.closeBtn(this.parent, this.location.x);

                            this.OB.UI_bgColor255(this, [150,120,69]);
                            this.sel = true;

                            var addList = this.OB.getTitle(this.fsN);
                            if(addList.length>0){
                                var addBtn = this.OB.setDirBtn(this.parent , addList, this.location.x + 175, this.location.y);
                                if(addBtn.length>0){
                                    this.OB.moveBtn(addBtn, this.parent);
                                }
                            }
                            break;
                    case 2: Folder(this.fsN).execute(); break;
                }
            },

            //マウスイベント(mousedown)
            mdFunc2: function(md2)
            {
                this.OB.UI_bgColor255(this.parent, [150,120,69]);
                var scGG = this.parent.parent.parent.scGrp;
                switch(this.val)
                {
                    case "L": if(scGG.size[0]>800){
                                  if(scGG.location.x + 175<0){
                                      app.tweenAE([scGG], ["location.x"], [175], 0.3, ["easeOut"]);
                                  }else{
                                      app.tweenAE([scGG], ["location.x"], [Math.abs(scGG.location.x)], 0.3, ["easeOut"]);
                                  }
                              }
                              break;
                    case "T": if(scGG.size[1]>550){
                                  if(scGG.location.y + 100<0){
                                      app.tweenAE([scGG], ["location.y"], [100], 0.3, ["easeOut"]);
                                  }else{
                                      app.tweenAE([scGG], ["location.y"], [Math.abs(scGG.location.y)], 0.3, ["easeOut"]);
                                  }
                              }
                              break;
                    case "B": if(scGG.size[1]>550){
                                  if(scGG.location.y - 100>550 - scGG.size[1]){
                                      app.tweenAE([scGG], ["location.y"], [-100], 0.3, ["easeOut"]);
                                  }else{
                                      app.tweenAE([scGG], ["location.y"], [550 - scGG.size[1] - scGG.location.y], 0.3, ["easeOut"]);
                                  }
                              }
                              break;
                    case "R": if(scGG.size[0]>800){
                                  if(scGG.location.x - 175>800 - scGG.size[0]){
                                      app.tweenAE([scGG], ["location.x"], [-175], 0.3, ["easeOut"]);
                                  }else{
                                      app.tweenAE([scGG], ["location.x"], [800 - scGG.size[0] - scGG.location.x], 0.3, ["easeOut"]);
                                  }
                              }
                              break;
                }
                this.OB.UI_bgColor255(this.parent, [100,100,100]);
            },

            //backgroundColor(0～255): UI_bgColor255(オブジェクト名, [R, G, B])
            UI_bgColor255: function(uiObj, uiColor)
            {
            	var gColor = new Array();
            	for(var i=0;i<3;i++){
            		gColor[i] = 1/255*Math.round(uiColor[i]);
            		//alert(gColor[i]);
            	}
            	var gUI = uiObj.graphics;
            	var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
            	gUI.backgroundColor = uiBrush;
            },

            //foregroundColor(0～255): UI_fgColor255(オブジェクト名, [R, G, B])
            UI_fgColor255: function(uiObj, uiColor)
            {
            	var gColor = new Array();
            	for(var i=0;i<3;i++){
            		gColor[i] = 1/255*Math.round(uiColor[i]);
            		//alert(gColor[i]);
            	}
            	var gUI = uiObj.graphics;
            	var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
            	gUI.foregroundColor = uiPen;
            },

            //font: UI_font(オブジェクト名, ポストスクリプトネーム<フォント名・String>, フォントサイズ)
            UI_font: function(uiObj, uiFont, uiFontStyle, uiFontSize)
            {
            	var fontStyle = eval("ScriptUI.FontStyle." + uiFontStyle);
            	var gFont = ScriptUI.newFont (uiFont, fontStyle, uiFontSize);
            	uiObj.graphics.font = gFont;
            },

            runFunc: function()
            {
                this.osChk();
                if(! this.valE){
                    this.win_Bld();
                }
            }
        }

        // sub main
        var GT = new runScp(thisObj);

        //アプリのバージョン確認 (CS4 over)
        if (parseFloat(app.version) < 9)
        {
        	alert(GT.strErr);
        	return;
        }else{
        	GT.runFunc(thisObj);
        }
    }
}