﻿// AE Script用アニメーションライブラリ(Windows ONLY)
//
// _tweenAE_Lib.jsx   ver.1.0   2012.01.10
//
// 動作確認
// AfterEffects CS4  /  windows XP 64bit
//
// ※Macでは最終的な結果として移動しますが、途中のアニメーションはしません
//
//
//
//   Copyright: @curryegg  All rights reserved.
//   email:   curry_eggs@yahoo.co.jp       blog:   http://curryegg.blog.shinobi.jp/        twitter account:   curry_eggs
//
//


//アプリのバージョン確認 (CS4 over)
if (parseFloat(app.version) < 9)
{
	alert("CS4 以上じゃないとダメだってばっ！！");
}else{
    (function()
    {

        //アニメーション用Func
        //tweenAE([オブジェクト :Array], [パラメーターString :Array]<"location.x" or "location.y" or "size.x" or "size.y" :Array>, [移動幅 :Array], 秒数, [オプションString :Array]<"Linear" or "easeIn" or "easeOut" or "easeInOut">)
        Application.prototype.tweenAE =
        function(valObjs, valParams, valDises, valSec, valOptions)
        {
            //alert(valObjs.length +"_"+ valParams.length +"_"+ valDises.length +"_"+ valOptions.length);
            if(valParams.length == valDises.length && valParams.length == valOptions.length){
                //Win用 アニメーション有
                if(OSChker() == "Win"){
                    //デバック用
                    //var dateStart = Date(0);

                    var arrDis = valDises;
                    arrDis.sort();
                    var sC = 0;
                    var sCMax = Math.abs(arrDis[arrDis.length-1]);
                    //1sec = 1000;
                    var valSL = 1000 * valSec / sCMax;

                    while(sC < sCMax)
                    {
                        for(var vO=0;vO<valObjs.length;vO++)
                        {
                            var valObj = valObjs[vO];
                            for(var vOO=0;vOO<valParams.length;vOO++)
                            {
                                //実行 オプション判別
                                if(valOptions[vOO] == "Linear"){
                                    LinearAct(valObj, valParams[vOO], valDises[vOO], sC, sCMax);
                                }else if(valOptions[vOO] == "easeIn"){
                                    easeInAct(valObj, valParams[vOO], valDises[vOO], sC, sCMax);
                                }else if(valOptions[vOO] == "easeOut"){
                                    easeOutAct(valObj, valParams[vOO], valDises[vOO], sC, sCMax);
                                }else if(valOptions[vOO] == "easeInOut"){
                                    easeInOutAct(valObj, valParams[vOO], valDises[vOO], sC, sCMax);
                                }else{
                                    alert("******["+ valOptions[vOO] +"] は有効なオプションではありません******");
                                }
                            }
                        }

                        sC++;
                        $.sleep(valSL);
                    }

                    //デバック用
                    //var dateEnd = Date(1);
                    //alert(dateStart +"\r\n"+ dateEnd +"\r\n"+ sCMax);
                //Mac用 アニメーション無し
                }else if(OSChker() == "Mac"){
                    for(var vO=0;vO<valObjs.length;vO++)
                    {
                        var valObj = valObjs[vO];
                        for(var vOO=0;vOO<valParams.length;vOO++)
                        {
                            //パラメーター判別
                            switch (valParams[vOO])
                            {
                                case "location.x": valObj.location.x += valDises[vOO]; break;
                                case "location.y": valObj.location.y += valDises[vOO]; break;
                                case "size.x": valObj.size = [valObj.size[0] + valDises[vOO], valObj.size[1]]; break;
                                case "size.y": valObj.size = [valObj.size[0], valObj.size[1] + valDises[vOO]]; break;
                            }
                        }
                    }
                }
            }

            //OSチェッカー
            function OSChker()
            {
                if(File.fs == "Windows"){
                    return "Win";
                }else if(File.fs == "Macintosh"){
                    return "Mac";
                }
            }

            //******各オプション用ファンクション******
            function LinearAct(valObj, valParam, valDis, sC, sCMax)
            {
                //小数点以下も計算
                if(sC == 0){
                    var valCalA = 0
                }else{
                    var valCalA = Math.abs(valDis) / sCMax * sC;
                }
                var valCalB = Math.abs(valDis) / sCMax * (sC + 1);

                //整数値のみ取得
                var moveVal = Math.floor(valCalB) - Math.floor(valCalA);

                if(valDis >= 0){
                    //パラメーター判別
                    switch (valParam)
                    {
                        case "location.x": valObj.location.x += moveVal; break;
                        case "location.y": valObj.location.y += moveVal; break;
                        case "size.x": valObj.size = [valObj.size[0] + moveVal, valObj.size[1]]; break;
                        case "size.y": valObj.size = [valObj.size[0], valObj.size[1] + moveVal]; break;
                    }
                }else{
                    //パラメーター判別
                     switch (valParam)
                    {
                        case "location.x": valObj.location.x -= moveVal; break;
                        case "location.y": valObj.location.y -= moveVal; break;
                        case "size.x": valObj.size = [valObj.size[0] - moveVal, valObj.size[1]]; break;
                        case "size.y": valObj.size = [valObj.size[0], valObj.size[1] - moveVal]; break;
                    }
                }
            }

            function easeInAct(valObj, valParam, valDis, sC, sCMax)
            {
                //a = Y / Math.pow(X, 2) 二次関数 0<a x=最大値
                var thrVal = Math.abs(valDis) / Math.pow(Math.abs(sCMax), 2);

                //小数点以下も計算
                if(sC == 0){
                    var valCalA = 0
                }else{
                    //Y = a * Math.pow(X, 2) 二次関数
                    var valCalA = thrVal * Math.pow(sC, 2);
                }
                //Y = a * Math.pow(X, 2) 二次関数
                var valCalB = thrVal * Math.pow(sC + 1, 2);

                //１回分の値
                var moveVal = Math.floor(valCalB) - Math.floor(valCalA);

                if(valDis >= 0){
                    //パラメーター判別
                    switch (valParam)
                    {
                        case "location.x": valObj.location.x += moveVal; break;
                        case "location.y": valObj.location.y += moveVal; break;
                        case "size.x": valObj.size = [valObj.size[0] + moveVal, valObj.size[1]]; break;
                        case "size.y": valObj.size = [valObj.size[0], valObj.size[1] + moveVal]; break;
                    }
                }else{
                    //パラメーター判別
                    switch (valParam)
                    {
                        case "location.x": valObj.location.x -=  moveVal; break;
                        case "location.y": valObj.location.y -= moveVal; break;
                        case "size.x": valObj.size = [valObj.size[0] - moveVal, valObj.size[1]]; break;
                        case "size.y": valObj.size = [valObj.size[0], valObj.size[0] - moveVal]; break;
                    }
                }
            }

            function easeOutAct(valObj, valParam, valDis, sC2, sCMax)
            {
                //a = Y / Math.pow(X, 2) 二次関数 a<0 x=最大値
                var thrVal = Math.abs(valDis) / Math.pow(sCMax, 2) * -1;

                //小数点以下も計算
                //Y = a * Math.pow(X, 2) + q 二次関数 + 原点戻し
                var valCalA = thrVal * Math.pow((sCMax - sC2) * -1, 2) + Math.abs(valDis);

                //Y = a * Math.pow(X, 2) + q 二次関数 + 原点戻し
                var valCalB = thrVal * Math.pow((sCMax - (sC2 + 1)) * -1, 2) + Math.abs(valDis);

                //１回分の値
                var moveVal = Math.floor(valCalB) - Math.floor(valCalA);
                if(valDis >= 0){
                    //パラメーター判別
                    switch (valParam)
                    {
                        case "location.x": valObj.location.x += moveVal; break;
                        case "location.y": valObj.location.y += moveVal; break;
                        case "size.x": valObj.size = [valObj.size[0] + moveVal, valObj.size[1]]; break;
                        case "size.y": valObj.size = [valObj.size[0], valObj.size[1] + moveVal]; break;
                    }
                }else{
                    //パラメーター判別
                    switch (valParam)
                    {
                        case "location.x": valObj.location.x -= moveVal; break;
                        case "location.y": valObj.location.y -= moveVal; break;
                        case "size.x": valObj.size = [valObj.size[0] - moveVal, valObj.size[1]]; break;
                        case "size.y": valObj.size = [valObj.size[0], valObj.size[1] - moveVal]; break;
                    }
                }
            }

            function easeInOutAct(valObj, valParam, valDis, sC, sCMax)
            {
                var hVal = Math.floor(sCMax / 2);
                if(sC < hVal){
                    //easeIn ※距離の前半
                    easeInAct(valObj, valParam, valDis, sC, sCMax);
                }else{
                    //easeOut ※距離の後半
                    easeOutAct(valObj, valParam, valDis, sC - hVal, sCMax - 1);
                }
            }
        }
    })();

}