﻿// test_Floating_UI    14/03/18
//
//  フローティングアイコンのUIテスト
//  CC では Mac でのオブジェクトの作成順位と上下関係が Win と同じになった模様


(function()
{
    floating_UI(this);

    function floating_UI(thisObj)
    {
        function runScr()
        {
            //Item
            this.scItem = new Array();
            for(var c=0;c<10;c++){
                if(c < 9){
                    this.scItem[c] = "items_0" + String(c+1);
                }else{
                    this.scItem[c] = "items_" + String(c+1);
                }
            }

            this.gpSize = 22;
            this.scGP = new Array();
            this.scInfo = new Array();
            this.scInfo = new Array();
            this.minMax = new Array();
            this.arrVal = new Array();
            this.upLoc = new Array();
            this.downLoc = new Array();
            this.mdVal = null;
            this.valD = false;

            this.idNum = null;
            this.valY = 0;
            this.curY = 0;
            this.sY = 0;
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CC 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //64bit OSかどうか
                    if(app.version.indexOf("9") == 0 && $.os.indexOf("64") != -1){
                        //AE CS4 Scriptsフォルダパス<64bit OS>
                        this.aePath = "C:/Program Files (x86)/Adobe/Adobe After Effects CS" + this.verVal + "/Support Files/";
                    }else{
                        //AE Scriptsフォルダパス
                        //CS5の場合、小数点あり
                        if(this.verVal == 5){
                            this.verVal = Number(app.version.split("x")[0]) - 5;
                            this.aePath = "C:/Program Files/Adobe/Adobe After Effects CS" + this.verVal + "/Support Files/";
                        //CS6
                        }else if(this.verVal == 6){
                            this.aePath = "C:/Program Files/Adobe/Adobe After Effects CS" + this.verVal + "/Support Files/";
                        //CC
                        }else if(this.verVal == 7){
                            this.aePath = "C:/Program Files/Adobe/Adobe After Effects CC" + "/Support Files/";
                        }
                    }

                    //Windows
                    this.OS = "Win";
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    //CS5の場合、小数点あり
                    if(this.verVal == 5){
                        this.verVal = Number(app.version.split("x")[0]) - 5;
                        this.aePath = "/Applications/Adobe After Effects CS" + this.verVal + "/";
                    //CS6
                    }else if(this.verVal == 6){
                        this.aePath = "/Applications/Adobe After Effects CS" + this.verVal + "/";
                    //CC
                    }else if(this.verVal == 7){
                        this.aePath = "/Applications/Adobe After Effects CC" + "/";
                    }

                    //Mac
                    this.OS = "Mac";
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //Scriptsフォルダパス
                this.scFol = this.aePath + "Scripts/";

                //tab space
                this.tabS = "\t";

                //alert(this.aePath);
            },

            //
            bld_DLG: function()
            {
                dSelf = this;
                this.dlg = new Window("window"," test_Floating_UI",[0,0,400,520]);

                this.scGrp = this.dlg.add("panel",[30,50,300,300],"",{borderStyle:"black"});
                var listH = (this.scItem.length * this.gpSize-1) + (this.scItem.length * 3);
                if(listH < this.scGrp.size[1]){
                    listH = this.scGrp.size[1];
                }
                this.scList = this.scGrp.add("group",[0,0,this.scGrp.size[0]-19,500]);
                this.UI_bgColor255(this.scList,[40,40,40]);
                this.scList.addEventListener('mousemove',this.mvFunc);

                for(var i=0;i<this.scItem.length;i++){
                    this.scGP[i] = this.scList.add("group",[0,(i*this.gpSize) + (i*3),250,((i+1)*this.gpSize-1) + ((i+1)*3)]);
                    this.UI_bgColor255(this.scGP[i],[70,70,70]);
                    this.scGP[i].id = i;
                    this.upLoc.push(((i+1)*this.gpSize-1) + ((i+1)*3));
                    this.downLoc.push(this.scGP[i].location[1]);
                    this.scGP[i].loc = [this.scGP[i].location[1], ((i+1)*this.gpSize-1) + ((i+1)*3)];
                    this.scGP[i].addEventListener('mousedown',this.mdFunc);

                    this.scInfo[i] = this.scGP[i].add("statictext",[5,0,this.scGP[i].size[0],this.scGP[i].size[1]],this.scItem[i]); this.scInfo[i].justify = "left";

                    if(i == 0){
                        this.minMax[0] = this.scGP[i].location[1];
                    }else if(i == this.scItem.length-1){
                        this.minMax[1] = this.scGP[i].location[1];
                    }
                }

                //floating Icon
                this.fIcon = this.scList.add("group",[0,0,250,this.gpSize  + 2]);
                this.UI_bgColor255(this.fIcon,[120,120,240]);
                this.fIcon.id = 0;
                this.fIcon.addEventListener('mouseup',this.muFunc);
                this.fInfo = this.fIcon.add("statictext",[5,0,this.fIcon.size[0],this.fIcon.size[1]],""); this.fInfo.justify = "left";
                this.fIcon.visible = false;



                this.scrBar = this.scGrp.add("scrollbar",[this.scGrp.size[0]-20,0,this.scGrp.size[0]-1,this.scGrp.size[1]-5],0,0,100);
                this.scrBar.stepdelta = 5;
                var slVal = (dSelf.scList.size[1] - this.scGrp.size[1]) / 100;
                this.scrBar.onChanging = function()
                                                {
                                                    dSelf.scList.location[1] = this.value * slVal * -1;
                                                }
                this.scrBar.onChange= function()
                                                {
                                                    dSelf.scList.location[1] = this.value * slVal * -1;
                                                }

                this.logInfo = this.dlg.add("statictext",[10,310,300,510],"",{multiline:true});
                this.logInfo2 = this.dlg.add("statictext",[310,10,390,510],"",{multiline:true});

                this.dlg.center();
                this.dlg.show();
            },

            //maouse event
            //mousedown
            mdFunc: function(md)
            {
                if(! dSelf.valD){
                    dSelf.valY = md.clientY;
                    dSelf.fIcon.location = this.location;
                    dSelf.fIcon.id = this.id;
                    dSelf.fInfo.text = dSelf.scInfo[this.id].text;
                    dSelf.fIcon.visible = true;

                    dSelf.valD = true;
                    dSelf.idNum = this.id;
                    this.visible = false;

                    dSelf.arrVal = new Array();
                    for(var i=0;i<dSelf.scItem.length;i++){
                        if(i != this.id){
                            dSelf.arrVal.push(dSelf.scItem[i]);
                        }
                    }

                    dSelf.sY = md.screenY;

                    //ログ
                dSelf.logInfo.text = "select ID: " + dSelf.fIcon.id +dSelf.CF+ "move ID: "+ dSelf.idNum +dSelf.CF+ "ID Area: "+ dSelf.scGP[dSelf.idNum].loc.join("_")
                }
            },

            //mouseup
            muFunc: function(mu)
            {
                dSelf.scInfo[dSelf.idNum].text = dSelf.scItem[dSelf.fIcon.id];
                dSelf.scGP[dSelf.idNum].visible = true;
                var newItem = new Array();
                for(var i=0;i<dSelf.scItem.length;i++){
                    newItem[i] = dSelf.scInfo[i].text
                    dSelf.scGP[i].visible = true;
                }
                dSelf.scItem = newItem;

                dSelf.fIcon.visible = false;
                dSelf.valD = false;
                dSelf.idNum = null;

                //ログ
                dSelf.logInfo2.text = dSelf.scItem.length + " Items" +dSelf.CF+dSelf.CF+ dSelf.scItem.join(dSelf.CF);
            },

            //mousemove
            mvFunc: function(mv)
            {
                if(dSelf.valD){
                    dSelf.curY = mv.clientY - dSelf.valY;
                    if(dSelf.curY < dSelf.minMax[0]){
                        dSelf.curY = dSelf.minMax[0];
                    }else if(dSelf.minMax[1] <= dSelf.curY){
                        dSelf.curY = dSelf.minMax[1];
                    }

                    //マウスが上移動か下移動か
                    if(dSelf.curY - dSelf.fIcon.location[1] < dSelf.curY){
                        var pVal = "+";
                    }else{
                        var pVal = "-";
                    }
                    //dSelf.fIcon.location[1] = dSelf.curY;

                    //下に移動
                    if(pVal == "+"){
                        if(dSelf.scGP[dSelf.idNum].loc[1] < dSelf.curY){
                            dSelf.scInfo[dSelf.idNum].text = dSelf.arrVal[dSelf.idNum];
                            dSelf.scGP[dSelf.idNum].visible = true;

                            dSelf.idNum++;
                            dSelf.scGP[dSelf.idNum].visible = false;
                        }
                    //上に移動
                    }else if(pVal == "-"){
                        if(dSelf.curY < dSelf.scGP[dSelf.idNum].loc[0]){
                            dSelf.scInfo[dSelf.idNum].text = dSelf.arrVal[dSelf.idNum-1];
                            dSelf.scGP[dSelf.idNum].visible = true;

                            dSelf.idNum--;
                            dSelf.scGP[dSelf.idNum].visible = false;
                        }
                    }
                    //ログ
                    dSelf.logInfo.text = "select ID: " + dSelf.fIcon.id +dSelf.CF+ "move ID: "+ dSelf.idNum +dSelf.CF+ "move ID Area: "+ dSelf.scGP[dSelf.idNum].loc.join("_")
                                         +dSelf.CF+ "LocalY: "+ dSelf.curY +dSelf.CF+ "Up_Down: "+ pVal;

                    dSelf.fIcon.location[1] = dSelf.curY;
                }
            },

            //scriptUI graphics 用ファンクション****************************************************
            //get backgroundColor255
            getUI_bgColor255: function(uiObj)
            {
                var curColor = uiObj.graphics.backgroundColor.color;
                var bgColor = new Array();
                for(var i=0;i<3;i++){
                    bgColor[i] = Math.round(curColor[i] * 255);
                }

                return bgColor;
            },

            //backgroundColor(0～255)
            UI_bgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiBrush = gUI.newBrush(gUI.BrushType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1]);
                gUI.backgroundColor = uiBrush;
            },

            //foregroundColor(0～255)
            UI_fgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
                gUI.foregroundColor = uiPen;
            },

            //font
            UI_font: function(uiObj, uiFont, uiFontStyle, uiFontSize)
            {
                var fontStyle = eval("ScriptUI.FontStyle." + uiFontStyle);
                var gFont = ScriptUI.newFont (uiFont, fontStyle, uiFontSize);
                uiObj.graphics.font = gFont;
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.bld_DLG();
            }
        }

        // sub main
        var TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CC over)
        if (parseFloat(app.version) < 12)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();