﻿//   setRenQ_CC.jsx ver.1.1  2016.03.29
//
//
//    選択したコンポ(複数可)をレンダーキューに追加します。
//    その際に、あらかじめ登録してある保存先のパスを任意選択できます。
//
//    以前に書いたスクリプトの改訂版です。
//    AfterEffects CS4 以上で動作。
//    
//    
//    2016.03.29    ver.1.0 ファイル名に連番をつけるオプションをチェックボックスに変更
//    
//
//    =動作確認=
//    AfterEffects CC2014
//    windows 7
//
//  = curryegg =
//  mail: curryeggs@gmail.com
//  twitter: @curry_eggs
//  blog: http://curryegg.blog.shinobi.jp/
//  


(function()
{
    setRenQ(this);

    function setRenQ(thisObj)
    {
        function runScr()
        {
            //名前に文字を追加する条件のデフォルト指定  0 = non, 1 = cellフォルダ名のみ, 2 = cellフォルダ名とファイル名, 3 = ファイル名のみ
            this.addStrNo = 0;

            //追加する文字のデフォルト指定用配列 [ non, cellフォルダ名のみ, cellフォルダ名とファイル名, ファイル名のみ ]
            this.addStr = ["", "", "",""];


            this.getPref = new Array();
            this.fList = new Array();
            this.valE = false;
            this.actProj = app.project;
            this.selComps = new Array();
            this.curFol = null;
            this.temps = new Array();
            this.defIndex = null;
            this.valD = false;
            this.moIndex = null;
            this.valMK = true;
            this.addNameList = ["non", "cellフォルダ名のみに追加", "cellフォルダ名とファイル名に追加", "ファイル名のみに追加"];
            this.addName = "";
        }

        runScr.prototype =
        {
            //アプリバージョン確認・エラーコメント
            strErr: "****** CS4 以上じゃないですよっと ******",

            //OS判別
            osChk: function()
            {
                //AE CS バージョン取得
                this.verVal = parseInt(app.version.split(".")[0]) - 5;

                //改行コード用(Win & Mac 両対応)
                if(File.fs == "Windows"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Windows
                    this.OS = "Win";
                    //root
                    this.rootFol = "c:/";
                    //new root
                    this.newRootFol = this.rootFol;
                    //改行コード
                    this.CF = "\r\n";
                    //パスのバックスラッシュ
                    this.cN = "\\";
                }else if(File.fs == "Macintosh"){
                    //AE Scriptsフォルダパス
                    this.aePath = Folder.startup.parent.parent.parent.fsName.replace(/\\/g,"/") + "/Scripts/";

                    //Mac
                    this.OS = "Mac";
                    //root
                    this.rootFol = "/User/";
                    //new root
                    this.newRootFol = this.rootFol;
                    //改行コード
                    this.CF = "\r";
                    //パスのバックスラッシュ
                    this.cN = "/";
                }

                //tab space
                this.tabS = "\t";

                //pref ファイルパス
                this.setRenQ_pref = this.aePath + "setRenQ_CC_pref.txt";

                //alert(this.aePath);
            },

            //get selected comp
            getComp: function()
            {
                if(this.actProj.file == null){
                    alert("******プロジェクトを保存してください******");
                }else{
                    var aepName = this.actProj.file.name.split(".aep");
                    this.actProj.name = aepName[0];
                    //alert(this.actProj.name);

                    var allItems = this.actProj.items;
                    for(var i=1;i<=allItems.length;i++){
                        if(allItems[i].selected){
                            if(allItems[i] instanceof CompItem){
                                this.selComps.push(allItems[i]);
                            }
                        }
                    }

                    if(this.selComps.length ==0){
                        alert("******コンポが選択されていません******");
                    }else{
                        this.prefSet();
                    }
                }

            },

            //出力モジュールをリスト化
            getTemp: function()
            {
                var testQ = app.project.renderQueue.items.add(this.selComps[0]);
                var curTemps = testQ.outputModule(1).templates;

                //隠れてる設定を除外
                for(var q=0;q<curTemps.length;q++){
                    if(curTemps[q].indexOf("_HIDDEN") == -1){
                        this.temps.push(curTemps[q]);
                    }
                }

                //デフォルトの設定を取得
                for(var q=0;q<this.temps.length;q++){
                    if(testQ.outputModule(1).name == this.temps[q]){
                        this.defIndex = q;
                        break;
                    }
                }

                testQ.remove();
                //alert(this.defIndex);
            },

            //  UI
            BuildUI: function()
            {
                var blObj = new Window("palette"," setRenderQ_CC ver.1.1",[100,50,590,330]);

                blObj.ddlObj = null;
                blObj.ddlObj = undefined;

                this.ReBuildUI(blObj);
            },

            //  パネル内UI
            ReBuildUI: function(reObj)
            {
                var bSelf = this;
                reObj.ddlGroup = reObj.add("panel", [10, 5, 480, 80]);
                reObj.ddlInfo = reObj.ddlGroup.add("statictext",[10, 10, 300, 30], "保存フォルダのパスを選択");
                reObj.ddlInfo.helpTip = "指定した保存フォルダ内に、プロジェクト名のCutフォルダを作成します";
                reObj.addBtn = reObj.ddlGroup.add("button",[310, 10, 460, 30], "保存フォルダを追加");
                reObj.addBtn.onClick = function()
                                                {
                                                    reObj.close();
                                                    bSelf.bld_Add(bSelf.newRootFol);
                                                    bSelf.savePref(new File(bSelf.setRenQ_pref),bSelf.getPref,bSelf.newRootFol);
                                                    bSelf.impPath(bSelf.setRenQ_pref);

                                                    if(! bSelf.valE){
                                                        bSelf.getTemp();
                                                        bSelf.BuildUI();
                                                    }
                                                };
                reObj.ddlObj = reObj.ddlGroup.add("dropdownlist",[30, 35, 430, 60], bSelf.fList);

                reObj.ddlGroup2 = reObj.add("panel", [10, 90, 480, 165]);
                reObj.ddlInfo2 = reObj.ddlGroup2.add("statictext",[10, 10, 460, 30], "出力モジュールを選択");
                reObj.ddlObj2 = reObj.ddlGroup2.add("dropdownlist",[30, 35, 430, 60], bSelf.temps);
                reObj.ddlObj2.selection = reObj.ddlObj2.items[bSelf.defIndex];

                reObj.chkBox = reObj.add("checkbox", [30, 170, 170, 200], "コンポ名のフォルダを作成");
                reObj.chkBox.active = false;
                reObj.chkBox.value = this.valMK;
                if(reObj.chkBox.value){
                    reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、コンポ名のCellフォルダを作成し、その中にファイルを保存します";
                }else{
                    reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、直接ファイルを保存します";
                }
                reObj.chkBox.onClick = function()
                                                            {
                                                                if(reObj.chkBox.value){
                                                                    reObj.chkBox.active = false;
                                                                    reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、コンポ名のCellフォルダを作成し、その中にファイルを保存します";

                                                                    reObj.ddlObj3.selection = reObj.ddlObj3.items[bSelf.addStrNo];
                                                                }else{
                                                                    reObj.chkBox.active = false;
                                                                    reObj.chkBox.helpTip = "プロジェクト名のCutフォルダ内に、直接ファイルを保存します";

                                                                    reObj.ddlObj3.selection = reObj.ddlObj3.items[0];
                                                                }
                                                            };

                reObj.chkBox2 = reObj.add("checkbox", [30, 210, 170, 240], "連番ファイル");
                reObj.chkBox2.helpTip = "ファイル名の後に連番を追記します";
                reObj.chkBox2.value = true;

                reObj.ddlGroup3 = reObj.add("panel", [180, 175, 480, 230]);
                reObj.ddlInfo3 = reObj.ddlGroup3.add("statictext",[10, 5, 180, 25], "名前に文字を追加");
                reObj.ddlInfo3.helpTip = "選んだ条件で、名前に右で指定した文字を追加します";
                reObj.ddlInfo4 = reObj.ddlGroup3.add("statictext",[190, 5, 280, 25], "追加する文字");
                reObj.ddlObj3 = reObj.ddlGroup3.add("dropdownlist",[10, 25, 180, 45], bSelf.addNameList);
                if(reObj.chkBox.value){
                    reObj.ddlObj3.selection = reObj.ddlObj3.items[bSelf.addStrNo];
                }else{
                    reObj.ddlObj3.selection = reObj.ddlObj3.items[0];
                }
                reObj.editTxt = reObj.ddlGroup3.add("edittext",[190, 25, 280, 45]);
                reObj.editTxt.text = bSelf.addStr[reObj.ddlObj3.selection.index];
                reObj.ddlObj3.onChange = function()
                                                                {
                                                                    if(!reObj.chkBox.value){
                                                                        if(reObj.ddlObj3.selection == reObj.ddlObj3.items[1] || reObj.ddlObj3.selection == reObj.ddlObj3.items[2]){
                                                                            reObj.ddlObj3.selection = reObj.ddlObj3.items[0];
                                                                        }
                                                                    }

                                                                    reObj.editTxt.text = bSelf.addStr[reObj.ddlObj3.selection.index];
                                                                };


                reObj.txtEdBtn = reObj.add( "button" , [30, 240, 190, 270] , "パス登録用テキストを編集" );
                reObj.txtEdBtn.helpTip = "パス登録用テキストを開きます。" +this.CF+
                                               "その際、ダイアログは閉じます。";
                reObj.txtEdBtn.onClick = function()
                                                                {
                                                                    bSelf.txtEdit();
                                                                    reObj.close();
                                                                };

                reObj.cancelBtn = reObj.add( "button" , [260, 240, 360, 270] , "Cancel" , {name:"cancel"} );
                reObj.cancelBtn.onClick = function()
                                                                {
                                                                    reObj.Btnon = "Cansel";
                                                                    reObj.close();
                                                                };

                reObj.okBtn = reObj.add( "button" , [370, 240, 480, 270] , "OK" , {name:"ok"} );
                reObj.okBtn.onClick = function()
                                                                {
                                                                    reObj.Btnon = "OK";

                                                                    var nL = reObj.ddlObj.selection;
                                                                    if(nL == null){
                                                                        alert("******保存フォルダが選ばれていません******");
                                                                    }else{
                                                                        reObj.close();
                                                                    }
                                                                };

                reObj.onClose = function()
                                        {
                                            //  "OK" なら、取得
                                            if(reObj.Btnon == "OK"){
                                                var nL = reObj.ddlObj.selection;
                                                var nM = reObj.ddlObj2.selection;
                                                bSelf.valMK = reObj.chkBox.value;

                                                bSelf.curFol = bSelf.getPref[nL.index][1];
                                                //alert(bSelf.curFol);
                                                bSelf.moIndex = nM.index;

                                                bSelf.addName = {
                                                                No : reObj.ddlObj3.selection.index,
                                                                txt : reObj.editTxt.text
                                                                };

                                                bSelf.addRenQ(bSelf,reObj.chkBox2.value);
                                            }
                                        };



                reObj.center();
                reObj.show();

            },

            //
            addRenQ: function(bSelf,valRen)
            {
                app.beginUndoGroup("setRenQ_CC");
                var cFol = bSelf.curFol + "/" + bSelf.actProj.name;
                //保存用Cutフォルダを作成
                var nFol = new Folder(cFol);
                if(!nFol.exists){
                    nFol.create();
                }

                if(nFol.exists){
                    //セルフォルダを作成する場合
                    if(bSelf.valMK){
                        for(var i=0;i<bSelf.selComps.length;i++){
                            var ceFol = null;
                            if(bSelf.addName.No == 1 || bSelf.addName.No == 2){
                                ceFol = cFol + "/" + bSelf.selComps[i].name + bSelf.addName.txt;
                            }else{
                                ceFol = cFol + "/" + bSelf.selComps[i].name;
                            }
                            //保存用cellフォルダを作成
                            var nnFol = null;
                            nnFol = new Folder(ceFol);
                            if(!nnFol.exists){
                                nnFol.create();
                            }

                            if(nnFol.exists){
                                var curQ = app.project.renderQueue.items.add(bSelf.selComps[i]);
                                var curOM = curQ.outputModule(1);
                                curOM.applyTemplate(bSelf.temps[bSelf.moIndex]);
                                var celName = null;
                                if(bSelf.addName.No == 2 || bSelf.addName.No == 3){
                                    celName = bSelf.selComps[i].name + bSelf.addName.txt;
                                }else{
                                    celName = bSelf.selComps[i].name;
                                }

                                //bSelf.offDeb();

                                try{
                                    if(valRen){
                                        curOM.file = new File(ceFol + "/" + celName + "_[####]");
                                    }else{
                                        curOM.file = new File(ceFol + "/" + celName);
                                    }
                                }catch(e){

                                }

                                //bSelf.reDeb();
                            }
                        }
                    //セルフォルダを作成しない場合
                    }else{
                        for(var i=0;i<bSelf.selComps.length;i++){
                            var ceFol = null;
                            ceFol = cFol;

                            var curQ = app.project.renderQueue.items.add(bSelf.selComps[i]);
                            var curOM = curQ.outputModule(1);
                            curOM.applyTemplate(bSelf.temps[bSelf.moIndex]);
                            var celName = null;
                            if(bSelf.addName.No == 2 || bSelf.addName.No == 3){
                                celName = bSelf.selComps[i].name + bSelf.addName.txt;
                            }else{
                                celName = bSelf.selComps[i].name;
                            }

                            //offDeb();

                            try{
                                curOM.file = new File(ceFol + "/" + celName + "_[####]");
                            }catch(e){

                            }

                            //bSelf.reDeb();
                        }
                    }

                }
                app.endUndoGroup();
            },

            //prefSet
            prefSet: function()
            {
                var preFile = new File(this.setRenQ_pref);
                if(! preFile.exists){
                    var getPref = new Array();
                    this.bld_Add(this.rootFol);
                    this.savePref(preFile,this.getPref,this.newRootFol);
                }

                this.impPath(this.setRenQ_pref);

                if(! this.valE){
                    this.getTemp();
                    this.BuildUI();
                }
            },

            //savePref
            savePref: function(exFile,prefObj,rootFolder)
            {
                if(prefObj.length > 0){
                    var saveTxt = "リスト表示名,保存フォルダのパス(win例　C:/～  　mac例　/User/～　※コピペでもＯＫ) ※※２行目から記述してください。※※ RootFolder:" + rootFolder;
                    for(var i=0;i<prefObj.length;i++){
                        if(prefObj[i][0] != "" && prefObj[i][1] != "none"){
                            saveTxt += this.CF+ prefObj[i].join();
                        }else{
                            this.valE = true;
                            break;
                        }
                    }

                    if(! this.valE){
                        //UTF-8にエンコード
                        exFile.encoding = "UTF-8";
                        var flag = exFile.open("w");
                        if(flag){
                            try
                            {
                                //複数行を一気に書き込み
                                exFile.writeln(saveTxt);
                                exFile.close();
                            }catch(e){

                            }
                        }else{
                            this.valE = true;
                            alert("******保存できませんでした******" +this.CF+ exFile.fsName);
                        }
                    }else{
                        alert("リスト表示名、もしくは保存先が正しくありません");
                    }
                }else{
                    this.valE = true;
                    alert("キャンセルされました");
                }
            },

            //bld_Add
            bld_Add: function(oyaFolder)
            {
                var bSelf = this;
                var addUI = new Window("dialog"," add setRenQ_CC ", [0,0,500,300]);
                var infoA = addUI.add("statictext",[5,5,100,25],"リスト表示名");
                var listName = addUI.add("edittext",[10,30,200,60],"");

                var infoB = addUI.add("statictext",[5,80,120,100],"保存先のRootフォルダ");
                var rootBtn = addUI.add("button",[130,80,190,100],".....");
                rootBtn.onClick = function()
                                            {
                                                var oyaFol = new Folder(oyaFolder);
                                                var oyaPath = Folder.selectDialog("保存先のRootフォルダを選択してください",oyaFol);
                                                if(oyaPath){
                                                    curPath.text = oyaPath.fsName;
                                                    bSelf.newRootFol = oyaPath.fsName;
                                                }
                                            };
                var curPath = addUI.add("statictext",[10,110,490,150],bSelf.newRootFol,{multiline:true}); curPath.justify = "left";
                this.UI_fgColor255(curPath,[220,150,0]);

                var infoC = addUI.add("statictext",[5,180,50,200],"保存先");
                var saveBtn = addUI.add("button",[60,180,120,200],".....");
                saveBtn.onClick = function()
                                            {
                                                var fFol = new Folder(bSelf.newRootFol);
                                                var addPath = Folder.selectDialog("保存先フォルダを選択してください",fFol);
                                                if(addPath){
                                                    savePath.text = addPath.fsName;
                                                }
                                            };
                var savePath = addUI.add("statictext",[10,210,490,250],"none",{multiline:true}); savePath.justify = "left";
                this.UI_fgColor255(savePath,[220,150,0]);

                var okBtn = addUI.add("button",[390,255,490,290],"OK");
                okBtn.onClick = function()
                                        {
                                            bSelf.getPref.push([listName.text,savePath.text]);
                                            addUI.close();
                                        };

                addUI.center();
                addUI.show();
            },

            //import Txt
            impPath: function(impTxt)
            {
                this.getPref = new Array();
                this.fList = new Array();
                var impFile = new File(impTxt);
                if(impFile.open("r")){
                    try{
                        var i = 0;
                        do{
                            var txt = impFile.readln();
                            if(i == 0){
                                this.newRootFol = txt.split("RootFolder:")[1];
                            }else{
                                var txtArray = new Array();
                                txtArray = txt.split(",");
                                this.getPref.push(txtArray);
                                this.fList.push(txtArray[0]);
                            }
                            i++;
                        }while(! impFile.eof);
                    }catch(e){
                        alert("******読み込みに失敗しました******");
                         this.valE = true;
                    }
                }else{
                    alert("******読み込み出来ませんでした******");
                    this.valE = true;
                }

                if(this.getPref.length == 0){
                    alert("******パスが登録されていません******");
                    this.valE = true;
                }

            },

            txtEdit: function()
            {
                var exFile = new File(this.setRenQ_pref);
                File(exFile).execute();
            },

            //JavaScript Debuggerが有効だったら、無効にする
            offDeb: function()
            {
                 var j = app.preferences.getPrefAsLong("Main Pref Section","Pref_JAVASCRIPT_DEBUGGER");
                //alert(j);

                if(j == 1){
                    app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 0);
                    app.preferences.saveToDisk();
                    app.preferences.reload();

                    this.valD = true;
                }
            },

            //JavaScript Debuggerの設定を変えてたら、元に戻す
            reDeb: function()
            {
               if(this.valD){
                   app.preferences.savePrefAsLong("Main Pref Section", "Pref_JAVASCRIPT_DEBUGGER", 1);
                   app.preferences.saveToDisk();
                   app.preferences.reload();

                   this.valD = false;
               }
            },

            //scriptUI graphics 用ファンクション****************************************************
            //foregroundColor(0～255)
            UI_fgColor255: function(uiObj, uiColor)
            {
                var gColor = new Array();
                for(var i=0;i<3;i++){
                    gColor[i] = 1/255*Math.round(uiColor[i]);
                    //alert(gColor[i]);
                }
                var gUI = uiObj.graphics;
                var uiPen = gUI.newPen(gUI.PenType.SOLID_COLOR, [gColor[0], gColor[1], gColor[2], 1], 1);
                gUI.foregroundColor = uiPen;
            },

            runFunc: function(thisObj)
            {
                    this.osChk();
                    this.getComp();
            }
        }

        // sub main
        this.TMP = new runScr(thisObj);

        //アプリのバージョン確認 (CS4 over)
        if (parseFloat(app.version) < 9)
        {
            alert(TMP.strErr);
            return;
        }else{
            TMP.runFunc(thisObj);
        }
    }
})();