#ifndef HSARTK_AS_INCLUDED
#define global HSARTK_AS_INCLUDED

#uselib "hsartk.dll"
#func global ARInitCamera "ARInitCamera" str, int, int, int
#func global ARSelCamera "ARSelCamera" int
#func global _ARGetCameraFovY "ARGetCameraFovY" var
#func global ARSetMarker "ARSetMarker" int, str, double, double, double
#func global ARDetectMarker "ARDetectMarker" int, int, int, int, bmscr
#func global _ARCountMarker "ARCountMarker" var, int
#func global _ARGetMarkerMat "ARGetMarkerMat" var, int, int
#func global _ARGetMarkerMatCont "ARGetMarkerMatCont" var, int, var
#func global _ARCalcMarkerPos "ARCalcMarkerPos" var, var, var, var, var, var, var, int
#func global _ARCalcCameraPos "ARCalcCameraPos" var, var, var, var, var, var, var, int
#func global ARSetCameraPos "ARSetCameraPos" double, double, double, double, double, double, int
#func global ARSetMarkerTransLHtoRH "ARSetMarkerTransLHtoRH" var
#func global ARTerm onexit "ARTerm"

#module

#deffunc ARGetCameraFovY var vRet
	vRet = 0.0
	_ARGetCameraFovY vRet
	return

#deffunc ARCountMarker var vRet, int markerID
	vRet = 0
	_ARCountMarker vRet, markerID
	return

#deffunc ARGetMarkerMat array vRet, int markerID, int maxCount
	if maxCount > 0 {
		ddim vRet, maxCount, 12
	} else {
		ddim vRet, 12
	}
	_ARGetMarkerMat vRet, markerID, maxCount
	return

#deffunc ARGetMarkerMatCont array vRet, int markerID, var prevMat
	ddim vRet, 12
	_ARGetMarkerMatCont vRet, markerID, prevMat
	return

#deffunc ARCalcMarkerPos var x, var y, var z, var a, var b, var c, var trMat, int rotMode
	x = 0.0 : y = 0.0 : z = 0.0 : a = 0.0 : b = 0.0 : c = 0.0
	_ARCalcMarkerPos x, y, z, a, b, c, trMat, rotMode
	a = -a : c = -c
	return

#deffunc ARCalcCameraPos var x, var y, var z, var a, var b, var c, var trMat, int rotMode
	x = 0.0 : y = 0.0 : z = 0.0 : a = 0.0 : b = 0.0 : c = 0.0
	_ARCalcCameraPos x, y, z, a, b, c, trMat, rotMode
	a = -a : c = -c
	return

#global


#endif