// hsartk.cpp : DLL AvP[VpɃGNX|[g֐`܂B
//

#include "stdafx.h"
#include <memory>
#include "hsartk.h"
#include "AR/ar.h"
#include <vector>
#include <functional>
#include <algorithm>
#define _USE_MATH_DEFINES
#include <math.h>
#include "nyar_NyARTransMat.h"

using namespace std;

// ]: HSP modelorder ߂̒`l
#define HGMODEL_ROTORDER_ZYX	0
#define HGMODEL_ROTORDER_XYZ	1
#define HGMODEL_ROTORDER_YXZ	2

// Jő吔
#define MAX_CAMERA_COUNT 2

// ő}[J[ސ
#define MAX_MARKER_COUNT AR_PATT_NUM_MAX

// o^}[J[
struct MarkerInfo {
	bool used;
	int patt_no;
	double width;
	double center_coord[2];
} g_marker[MAX_MARKER_COUNT];

// Jp[^
struct CameraInfo {
	bool used;
	ARParam arParam;
	vector<BYTE> imageBuff;
	vector<ARMarkerInfo> markerInfo;
	double transV2HW[3][4];				// ViewWnhgimg3WorldWn ϊs
} g_camera[MAX_CAMERA_COUNT];

// n}[J[WEn}[J[W ϊs
// (ftHgłYW̕]))
static double g_transLH2RH[3][4] = {
	{ 1.0, 0.0, 0.0, 0.0 },
	{ 0.0,-1.0, 0.0, 0.0 },
	{ 0.0, 0.0, 1.0, 0.0 }
};


// ݂̑IJ
CameraInfo* g_curCamera = NULL;
nyar_NyARTransMat_O2_t* g_nya = NULL;		// NyARTransMat(arGetTransMat̍)p

// ֐vg^Cv
void GetRotTransformMatrixZYX(double a, double b, double c, double transfMat[3][4]);
void GetRotTransformMatrixXYZ(double a, double b, double c, double transfMat[3][4]);
void GetRotTransformMatrixYXZ(double a, double b, double c, double transfMat[3][4]);
void GetRotAngleZYX(const double transfMat[3][4], double* a, double* b, double* c);
void GetRotAngleXYZ(const double transfMat[3][4], double* a, double* b, double* c);
void GetRotAngleYXZ(const double transfMat[3][4], double* a, double* b, double* c);


// DLLGg|Cg
BOOL APIENTRY DllMain( HMODULE hModule,
                       DWORD  ul_reason_for_call,
                       LPVOID lpReserved
					 )
{
	switch (ul_reason_for_call)
	{
	case DLL_PROCESS_ATTACH:
	case DLL_THREAD_ATTACH:
	case DLL_THREAD_DETACH:
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}


// n}[J[WEn}[J[W ϊs
int ARSetMarkerTransLHtoRH(const double* transL2R)
{
	// p[^`FbN
	if (transL2R == NULL) {
		return -1;
	}

	memcpy(g_transLH2RH, transL2R, sizeof(g_transLH2RH));
	return 0;
}


// Jw
int ARInitCamera(const char* paramfile, int width, int height, int camId)
{
	// G[`FbN
	if (camId < 0 || MAX_CAMERA_COUNT <= camId) {
		return -1;
	}

	// Jp[^ǂݍ
	ARParam arParam;
	int result = arParamLoad(paramfile, 1, &arParam);
	g_camera[camId].used = (result == 0) ? true : false;

	// JgJƂđI
	g_curCamera = (result == 0) ? &g_camera[camId] : NULL;

	if (g_curCamera != NULL) {
		// Jp[^TCYɍ킹ăXP[O
		arParamChangeSize(&arParam, width, height, &g_curCamera->arParam);

		// Jp[^ݒ
		arInitCparam(&g_curCamera->arParam);
		if (g_nya != NULL) {
			nyar_NyARTransMat_O2_free(g_nya);
		}
		g_nya = nyar_NyARTransMat_O2_create(&g_curCamera->arParam);

		// ϊs񏉊
		g_curCamera->transV2HW[0][0] = 1.0;
		g_curCamera->transV2HW[0][1] = 0.0;
		g_curCamera->transV2HW[0][2] = 0.0;
		g_curCamera->transV2HW[0][3] = 0.0;
		g_curCamera->transV2HW[1][0] = 0.0;
		g_curCamera->transV2HW[1][1] = 1.0;
		g_curCamera->transV2HW[1][2] = 0.0;
		g_curCamera->transV2HW[1][3] = 0.0;
		g_curCamera->transV2HW[2][0] = 0.0;
		g_curCamera->transV2HW[2][1] = 0.0;
		g_curCamera->transV2HW[2][2] = -1.0;
		g_curCamera->transV2HW[2][3] = 0.0;
	}

	return result;
}

int ARSelCamera(int camId)
{
	// G[`FbN
	if (camId < 0 || MAX_CAMERA_COUNT <= camId || !g_camera[camId].used) {
		return -1;
	}

	// ݂̃JƂđI
	g_curCamera = &g_camera[camId];

	// Jp[^Đݒ
	arInitCparam(&g_curCamera->arParam);
	if (g_nya != NULL) {
		nyar_NyARTransMat_O2_free(g_nya);
	}
	g_nya = nyar_NyARTransMat_O2_create(&g_curCamera->arParam);

	return 0;
}

int ARGetCameraFovY(double* fov)
{
	// JI`FbN
	if (g_curCamera == NULL) {
		return -1;
	}

	// p[^`FbN
	if (fov == NULL) {
		return -1;
	}

	double C[3][4], T[3][4];
	if (arParamDecompMat(g_curCamera->arParam.mat, C, T) < 0) {
		return -1;
	}

	double height = g_curCamera->arParam.ysize - 1;
	double q11 = - 2.0 * (height * C[2][1] - C[1][1]) / (height * C[2][2]);
	double q12 = -(2.0 * (height * C[2][2] - C[1][2]) / (height * C[2][2]) - 1.0);

	double projMat11 = q11 * T[1][1] + q12 * T[2][1];
	*fov = 2.0 * atan2(1.0, projMat11);

	return 0;
}

// }[J[p^[o^
int ARSetMarker(int markerId, const char* pattfile, double width, double x_coord, double y_coord)
{
	// G[`FbN
	if (markerId < 0 || MAX_MARKER_COUNT <= markerId || width < 0.0) {
		return -1;
	}

	MarkerInfo* targetMarker = &g_marker[markerId];

	// ɓo^Ăꍇ͉
	if (targetMarker->used) {
		arFreePatt(targetMarker->patt_no);
		targetMarker->used = false;
	}

	// p^[t@C̓ǂݍ
	targetMarker->patt_no = arLoadPatt(pattfile);
	if (targetMarker->patt_no < 0) {
		return -1;
	}

	// ֘Ap[^Zbg
	targetMarker->used = true;					// gptO
	targetMarker->width = width;				// }[J[̕
	targetMarker->center_coord[0] = x_coord;	// SXW
	targetMarker->center_coord[1] = y_coord;	// SYW
	return 0;
}

int ARDetectMarker(int cx, int cy, int threshold, int mode, BMSCR* bmscr)
{
	// JI`FbN
	if (g_curCamera == NULL) {
		return -1;
	}

	// IJ̃}[J[NA
	g_curCamera->markerInfo.clear();
	
	// ͈̓`FbN
	int sx = g_curCamera->arParam.xsize;
	int sy = g_curCamera->arParam.ysize;
	if (bmscr == NULL || cx < 0 || cy < 0 || sx <= 0 || sy <= 0 || cx + sx > bmscr->sx || cy + sy > bmscr->sy) {
		return -1;
	}

	// ʃ[h`FbN (tJ[[ĥ݋)
	if (bmscr->flag != BMSCR_FLAG_INUSE || bmscr->palmode != BMSCR_PALMODE_FULLCOLOR || bmscr->pBit == NULL) {
		return -1;
	}

	// w͈̓C[Wo (RGR  BGRA)
	g_curCamera->imageBuff.resize(sx * sy * 4);
	BYTE* bmpDst = &g_curCamera->imageBuff[0];
	const BYTE* bmpSrc = bmscr->pBit;

	BYTE *pDst = bmpDst;
	int screenLineBytes = (bmscr->sx * 3 + 3) & ~3;
	int screenHeight = bmscr->sy;
	for (int y=cy; y<cy+sy; y++) {
		const BYTE* pSrc = bmpSrc + (( screenHeight - 1 - y) * screenLineBytes ) + (cx * 3);
		for (int x=cx; x<cx+sx; x++) {
			// BGRȀɊi[
			pDst[0] = pSrc[0];		// B
			pDst[1] = pSrc[1];		// G
			pDst[2] = pSrc[2];		// R
			pDst[3] = 0xFF;			// A
			pDst += 4;
			pSrc += 3;
		}
	}

	// }[J[o
	ARMarkerInfo* markerInfo;
	int markerCount;
	int result;
	if (mode == 1) {
		result = arDetectMarkerLite(bmpDst, threshold, &markerInfo, &markerCount);
	} else {
		result = arDetectMarker(bmpDst, threshold, &markerInfo, &markerCount);
	}
	if (result < 0) {
		return -1;
	}

	// o}[J[ێ (m̃p^[ID̂̂̂)
	for (int i=0; i<markerCount; i++) {
		if (markerInfo[i].id >= 0) {
			g_curCamera->markerInfo.assign(markerInfo, markerInfo + markerCount);
		}
	}

	// Ԃ
	return (int)g_curCamera->markerInfo.size();
}

int ARCountMarker(int* result, int markerId)
{
	// p[^`FbN
	if (result == NULL) {
		return -1;
	}
	*result = 0;

	// JI`FbN
	if (g_curCamera == NULL) {
		return -1;
	}

	// }[J[ID`FbN
	if (markerId < 0 || MAX_MARKER_COUNT <= markerId || !g_marker[markerId].used) {
		return -1;
	}

	MarkerInfo* targetMarker = &g_marker[markerId];

	// JEg
	for (size_t i=0; i<g_curCamera->markerInfo.size(); i++) {
		if (g_curCamera->markerInfo[i].id == targetMarker->patt_no) {
			(*result)++;
		}
	}

	return 0;
}

// }[J[vxrt@N^ (vxɂ\[gp)
struct MarkerConfidenceComp : public binary_function<int,int,bool> {
	MarkerConfidenceComp(const ARMarkerInfo* info):info_(info){}
	bool operator()(int i, int j) {
		return (info_[i].cf > info_[j].cf);
	}
private:
	const ARMarkerInfo* info_;
};

// }[J[擾
int ARGetMarkerMat(double transL2V[][3][4], int markerId, int maxcount)
{
	// JI`FbN
	if (g_curCamera == NULL) {
		return -1;
	}

	// }[J[ID`FbN
	if (markerId < 0 || MAX_MARKER_COUNT <= markerId || !g_marker[markerId].used) {
		return -1;
	}

	MarkerInfo* targetMarker = &g_marker[markerId];

	// Ώۃ}[J[̃CfbNXXg̐
	int detectedCount = 0;
	int indices[AR_SQUARE_MAX];
	for (size_t i=0; i<g_curCamera->markerInfo.size(); i++) {
		if (g_curCamera->markerInfo[i].id == targetMarker->patt_no) {
			indices[detectedCount++] = i;
		}
	}

	// 擾
	int count = detectedCount;
	if (count > maxcount) {
		count = (maxcount > 0) ? maxcount : 1;
	}

	// CfbNXXgvx̍Ƀ\[g
	partial_sort(indices, indices+count, indices+detectedCount, MarkerConfidenceComp(&g_curCamera->markerInfo[0]));

	// Rs[
	double center_coord[2] = {0.0, 0.0};
	for (int i=0; i<count; i++) {
		//arGetTransMat(&g_curCamera->markerInfo[indices[i]], targetMarker->center_coord,
		//	targetMarker->width, transL2V[i]);
		nyar_NyARTransMat_O2_transMat(g_nya, &g_curCamera->markerInfo[indices[i]], 
			targetMarker->center_coord, targetMarker->width, transL2V[i]);
	}

	return count;
}


// }[J[擾
int ARGetMarkerMatCont(double transL2V[3][4], int markerId, double prevTransL2V[3][4])
{
	// JI`FbN
	if (g_curCamera == NULL) {
		return -1;
	}

	// }[J[ID`FbN
	if (markerId < 0 || MAX_MARKER_COUNT <= markerId || !g_marker[markerId].used) {
		return -1;
	}

	MarkerInfo* targetMarker = &g_marker[markerId];

	// Ώۃ}[J[̃CfbNXXg̐
	int detectedCount = 0;
	int indices[AR_SQUARE_MAX];
	for (size_t i=0; i<g_curCamera->markerInfo.size(); i++) {
		if (g_curCamera->markerInfo[i].id == targetMarker->patt_no) {
			indices[detectedCount++] = i;
		}
	}

	// 擾
	int count = (detectedCount >= 1) ? 1 :0;

	// CfbNXXgvx̍Ƀ\[g
	partial_sort(indices, indices+count, indices+detectedCount, MarkerConfidenceComp(&g_curCamera->markerInfo[0]));

	// Rs[
	double center_coord[2] = {0.0, 0.0};
	if (count > 0) {
		//arGetTransMat(&g_curCamera->markerInfo[indices[i]], targetMarker->center_coord,
		//	prevTransL2V, targetMarker->width, transL2V[i]);
		nyar_NyARTransMat_O2_transMatCont(g_nya, &g_curCamera->markerInfo[indices[0]], 
			prevTransL2V, targetMarker->center_coord, targetMarker->width, transL2V);
	}

	return count;
}

int ARSetCameraPos(double x, double y, double z, double a, double b, double c, int rotMode)
{
	// JI`FbN
	if (g_curCamera == NULL) {
		return -1;
	}

	// [hgimg3JWnhgimg3[hWn]ϊs̉]擾
	// (X,Z܂̉]͔̕]Ă)
	double transHC2HW[3][4];
	switch (rotMode) {
		case HGMODEL_ROTORDER_ZYX:
			GetRotTransformMatrixZYX(a, b, c, transHC2HW);
			break;
		case HGMODEL_ROTORDER_XYZ:
			GetRotTransformMatrixXYZ(a, b, c, transHC2HW);
			break;
		case HGMODEL_ROTORDER_YXZ:
			GetRotTransformMatrixYXZ(a, b, c, transHC2HW);
			break;
		default:
			return -1;
	}

	// [hgimg3JWnhgimg3[hWn]ϊs̕sړZbg
	transHC2HW[0][3] = x;
	transHC2HW[1][3] = y;
	transHC2HW[2][3] = z;

	// [ViewWnhgimg3[hWn]ϊs쐬ĕێ
	// (Z]ϊE炩 => 3ڗvf̕])
	g_curCamera->transV2HW[0][0] =  transHC2HW[0][0];
	g_curCamera->transV2HW[0][1] =  transHC2HW[0][1];
	g_curCamera->transV2HW[0][2] = -transHC2HW[0][2];
	g_curCamera->transV2HW[0][3] =  transHC2HW[0][3];
	g_curCamera->transV2HW[1][0] =  transHC2HW[1][0];
	g_curCamera->transV2HW[1][1] =  transHC2HW[1][1];
	g_curCamera->transV2HW[1][2] = -transHC2HW[1][2];
	g_curCamera->transV2HW[1][3] =  transHC2HW[1][3];
	g_curCamera->transV2HW[2][0] =  transHC2HW[2][0];
	g_curCamera->transV2HW[2][1] =  transHC2HW[2][1];
	g_curCamera->transV2HW[2][2] = -transHC2HW[2][2];
	g_curCamera->transV2HW[2][3] =  transHC2HW[2][3];

	return 0;
}

int ARCalcCameraPos(double* x, double* y, double* z, double* a, double* b, double* c, const double transL2V[3][4], int rotMode)
{
	// p[^`FbN
	if (x == NULL || y == NULL || z == NULL || a == NULL || b == NULL || c == NULL || transL2V == NULL) {
		return -1;
	}

	// [[J(}[J[)Wnhgimg3JWn]ϊs擾
	// (Z]ϊ炩 => 3sڕ])
	double transL2HC[3][4] = {
		{  transL2V[0][0],  transL2V[0][1],  transL2V[0][2],  transL2V[0][3] },
		{  transL2V[1][0],  transL2V[1][1],  transL2V[1][2],  transL2V[1][3] },
		{ -transL2V[2][0], -transL2V[2][1], -transL2V[2][2], -transL2V[2][3] }
	};

	// [hgimg3[J(=Vhgimg3[h)Wnhgimg3JWn]ϊs擾
	// (E [n}[J[WEn}[J[W]ϊs )
	double transHL2HC[3][4];
	arUtilMatMul(transL2HC, g_transLH2RH, transHL2HC);

	// [hgimg3JWnhgimg3[JWn]ϊs擾
	double tarnsHC2HL[3][4];
	arUtilMatInv(transHL2HC, tarnsHC2HL);

	// sړ
	*x = tarnsHC2HL[0][3];
	*y = tarnsHC2HL[1][3];
	*z = tarnsHC2HL[2][3];

	// ]ϊIC[pɕϊ
	switch (rotMode) {
		case HGMODEL_ROTORDER_ZYX:
			GetRotAngleZYX(tarnsHC2HL, a, b, c);
			break;
		case HGMODEL_ROTORDER_XYZ:
			GetRotAngleXYZ(tarnsHC2HL, a, b, c);
			break;
		case HGMODEL_ROTORDER_YXZ:
			GetRotAngleYXZ(tarnsHC2HL, a, b, c);
			break;
		default:
			return -1;
	}

	return 0;
}

int ARCalcMarkerPos(double* x, double* y, double* z, double* a, double* b, double* c, const double transL2V[3][4], int rotMode)
{
	// JI`FbN
	if (g_curCamera == NULL) {
		return -1;
	}

	// p[^`FbN
	if (x == NULL || y == NULL || z == NULL || a == NULL || b == NULL || c == NULL || transL2V == NULL) {
		return -1;
	}

	// [[J(}[J[)Wnhgimg3[hWn]ϊsvZ
	double transL2HW[3][4];
	arUtilMatMul(g_curCamera->transV2HW, const_cast<double(*)[4]>(transL2V), transL2HW);

	// [hgimg3[JWnhgimg3[hWn]ϊsvZ
	// (n}[J[WEn}[J[W ϊsE炩)
	double transHL2HW[3][4];
	arUtilMatMul(transL2HW, g_transLH2RH, transHL2HW);

	// sړ
	*x = transHL2HW[0][3];
	*y = transHL2HW[1][3];
	*z = transHL2HW[2][3];

	// ]ϊIC[pɕϊ
	switch (rotMode) {
		case HGMODEL_ROTORDER_ZYX:
			GetRotAngleZYX(transHL2HW, a, b, c);
			break;
		case HGMODEL_ROTORDER_XYZ:
			GetRotAngleXYZ(transHL2HW, a, b, c);
			break;
		case HGMODEL_ROTORDER_YXZ:
			GetRotAngleYXZ(transHL2HW, a, b, c);
			break;
		default:
			return -1;
	}

	return 0;
}


void ARTerm()
{
	// o^ς݃}[J[̃p^[ID
	for (int i=0; i<MAX_MARKER_COUNT; i++) {
		if (g_marker[i].used) {
			arFreePatt(g_marker[i].patt_no);
			g_marker[i].used = false;
		}
	}
	if (g_nya != NULL) {
		nyar_NyARTransMat_O2_free(g_nya);
		g_nya = NULL;
	}
}


void GetRotTransformMatrixZYX(double a, double b, double c, double transfMat[3][4])
{
	double sin_a = sin(a), cos_a = cos(a);
	double sin_b = sin(b), cos_b = cos(b);
	double sin_c = sin(c), cos_c = cos(c);

	transfMat[0][0] =  cos_b * cos_c;
	transfMat[0][1] = -cos_a * sin_c + sin_a * sin_b * cos_c;
	transfMat[0][2] =  sin_a * sin_c + cos_a * sin_b * cos_c;
	transfMat[0][3] =  0;
	transfMat[1][0] =  cos_b * sin_c;
	transfMat[1][1] =  cos_a * cos_c + sin_a * sin_b * sin_c;
	transfMat[1][2] = -sin_a * cos_c + cos_a * sin_b * sin_c;
	transfMat[1][3] =  0;
	transfMat[2][0] = -sin_b;
	transfMat[2][1] =  sin_a * cos_b;
	transfMat[2][2] =  cos_a * cos_b;
	transfMat[2][3] =  0;
}

void GetRotTransformMatrixXYZ(double a, double b, double c, double transfMat[3][4])
{
	double sin_a = sin(a), cos_a = cos(a);
	double sin_b = sin(b), cos_b = cos(b);
	double sin_c = sin(c), cos_c = cos(c);

	transfMat[0][0] =  cos_b * cos_c;
	transfMat[0][1] = -cos_b * sin_c;
	transfMat[0][2] =  sin_b;
	transfMat[0][3] =  0;
	transfMat[1][0] =  sin_a * sin_b * cos_c + cos_a * sin_c;
	transfMat[1][1] = -sin_a * sin_b * sin_c + cos_a * cos_c;
	transfMat[1][2] = -sin_a * cos_b;
	transfMat[1][3] =  0;
	transfMat[2][0] = -cos_a * sin_b * cos_c + sin_a * sin_c;
	transfMat[2][1] =  cos_a * sin_b * sin_c + sin_a * cos_c;
	transfMat[2][2] =  cos_a * cos_b;
	transfMat[2][3] =  0;
}

void GetRotTransformMatrixYXZ(double a, double b, double c, double transfMat[3][4])
{
	double sin_a = sin(a), cos_a = cos(a);
	double sin_b = sin(b), cos_b = cos(b);
	double sin_c = sin(c), cos_c = cos(c);

	transfMat[0][0] =  cos_b * cos_c + sin_a * sin_b * sin_c;
	transfMat[0][1] = -cos_b * sin_c + sin_a * sin_b * cos_c;
	transfMat[0][2] =  cos_a * sin_b;
	transfMat[0][3] =  0;
	transfMat[1][0] =  cos_a * sin_c;
	transfMat[1][1] =  cos_a * cos_c;
	transfMat[1][2] = -sin_a;
	transfMat[1][3] =  0;
	transfMat[2][0] = -sin_b * cos_c + sin_a * cos_b * sin_c;
	transfMat[2][1] =  sin_b * sin_c + sin_a * cos_b * cos_c;
	transfMat[2][2] =  cos_a * cos_b;
	transfMat[2][3] =  0;
}

void GetRotAngleZYX(const double transfMat[3][4], double* a, double* b, double* c)
{
	if (fabs(1.0 - transfMat[2][0] * transfMat[2][0]) < 0.0000001) {
		*b = -asin(transfMat[2][0]);
		*c = atan2(-transfMat[0][1], transfMat[1][1]);
		*a = 0.0;
	} else {
		*b = -asin(transfMat[2][0]);
		*c = atan2(transfMat[1][0], transfMat[0][0]);
		*a = atan2(transfMat[2][1], transfMat[2][2]);
	}
}

void GetRotAngleXYZ(const double transfMat[3][4], double* a, double* b, double* c)
{
	if (fabs(1.0 - transfMat[0][2] * transfMat[0][2]) < 0.0000001) {
		*b = asin(transfMat[0][2]);
		*a = atan2(transfMat[2][1], transfMat[1][1]);
		*c = 0.0;
	} else {
		*b = asin(transfMat[0][2]);
		*a = atan2(-transfMat[1][2], transfMat[2][2]);
		*c = atan2(-transfMat[0][1], transfMat[0][0]);
	}
}

void GetRotAngleYXZ(const double transfMat[3][4], double* a, double* b, double* c)
{
	if (fabs(1.0 - transfMat[1][2] * transfMat[1][2]) < 0.0000001) {
		*a = -asin(transfMat[1][2]);
		*b = atan2(-transfMat[2][0], transfMat[0][0]);
		*c = 0.0;
	} else {
		*a = -asin(transfMat[1][2]);
		*b = atan2(transfMat[0][2], transfMat[2][2]);
		*c = atan2(transfMat[1][0], transfMat[1][1]);
	}
}

