#pragma once

#include "hspvar_core.h"
#include "hspwnd.h"

extern "C" {
	int ARSetMarkerTransLHtoRH(const double* transL2R);
	int ARInitCamera(const char* paramfile, int width, int height, int camId);
	int ARSelCamera(int camId);
	int ARGetCameraFovY(double* fov);
	int ARSetMarker(int markerId, const char* pattfile, double width, double x_coord, double y_coord);
	int ARDetectMarker(int cx, int cy, int threshold, int mode, BMSCR* bmscr);
	int ARCountMarker(int* result, int markerId);
	int ARGetMarkerMat(double transf[][3][4], int markerId, int maxcount);
	int ARGetMarkerMatCont(double transf[3][4], int markerId, double prevTransf[3][4]);
	int ARCalcMarkerPos(double* x, double* y, double* z, double* argx, double* argy, double* argz, const double trans[3][4], int rotMode);
	int ARCalcCameraPos(double* x, double* y, double* z, double* argx, double* argy, double* argz, const double trans[3][4], int rotMode);
	int ARSetCameraPos(double x, double y, double z, double argx, double argy, double argz, int rotMode);
	void ARTerm();
}

