﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;
using System.IO;
using System.Collections;
using System.Media;
using System.Windows.Media; // ソリューションエクスプローラでプロジェクト名を右クリックし、[参照の追加]を選択して、PresentationCore(とWindowsBase)を追加する
using Music;

namespace WadView
{
    public partial class mainForm : Form
    {
        const int INT_SIZE = sizeof(int);
        const int PATCHDESC_SIZE = 10;
        const int MAX_PATCH_WIDTH = 320;
        int[] columnofs = new int[MAX_PATCH_WIDTH];
        string appPath;
        Wad currWad = new Wad();
        bool wadLoaded = false;
        int numpatches;
        string[] pnames;
        MemoryStream[] patches;
        int numtextures;
        texture_s[] textures;
        int numsprites;
        MemoryStream[] sprites;
        List<MemoryStream> mscpatches = new List<MemoryStream>();
        List<MemoryStream> flats = new List<MemoryStream>();
        MemoryStream playpal = null;
        BinaryReader playpalReader;
        List<sound_s> sfxList = new List<sound_s>();
        SoundPlayer SPlayer = new SoundPlayer();
        List<Midi> musList = new List<Midi>();
        MediaPlayer MPlayer = new MediaPlayer();
        string tempmidname;
        int tempmidnum = 0;
        MemoryStream textureBitmapStream = null;
        BinaryWriter textureBitmapWriter;
        int textureWidth, textureHeight;
        MemoryStream texpatchBitmapStream = null;
        BinaryWriter texpatchBitmapWriter;
        int texpatchWidth, texpatchHeight;
        MemoryStream spriteBitmapStream = null;
        BinaryWriter spriteBitmapWriter;
        int spriteWidth, spriteHeight;
        MemoryStream mscpatchBitmapStream = null;
        BinaryWriter mscpatchBitmapWriter;
        int mscpatchWidth, mscpatchHeight;
        MemoryStream flatBitmapStream = null;
        BinaryWriter flatBitmapWriter;
        bool nopatch = true;
        string[] mscpatchnames =
        {
	        "TITLEPIC",
            "HELP",
	        "HELP1",
	        "CREDIT",
	        "HELP2",
            "M_PAUSE",
	        // Menu	
	        "M_LOADG",
	        "M_LSLEFT",
	        "M_LSCNTR",
	        "M_LSRGHT",
	        "M_SAVEG",
	        "M_SVOL",
	        "M_DOOM",
	        "M_NEWG",
	        "M_SKILL",
	        "M_EPISOD",
	        "M_OPTTTL",
	        "M_GDHIGH",
	        "M_GDLOW",
	        "M_MSGOFF",
	        "M_MSGON",
	        "M_THERML",
	        "M_THERMM",
	        "M_THERMR",
	        "M_THERMO",
	        "M_CELL1", // not
	        "M_CELL2", //  used?
	        "M_SKULL1",
	        "M_SKULL2",
	        "M_NGAME",
	        "M_OPTION",
	        "M_RDTHIS",
	        "M_QUITG",
	        "M_EPI1",
	        "M_EPI2",
	        "M_EPI3",
	        "M_EPI4",
	        "M_JKILL",
	        "M_ROUGH",
	        "M_HURT",
	        "M_ULTRA",
	        "M_NMARE",
	        "M_ENDGAM",
	        "M_MESSG",
	        "M_DETAIL",
	        "M_SCRNSZ",
	        "M_MSENS",
	        "M_SFXVOL",
	        "M_MUSVOL",
            // Status bar
            "STBAR",    // entire status bar background
            "STFST00",  // faces
            "STFST01",
            "STFST02",
            "STFST10",
            "STFST11",
            "STFST12",
            "STFST20",
            "STFST21",
            "STFST22",
            "STFST30",
            "STFST31",
            "STFST32",
            "STFST40",
            "STFST41",
            "STFST42",
            "STFTR00",
            "STFTR10",
            "STFTR20",
            "STFTR30",
            "STFTR40",
            "STFTL00",
            "STFTL10",
            "STFTL20",
            "STFTL30",
            "STFTL40",
            "STFOUCH0",
            "STFOUCH1",
            "STFOUCH2",
            "STFOUCH3",
            "STFOUCH4",
            "STFEVL0",
            "STFEVL1",
            "STFEVL2",
            "STFEVL3",
            "STFEVL4",
            "STFKILL0",
            "STFKILL1",
            "STFKILL2",
            "STFKILL3",
            "STFKILL4",
            "STFGOD0",
            "STFDEAD0",
            "STTNUM0",  // tall number
            "STTNUM1",
            "STTNUM2",
            "STTNUM3",
            "STTNUM4",
            "STTNUM5",
            "STTNUM6",
            "STTNUM7",
            "STTNUM8",
            "STTNUM9",
            "STYSNUM0", // short number. 2 to 7 are also weapon number(yellow)
            "STYSNUM1",
            "STYSNUM2",
            "STYSNUM3",
            "STYSNUM4",
            "STYSNUM5",
            "STYSNUM6",
            "STYSNUM7",
            "STYSNUM8",
            "STYSNUM9",
            "STGNUM2",  // weapon number(gray)
            "STGNUM3",
            "STGNUM4",
            "STGNUM5",
            "STGNUM6",
            "STGNUM7",
            "STKEYS0",  // key cards
            "STKEYS1",
            "STKEYS2",
            "STKEYS3",
            "STKEYS4",
            "STKEYS5",
            "STTPRCNT", // tall percent
            "STTMINUS", // minus sign
            "STARMS",   // arms background
            "STFB0",    // face backgrounds
            "STFB1",
            "STFB2",
            "STFB3",
            // Intermission 
            "INTERPIC",
            "WIMAP0",
            "WIMAP1",
            "WIMAP2",
            "WIURH0",   // you are here
            "WIURH1",   // you are here (alt.)
            "WISPLAT",  // splat
            "WIMINUS",
            "WIPCNT",
            "WIF",
            "WIENTER",
            "WIOSTK",
            "WIOSTS",
            "WISCRT2",
            "WIOBJ",
            "WIOSTI",
            "WIFRGS",
            "WICOLON",
            "WITIME",
            "WISUCKS",
            "WIPAR",
            "WIKILRS",
            "WIVCTMS",
            "WIMSTT",
            "STFST01",
            "STFDEAD0",
            "STPB0",
            "STPB1",
            "STPB2",
            "STPB3",
            "WIBP1",
            "WIBP2",
            "WIBP3",
            "WIBP4",
            // Finale
            "VICTORY2",
            "ENDPIC",
            "PFUB1",
            "PFUB2",
            "END0",
            "END1",
            "END2",
            "END3",
            "END4",
            "END5",
            "END6",
            "BOSSBACK"
        };
        bool grpLoaded = false;
        FileStream grpFS;
        BinaryReader grpBR;
        int grpNumfiles;
        lumpinfo_s[] grpInfotable;
        List<tile_s> tileList = new List<tile_s>();
        MemoryStream tileBitmapStream = null;
        BinaryWriter tileBitmapWriter;
        int tileWidth, tileHeight;
        byte[] palettedat = new byte[768];
        List<sound_s> vocList = new List<sound_s>();
        List<MemoryStream> midList = new List<MemoryStream>();

        public mainForm()
        {
            InitializeComponent();
        }

        private void openWadFileButton_Click(object sender, EventArgs e)
        {
            openFileDialog1.Title = "WADファイルを開く";
            openFileDialog1.Filter = "WADファイル|*.wad";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if (wadLoaded == true)
                    ClearWadTabs();
                if (currWad.Open(openFileDialog1.FileName) == true)
                {
                    if (SetupWadTabs() == false)
                    {
                        ClearWadTabs();
                        return;
                    }
                }
            }
        }

        bool SetupWadTabs()
        {
            MemoryStream ms, ms2;
            BinaryReader br, br2;
            int i, j, c;
            char[] name8;
            string s;
            int numtextures1, numtextures2;
            int offset;
            int nBytes;
            byte[] ByteArray;
            sound_s sfx;
            BinaryWriter bw;
            Midi mid;
            
            ms = currWad.ReadLump("PNAMES\0\0");
            if (ms == null)
                return false;
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            numpatches = br.ReadInt32();
            pnames = new string[numpatches];
            patches = new MemoryStream[numpatches];
            for (i=0 ; i<numpatches ; i++)
            {
                name8 = br.ReadChars(8);
                s = new String(name8);
                pnames[i] = s;
                patches[i] = currWad.ReadLump(s);
            }
            ms = currWad.ReadLump("TEXTURE1");
            if (ms == null)
                return false;
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            numtextures1 = br.ReadInt32();
            ms2 = currWad.ReadLump("TEXTURE2");
            if (ms2 == null)
            {
                numtextures2 = 0;
                br2 = br; // ビルドエラー抑制のためだけ
            }
            else
            {
                br2 = new BinaryReader(ms2, Encoding.ASCII);
                ms2.Seek(0, SeekOrigin.Begin);
                numtextures2 = br2.ReadInt32();
            }
            numtextures = numtextures1 + numtextures2;
            textures = new texture_s[numtextures];
            for (i=0, j=0 ; i<numtextures ; i++, j++)
            {
                if (i == numtextures1)
                {
                    ms = ms2;
                    br = br2;
                    j = 0;
                }
                ms.Seek(j*INT_SIZE+INT_SIZE, SeekOrigin.Begin);
                offset = br.ReadInt32();
                ms.Seek(offset, SeekOrigin.Begin);
                name8 = br.ReadChars(8);
                s = new String(name8);
                textures[i].name = s;
                br.ReadInt32(); // dummy1
                textures[i].width = br.ReadInt16();
                textures[i].height = br.ReadInt16();
                br.ReadInt32(); // dummy2
                textures[i].patchcount = br.ReadInt16();
                nBytes = PATCHDESC_SIZE * textures[i].patchcount;
                ByteArray = new byte[nBytes];
                ByteArray = br.ReadBytes(nBytes);
                textures[i].patches = new MemoryStream(ByteArray);
            }
            j = currWad.GetNumForName("S_START\0") + 1;
            numsprites = currWad.GetNumForName("S_END\0\0\0") - j;
            sprites = new MemoryStream[numsprites];
            for (i=0 ; i<numsprites ; i++)
            {
                s = currWad.infotable[j+i].name;
                sprites[i] = currWad.ReadLump(s);
                spriteComboBox.Items.Add(s);
            }
            foreach (string name in mscpatchnames)
            {
                string paddedname = name.PadRight(8, '\0'); // 2011/01/07修正
                ms = currWad.ReadLump(paddedname);
                if (ms != null)
                {
                    mscpatches.Add(ms);
                    mscpatchComboBox.Items.Add(name);
                }
            }
            j = currWad.GetNumForName("F_START\0") + 1;
            c = currWad.GetNumForName("F_END\0\0\0") - j;
            for (i=0 ; i<c ; i++)
            {
                s = currWad.infotable[j+i].name;
                ms = currWad.ReadLump(s);
                if (ms != null)
                {
                    flats.Add(ms);
                    flatComboBox.Items.Add(s);
                }
            }
            playpal = currWad.ReadLump("PLAYPAL\0");
            if (playpal == null)
                return false;
            playpalReader = new BinaryReader(playpal, Encoding.ASCII);
            for (i=0 ; i<currWad.numlumps ; i++)
            {
                s = currWad.infotable[i].name;
                if (s.StartsWith("DS"))
                {
                    ms = currWad.ReadLump(s);
                    if (ms != null)
                    {
                        br = new BinaryReader(ms, Encoding.ASCII);
                        ms.Seek(2, SeekOrigin.Begin);
                        if (br.ReadUInt16() != 11025)
                            continue;
                        sfx.name = s;
                        ms2 = new MemoryStream(currWad.infotable[i].size - 8 + 44);
                        bw = new BinaryWriter(ms2, Encoding.ASCII);
                        bw.Write(Encoding.ASCII.GetBytes("RIFF"));
                        bw.Write((Int32)(currWad.infotable[i].size - 8 + 44 - 8));
                        bw.Write(Encoding.ASCII.GetBytes("WAVE"));
                        bw.Write(Encoding.ASCII.GetBytes("fmt "));
                        bw.Write((Int32)16);
                        bw.Write((UInt16)1);        // compression code (1 = PCM)
                        bw.Write((UInt16)1);        // number of channels (i.e. mono, stereo...)
                        bw.Write((UInt32)11025);    // samples per second
                        bw.Write((UInt32)11025);    // average number of bytes per second
                        bw.Write((UInt16)1);        // block size of data
                        bw.Write((UInt16)8);        // number of bits per sample of mono data
                        bw.Write(Encoding.ASCII.GetBytes("data"));
                        bw.Write((Int32)(currWad.infotable[i].size - 8));
                        nBytes = currWad.infotable[i].size - 8;
                        ByteArray = new byte[nBytes];
                        ms.Seek(8, SeekOrigin.Begin);
                        ByteArray = br.ReadBytes(nBytes);
                        bw.Write(ByteArray);
                        sfx.data = ms2;
                        sfx.length = (currWad.infotable[i].size - 8) / 11025.0f;
                        sfx.samplerate = 11025;
                        sfx.resolution = 8;
                        sfxList.Add(sfx);
                    }
                }
            }
            for (i=0 ; i<currWad.numlumps ; i++)
            {
                s = currWad.infotable[i].name;
                if (s.StartsWith("D_"))
                {
                    ms = currWad.ReadLump(s);
                    if (ms != null)
                    {
                        mid = new Midi(s, ms);
                        if (mid.data == null)
                            continue;
                        musList.Add(mid);
                    }
                }
            }
            foreach (texture_s tex in textures)
                textureComboBox.Items.Add(tex.name);
            foreach (string name in pnames)
                texpatchComboBox.Items.Add(name);
            for (i=0 ; i<sfxList.Count ; i++)
                sfxComboBox.Items.Add(sfxList[i].name);
            for (i=0 ; i<musList.Count ; i++)
                musComboBox.Items.Add(musList[i].name);
            textureMagComboBox.SelectedIndex = 0;
            texpatchMagComboBox.SelectedIndex = 0;
            spriteMagComboBox.SelectedIndex = 0;
            mscpatchMagComboBox.SelectedIndex = 0;
            flatMagComboBox.SelectedIndex = 0;
            textureBGComboBox.SelectedIndex = 0;
            texpatchBGComboBox.SelectedIndex = 0;
            spriteBGComboBox.SelectedIndex = 0;
            mscpatchBGComboBox.SelectedIndex = 0;
            wadLoaded = true;
            textureComboBox.SelectedIndex = 0;
            texpatchComboBox.SelectedIndex = 0;
            spriteComboBox.SelectedIndex = 0;
            mscpatchComboBox.SelectedIndex = 0;
            flatComboBox.SelectedIndex = 0;
            sfxComboBox.SelectedIndex = 0;
            musComboBox.SelectedIndex = 0;
            //this.Text = currWad.filename + " - WadView";
            return true;
        }

        void ClearWadTabs()
        {
            int i;

            textureComboBox.Items.Clear();
            texpatchComboBox.Items.Clear();
            spriteComboBox.Items.Clear();
            mscpatchComboBox.Items.Clear();
            flatComboBox.Items.Clear();
            sfxComboBox.Items.Clear();
            musComboBox.Items.Clear();
            texpatchInfoLabel.Text = null;
            textureInfoLabel.Text = null;
            spriteInfoLabel.Text = null;
            mscpatchInfoLabel.Text = null;
            sfxInfoLabel.Text = null;
            musInfoLabel.Text = null;
            texturePictureBox.Image = null;
            texpatchPictureBox.Image = null;
            spritePictureBox.Image = null;
            mscpatchPictureBox.Image = null;
            flatPictureBox.Image = null;
            for (i=0; i<numpatches ; i++)
            {
                if (patches[i] != null)
                    patches[i].Dispose();
                patches[i] = null;
            }
            for (i=0 ; i<numsprites ; i++)
            {
                if (sprites[i] != null)
                    sprites[i].Dispose();
                sprites[i] = null;
            }
            for (i=0 ; i<mscpatches.Count ; i++)
                mscpatches[i].Dispose();
            mscpatches.Clear();
            for (i=0 ; i<flats.Count ; i++)
                flats[i].Dispose();
            flats.Clear();
            if (playpal != null)
            {
                playpal.Dispose();
                playpal = null;
            }
            if (texpatchBitmapStream != null)
            {
                texpatchBitmapStream.Dispose();
                texpatchBitmapStream = null;
            }
            for (i=0 ; i<sfxList.Count ; i++)
                sfxList[i].data.Dispose();
            sfxList.Clear();
            for (i=0 ; i<musList.Count ; i++)
                musList[i].data.Dispose();
            musList.Clear();
            numpatches = 0;
            numtextures = 0;
            numsprites = 0;
            nopatch = true;
            currWad.Close();
            wadLoaded = false;
        }

        void SetupBitmapHeader(BinaryWriter bw, int paltype)
        {
            byte[] bfType = {0x42, 0x4D};
            int i;
            byte R, G, B;

            bw.Write(bfType);       // bfType
            bw.Write((Int32)1078);  // bfSize
            bw.Write((Int16)0);     // bfReserved1
            bw.Write((Int16)0);     // bfReserved2
            bw.Write((Int32)1078);  // bfOffBits
            bw.Write((Int32)40);    // biSize
            bw.Write((Int32)0);     // biWidth
            bw.Write((Int32)0);     // biHeight
            bw.Write((Int16)1);     // biPlanes
            bw.Write((Int16)8);     // biBitCount
            bw.Write((Int32)0);     // biCompression
            bw.Write((Int32)0);     // biSizeImage
            bw.Write((Int32)0);     // biXPelsPerMeter
            bw.Write((Int32)0);     // biYPelsPerMeter
            bw.Write((Int32)0);     // biClrUsed
            bw.Write((Int32)0);     // biClrImportant
            if (paltype == 0)
            {
                playpal.Seek(0, SeekOrigin.Begin);
                for (i=0 ; i<256 ; i++)
                {
                    R = playpalReader.ReadByte();
                    G = playpalReader.ReadByte();
                    B = playpalReader.ReadByte();
                    bw.Write(B);
                    bw.Write(G);
                    bw.Write(R);
                    bw.Write((byte)0);
                }
            }
            else
            {
                for (i=0 ; i<256 ; i++)
                {
                    // The colors are based on the VGA 262,144 color palette.  The values range from
                    //  0-63, so if you want to convert it to a windows palette you will have to
                    //  multiply each byte by 4. (palette.txtから抜粋)
                    R = (byte)(palettedat[i*3]*4);
                    G = (byte)(palettedat[i*3+1]*4);
                    B = (byte)(palettedat[i*3+2]*4);
                    bw.Write(B);
                    bw.Write(G);
                    bw.Write(R);
                    bw.Write((byte)0);
                }
            }
        }

        void DrawColumnOnBitmap(BinaryReader br, BinaryWriter bw, int x, int originy, int pitch, int height)
        {
            byte topdelta, length, blank;
            int count, start;
            int i, c, r, pos;

            topdelta = br.ReadByte();
            while (topdelta != 0xFF)
            {
                length = br.ReadByte();
                blank = br.ReadByte();
                count = length;
                start = originy + topdelta;
                if (start >= height)
                    return;
                if (start < 0)
                {
                    count += start;
                    if (count > 0)
                    {
                        c = -start;
                        for (i=0 ; i<c ; i++)
                            blank = br.ReadByte();
                        start = 0;
                    }
                    else
                    {
                        for (i=0 ; i<length ; i++)
                            blank = br.ReadByte();
                        blank = br.ReadByte();
                        topdelta = br.ReadByte();
                        continue;
                    }
                }
                r = (start + count) - height;
                if (r > 0)
                    count = height - start;
                for (i=0 ; i<count ; i++)
                {
                    pos = 1078 + x + ((height-1)-(start+i))*pitch; // TOP DOWN を BOTTOM UP にしておく
                    bw.Seek(pos, SeekOrigin.Begin);
                    bw.Write(br.ReadByte());
                }
                if (r > 0)
                    return;
                blank = br.ReadByte();
                topdelta = br.ReadByte();
            }
        }

        private void texpatchComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i;
            MemoryStream ms;
            BinaryReader br;
            int leftoffset, topoffset;
            int pitch, dim, size;
            byte back;

            if (!wadLoaded)
                return;
            i = texpatchComboBox.SelectedIndex;
            ms = patches[i];
            if (ms == null)
            {
                texpatchInfoLabel.Text = "このPATCHは\nWADファイル中には\n存在しません";
                nopatch = true;
                texpatchPictureBox.Invalidate();
                return;
            }
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            texpatchWidth = br.ReadInt16();
            texpatchHeight = br.ReadInt16();
            leftoffset = br.ReadInt16();
            topoffset = br.ReadInt16();
            for (i=0 ; i<texpatchWidth ; i++)
                columnofs[i] = br.ReadInt32();
            texpatchInfoLabel.Text = "幅: " + texpatchWidth.ToString() +
                                   "\n高さ: " + texpatchHeight.ToString() + "\n" +
                                   "\nLeft Offset: " + leftoffset.ToString() +
                                   "\nTop Offset: " + topoffset.ToString();
            if (texpatchBitmapStream == null)
            {
                texpatchBitmapStream = new MemoryStream(1078);
                texpatchBitmapWriter = new BinaryWriter(texpatchBitmapStream, Encoding.ASCII);
                SetupBitmapHeader(texpatchBitmapWriter, 0);
            }
            pitch = (texpatchWidth + 3) / 4 * 4;
            dim = pitch * texpatchHeight;
            size = 1078 + dim;
            texpatchBitmapStream.SetLength(size);
            texpatchBitmapStream.Seek(2, SeekOrigin.Begin);
            texpatchBitmapWriter.Write(size);   // bfSize
            texpatchBitmapStream.Seek(18, SeekOrigin.Begin);
            texpatchBitmapWriter.Write(texpatchWidth);  // biWidth
            texpatchBitmapWriter.Write(texpatchHeight); // biHeight
            texpatchBitmapStream.Seek(1078, SeekOrigin.Begin);
            if (texpatchBGComboBox.SelectedIndex == 0)
                back = 0;
            else
                back = 255;
            for (i=0 ; i<dim ; i++)
                texpatchBitmapWriter.Write(back);
            for (i=0 ; i<texpatchWidth ; i++)
            {
                ms.Seek(columnofs[i], SeekOrigin.Begin);
                DrawColumnOnBitmap(br, texpatchBitmapWriter, i, 0, pitch, texpatchHeight);
            }
            nopatch = false;
            texpatchPictureBox.Invalidate();
        }

        private void texpatchPictureBox_Paint(object sender, PaintEventArgs e)
        {
            Graphics g;
            Image image;
            int s;

            if (!wadLoaded)
                return;
            g = e.Graphics;
            g.Clear(texpatchPictureBox.BackColor);
            if (nopatch)
                return;
            s = texpatchMagComboBox.SelectedIndex + 1;
            image = Image.FromStream(texpatchBitmapStream);
            g.DrawImage(image, 10, 10, texpatchWidth * s, texpatchHeight * s);
        }

        private void musComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i;
            int sec, min;

            i = musComboBox.SelectedIndex;
            min = musList[i].secs / 60;
            sec = musList[i].secs - min * 60;
            musInfoLabel.Text = "長さ: " + min.ToString() + "分 " + sec.ToString() + "秒";
        }

        private void saveWadItemButton_Click(object sender, EventArgs e)
        {
            int tabIndex, i;
            MemoryStream ms;
            byte[] byteArray;
            FileStream fs;

            if (!wadLoaded)
                return;
            tabIndex = wadTabControl.SelectedIndex;
            //MessageBox.Show("選択されているタブのインデックスは " + tabIndex.ToString() + " です");
            switch (tabIndex)
            {
                case 0:
                case 1:
                case 2:
                case 3:
                case 4:
                    if (tabIndex == 0)
                    {
                        i = textureComboBox.SelectedIndex;
                        ms = textureBitmapStream;
                        saveFileDialog1.FileName = textureComboBox.Items[i] + ".bmp";
                    }
                    else if (tabIndex == 1)
                    {
                        i = texpatchComboBox.SelectedIndex;
                        ms = texpatchBitmapStream;
                        saveFileDialog1.FileName = texpatchComboBox.Items[i] + ".bmp";
                    }
                    else if (tabIndex == 2)
                    {
                        i = spriteComboBox.SelectedIndex;
                        ms = spriteBitmapStream;
                        saveFileDialog1.FileName = spriteComboBox.Items[i] + ".bmp";
                    }
                    else if (tabIndex == 3)
                    {
                        i = mscpatchComboBox.SelectedIndex;
                        ms = mscpatchBitmapStream;
                        saveFileDialog1.FileName = mscpatchComboBox.Items[i] + ".bmp";
                    }
                    else
                    {
                        i = flatComboBox.SelectedIndex;
                        ms = flatBitmapStream;
                        saveFileDialog1.FileName = flatComboBox.Items[i] + ".bmp";
                    }
                    saveFileDialog1.Title = "画像をBMPファイルとして保存";
                    saveFileDialog1.Filter = "BMPファイル|*.bmp";
                    break;
                case 5:
                    i = sfxComboBox.SelectedIndex;
                    ms = sfxList[i].data;
                    saveFileDialog1.Title = "SFXをWAVファイルとして保存";
                    saveFileDialog1.Filter = "WAVファイル|*.wav";
                    saveFileDialog1.FileName = sfxComboBox.Items[i] + ".wav";
                    break;
                case 6:
                    i = musComboBox.SelectedIndex;
                    ms = musList[i].data;
                    saveFileDialog1.Title = "MUSをMIDIファイルとして保存";
                    saveFileDialog1.Filter = "MIDIファイル|*.mid";
                    saveFileDialog1.FileName = musComboBox.Items[i] + ".mid";
                    break;
                default:
                    return;
            }
            if (saveFileDialog1.ShowDialog() != DialogResult.OK)
                return;
            byteArray = new byte[ms.Length];
            ms.Seek(0, SeekOrigin.Begin);
            ms.Read(byteArray, 0, (int)ms.Length);
            fs = (FileStream)saveFileDialog1.OpenFile();
            fs.Write(byteArray, 0, (int)ms.Length);
            fs.Close();
        }

        private void musPlayButton_Click(object sender, EventArgs e)
        {
            int i;
            MemoryStream ms;
            byte[] byteArray;
            FileStream fs;

            if (!wadLoaded)
                return;
            MPlayer.Stop();
            MPlayer.Close();
            Directory.SetCurrentDirectory(appPath);
            if (File.Exists(tempmidname) == true)
                File.Delete(tempmidname);
            tempmidname = "tempmid" + tempmidnum.ToString() + ".mid";
            tempmidnum++;
            i = musComboBox.SelectedIndex;
            ms = musList[i].data;
            byteArray = new byte[ms.Length];
            ms.Seek(0, SeekOrigin.Begin);
            ms.Read(byteArray, 0, (int)ms.Length);
            fs = new FileStream(tempmidname, FileMode.Create);
            fs.Write(byteArray, 0, (int)ms.Length);
            fs.Close();
            MPlayer.Open(new Uri(tempmidname, UriKind.Relative));
            MPlayer.Play(); // MediaPlayerクラスを使って実際に再生させるには、WMP10以上が必要
        }

        private void mainForm_FormClosed(object sender, FormClosedEventArgs e)
        {
            Directory.SetCurrentDirectory(appPath);
            if (File.Exists(tempmidname) == true)
            {
                MPlayer.Stop();
                MPlayer.Close();
                File.Delete(tempmidname);
            }
        }

        private void mainForm_Load(object sender, EventArgs e)
        {
            appPath = AppDomain.CurrentDomain.BaseDirectory;
        }

        private void musStopButton_Click(object sender, EventArgs e)
        {
            Directory.SetCurrentDirectory(appPath);
            if (File.Exists(tempmidname) == true)
            {
                MPlayer.Stop();
                MPlayer.Close();
                File.Delete(tempmidname);
            }
        }

        private void sfxComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i;

            i = sfxComboBox.SelectedIndex;
            sfxInfoLabel.Text = "長さ: " + sfxList[i].length.ToString("0.00") + "秒";
        }

        private void sfxPlayButton_Click(object sender, EventArgs e)
        {
            int i;

            if (!wadLoaded)
                return;
            i = sfxComboBox.SelectedIndex;
            // ストリームの位置を手動で先頭に戻さないと、「WAVE ヘッダーが壊れています。」 というエラーが出るのは(.NET側の)バグの模様
            // 以下は、http://www.geekpedia.com/tutorial193_Play-WAV-files-using-SoundPlayer.html のコメント欄に書かれていた対処方法
            MemoryStream ms = sfxList[i].data;
            ms.Position = 0;
            SPlayer.Stream = null;
            SPlayer.Stream = ms;
            SPlayer.Play();
        }

        private void sfxStopButton_Click(object sender, EventArgs e)
        {
            SPlayer.Stop();
        }

        private void textureComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i, j;
            texture_s tex;
            string s;
            MemoryStream ms, ms2;
            BinaryReader br, br2;
            short originx, originy, patch, dummy;
            int pitch, dim, size;
            byte back;
            int patchWidth;
            int x, x1, x2;

            if (!wadLoaded)
                return;
            i = textureComboBox.SelectedIndex;
            tex = textures[i];
            textureWidth = tex.width;
            textureHeight = tex.height;
            s = "幅: " + textureWidth.ToString() + "\n高さ: " + textureHeight.ToString() + "\n\nPatch数: " + tex.patchcount.ToString();
            if (textureBitmapStream == null)
            {
                textureBitmapStream = new MemoryStream(1078);
                textureBitmapWriter = new BinaryWriter(textureBitmapStream, Encoding.ASCII);
                SetupBitmapHeader(textureBitmapWriter, 0);
            }
            pitch = (textureWidth + 3) / 4 * 4;
            dim = pitch * textureHeight;
            size = 1078 + dim;
            textureBitmapStream.SetLength(size);
            textureBitmapStream.Seek(2, SeekOrigin.Begin);
            textureBitmapWriter.Write(size);   // bfSize
            textureBitmapStream.Seek(18, SeekOrigin.Begin);
            textureBitmapWriter.Write(textureWidth);  // biWidth
            textureBitmapWriter.Write(textureHeight); // biHeight
            textureBitmapStream.Seek(1078, SeekOrigin.Begin);
            if (textureBGComboBox.SelectedIndex == 0)
                back = 0;
            else
                back = 255;
            for (i=0 ; i<dim ; i++)
                textureBitmapWriter.Write(back);
            ms = tex.patches;
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            for (i=0 ; i<tex.patchcount ; i++)
            {
                originx = br.ReadInt16();
                originy = br.ReadInt16();
                patch = br.ReadInt16();
                s += ("\n  " + pnames[patch]);
                dummy = br.ReadInt16(); // stepdir
                dummy = br.ReadInt16(); // colormap
                ms2 = patches[patch];
                if (ms2 == null)
                    continue;
                br2 = new BinaryReader(ms2, Encoding.ASCII);
                ms2.Seek(0, SeekOrigin.Begin);
                patchWidth = br2.ReadInt16();
                ms2.Seek(8, SeekOrigin.Begin);
                for (j=0 ; j<patchWidth ; j++)
                    columnofs[j] = br2.ReadInt32();
                x1 = originx;
                x2 = x1 + patchWidth;
                if (x1 < 0)
                    x = 0;
                else
                    x = x1;
                if (x2 > textureWidth)
                    x2 = textureWidth;
                for ( ; x<x2 ; x++)
                {
                    ms2.Seek(columnofs[x-x1], SeekOrigin.Begin);
                    DrawColumnOnBitmap(br2, textureBitmapWriter, x, originy, pitch, textureHeight);
                }
            }
            s = s.Replace('\0', ' ');
            textureInfoLabel.Text = s;
            texturePictureBox.Invalidate();
        }

        private void texturePictureBox_Paint(object sender, PaintEventArgs e)
        {
            Graphics g;
            Image image;
            int s;

            if (!wadLoaded)
                return;
            g = e.Graphics;
            g.Clear(texturePictureBox.BackColor);
            s = textureMagComboBox.SelectedIndex + 1;
            image = Image.FromStream(textureBitmapStream);
            g.DrawImage(image, 10, 10, textureWidth * s, textureHeight * s);
        }

        private void spriteComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i;
            MemoryStream ms;
            BinaryReader br;
            int leftoffset, topoffset;
            int pitch, dim, size;
            byte back;

            if (!wadLoaded)
                return;
            i = spriteComboBox.SelectedIndex;
            ms = sprites[i];
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            spriteWidth = br.ReadInt16();
            spriteHeight = br.ReadInt16();
            leftoffset = br.ReadInt16();
            topoffset = br.ReadInt16();
            for (i=0 ; i<spriteWidth ; i++)
                columnofs[i] = br.ReadInt32();
            spriteInfoLabel.Text = "幅: " + spriteWidth.ToString() +
                                   "\n高さ: " + spriteHeight.ToString() + "\n" +
                                   "\nLeft Offset: " + leftoffset.ToString() +
                                   "\nTop Offset: " + topoffset.ToString();
            if (spriteBitmapStream == null)
            {
                spriteBitmapStream = new MemoryStream(1078);
                spriteBitmapWriter = new BinaryWriter(spriteBitmapStream, Encoding.ASCII);
                SetupBitmapHeader(spriteBitmapWriter, 0);
            }
            pitch = (spriteWidth + 3) / 4 * 4;
            dim = pitch * spriteHeight;
            size = 1078 + dim;
            spriteBitmapStream.SetLength(size);
            spriteBitmapStream.Seek(2, SeekOrigin.Begin);
            spriteBitmapWriter.Write(size);   // bfSize
            spriteBitmapStream.Seek(18, SeekOrigin.Begin);
            spriteBitmapWriter.Write(spriteWidth);  // biWidth
            spriteBitmapWriter.Write(spriteHeight); // biHeight
            spriteBitmapStream.Seek(1078, SeekOrigin.Begin);
            if (spriteBGComboBox.SelectedIndex == 0)
                back = 0;
            else
                back = 255;
            for (i=0 ; i<dim ; i++)
                spriteBitmapWriter.Write(back);
            for (i=0 ; i<spriteWidth ; i++)
            {
                ms.Seek(columnofs[i], SeekOrigin.Begin);
                DrawColumnOnBitmap(br, spriteBitmapWriter, i, 0, pitch, spriteHeight);
            }
            spritePictureBox.Invalidate();
        }

        private void spritePictureBox_Paint(object sender, PaintEventArgs e)
        {
            Graphics g;
            Image image;
            int s;

            if (!wadLoaded)
                return;
            g = e.Graphics;
            g.Clear(spritePictureBox.BackColor);
            s = spriteMagComboBox.SelectedIndex + 1;
            image = Image.FromStream(spriteBitmapStream);
            g.DrawImage(image, 10, 10, spriteWidth * s, spriteHeight * s);
        }

        private void mscpatchComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i;
            MemoryStream ms;
            BinaryReader br;
            int leftoffset, topoffset;
            int pitch, dim, size;
            byte back;

            if (!wadLoaded)
                return;
            i = mscpatchComboBox.SelectedIndex;
            ms = mscpatches[i];
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            mscpatchWidth = br.ReadInt16();
            mscpatchHeight = br.ReadInt16();
            leftoffset = br.ReadInt16();
            topoffset = br.ReadInt16();
            for (i=0 ; i<mscpatchWidth ; i++)
                columnofs[i] = br.ReadInt32();
            mscpatchInfoLabel.Text = "幅: " + mscpatchWidth.ToString() +
                                     "\n高さ: " + mscpatchHeight.ToString() + "\n" +
                                     "\nLeft Offset: " + leftoffset.ToString() +
                                     "\nTop Offset: " + topoffset.ToString();
            if (mscpatchBitmapStream == null)
            {
                mscpatchBitmapStream = new MemoryStream(1078);
                mscpatchBitmapWriter = new BinaryWriter(mscpatchBitmapStream, Encoding.ASCII);
                SetupBitmapHeader(mscpatchBitmapWriter, 0);
            }
            pitch = (mscpatchWidth + 3) / 4 * 4;
            dim = pitch * mscpatchHeight;
            size = 1078 + dim;
            mscpatchBitmapStream.SetLength(size);
            mscpatchBitmapStream.Seek(2, SeekOrigin.Begin);
            mscpatchBitmapWriter.Write(size);   // bfSize
            mscpatchBitmapStream.Seek(18, SeekOrigin.Begin);
            mscpatchBitmapWriter.Write(mscpatchWidth);  // biWidth
            mscpatchBitmapWriter.Write(mscpatchHeight); // biHeight
            mscpatchBitmapStream.Seek(1078, SeekOrigin.Begin);
            if (mscpatchBGComboBox.SelectedIndex == 0)
                back = 0;
            else
                back = 255;
            for (i=0 ; i<dim ; i++)
                mscpatchBitmapWriter.Write(back);
            for (i=0 ; i<mscpatchWidth ; i++)
            {
                ms.Seek(columnofs[i], SeekOrigin.Begin);
                DrawColumnOnBitmap(br, mscpatchBitmapWriter, i, 0, pitch, mscpatchHeight);
            }
            mscpatchPictureBox.Invalidate();
        }

        private void mscpatchPictureBox_Paint(object sender, PaintEventArgs e)
        {
            Graphics g;
            Image image;
            int s;

            if (!wadLoaded)
                return;
            g = e.Graphics;
            g.Clear(mscpatchPictureBox.BackColor);
            s = mscpatchMagComboBox.SelectedIndex + 1;
            image = Image.FromStream(mscpatchBitmapStream);
            g.DrawImage(image, 10, 10, mscpatchWidth * s, mscpatchHeight * s);
        }

        private void flatComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i, j, pos;
            MemoryStream ms;
            BinaryReader br;

            if (!wadLoaded)
                return;
            i = flatComboBox.SelectedIndex;
            ms = flats[i];
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            if (flatBitmapStream == null)
            {
                flatBitmapStream = new MemoryStream(1078+4096);
                flatBitmapWriter = new BinaryWriter(flatBitmapStream, Encoding.ASCII);
                SetupBitmapHeader(flatBitmapWriter, 0);
            }
            flatBitmapStream.Seek(2, SeekOrigin.Begin);
            flatBitmapWriter.Write(1078+4096);  // bfSize
            flatBitmapStream.Seek(18, SeekOrigin.Begin);
            flatBitmapWriter.Write(64); // biWidth
            flatBitmapWriter.Write(64); // biHeight
            for (i=0 ; i<64 ; i++)
            {
                for (j=0 ; j<64 ; j++)
                {
                    pos = 1078 + (63-i)*64 + j;
                    flatBitmapWriter.Seek(pos, SeekOrigin.Begin);
                    flatBitmapWriter.Write(br.ReadByte());
                }
            }
            flatPictureBox.Invalidate();
        }

        private void flatPictureBox_Paint(object sender, PaintEventArgs e)
        {
            Graphics g;
            Image image;
            int s;

            if (!wadLoaded)
                return;
            g = e.Graphics;
            g.Clear(flatPictureBox.BackColor);
            s = flatMagComboBox.SelectedIndex + 1;
            image = Image.FromStream(flatBitmapStream);
            g.DrawImage(image, 10, 10, 64 * s, 64 * s);
        }

        private void openGrpFileButton_Click(object sender, EventArgs e)
        {
            openFileDialog1.Title = "GRPファイルを開く";
            openFileDialog1.Filter = "GRPファイル|*.grp";
            if (openFileDialog1.ShowDialog() == DialogResult.OK)
            {
                if (grpLoaded == true)
                    ClearGrpTabs();
                if (OpenGrpFile(openFileDialog1.FileName) == true)
                {
                    if (SetupGrpTabs() == false)
                    {
                        ClearGrpTabs();
                        return;
                    }
                }
            }
        }

        bool OpenGrpFile(string path)
        {
            char[] name12;
            string s;
            int i, pos;
            char[] charsToTrim = { '\0' };

            grpFS = File.OpenRead(path);
            grpBR = new BinaryReader(grpFS, Encoding.ASCII);
            name12 = grpBR.ReadChars(12);
            s = new String(name12);
            if (s != "KenSilverman")
            {
                MessageBox.Show("GRPファイルのフォーマットが正しくありません");
                return false;
            }
            grpNumfiles = grpBR.ReadInt32();
            grpInfotable = new lumpinfo_s[grpNumfiles];
            pos = 16 * (1 + grpNumfiles);
            for (i=0 ; i<grpNumfiles ; i++)
            {
                name12 = grpBR.ReadChars(12);
                s = new String(name12);
                grpInfotable[i].name = s.TrimEnd(charsToTrim);
                grpInfotable[i].size = grpBR.ReadInt32();
                grpInfotable[i].pos = pos;
                pos += grpInfotable[i].size;
            }
            return true;
        }

        bool SetupGrpTabs()
        {
            int i;
            string s;
            int nBytes;
            byte[] byteArray;
            MemoryStream ms;

            for (i=0 ; i<grpNumfiles ; i++)
            {
                s = grpInfotable[i].name;
                if (s.EndsWith(".ART"))
                    ReadTiles(grpInfotable[i].pos, s.Remove(s.Length-4));
            }
            for (i=0 ; i<grpNumfiles ; i++)
            {
                if (grpInfotable[i].name == "PALETTE.DAT")
                {
                    grpFS.Seek(grpInfotable[i].pos, SeekOrigin.Begin);
                    grpFS.Read(palettedat, 0, 768);
                }
            }
            for (i=0 ; i<grpNumfiles ; i++)
            {
                s = grpInfotable[i].name;
                if (s.EndsWith(".VOC"))
                    ReadVoc(grpInfotable[i].pos, s.Remove(s.Length-4));
            }
            for (i=0 ; i<grpNumfiles ; i++)
            {
                s = grpInfotable[i].name;
                if (s.EndsWith(".MID"))
                {
                    nBytes = grpInfotable[i].size;
                    byteArray = new byte[nBytes];
                    grpFS.Seek(grpInfotable[i].pos, SeekOrigin.Begin);
                    grpFS.Read(byteArray, 0, nBytes);
                    ms = new MemoryStream(byteArray);
                    midList.Add(ms);
                    midComboBox.Items.Add(s.Remove(s.Length-4));
                }
            }
            for (i=0 ; i<tileList.Count ; i++)
                artComboBox.Items.Add(tileList[i].name);
            for (i=0 ; i<vocList.Count ; i++)
                vocComboBox.Items.Add(vocList[i].name);
            artMagComboBox.SelectedIndex = 0;
            grpLoaded = true;
            artComboBox.SelectedIndex = 0;
            vocComboBox.SelectedIndex = 0;
            if (midList.Count != 0) // 製品版のSWのMIDファイルが見つからない
                midComboBox.SelectedIndex = 0;
            return true;
        }

        void ClearGrpTabs()
        {
            int i;

            artComboBox.Items.Clear();
            vocComboBox.Items.Clear();
            midComboBox.Items.Clear();
            artInfoLabel.Text = null;
            vocInfoLabel.Text = null;
            artPictureBox.Image = null;
            for (i=0 ; i<tileList.Count ; i++)
                tileList[i].data.Dispose();
            tileList.Clear();
            for (i=0 ; i<vocList.Count ; i++)
                vocList[i].data.Dispose();
            vocList.Clear();
            for (i=0 ; i<midList.Count ; i++)
                midList[i].Dispose();
            midList.Clear();
            tileBitmapStream = null; // DUKEとSWではパレットが違う
            grpFS.Close();
            grpLoaded = false;
        }

        void ReadTiles(int pos, string basename)
        {
            int i, localtilestart, localtileend, numlocaltiles;
            short[] tilesizx, tilesizy;
            int nBytes;
            byte[] byteArray;
            tile_s tile;

            grpFS.Seek(pos, SeekOrigin.Begin);
            i = grpBR.ReadInt32();  // artversion
            i = grpBR.ReadInt32();  // numtiles
            localtilestart = grpBR.ReadInt32();
            localtileend = grpBR.ReadInt32();
            numlocaltiles = localtileend - localtilestart + 1;
            tilesizx = new short[numlocaltiles];
            for (i=0 ; i<numlocaltiles ; i++)
                tilesizx[i] = grpBR.ReadInt16();
            tilesizy = new short[numlocaltiles];
            for (i=0 ; i<numlocaltiles ; i++)
                tilesizy[i] = grpBR.ReadInt16();
            grpFS.Seek(sizeof(int)*numlocaltiles, SeekOrigin.Current);  // picanm[numlocaltiles]
            for (i=0 ; i<numlocaltiles ; i++)
            {
                if ((tilesizx[i] == 0) && (tilesizy[i] == 0))
                    continue;
                nBytes = tilesizx[i]*tilesizy[i];
                byteArray = new byte[nBytes];
                grpFS.Read(byteArray, 0, nBytes);
                tile.name = (localtilestart+i).ToString() + "[" + basename + "]";
                tile.width = tilesizx[i];
                tile.height = tilesizy[i];
                tile.data = new MemoryStream(byteArray);
                tileList.Add(tile);
            }
        }

        void ReadVoc(int pos, string basename)
        {
            char[] id19;
            string s;
            short headersize;
            byte blocktype;
            uint datalength;
            byte sampleratecode, compressioncode;
            int totalsize, samplespersecond, bitspersample, numchannels;
            MemoryStream ms;
            BinaryWriter bw;
            int nBytes;
            byte[] byteArray;
            sound_s voc;

            grpFS.Seek(pos, SeekOrigin.Begin);
            id19 = grpBR.ReadChars(19);
            s = new String(id19);
            if (s != "Creative Voice File")
            {
                MessageBox.Show("VOCファイルのフォーマットが正しくありません");
                return;
            }
            grpFS.Seek(1, SeekOrigin.Current);
            headersize = grpBR.ReadInt16();
            if (headersize != 26)
            {
                MessageBox.Show("VOCファイルヘッダのサイズが26ではありません");
                return;
            }
            grpFS.Seek(4, SeekOrigin.Current);
            blocktype = grpBR.ReadByte();
            datalength = grpBR.ReadUInt32();
            datalength &= 0x00FFFFFF;
            grpFS.Seek(-1, SeekOrigin.Current);
            if (blocktype == 1)
            {
                sampleratecode = grpBR.ReadByte();
                compressioncode = grpBR.ReadByte();
                if (compressioncode != 0)
                {
                    MessageBox.Show("BlockType1のCompressionCodeが0ではありません");
                    return;
                }
                samplespersecond = 1000000 / (256 - sampleratecode);
                bitspersample = 8;
                totalsize = (int)datalength - 2 + 44;
            }
            else if (blocktype == 9)
            {
                samplespersecond = grpBR.ReadInt32();
                bitspersample = grpBR.ReadByte();
                numchannels = grpBR.ReadByte();
                if (numchannels != 1)
                {
                    MessageBox.Show("BlockType9のチャンネル数が1ではありません");
                    return;
                }
                grpFS.Seek(6, SeekOrigin.Current);
                totalsize = (int)datalength - 12 + 44;
            }
            else
            {
                MessageBox.Show("VOCファイルヘッダの後がType1またはType9のブロックではありません");
                return;
            }
            ms = new MemoryStream(totalsize);
            bw = new BinaryWriter(ms, Encoding.ASCII);
            bw.Write(Encoding.ASCII.GetBytes("RIFF"));
            bw.Write((Int32)(totalsize - 8));
            bw.Write(Encoding.ASCII.GetBytes("WAVE"));
            bw.Write(Encoding.ASCII.GetBytes("fmt "));
            bw.Write((Int32)16);
            bw.Write((UInt16)1);                                    // compression code (1 = PCM)
            bw.Write((UInt16)1);                                    // number of channels (i.e. mono, stereo...)
            bw.Write((UInt32)samplespersecond);                     // samples per second
            bw.Write((UInt32)(bitspersample/8*samplespersecond));   // average number of bytes per second
            bw.Write((UInt16)(bitspersample/8));                    // block size of data
            bw.Write((UInt16)bitspersample);                        // number of bits per sample of mono data
            bw.Write(Encoding.ASCII.GetBytes("data"));
            bw.Write((Int32)(totalsize - 44));
            nBytes = totalsize - 44;
            byteArray = new byte[nBytes];
            byteArray = grpBR.ReadBytes(nBytes);
            bw.Write(byteArray);
            voc.name = basename;
            voc.length = (float)(totalsize - 44) / samplespersecond;
            voc.samplerate = samplespersecond;
            voc.resolution = bitspersample;
            voc.data = ms;
            vocList.Add(voc);
        }

        private void artComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i, j, pos;
            MemoryStream ms;
            BinaryReader br;
            int pitch, dim, size;

            if (!grpLoaded)
                return;
            i = artComboBox.SelectedIndex;
            ms = tileList[i].data;
            br = new BinaryReader(ms, Encoding.ASCII);
            ms.Seek(0, SeekOrigin.Begin);
            tileWidth = tileList[i].width;
            tileHeight = tileList[i].height;
            artInfoLabel.Text = "幅: " + tileWidth.ToString() +
                                "\n高さ: " + tileHeight.ToString();
            if (tileBitmapStream == null)
            {
                tileBitmapStream = new MemoryStream(1078);
                tileBitmapWriter = new BinaryWriter(tileBitmapStream, Encoding.ASCII);
                SetupBitmapHeader(tileBitmapWriter, 1);
            }
            pitch = (tileWidth + 3) / 4 * 4;
            dim = pitch * tileHeight;
            size = 1078 + dim;
            tileBitmapStream.SetLength(size);
            tileBitmapWriter.Seek(2, SeekOrigin.Begin);
            tileBitmapWriter.Write(size);       // bfSize
            tileBitmapWriter.Seek(18, SeekOrigin.Begin);
            tileBitmapWriter.Write(tileWidth);  // biWidth
            tileBitmapWriter.Write(tileHeight); // biHeight
            for (i=0 ; i<tileWidth ; i++)
            {
                for (j=0 ; j<tileHeight ; j++)
                {
                    pos = 1078 + ((tileHeight-1) - j)*pitch + i;
                    tileBitmapWriter.Seek(pos, SeekOrigin.Begin);
                    tileBitmapWriter.Write(br.ReadByte());
                }
            }
            artPictureBox.Invalidate();
        }

        private void artPictureBox_Paint(object sender, PaintEventArgs e)
        {
            Graphics g;
            Image image;
            int s;

            if (!grpLoaded)
                return;
            g = e.Graphics;
            g.Clear(artPictureBox.BackColor);
            s = artMagComboBox.SelectedIndex + 1;
            image = Image.FromStream(tileBitmapStream);
            g.DrawImage(image, 10, 10, tileWidth * s, tileHeight * s);
        }

        private void vocComboBox_SelectedIndexChanged(object sender, EventArgs e)
        {
            int i;

            i = vocComboBox.SelectedIndex;
            vocInfoLabel.Text = "長さ: " + vocList[i].length.ToString("0.00") + "秒" +
                                "\n周波数: " + vocList[i].samplerate.ToString() + "Hz" +
                                "\nビット数: " + vocList[i].resolution.ToString() + "bit";
        }

        private void vocPlayButton_Click(object sender, EventArgs e)
        {
            int i;
            MemoryStream ms;

            if (!grpLoaded)
                return;
            i = vocComboBox.SelectedIndex;
            ms = vocList[i].data;
            ms.Position = 0;
            SPlayer.Stream = null;
            SPlayer.Stream = ms;
            SPlayer.Play();
        }

        private void vocStopButton_Click(object sender, EventArgs e)
        {
            SPlayer.Stop();
        }

        private void midPlayButton_Click(object sender, EventArgs e)
        {
            int i;
            MemoryStream ms;
            byte[] byteArray;
            FileStream fs;

            if (!grpLoaded)
                return;
            if (midList.Count == 0)
                return;
            MPlayer.Stop();
            MPlayer.Close();
            Directory.SetCurrentDirectory(appPath);
            if (File.Exists(tempmidname) == true)
                File.Delete(tempmidname);
            tempmidname = "tempmid" + tempmidnum.ToString() + ".mid";
            tempmidnum++;
            i = midComboBox.SelectedIndex;
            ms = midList[i];
            byteArray = new byte[ms.Length];
            ms.Seek(0, SeekOrigin.Begin);
            ms.Read(byteArray, 0, (int)ms.Length);
            fs = new FileStream(tempmidname, FileMode.Create);
            fs.Write(byteArray, 0, (int)ms.Length);
            fs.Close();
            MPlayer.Open(new Uri(tempmidname, UriKind.Relative));
            MPlayer.Play();
        }

        private void midStopButton_Click(object sender, EventArgs e)
        {
            Directory.SetCurrentDirectory(appPath);
            if (File.Exists(tempmidname) == true)
            {
                MPlayer.Stop();
                MPlayer.Close();
                File.Delete(tempmidname);
            }
        }

        private void saveGrpItemButton_Click(object sender, EventArgs e)
        {
            int tabIndex, i;
            MemoryStream ms;
            byte[] byteArray;
            FileStream fs;

            if (!grpLoaded)
                return;
            tabIndex = grpTabControl.SelectedIndex;
            switch (tabIndex)
            {
                case 0:
                    i = artComboBox.SelectedIndex;
                    ms = tileBitmapStream;
                    saveFileDialog1.Title = "画像をBMPファイルとして保存";
                    saveFileDialog1.Filter = "BMPファイル|*.bmp";
                    saveFileDialog1.FileName = artComboBox.Items[i] + ".bmp";
                    break;
                case 1:
                    i = vocComboBox.SelectedIndex;
                    ms = vocList[i].data;
                    saveFileDialog1.Title = "サウンドをWAVファイルとして保存";
                    saveFileDialog1.Filter = "WAVファイル|*.wav";
                    saveFileDialog1.FileName = vocComboBox.Items[i] + ".wav";
                    break;
                case 2:
                    if (midList.Count == 0)
                        return;
                    i = midComboBox.SelectedIndex;
                    ms = midList[i];
                    saveFileDialog1.Title = "音楽をMIDIファイルとして保存";
                    saveFileDialog1.Filter = "MIDIファイル|*.mid";
                    saveFileDialog1.FileName = midComboBox.Items[i] + ".mid";
                    break;
                default:
                    return;
            }
            if (saveFileDialog1.ShowDialog() != DialogResult.OK)
                return;
            byteArray = new byte[ms.Length];
            ms.Seek(0, SeekOrigin.Begin);
            ms.Read(byteArray, 0, (int)ms.Length);
            fs = (FileStream)saveFileDialog1.OpenFile();
            fs.Write(byteArray, 0, (int)ms.Length);
            fs.Close();
        }
    }

    public class Wad
    {
        public string filename;
        FileStream fs;
        BinaryReader br;
        public int numlumps;
        int infotableofs;
        public lumpinfo_s[] infotable;

        public bool Open(string path)
        {
            char[] id4;
            int i;
            string s;
            lumpinfo_s lumpinfo;
            char[] lumpname;

            filename = Path.GetFileName(path);
            fs = File.OpenRead(path);
            br = new BinaryReader(fs, Encoding.ASCII);
            id4 = br.ReadChars(4);
            s = new String(id4);
            if (s != "IWAD")
            {
                MessageBox.Show("ファイルがIWADではありません");
                return false;
            }
            numlumps = br.ReadInt32();
            infotableofs = br.ReadInt32();
            infotable = new lumpinfo_s[numlumps];
            fs.Seek(infotableofs, SeekOrigin.Begin);
            for (i=0 ; i<numlumps ; i++)
            {
                lumpinfo.pos = br.ReadInt32();
                lumpinfo.size = br.ReadInt32();
                lumpname = br.ReadChars(8);
                lumpinfo.name = new String(lumpname);
                infotable[i] = lumpinfo;
            }
            return true;
        }

        public void Close()
        {
            fs.Close();
        }

        public MemoryStream ReadLump(string lumpname)
        {
            int i;
            int nBytes;
            byte[] ByteArray;
            MemoryStream ms;

            i = GetNumForName(lumpname);
            if (i == numlumps)
            {
                //MessageBox.Show("ReadLump: " + lumpname + " が見つかりません");
                return null;
            }
            nBytes = infotable[i].size;
            if (nBytes == 0)
                return null;
            ByteArray = new byte[nBytes];
            fs.Seek(infotable[i].pos, SeekOrigin.Begin);
            fs.Read(ByteArray, 0, nBytes);
            ms = new MemoryStream(ByteArray);
            return ms;
        }

        public int GetNumForName(string name)
        {
            int i=0;

            foreach (lumpinfo_s info in infotable)
            {
                if (info.name == name)
                    break;
                i++;
            }
            return i;
        }
    }

    public struct lumpinfo_s
    {
        public int      pos;
        public int      size;
        public string   name;
    }

    public struct texture_s
    {
        public string       name;
        public int          width;
        public int          height;
        public int          patchcount;
        public MemoryStream patches;
    }

    public struct sound_s
    {
        public string       name;
        public float        length;
        public int          samplerate;
        public int          resolution;
        public MemoryStream data;
    }

    public struct tile_s
    {
        public string       name;
        public int          width;
        public int          height;
        public MemoryStream data;
    }
}
