#include <windows.h>
#include <gl\gl.h> // @windows.hsĂȂ΂ȂȂ       
#include <gl\glu.h>
#include <stdlib.h>
#include <io.h>
#include "doomdef.h"
#include "doomstat.h"
#include "d_main.h"
#include "i_system.h"
#include "m_menu.h"
#include "g_game.h"
#include "z_zone.h"
#include "w_wad.h"
#include "sounds.h"
#include "s_sound.h"
#include "m_misc.h"
#include "v_video.h"
#include "hu_stuff.h"
#include "i_video.h"
#include "p_setup.h"
#include "st_stuff.h"
#include "r_local.h"
#include "m_argv.h"
#include "wi_stuff.h"
#include "f_finale.h"
#include "i_sound.h"

char*		wadfiles[MAXWADFILES];

boolean		devparm;		// started game with -devparm
boolean     nomonsters;		// checkparm of -nomonsters
boolean     respawnparm;	// checkparm of -respawn
boolean     fastparm;		// checkparm of -fast

boolean		singletics = false; // debug flag to cancel adaptiveness

skill_t		startskill;
int			startepisode;
int			startmap;
boolean		autostart;

boolean		advancedemo;

//char		basedefault[1024];      // default file
char        basedefault[] = "config.txt";

void D_CheckNetGame (void);
void G_BuildTiccmd (ticcmd_t* cmd);
void D_DoAdvanceDemo (void);

//
// EVENT HANDLING
//
// Events are asynchronous inputs generally generated by the game user.
// Events can be discarded if no responder claims them
//
event_t         events[MAXEVENTS];
int             eventhead;
int 		eventtail;

//
// D_PostEvent
// Called by the I/O functions when input is detected
//
void D_PostEvent (event_t* ev)
{
    events[eventhead] = *ev;
    eventhead = (++eventhead)&(MAXEVENTS-1);
}

//
// D_ProcessEvents
// Send all the events of the given timestamp down the responder chain
//
void D_ProcessEvents (void)
{
    event_t*	ev;
	
    // IF STORE DEMO, DO NOT ACCEPT INPUT
    if ( ( gamemode == commercial )
	 && (W_CheckNumForName("map01")<0) )
      return;
	
    for ( ; eventtail != eventhead ; eventtail = (++eventtail)&(MAXEVENTS-1) )
    {
	ev = &events[eventtail];
	if (M_Responder (ev))
	    continue;               // menu ate the event
	G_Responder (ev);
    }
}

//
// D_Display
//  draw current display, possibly wiping it from the previous
//

// wipegamestate can be set to -1 to force a wipe on the next draw
gamestate_t wipegamestate = GS_DEMOSCREEN;
extern  boolean setsizeneeded;
void R_ExecuteSetViewSize (void);

extern HGLRC    hRC;
extern int      setblocks;
extern double   ortholeft;
extern double   orthoright;

void D_Display (void)
{
	if (!hRC)
		return;

    // change the view size if needed
    if (setsizeneeded)
    {
        R_ExecuteSetViewSize ();
        //oldgamestate = -1;        // force background redraw
        //borderdrawcount = 3;
    }

	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);

    // draw the view directly
    if (gamestate == GS_LEVEL && !automapactive && gametic)
        R_RenderPlayerView (&players[displayplayer]);

    glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glMatrixMode(GL_PROJECTION);
	glPushMatrix();
	glLoadIdentity();
	gluOrtho2D(ortholeft, orthoright, 200, 0);
    glDepthMask(GL_FALSE);
    glColor4ub(255, 255, 255, 255);

	switch (gamestate)
    {
      case GS_LEVEL:
	if (!gametic)
	    break;/*
	if (automapactive)
	    AM_Drawer ();
	if (wipe || (viewheight != 200 && fullscreen) )
	    redrawsbar = true;
	if (inhelpscreensstate && !inhelpscreens)
	    redrawsbar = true;              // just put away the help screen*/
	ST_Drawer (setblocks > 10/*, redrawsbar */);
	//fullscreen = viewheight == 200;
	break;

      case GS_INTERMISSION:
	WI_Drawer ();
	break;

      case GS_FINALE:
	F_Drawer ();
	break;

      case GS_DEMOSCREEN:
	D_PageDrawer ();
	break;
    }

    if (gamestate == GS_LEVEL && gametic)
	    HU_Drawer ();

    // draw pause pic
    if (paused)
        V_DrawPatchDirect((320-68)/2, 4, 0, W_CacheLumpName ("M_PAUSE", PU_CACHE));

	M_Drawer();

    glDepthMask(GL_TRUE);
	glPopMatrix();

	I_FinishUpdate();
}

extern HWAVEOUT hWaveOut;
int interframe;
int nowait;

MSG msg;

void D_DoomLoop(void)
{
    static int  starttime;

    I_StartTic ();
	D_ProcessEvents ();
	G_BuildTiccmd (&netcmds[consoleplayer][maketic%BACKUPTICS]);
	if (advancedemo)
        D_DoAdvanceDemo ();
	M_Ticker ();
	G_Ticker ();
	gametic++;
	maketic++;
    if (hWaveOut)
    {
        I_UpdateSound();
	    I_SubmitSound();
    }

    if (nowait)
    {
        interframe = 1;
        D_Display();
        interframe = 0;
        D_Display();
    }
    else
    {
        if ((timeGetTime()-starttime) <= 16)
        {
            while ((timeGetTime()-starttime) < 12)
            {
                // V2.1
                if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
                    DispatchMessage(&msg);
            }
            interframe = 1;
            D_Display();
        }
        while ((timeGetTime()-starttime) < 28)
        {
            // V2.1
            if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
                DispatchMessage(&msg);
        }
        starttime = timeGetTime();
        interframe = 0;
        D_Display();
    }
}

//
//  DEMO LOOP
//
int             demosequence;
int             pagetic;
char                    *pagename;

//
// D_PageTicker
// Handles timing for warped projection
//
void D_PageTicker (void)
{
    if (--pagetic < 0)
	D_AdvanceDemo ();
}

//
// D_PageDrawer
//
void D_PageDrawer (void)
{
    V_DrawPatch (0,0, 0, W_CacheLumpName(pagename, PU_CACHE));
}

//
// D_AdvanceDemo
// Called after each demo or intro demosequence finishes
//
void D_AdvanceDemo (void)
{
    advancedemo = true;
}

//
// This cycles through the demo sequences.
// FIXME - version dependend demo numbers?
//
 void D_DoAdvanceDemo (void)
{
    players[consoleplayer].playerstate = PST_LIVE;  // not reborn
    advancedemo = false;
    usergame = false;               // no save / end game here
    paused = false;
    gameaction = ga_nothing;

    if ( gamemode == retail )
      demosequence = (demosequence+1)%7;
    else
      demosequence = (demosequence+1)%6;
    
    switch (demosequence)
    {
      case 0:
	if ( gamemode == commercial )
	    pagetic = 35 * 11;
	else
	    pagetic = 170;
	gamestate = GS_DEMOSCREEN;
	pagename = "TITLEPIC";
	if ( gamemode == commercial )
	  S_StartMusic(mus_dm2ttl);
	else
	  S_StartMusic (mus_intro);
	break;
      case 1:
	G_DeferedPlayDemo ("demo1");
	break;
      case 2:
	pagetic = 200;
	gamestate = GS_DEMOSCREEN;
	pagename = "CREDIT";
	break;
      case 3:
	G_DeferedPlayDemo ("demo2");
	break;
      case 4:
	gamestate = GS_DEMOSCREEN;
	if ( gamemode == commercial)
	{
	    pagetic = 35 * 11;
	    pagename = "TITLEPIC";
	    S_StartMusic(mus_dm2ttl);
	}
	else
	{
	    pagetic = 200;

	    if ( gamemode == retail )
	      pagename = "CREDIT";
	    else
	      pagename = "HELP2";
	}
	break;
      case 5:
	G_DeferedPlayDemo ("demo3");
	break;
        // THE DEFINITIVE DOOM Special Edition demo
      case 6:
	G_DeferedPlayDemo ("demo4");
	break;
    }
}

//
// D_StartTitle
//
void D_StartTitle (void)
{
    gameaction = ga_nothing;
    demosequence = -1;
    D_AdvanceDemo ();
}

//
// D_AddFile
//
void D_AddFile (char *file)
{
    int     numwadfiles;
    char    *newfile;
	
    for (numwadfiles = 0 ; wadfiles[numwadfiles] ; numwadfiles++)
	;

    newfile = malloc (strlen(file)+1);
    strcpy (newfile, file);
	
    wadfiles[numwadfiles] = newfile;
}

#define R_OK	4

extern char iwadfile[];

//
// IdentifyVersion
// Checks availability of IWAD files by name,
// to determine whether registered/commercial features
// should be executed (notably loading PWAD's).
//
void IdentifyVersion (void)
{/*
	if ( !access ("doom2f.wad",R_OK) )
    {
	gamemode = commercial;
	// C'est ridicule!
	// Let's handle languages in config files, okay?
	language = french;
	D_AddFile ("doom2f.wad");
	return;
    }*/

    //if ( !access ("doom2.wad",R_OK) )
    if (!strcmp(iwadfile, "doom2.wad"))
    {
	gamemode = commercial;
	D_AddFile ("doom2.wad");
	return;
    }

    //if ( !access ("plutonia.wad", R_OK ) )
    if (!strcmp(iwadfile, "plutonia.wad"))
    {
      gamemode = commercial;
      D_AddFile ("plutonia.wad");
      return;
    }

    //if ( !access ( "tnt.wad", R_OK ) )
    if (!strcmp(iwadfile, "tnt.wad"))
    {
      gamemode = commercial;
      D_AddFile ("tnt.wad");
      return;
    }

    //if ( !access ("doomu.wad",R_OK) )
    if (!strcmp(iwadfile, "doomu.wad"))
    {
      gamemode = retail;
      D_AddFile ("doomu.wad");
      return;
    }

    //if ( !access ("doom.wad",R_OK) )
    if (!strcmp(iwadfile, "doom.wad"))
    {
      gamemode = registered;
      D_AddFile ("doom.wad");
      return;
    }

    //if ( !access ("doom1.wad",R_OK) )
    if (!strcmp(iwadfile, "doom1.wad"))
    {
      gamemode = shareware;
      D_AddFile ("doom1.wad");
      return;
    }

	I_Error("Game mode indeterminate.\n");
}

//
// D_DoomMain
//
void D_DoomMain (void)
{
    int     p;
    char    file[256];

	IdentifyVersion ();

    modifiedgame = false;

    nomonsters = M_CheckParm ("-nomonsters"); // @ʏɃQ[n߂ƎI false ɂȂ̂ -warp IvVȂǂƕpȂ΂ȂȂ

    p = M_CheckParm ("-file");
    if (p)
    {
	    // the parms after p are wadfile/lump names,
	    // until end of parms or another - preceded parm
	    modifiedgame = true;            // homebrew levels
	    while (++p != myargc && myargv[p][0] != '-')
	        D_AddFile (myargv[p]);
    }

    // @.lmpt@CtĂ
    p = M_CheckParm ("-playdemo");
    if (p && p < myargc-1)
    {
	    sprintf (file,"%s.lmp", myargv[p+1]);
	    D_AddFile (file);
	    //printf("Playing demo %s.lmp.\n",myargv[p+1]);
    }

	// get skill / episode / map from parms
    startskill = sk_medium;
    startepisode = 1;
    startmap = 1;
    autostart = false;

    p = M_CheckParm ("-skill");
    if (p && p < myargc-1)
    {
	    startskill = myargv[p+1][0]-'1';
	    autostart = true;
    }

    p = M_CheckParm ("-warp");
    if (p && p < myargc-1)
    {
	    if (gamemode == commercial)
	        startmap = atoi (myargv[p+1]);
	    else
	    {
	        startepisode = myargv[p+1][0]-'0';
	        startmap = myargv[p+2][0]-'0';
	    }
	    autostart = true;
    }

	Z_Init();
 	W_InitMultipleFiles(wadfiles);
	
	// @WinDoomŕtĂ镔BW_InitMultipleFiles()̌AM_Init()̑OōsKv
	if ((gamemode == retail) || (gamemode == registered))
       {
        char name[10][8] = { "e4m1","e4m2","e4m3","e4m4","e4m5","e4m6","e4m7","e4m8","e4m9", "m_epi4" };
        int i;
        //WriteDebug("Checking for Ultimate Doom...\n");
        gamemode = retail;
        for (i = 0;i < 10; i++)
          {
            if (W_CheckNumForName(name[i]) < 0)
               {
                gamemode = registered;
                break;
               }
           }
        if (gamemode == registered)
            /*WriteDebug("Normal Doom WAD file...\n")*/;
        else
            /*WriteDebug("Ultimate Doom WAD - fourth episode enabled...\n")*/;
       }

    // Check for -file in shareware
    if (modifiedgame)
    {
	// These are the lumps that will be checked in IWAD,
	// if any one is not present, execution will be aborted.
	char name[23][8]=
	{
	    "e2m1","e2m2","e2m3","e2m4","e2m5","e2m6","e2m7","e2m8","e2m9",
	    "e3m1","e3m3","e3m3","e3m4","e3m5","e3m6","e3m7","e3m8","e3m9",
	    "dphoof","bfgga0","heada1","cybra1","spida1d1"
	};
	int i;
	
	if ( gamemode == shareware)
	    I_Error("\nYou cannot -file with the shareware "
		    "version. Register!");

	// Check for fake IWAD with right name,
	// but w/o all the lumps of the registered version. 
	if (gamemode == registered)
	    for (i = 0;i < 23; i++)
		if (W_CheckNumForName(name[i])<0)
		    I_Error("\nThis is not the registered version.");
    }

    I_Init();
    V_Init();
	M_Init();
	R_Init();
	P_Init();
	D_CheckNetGame ();
	S_Init (snd_SfxVolume /* *8 */, snd_MusicVolume /* *8*/ );
	HU_Init();
	ST_Init ();

    // start the apropriate game based on parms
    p = M_CheckParm ("-record");
    if (p && p < myargc-1)
    {
	    G_RecordDemo (myargv[p+1]);
	    autostart = true;
    }

    p = M_CheckParm ("-playdemo");
    if (p && p < myargc-1)
    {
	    singledemo = true;          // quit after one demo
	    //G_DeferedPlayDemo (myargv[p+1]); // @ft@C͎st@CƓtH_ɂȂ΂Ȃ͗l
        {
            char* dest = (char *)calloc(9, 1);
            ExtractFileBase(myargv[p+1], dest);
            G_DeferedPlayDemo(dest);
        }
        return;
        //D_DoomLoop ();  // never returns
    }

	if ( gameaction != ga_loadgame )
    {
	    if (autostart || netgame)
	        G_InitNew (startskill, startepisode, startmap);
	    else
	        D_StartTitle ();        // start up intro loop
    }

    if (demorecording)
	    G_BeginRecording ();
}
