#include <windows.h>
#include <dmusici.h> // @August 2007 DirectX SDK was "the final release of the DirectX SDK that will contain the following components: DirectMusic"
                     // @rh 'dmusici.h': No such file or directory ƏôŁAۑĂDirectX9.0bSDKtH_(ЁuDirectX9HvO~Ovp)
                     // @Cӂ̏ꏊ(ChCũ[g)ɒuAVisualStudio̐ݒŃpXʂ
extern "C" {

IDirectMusicPerformance8* pPerformance;
IDirectMusicLoader8* pLoader;
IDirectMusicSegment8* pSegment;
IDirectMusicSegmentState* pSegmentState;

void DM_Init(HWND hWnd)
{
    CoInitialize(NULL);

    CoCreateInstance(CLSID_DirectMusicPerformance, NULL, CLSCTX_INPROC, IID_IDirectMusicPerformance8, (void**)&pPerformance );

    pPerformance->InitAudio(NULL,              // IDirectMusic interface not needed.
                            NULL,              // IDirectSound interface not needed.
                            hWnd,              // Window handle.
                            DMUS_APATH_DYNAMIC_STEREO,
                            64,                // Number of performance channels.
                            DMUS_AUDIOF_ALL,   // Features on synthesizer.
                            NULL               // Audio parameters; use defaults.
                            );

    CoCreateInstance(CLSID_DirectMusicLoader, NULL, CLSCTX_INPROC, IID_IDirectMusicLoader8, (void**)&pLoader);
}

void DM_Shutdown(void)
{
    if (pPerformance)
        pPerformance->Stop(NULL, NULL, 0, 0);

    if (pSegment)
    {
        pSegment->Unload(pPerformance);
        pSegment->Release();
    }

    if (pLoader)
        pLoader->Release();

    if (pPerformance)
    {
        pPerformance->CloseDown();
        pPerformance->Release();
    }

    CoUninitialize();
}

void DM_UnloadMusic(void)
{
    if (pPerformance)
        pPerformance->Stop(NULL, NULL, 0, 0);

    if (pLoader)
        pLoader->ClearCache(GUID_DirectMusicAllTypes);

    if (pSegment)
    {
        pSegment->Unload(pPerformance);
        pSegmentState->Release();
        pSegment->Release();
    }
}

BOOL DM_LoadSMF(byte* src, int size)
{
    DMUS_OBJECTDESC ObjDesc;
    HRESULT hr;

    ZeroMemory(&ObjDesc, sizeof(DMUS_OBJECTDESC));
    ObjDesc.dwSize      = sizeof(DMUS_OBJECTDESC);
    ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_MEMORY;
    ObjDesc.guidClass   = CLSID_DirectMusicSegment;
    ObjDesc.pbMemData   = src; // Do not use this value except when loading from a resource contained in the executable file.
    ObjDesc.llMemLength = size;

    hr = pLoader->GetObject(&ObjDesc, IID_IDirectMusicSegment8, (void**)&pSegment);
    if (hr != S_OK)
        return FALSE;

    hr = pSegment->SetParam(GUID_StandardMIDIFile, 0xFFFFFFFF, 0, 0, NULL);
    if (hr != S_OK)
        return FALSE;

    hr = pSegment->Download(pPerformance);
    if (hr != S_OK)
        return FALSE;

    return TRUE;
}

BOOL DM_LoadWAV(byte* src, int size)
{
    DMUS_OBJECTDESC ObjDesc;
    HRESULT hr;

    ZeroMemory(&ObjDesc, sizeof(DMUS_OBJECTDESC));
    ObjDesc.dwSize      = sizeof(DMUS_OBJECTDESC);
    ObjDesc.dwValidData = DMUS_OBJ_CLASS | DMUS_OBJ_MEMORY;
    ObjDesc.guidClass   = CLSID_DirectMusicSegment;
    ObjDesc.pbMemData   = src; // Do not use this value except when loading from a resource contained in the executable file.
    ObjDesc.llMemLength = size;

    hr = pLoader->GetObject(&ObjDesc, IID_IDirectMusicSegment8, (void**)&pSegment);
    if (hr != S_OK)
        return FALSE;

    hr = pSegment->Download(pPerformance);
    if (hr != S_OK)
        return FALSE;

    return TRUE;
}

void DM_PlayMusic(int looping)
{
    DWORD dwRepeats = looping ? DMUS_SEG_REPEAT_INFINITE : 0;

    if (!pSegment)
        return;

    pSegment->SetLoopPoints(0, 0);
    pSegment->SetRepeats(dwRepeats);
    pPerformance->PlaySegment(pSegment, 0, 0, &pSegmentState);
}

MUSIC_TIME  musictime;

void DM_PauseMusic(void)
{
    if (!pSegment)
        return;

    pSegmentState->GetSeek(&musictime);
    pPerformance->Stop(NULL, pSegmentState, 0, 0);
}

void DM_ResumeMusic(void)
{
    if (!pSegment)
        return;

    if (musictime) // @MUSIC_TIMElong^
    {
        pSegment->SetStartPoint(musictime);
        pPerformance->PlaySegment(pSegment, 0, 0, &pSegmentState);
        musictime = 0;
    }
}

void DM_StopMusic(void)
{
    if (!pSegment)
        return;

    pPerformance->Stop(NULL, NULL, 0, 0);
}

#define MUSICVOLUMERANGE 15

void DM_SetMasterVolume(int i)
{
    long vol = -3000 + (4000 * i / MUSICVOLUMERANGE);

    if (vol <= -3000)
        vol = -10000;

    pPerformance->SetGlobalParam(GUID_PerfMasterVolume, (void*)&vol, sizeof(long));
}

} // extern "C"
