#include <windows.h>
#include <gdiplus.h>
#include "i_system.h"
using namespace Gdiplus;

extern "C" unsigned* ImageFileToRGBA(void* image, int size, int* width, int* height)
{
    HGLOBAL hGlobal;
    LPVOID lpBuffer;
    IStream* lpStream;
    BitmapData bitmapData;
    unsigned* data;
    int i, j;
    byte *dest, *src;

    hGlobal = GlobalAlloc(GHND, size);
    lpBuffer = GlobalLock(hGlobal);
    memcpy(lpBuffer, image, size);
    GlobalUnlock(hGlobal);
    CreateStreamOnHGlobal(hGlobal, TRUE, &lpStream);
    Bitmap bitmap(lpStream);
    *width = bitmap.GetWidth();
    *height = bitmap.GetHeight();
    data = (unsigned*)malloc(4*(*width)*(*height));
#if 0 // @mFς
    Color pixelColor;
    for (i=0 ; i<*height ; i++)
    {
        dest = (byte*)data + i*(*width)*4;
        for (j=0 ; j<*width ; j++, dest+=4)
        {
            bitmap.GetPixel(j, i, &pixelColor);
            dest[0] = pixelColor.GetR();
            dest[1] = pixelColor.GetG();
            dest[2] = pixelColor.GetB();
            dest[3] = pixelColor.GetA();
        }
    }
#else
    Rect rect(0, 0, *width, *height);
    bitmap.LockBits(
      &rect,
      ImageLockModeRead,
      PixelFormat32bppARGB, // @ۂɂBGRȀԂɂȂ
      &bitmapData);
    for (i=0 ; i<*height ; i++)
    {
        dest = (byte*)data + i*(*width)*4;
        src = (byte*)bitmapData.Scan0 + i*bitmapData.Stride;
        for (j=0 ; j<*width ; j++, dest+=4, src+=4)
        {
            dest[0] = src[2];
            dest[1] = src[1];
            dest[2] = src[0];
            dest[3] = src[3];
        }
    }
    bitmap.UnlockBits(&bitmapData);
#endif
    return data;
}

GdiplusStartupInput gdiplusStartupInput;
ULONG_PTR gdiplusToken;

extern "C" void InitGdiplus(void)
{
    GdiplusStartup(&gdiplusToken, &gdiplusStartupInput, NULL);
}

extern "C" void ShutdownGdiplus(void)
{
    GdiplusShutdown(gdiplusToken);
}

extern "C" HINSTANCE hInst;

// @At@ltrbg}bv͐ǂ߂Ȃ
extern "C" unsigned* BitmapResourceToRGBA(PWCHAR name, int* pWidth, int* pHeight)
{
    BitmapData bitmapData;
    unsigned* data;
    int i, j;
    byte *dest, *src;
    int width, height;

    Bitmap bitmap(hInst, name);
    *pWidth = width = bitmap.GetWidth();
    *pHeight = height = bitmap.GetHeight();
    Rect rect(0, 0, width, height);
    bitmap.LockBits(
      &rect,
      ImageLockModeRead,
      PixelFormat32bppARGB,
      &bitmapData);
    data = (unsigned*)malloc(4*width*height);
    for (i=0 ; i<height ; i++)
    {
        dest = (byte*)data + i*width*4;
        src = (byte*)bitmapData.Scan0 + i*bitmapData.Stride;
        for (j=0 ; j<width ; j++, dest+=4, src+=4)
        {
            dest[0] = src[2];
            dest[1] = src[1];
            dest[2] = src[0];
            dest[3] = 255/*src[3]*/;
        }
    }
    bitmap.UnlockBits(&bitmapData);

    return data;
}

// @RGB/A-32bitACR͕\Ȃ
extern "C" unsigned* IconResourceToRGBA(char* name, int* pWidth, int* pHeight)
{
    HICON hIcon = (HICON)LoadImage(hInst, name, IMAGE_ICON, 0, 0, 0);
    BitmapData bitmapData;
    unsigned* data;
    int i, j;
    byte *dest, *src;
    int width, height;

    Bitmap bitmap(hIcon);
    *pWidth = width = bitmap.GetWidth();
    *pHeight = height = bitmap.GetHeight();
    Rect rect(0, 0, width, height);
    bitmap.LockBits(
      &rect,
      ImageLockModeRead,
      PixelFormat32bppARGB,
      &bitmapData);
    data = (unsigned*)malloc(4*width*height);
    for (i=0 ; i<height ; i++)
    {
        dest = (byte*)data + i*width*4;
        src = (byte*)bitmapData.Scan0 + i*bitmapData.Stride;
        for (j=0 ; j<width ; j++, dest+=4, src+=4)
        {
            dest[0] = src[2];
            dest[1] = src[1];
            dest[2] = src[0];
            dest[3] = src[3];
        }
    }
    bitmap.UnlockBits(&bitmapData);

    return data;
}
