// Emacs style mode select   -*- C++ -*- 
//-----------------------------------------------------------------------------
//
// $Id:$
//
// Copyright (C) 1993-1996 by id Software, Inc.
//
// This program is free software; you can redistribute it and/or
// modify it under the terms of the GNU General Public License
// as published by the Free Software Foundation; either version 2
// of the License, or (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// $Log:$
//
// DESCRIPTION:
//	Main program, simply calls D_DoomMain high level loop.
//
//-----------------------------------------------------------------------------

static const char
rcsid[] = "$Id: i_main.c,v 1.4 1997/02/03 22:45:10 b1 Exp $";

#define _CRT_SECURE_NO_WARNINGS

#define _WIN32_WINNT 0x0500     // for Mouse Wheei support (@uvO~OWindows()vP358)
#include <windows.h>
#include "doomdef.h"
#include "m_argv.h"
#include "d_main.h"
#include "i_system.h"
#include "music.h"
#include "m_misc.h"
#include "dm_lib.h"

/*
int
main
( int		argc,
  char**	argv ) 
{ 
    myargc = argc; 
    myargv = argv; 
 
    D_DoomMain (); 

    return 0;
} 
*/

HDC     hDC;
HWND    hMainWnd;
int     screenwidth;
int     screenheight;
//int     replay;
HINSTANCE hInst;

extern HGLRC hRC;

void D_DoomLoop(void);

int     buttonstate;
int     mousewheel;

LRESULT CALLBACK WndProc(HWND hwnd, UINT message, WPARAM wParam, LPARAM lParam)
{
	event_t event;

	switch(message)
	{
	case WM_KEYDOWN:
		if (lParam & 0x40000000)
			return 0;
        // @VK_OEM_COMMA/VK_OEM_PERIOD͔Ȃ̂ŃXLR[h画
        event.type = ev_keydown;
        if (((lParam>>16)&255) == 0x33) // @lParam 17rbgڂ8rbgOEMXLR[hɂȂĂ(uvO~OWindows()v6.2.2, 6.2.3 Q)
            event.data1 = ',';
        else if (((lParam>>16)&255) == 0x34)
            event.data1 = '.';
        else
		    event.data1 = wParam/*tolower(wParam)*/; // @̃At@xbgascii codeFL[Virtual-Key Code_u
		D_PostEvent(&event);
		return 0;

	case WM_KEYUP:
		event.type = ev_keyup;
        if (((lParam>>16)&255) == 0x33)
            event.data1 = ',';
        else if (((lParam>>16)&255) == 0x34)
            event.data1 = '.';
        else
		    event.data1 = wParam/*tolower(wParam)*/;
		D_PostEvent(&event);
		return 0;
	
    case WM_SYSKEYDOWN: // @AltL[Ƌɉ̃L[ꂽF10L[ꂽɔBMSDNCu "WM_SYSKEYDOWN" Q
        if (lParam & 0x40000000)
			return 0;
        event.type = ev_keydown;
        event.data1 = wParam;
        D_PostEvent(&event);
		break;

    case WM_SYSKEYUP:
        event.type = ev_keyup;
		event.data1 = wParam;
		D_PostEvent(&event);
        break;

    // @QUAKE\[X(MainWndProc()[gl_vidnt.c])甲
    // this is complicated because Win32 seems to pack multiple mouse events into
	// one update sometimes, so we always check all states and look for events
	case WM_LBUTTONDOWN:
	case WM_LBUTTONUP:
	case WM_RBUTTONDOWN:
	case WM_RBUTTONUP:
	case WM_MBUTTONDOWN:
	case WM_MBUTTONUP:
	case WM_MOUSEMOVE:
		buttonstate = 0;
		if (wParam & MK_LBUTTON)
			buttonstate |= 1;
		if (wParam & MK_RBUTTON)
			buttonstate |= 2;
		if (wParam & MK_MBUTTON)
			buttonstate |= 4;
		event.type = ev_mouse;
        event.data1 = buttonstate;
        event.data2 = event.data3 = 0;
        D_PostEvent(&event);
		return 0;

    case WM_MOUSEWHEEL: 
        if (!mousewheel)
            break;
		if ((short)HIWORD(wParam) > 0) 
            event.data3 = 50;   // MAXPLMOVE = 0x32
        else 
            event.data3 = -50;
        event.type = ev_mouse;
        event.data1 = buttonstate;
        event.data2 = 0;
        D_PostEvent(&event);
		return 0;
/*
    case MM_MCINOTIFY:
        if (wParam == MCI_NOTIFY_SUCCESSFUL)
        {
            if (replay)
                ReplayMidi();
            else
                StopMidi();
        }
        return 0;
*/
	case WM_DESTROY:
		I_Quit();
		//PostQuitMessage(0);
		return 0;
	}

	return DefWindowProc(hwnd, message, wParam, lParam);
}

extern int  debugout;
extern int	key_right;
extern int	key_left;
extern int	key_up;
extern int	key_down;
extern int	key_strafeleft;
extern int	key_straferight;
extern int  mousewalk;
extern int  midbuttonuse;
extern int  rebuildbsp;
extern int  nowait;
extern int  fixedratio;
extern int  fovy;
extern int  orgaspect;
extern int  nobob;

void InitGdiplus(void);
void ShutdownGdiplus(void);

BOOL CALLBACK StartupDlgProc(HWND, UINT, WPARAM, LPARAM);
int cxscreen, cyscreen;

#include <io.h>
char iwadfile[16];

int WINAPI WinMain(HINSTANCE hInstance, HINSTANCE hPrevInstance, PSTR szCmdLine, int iCmdShow)
{
	HWND        hwnd;
	MSG         msg;
	WNDCLASS    wndclass;
	char        szAppName[] = "GLDoom2007";
    FILE*       fp;
    int         p;
    //int         cxscreen, cyscreen;
    BOOL        dispchange = FALSE;

    hInst = hInstance;
	
    ParseCommand(szCmdLine); // @szCmdLine̓vO͊܂܂Ȃ

    M_LoadDefaults();

    cxscreen = GetSystemMetrics(SM_CXSCREEN);
    cyscreen = GetSystemMetrics(SM_CYSCREEN);

    if (M_CheckParm("-warp")) // @_CAO{bNXXLbv(xGfB^Nꂽ\)
    {
        if (!_access("doom2.wad", 0))
            strcpy(iwadfile, "doom2.wad");
        else if (!_access("plutonia.wad", 0))
            strcpy(iwadfile, "plutonia.wad");
        else if (!_access("tnt.wad", 0))
            strcpy(iwadfile, "tnt.wad");
        else if (!_access("doomu.wad", 0))
            strcpy(iwadfile, "doomu.wad");
        else if (!_access("doom.wad", 0))
            strcpy(iwadfile, "doom.wad");
        else if (!_access("doom1.wad", 0))
            strcpy(iwadfile, "doom1.wad");
        else
        {
            MessageBox(NULL, "IWAD܂łBvOI܂B", "GLDoom2007", MB_ICONERROR);
            return 0;
        }
    }
    else
    {
        if (DialogBox(hInst, "startupdialog", NULL, (DLGPROC)StartupDlgProc))
            return 0;
        
    }

    p = M_CheckParm("-debugout");
    if (p && p < myargc-1)
        debugout = atoi(myargv[p+1]);
    if (debugout)
    {
        fp = fopen(debugname, "w");
        I_Debug("GLDoom2007 Ver.2.1\n\n");
        fclose(fp);
    }

    p = M_CheckParm("-turnright");
    if (p && p < myargc-1)
        key_right = myargv[p+1][0];
    p = M_CheckParm("-turnleft");
    if (p && p < myargc-1)
        key_left = myargv[p+1][0];
    p = M_CheckParm("-walkforth");
    if (p && p < myargc-1)
        key_up = myargv[p+1][0];
    p = M_CheckParm("-walkback");
    if (p && p < myargc-1)
        key_down = myargv[p+1][0];
    p = M_CheckParm("-strafeleft");
    if (p && p < myargc-1)
        key_strafeleft = myargv[p+1][0];
    p = M_CheckParm("-straferight");
    if (p && p < myargc-1)
        key_straferight = myargv[p+1][0];
    p = M_CheckParm("-mousewheel");
    if (p && p < myargc-1)
        mousewheel = atoi(myargv[p+1]);
    p = M_CheckParm("-mousewalk");
    if (p && p < myargc-1)
        mousewalk = atoi(myargv[p+1]);
    p = M_CheckParm("-midbuttonuse");
    if (p && p < myargc-1)
        midbuttonuse = atoi(myargv[p+1]);
    p = M_CheckParm("-rebuild");
    if (p && p < myargc-1)
        rebuildbsp = atoi(myargv[p+1]);
    p = M_CheckParm("-nowait");
    if (p && p < myargc-1)
        nowait = atoi(myargv[p+1]);
    p = M_CheckParm("-fixedratio");
    if (p && p < myargc-1)
        fixedratio = atoi(myargv[p+1]);
    p = M_CheckParm("-fovy");
    if (p && p < myargc-1)
        fovy = atoi(myargv[p+1]);
    p = M_CheckParm("-orgaspect");
    if (p && p < myargc-1)
        orgaspect = atoi(myargv[p+1]);
    p = M_CheckParm("-nobob");
    if (p && p < myargc-1)
        nobob = atoi(myargv[p+1]);

    p = M_CheckParm("-width");
    if (p && p < myargc-1)
        screenwidth = atoi(myargv[p+1]);
    p = M_CheckParm("-height");
    if (p && p < myargc-1)
        screenheight = atoi(myargv[p+1]);

    if (!screenwidth || !screenheight)
    {
        screenwidth = cxscreen;
        screenheight = cyscreen;
    }

    if (screenwidth != cxscreen || screenheight != cyscreen)
    {
        DEVMODE devmode;
        LONG ret;

	    devmode.dmFields = DM_PELSWIDTH | DM_PELSHEIGHT;
	    devmode.dmPelsWidth = screenwidth;
	    devmode.dmPelsHeight = screenheight;
	    devmode.dmSize = sizeof(devmode);

	    ret = ChangeDisplaySettings(&devmode, CDS_FULLSCREEN); // @Platform SDK Q
        if (ret != DISP_CHANGE_SUCCESSFUL)
            I_Error("ChangeDisplaySettings() failed");

        dispchange = TRUE;
    }

	wndclass.style = CS_HREDRAW | CS_VREDRAW | CS_OWNDC;
	wndclass.lpfnWndProc = WndProc;
	wndclass.cbClsExtra = 0;
	wndclass.cbWndExtra = 0;
	wndclass.hInstance = hInstance;
	wndclass.hIcon = (HICON)LoadImage(hInstance, MAKEINTRESOURCE(0), IMAGE_ICON, 0, 0, 0)/*LoadIcon(hInstance, "sposa1")*/;
	wndclass.hCursor = LoadCursor(NULL, IDC_ARROW);
	wndclass.hbrBackground = (HBRUSH)GetStockObject(BLACK_BRUSH);
	wndclass.lpszMenuName = NULL;
	wndclass.lpszClassName = szAppName;

	RegisterClass(&wndclass);

	hwnd = CreateWindow(szAppName,
	                    szAppName,
	                    WS_POPUP | WS_VISIBLE,
	                    0,
	                    0,
	                    screenwidth,
	                    screenheight,
	                    NULL,
	                    NULL,
	                    hInstance,
	                    NULL);

    DM_Init(hwnd);
    InitGdiplus();

	ShowCursor(FALSE);
	hDC = GetDC(hwnd);
	hMainWnd = hwnd;
	D_DoomMain ();

	while (1)
	{
		if (PeekMessage(&msg, NULL, 0, 0, PM_REMOVE))
		{
			if (msg.message == WM_QUIT)
				break;

			DispatchMessage(&msg);
		} else
			D_DoomLoop();
	}

    ShutdownGdiplus();
    DM_Shutdown();

    if (dispchange)
        ChangeDisplaySettings(NULL, 0);

	return msg.wParam;
}

#include "dialog.h"

//char            szFilter[32];
char            szFile[1024];
char            szFileTitle[256];
OPENFILENAME    ofn;

void SetupOFN(HWND owner, char* filter, char* defext, char* title)
{
    //strcpy(szFilter, filter); // @tB^[̕ɂ̓k؂ƂĎĝstrn̊֐͎gȂ
    szFile[0] = 0;
    szFileTitle[0] = 0;
    ZeroMemory(&ofn, sizeof(OPENFILENAME));
    ofn.lStructSize = sizeof(OPENFILENAME);
	ofn.hwndOwner = owner;
    ofn.lpstrFilter = defext=="lmp" ? "ft@C {*.lmp}\0*.lmp\0\0" : "ׂẴt@C {*.*}\0*.*\0\0";
	ofn.lpstrFile = szFile;
	ofn.nMaxFile = 1024;
    ofn.lpstrFileTitle = szFileTitle;
	ofn.nMaxFileTitle = 256;
	ofn.lpstrDefExt = defext;
    ofn.lpstrTitle = title;
	ofn.Flags = OFN_HIDEREADONLY | OFN_NOCHANGEDIR;
}

BOOL CheckInput(char* str) // @͂܂͋󔒕ȂFALSEԂ
{
    char* c;

    c = &str[0];
    while (*c)
    {
        if (*c != ' ' && *c != '\t')
            return TRUE;
        c++;
    }

    return FALSE;
}

char* skillnames[] =
{
    "I'm Too Young To Die.", "Hey, Not Too Rough.", "Hurt Me Plenty.", "Ultra-Violence.", "Nightmare!"
};

char* d2mapnames[] =
{
    "MAP01", "MAP02", "MAP03", "MAP04", "MAP05", "MAP06", "MAP07", "MAP08",
    "MAP09", "MAP10", "MAP11", "MAP12", "MAP13", "MAP14", "MAP15", "MAP16",
    "MAP17", "MAP18", "MAP19", "MAP20", "MAP21", "MAP22", "MAP23", "MAP24",
    "MAP25", "MAP26", "MAP27", "MAP28", "MAP29", "MAP30", "MAP31", "MAP32"
};

char* udmapnames[] =
{
    "E1M1", "E1M2", "E1M3", "E1M4", "E1M5", "E1M6", "E1M7", "E1M8", "E1M9",
    "E2M1", "E2M2", "E2M3", "E2M4", "E2M5", "E2M6", "E2M7", "E2M8", "E2M9",
    "E3M1", "E3M2", "E3M3", "E3M4", "E3M5", "E3M6", "E3M7", "E3M8", "E3M9",
    "E4M1", "E4M2", "E4M3", "E4M4", "E4M5", "E4M6", "E4M7", "E4M8", "E4M9"
};

GameMode_t AddMapStrings(HWND hDropDownList)
{
    GameMode_t  mode;
    int         i;

    SendMessage(hDropDownList, CB_RESETCONTENT, 0, 0);

    if (!strcmp(iwadfile, "doom2.wad"))
        mode = commercial;
    if (!strcmp(iwadfile, "plutonia.wad"))
        mode = commercial;
    if (!strcmp(iwadfile, "tnt.wad"))
        mode = commercial;
    if (!strcmp(iwadfile, "doomu.wad"))
        mode = retail;
    if (!strcmp(iwadfile, "doom.wad"))
        mode = registered;
    if (!strcmp(iwadfile, "doom1.wad"))
        mode = shareware;

    switch (mode)
    {
    case commercial:
        for (i=0 ; i<32 ; i++)
            SendMessage(hDropDownList, CB_ADDSTRING, 0, (LPARAM)d2mapnames[i]);
        break;

    case retail:
        for (i=0 ; i<36 ; i++)
            SendMessage(hDropDownList, CB_ADDSTRING, 0, (LPARAM)udmapnames[i]);
        break;

    case registered:
        for (i=0 ; i<27 ; i++)
            SendMessage(hDropDownList, CB_ADDSTRING, 0, (LPARAM)udmapnames[i]);
        break;

    case shareware:
        for (i=0 ; i<9 ; i++)
            SendMessage(hDropDownList, CB_ADDSTRING, 0, (LPARAM)udmapnames[i]);
        break;
    }

    SendMessage(hDropDownList, CB_SETCURSEL, 0, 0);

    return mode;
}

void AddSkillStrings(HWND hDropDownList)
{
    int i;

    SendMessage(hDropDownList, CB_RESETCONTENT, 0, 0);

    for (i=0 ; i<5 ; i++)
        SendMessage(hDropDownList, CB_ADDSTRING, 0, (LPARAM)skillnames[i]);

    SendMessage(hDropDownList, CB_SETCURSEL, 0, 0);
}

BOOL CALLBACK WarpDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    RECT                rect;
    int                 w, h;
    static HWND         hDropDownList1, hDropDownList2;
    int                 i;
    static GameMode_t   mode;
    char                buf[4];

    switch (message)
    {
    case WM_INITDIALOG:
        GetWindowRect(hDlg, &rect);
        w = rect.right - rect.left;
        h = rect.bottom - rect.top;
        MoveWindow(hDlg, (cxscreen - w)/2, (cyscreen - h)/2, w, h, TRUE);
        hDropDownList1 = GetDlgItem(hDlg, IDC_DROPDOWNLIST1);
        mode = AddMapStrings(hDropDownList1);
        hDropDownList2 = GetDlgItem(hDlg, IDC_DROPDOWNLIST2);
        AddSkillStrings(hDropDownList2);
        return TRUE;

    case WM_COMMAND:
        switch(LOWORD(wParam))
        {
        case IDOK:
            i = SendMessage(hDropDownList1, CB_GETCURSEL, 0, 0);
            AddParam("-warp");
            if (mode == commercial)
            {
                _itoa(i+1, buf, 10);
                AddParam(buf);
            }
            else
            {
                _itoa((i/9)+1, buf, 10);
                AddParam(buf);
                _itoa((i%9)+1, buf, 10);
                AddParam(buf);
            }
            i = SendMessage(hDropDownList2, CB_GETCURSEL, 0, 0);
            AddParam("-skill");
            _itoa(i+1, buf, 10);
            AddParam(buf);
            EndDialog(hDlg, 0);
            return TRUE;

        case IDCANCEL:
            EndDialog(hDlg, 1);
            return TRUE;
        }
        break;
    }

    return FALSE;
}

BOOL CALLBACK PlayDemoDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    RECT    rect;
    int     w, h;
    char    buf[256];
    int     i;

    switch (message)
    {
    case WM_INITDIALOG:
        GetWindowRect(hDlg, &rect);
        w = rect.right - rect.left;
        h = rect.bottom - rect.top;
        MoveWindow(hDlg, (cxscreen - w)/2, (cyscreen - h)/2, w, h, TRUE);
        return TRUE;

    case WM_COMMAND:
        switch(LOWORD(wParam))
        {
        case IDC_PUSHBUTTON1:
            SetupOFN(hDlg, "ft@C {*.lmp}\0*.lmp\0\0", "lmp", "ft@CI");
            if (GetOpenFileName(&ofn))
                SetDlgItemText(hDlg, IDC_EDITBOX1, szFile);
            return TRUE;

        case IDOK:
            GetDlgItemText(hDlg, IDC_EDITBOX1, buf, 256);
            if (CheckInput(buf))
            {
                AddParam("-playdemo");
                i = strlen(buf);
                if (i>4 && buf[i-4] == '.')
                    buf[i-4] = 0;
                AddParam(buf);
            }
            else
            {
                MessageBox(NULL, "ft@Cw肳Ă܂B", "GLDoom2007", MB_ICONERROR);
                return TRUE;
            }
            EndDialog(hDlg, 0);
            return TRUE;

        case IDCANCEL:
            EndDialog(hDlg, 1);
            return TRUE;
        }
        break;
    }

    return FALSE;
}

BOOL CALLBACK RecordDemoDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    RECT                rect;
    int                 w, h;
    static HWND         hDropDownList1, hDropDownList2;
    int                 i;
    static GameMode_t   mode;
    char                buf[256];

    switch (message)
    {
    case WM_INITDIALOG:
        GetWindowRect(hDlg, &rect);
        w = rect.right - rect.left;
        h = rect.bottom - rect.top;
        MoveWindow(hDlg, (cxscreen - w)/2, (cyscreen - h)/2, w, h, TRUE);
        hDropDownList1 = GetDlgItem(hDlg, IDC_DROPDOWNLIST1);
        mode = AddMapStrings(hDropDownList1);
        hDropDownList2 = GetDlgItem(hDlg, IDC_DROPDOWNLIST2);
        AddSkillStrings(hDropDownList2);
        return TRUE;

    case WM_COMMAND:
        switch(LOWORD(wParam))
        {
        case IDOK:
            GetDlgItemText(hDlg, IDC_EDITBOX1, buf, 256);
            if (CheckInput(buf))
            {
                AddParam("-record");
                i = strlen(buf);
                if (i>4 && buf[i-4] == '.')
                    buf[i-4] = 0;
                AddParam(buf);
            }
            else
            {
                MessageBox(NULL, "ft@Cw肳Ă܂B", "GLDoom2007", MB_ICONERROR);
                return TRUE;
            }
            i = SendMessage(hDropDownList1, CB_GETCURSEL, 0, 0);
            AddParam("-warp");
            if (mode == commercial)
            {
                _itoa(i+1, buf, 10);
                AddParam(buf);
            }
            else
            {
                _itoa((i/9)+1, buf, 10);
                AddParam(buf);
                _itoa((i%9)+1, buf, 10);
                AddParam(buf);
            }
            i = SendMessage(hDropDownList2, CB_GETCURSEL, 0, 0);
            AddParam("-skill");
            _itoa(i+1, buf, 10);
            AddParam(buf);
            EndDialog(hDlg, 0);
            return TRUE;

        case IDCANCEL:
            EndDialog(hDlg, 1);
            return TRUE;
        }
        break;
    }

    return FALSE;
}

void SetupListBox(HWND hListBox)
{
    if (!_access("doom2.wad", 0))
        SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)"doom2.wad");
    if (!_access("plutonia.wad", 0))
        SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)"plutonia.wad");
    if (!_access("tnt.wad", 0))
        SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)"tnt.wad");
    if (!_access("doomu.wad", 0))
        SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)"doomu.wad");
    if (!_access("doom.wad", 0))
        SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)"doom.wad");
    if (!_access("doom1.wad", 0))
        SendMessage(hListBox, LB_ADDSTRING, 0, (LPARAM)"doom1.wad");
}

extern int  texfilter;
extern int  shadow;
extern int  zlighton;
extern int  texborder;

BOOL CALLBACK StartupDlgProc(HWND hDlg, UINT message, WPARAM wParam, LPARAM lParam)
{
    RECT        rect;
    int         w, h;
    static HWND hListBox;
    int         i;
    char        buf[256];
    BOOL        bFileSwitch = FALSE;

    switch (message)
    {
    case WM_INITDIALOG:
        GetWindowRect(hDlg, &rect);
        w = rect.right - rect.left;
        h = rect.bottom - rect.top;
        MoveWindow(hDlg, (cxscreen - w)/2, (cyscreen - h)/2, w, h, TRUE);
        hListBox = GetDlgItem(hDlg, IDC_LISTBOX);
        SetupListBox(hListBox);
        if (!SendMessage(hListBox, LB_GETCOUNT, 0, 0))
        {
            MessageBox(NULL, "IWAD܂łBvOI܂B", "GLDoom2007", MB_ICONERROR);
            EndDialog(hDlg, 1);
            return TRUE;
        }
        SendMessage(hListBox, LB_SETCURSEL, 0, 0);
        CheckDlgButton(hDlg, IDC_CHECKBOX1, texfilter);
        CheckDlgButton(hDlg, IDC_CHECKBOX2, fixedratio);
        CheckDlgButton(hDlg, IDC_CHECKBOX3, !nobob);
        CheckDlgButton(hDlg, IDC_CHECKBOX4, shadow);
        CheckDlgButton(hDlg, IDC_CHECKBOX5, zlighton);
        CheckDlgButton(hDlg, IDC_CHECKBOX6, texborder);
        return TRUE;

    case WM_COMMAND:
        switch(LOWORD(wParam))
        {
        case IDC_PUSHBUTTON1:
            SetupOFN(hDlg, "ׂẴt@C {*.*}\0*.*\0\0", "", "ǉt@C1");
            if (GetOpenFileName(&ofn))
                SetDlgItemText(hDlg, IDC_EDITBOX1, szFile);
            return TRUE;

        case IDC_PUSHBUTTON2:
            SetupOFN(hDlg, "ׂẴt@C {*.*}\0*.*\0\0", "", "ǉt@C2");
            if (GetOpenFileName(&ofn))
                SetDlgItemText(hDlg, IDC_EDITBOX2, szFile);
            return TRUE;

        case IDC_PUSHBUTTON3:
            SetupOFN(hDlg, "ׂẴt@C {*.*}\0*.*\0\0", "", "ǉt@C3");
            if (GetOpenFileName(&ofn))
                SetDlgItemText(hDlg, IDC_EDITBOX3, szFile);
            return TRUE;

        case IDC_PUSHBUTTON4:
            i = SendMessage(hListBox, LB_GETCURSEL, 0, 0);
            SendMessage(hListBox, LB_GETTEXT, i, (LPARAM)iwadfile);
            if (!DialogBox(hInst, "warpdialog", hDlg, (DLGPROC)WarpDlgProc))
                SendMessage(hDlg, WM_COMMAND, IDOK, 0);
            return TRUE;

        case IDC_PUSHBUTTON5:
            i = SendMessage(hListBox, LB_GETCURSEL, 0, 0);
            SendMessage(hListBox, LB_GETTEXT, i, (LPARAM)iwadfile);
            if (!DialogBox(hInst, "playdemodialog", hDlg, (DLGPROC)PlayDemoDlgProc))
                SendMessage(hDlg, WM_COMMAND, IDOK, 0);
            return TRUE;

        case IDC_PUSHBUTTON6:
            i = SendMessage(hListBox, LB_GETCURSEL, 0, 0);
            SendMessage(hListBox, LB_GETTEXT, i, (LPARAM)iwadfile);
            if (!DialogBox(hInst, "recorddemodialog", hDlg, (DLGPROC)RecordDemoDlgProc))
                SendMessage(hDlg, WM_COMMAND, IDOK, 0);
            return TRUE;

        case IDOK:
            i = SendMessage(hListBox, LB_GETCURSEL, 0, 0);
            SendMessage(hListBox, LB_GETTEXT, i, (LPARAM)iwadfile);
            GetDlgItemText(hDlg, IDC_EDITBOX1, buf, 256);
            if (CheckInput(buf))
            {
                AddParam("-file");
                AddParam(buf);
                bFileSwitch = TRUE;
            }
            GetDlgItemText(hDlg, IDC_EDITBOX2, buf, 256);
            if (CheckInput(buf))
            {
                if (!bFileSwitch)
                {
                    AddParam("-file");
                    bFileSwitch = TRUE;
                }
                AddParam(buf);
            }
            GetDlgItemText(hDlg, IDC_EDITBOX3, buf, 256);
            if (CheckInput(buf))
            {
                if (!bFileSwitch)
                    AddParam("-file");
                AddParam(buf);
            }
            texfilter = IsDlgButtonChecked(hDlg, IDC_CHECKBOX1);
            fixedratio = IsDlgButtonChecked(hDlg, IDC_CHECKBOX2);
            nobob = !IsDlgButtonChecked(hDlg, IDC_CHECKBOX3);
            shadow = IsDlgButtonChecked(hDlg, IDC_CHECKBOX4);
            zlighton = IsDlgButtonChecked(hDlg, IDC_CHECKBOX5);
            texborder = IsDlgButtonChecked(hDlg, IDC_CHECKBOX6);
            EndDialog(hDlg, 0);
            return TRUE;

        case IDCANCEL:
            EndDialog(hDlg, 1); // @EndDialog()̑DialogBox()̖߂lɂȂ
            return TRUE;
        }
        break;
    }

    return FALSE;
}
