#include <windows.h>
#include <stdio.h>
#include <io.h>
#include "i_sound.h"
#include "w_wad.h"
#include "z_zone.h"
#include "i_system.h"
#include "music.h"
#include "dm_lib.h"

#define	WAV_BUFFERS	64
#define	WAV_MASK    63

HWAVEOUT    hWaveOut; 
HANDLE		hData;
HPSTR		lpData;
HGLOBAL		hWaveHdr;
LPWAVEHDR	lpWaveHdr;

#define SAMPLECOUNT		256//512
#define NUM_CHANNELS    16//8
#define BUFMUL          4
#define MIXBUFFERSIZE   (SAMPLECOUNT*BUFMUL)

int 		lengths[NUMSFX];

unsigned char*	channels[NUM_CHANNELS];
unsigned char*	channelsend[NUM_CHANNELS];
int             channelstart[NUM_CHANNELS];
int		        channelids[NUM_CHANNELS];
void*           channelorigins[NUM_CHANNELS]; // @WinDoom2005ŕtz

int		    vol_lookup[128*256];
int*		channelleftvol_lookup[NUM_CHANNELS];
int*		channelrightvol_lookup[NUM_CHANNELS];

void*
getsfx
( char*         sfxname,
  int*          len )
{
    unsigned char*      sfx;
    unsigned char*      paddedsfx;
    int                 i;
    int                 size;
    int                 paddedsize;
    char                name[20];
    int                 sfxlump;

    sprintf(name, "ds%s", sfxname);

    if ( W_CheckNumForName(name) == -1 )
        { sfxlump = W_GetNumForName("dspistol"); /*I_Debug("sfx not found: %s\n", name);*/ }
    else
        sfxlump = W_GetNumForName(name);
    
    size = W_LumpLength( sfxlump );

    sfx = (unsigned char*)W_CacheLumpNum( sfxlump, PU_STATIC );

    // @DS* lump̍ŏ8oCg̓Tv[gTv̏񂪏ꂽwb_
    paddedsize = ((size-8 + (SAMPLECOUNT-1)) / SAMPLECOUNT) * SAMPLECOUNT;

    paddedsfx = (unsigned char*)Z_Malloc( paddedsize+8, PU_STATIC, 0 );

    memcpy(  paddedsfx, sfx, size );
    for (i=size ; i<paddedsize+8 ; i++)
        paddedsfx[i] = 128;

    Z_Free( sfx );

    *len = paddedsize;

    return (void *)(paddedsfx + 8);
}

void//int
addsfx
( int		sfxid,
  int		volume,
  int		step,
  int		seperation,
  void*     origin )
{
    int     i;
    int		oldest = gametic;
    int		oldestnum = 0;
    int		slot;
    int		rightvol;
    int		leftvol;

    // Play these sound effects only one at a time.
    if ( sfxid == sfx_sawup
	 || sfxid == sfx_sawidl
	 || sfxid == sfx_sawful
	 || sfxid == sfx_sawhit
	 || sfxid == sfx_stnmov
	 || sfxid == sfx_pistol	 )
    {
	// Loop all channels, check.
	for (i=0 ; i<NUM_CHANNELS ; i++)
	{
	    // Active, and using the same SFX?
	    if ( (channels[i])
		 && (channelids[i] == sfxid) )
	    {
		// Reset.
		channels[i] = 0;
		// We are sure that iff,
		//  there will only be one.
		break;
	    }
	}
    }

    // Loop all channels to find oldest SFX. @channelꍇiNUM_CHANNELS܂ōsȂ
    for (i=0; (i<NUM_CHANNELS) && (channels[i]); i++)
    {
	if (channelstart[i] < oldest)
	{
	    oldestnum = i;
	    oldest = channelstart[i];
	}
    }

    if (i == NUM_CHANNELS)
	    slot = oldestnum;
    else
	    slot = i;

    channels[slot] = (unsigned char *)S_sfx[sfxid].data;
    channelsend[slot] = channels[slot] + lengths[sfxid];
    channelstart[slot] = gametic;
    channelorigins[slot] = origin;

    seperation += 1;            // range is: 1 - 256
    volume = (volume+1)*8 - 1;  // @volume0-15͈̔͂ɂȂĂ̂0-127͈̔͂Ɋg傷

    leftvol = volume - ((volume*seperation*seperation) >> 16); // @>>16/(256*256)Ɠ
    seperation = seperation - 257;
    rightvol = volume - ((volume*seperation*seperation) >> 16);

    // Sanity check, clamp volume.
    if (rightvol < 0 || rightvol > 127)
	    I_Error("rightvol out of bounds");
    if (leftvol < 0 || leftvol > 127)
	    I_Error("leftvol out of bounds");
    
    // Get the proper lookup table piece
    //  for this volume level???
    channelleftvol_lookup[slot] = &vol_lookup[leftvol*256];
    channelrightvol_lookup[slot] = &vol_lookup[rightvol*256];

    // Preserve sound SFX id,
    //  e.g. for avoiding duplicates of chainsaw.
    channelids[slot] = sfxid;
}

void I_SetChannels() // @S_Init()Ă΂
{
    int		i;
    int		j;

    for (i=0 ; i<NUM_CHANNELS ; i++)
        channels[i] = 0;

    // @-32768+32767̒l256̂i/127(i=0,..,127)ɃXP[āA128iK̃{[ɑΉunsigned charsigned short ւ̕ϊe[u
    for (i=0 ; i<128 ; i++)
        for (j=0 ; j<256 ; j++)
            vol_lookup[i*256+j] = (i*(j-128)*256)/127;
}

void I_StartSound(int id, int vol, int sep, int pitch, int priority, void *origin)
{
    addsfx(id, vol, 0/*steptable[pitch]*/, sep, origin);
}

void I_StopSound(void* origin)
{
    int i;

    for (i=0 ; i<NUM_CHANNELS ; i++)
    {
        if (channelorigins[i] == origin && channels[i] != 0)
            channels[i] = 0;
    }
}

void I_StopAllSound(void) // @WinDoom2005ŕt֐
{
    int i;

    for (i=0 ; i<NUM_CHANNELS ; i++)
        if (channels[i])
            channels[i] = 0;
}

int             snd_count;
unsigned int    snd_sent, snd_completed;

void I_UpdateSound( void )
{
    register unsigned int   sample;
    register int		    dl;
    register int		    dr;
    signed short*		    leftout;
    signed short*		    rightout;
    signed short*		    leftend;
    int				        step = 2;
    int				        chan;

    short*                  mixbuffer;
    int                     index;

    snd_count = 0;
    while (1)
    {
        if (snd_completed == snd_sent)
            break;

        index = snd_completed & WAV_MASK;

        if (!(lpWaveHdr[index].dwFlags & WHDR_DONE))
            break;

        index = (index + 8) & WAV_MASK; // @index(index+8)̊ԂɍĐ̃obt@
        mixbuffer = (short *)(lpData + index*MIXBUFFERSIZE);

        leftout = mixbuffer;
        rightout = mixbuffer+1;
        // Determine end, for left channel only
        //  (right channel is implicit).
        leftend = mixbuffer + SAMPLECOUNT*step;

        while (leftout != leftend)
        {
            dl = 0;
	        dr = 0;

            for (chan=0 ; chan<NUM_CHANNELS ; chan++)
            {
                if (channels[chan])
                {
                    sample = *channels[chan];
                    dl += channelleftvol_lookup[chan][sample];
		            dr += channelrightvol_lookup[chan][sample];

                    channels[chan]++;
                    // Check whether we are done.
		            if (channels[chan] >= channelsend[chan])
		                channels[chan] = 0;
                }
            }

            if (dl > 0x7fff)
	            *leftout = 0x7fff;
	        else if (dl < -0x8000)
	            *leftout = -0x8000;
	        else
	            *leftout = dl;

            if (dr > 0x7fff)
	            *rightout = 0x7fff;
	        else if (dr < -0x8000)
	            *rightout = -0x8000;
	        else
	            *rightout = dr;

            leftout += step;
	        rightout += step;
        }

        snd_completed++;
        snd_count++;
    }
}

void
I_SubmitSound(void)
{
    int         i;
    LPWAVEHDR   h;

    for (i=0 ; i<snd_count ; i++)
	{
		h = lpWaveHdr + (snd_sent & WAV_MASK);
		
		/* 
		 * Now the data block can be sent to the output device. The 
		 * waveOutWrite function returns immediately and waveform 
		 * data is sent to the output device in the background. 
		 */ 
		waveOutWrite(hWaveOut, h, sizeof(WAVEHDR));

        snd_sent++;
	}
}

void I_ShutdownSound(void)
{
    int i;

    if (hWaveOut)
	{
		waveOutReset(hWaveOut);

		if (lpWaveHdr)
		{
			for (i=0 ; i<WAV_BUFFERS ; i++)
				waveOutUnprepareHeader(hWaveOut, lpWaveHdr+i, sizeof(WAVEHDR));
		}

		waveOutClose(hWaveOut);

		if (hWaveHdr)
		{
			GlobalUnlock(hWaveHdr); 
			GlobalFree(hWaveHdr);
		}

		if (hData)
		{
			GlobalUnlock(hData);
			GlobalFree(hData);
		}

        hWaveOut = NULL;
	}
}

void
I_InitSound()
{
    WAVEFORMATEX    format; 
	int			    i;

	format.wFormatTag = WAVE_FORMAT_PCM;
	format.nChannels = 2;
    format.nSamplesPerSec = 11025;
    format.wBitsPerSample = 16;
    format.nBlockAlign = format.nChannels * format.wBitsPerSample / 8;
    format.nAvgBytesPerSec = format.nSamplesPerSec * format.nBlockAlign; 
 	format.cbSize = 0;

    waveOutOpen((LPHWAVEOUT)&hWaveOut, WAVE_MAPPER, &format, 0, 0L, CALLBACK_NULL);
	
	// Allocate and lock memory for the waveform data. The memory 
	// for waveform data must be globally allocated with 
	// GMEM_MOVEABLE and GMEM_SHARE flags. 
	hData = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, WAV_BUFFERS*MIXBUFFERSIZE); 
	lpData = GlobalLock(hData);
	memset(lpData, 0, WAV_BUFFERS*MIXBUFFERSIZE);
	 
	// Allocate and lock memory for the header. This memory must 
	// also be globally allocated with GMEM_MOVEABLE and 
	// GMEM_SHARE flags. 
	hWaveHdr = GlobalAlloc(GMEM_MOVEABLE | GMEM_SHARE, (DWORD)sizeof(WAVEHDR)*WAV_BUFFERS); 
	lpWaveHdr = (LPWAVEHDR)GlobalLock(hWaveHdr); 
	memset(lpWaveHdr, 0, sizeof(WAVEHDR)*WAV_BUFFERS);

	// After allocation, set up and prepare headers.  
	for (i=0 ; i<WAV_BUFFERS ; i++)
	{
		lpWaveHdr[i].dwBufferLength = MIXBUFFERSIZE; 
		lpWaveHdr[i].lpData = lpData + i*MIXBUFFERSIZE;

        waveOutPrepareHeader(hWaveOut, lpWaveHdr+i, sizeof(WAVEHDR));
	}

    snd_count = 8;
    I_SubmitSound();

    for (i=1 ; i<NUMSFX ; i++)
  { 
    // Alias? Example is the chaingun sound linked to pistol.
    if (!S_sfx[i].link)
    {
      // Load data from WAD file.
      S_sfx[i].data = getsfx( S_sfx[i].name, &lengths[i] );
    }	
    else
    {
      // Previously loaded already?
      S_sfx[i].data = S_sfx[i].link->data;
      lengths[i] = lengths[(S_sfx[i].link - S_sfx)/*/sizeof(sfxinfo_t)*/];
    }
  }
}

char midifile[] = "tempmidi.mid";
extern int  replay;

void S_StopMusic(void);

void I_ShutdownMusic(void)	
{
    S_StopMusic();

    if (!access(midifile, 0))
		remove(midifile);
}

unsigned long SwapLONG( unsigned long x);

#if 0
void I_PlaySong(musicinfo_t* music/*int handle*/, int looping)
{
    byte*   midbuf;
    int     size, tics;
    FILE*   fp;
    int     id4 = 0x6468544D; // "MThd"
    byte*   middata = NULL;
    int     trackLen;

    if (*(int*)music->data == id4)
    {   // @uWindowsTEhvO~Ov23.5 VXeGNXN[VuCxg Q
        middata = music->data;
        size = W_LumpLength(music->lumpnum);
        midbuf = malloc(size+10);
        memcpy(midbuf, middata, 22);
        memcpy(&midbuf[32], &middata[22], size-22);
        midbuf[22] = 0;
        midbuf[23] = 0xF0;
        midbuf[24] = 7;
        midbuf[25] = 0x7F;
        midbuf[26] = 0x7F;
        midbuf[27] = 4;
        midbuf[28] = 1;
        midbuf[29] = 0;
        midbuf[30] = (byte)(snd_MusicVolume*127/15);
        midbuf[31] = 0xF7;
        size += 10;
        trackLen = SwapLONG(*((unsigned long *)&midbuf[18])) + 10;
        midbuf[18] = (byte)((trackLen>>24)&255);
        midbuf[19] = (byte)((trackLen>>16)&255);
        midbuf[20] = (byte)((trackLen>>8)&255);
        midbuf[21] = (byte)(trackLen&255);
    }
    else
        size = MusToMidi(music->data, &midbuf, &tics);

	fp = fopen(midifile, "wb");
    fwrite(midbuf, 1, size, fp);
    fclose(fp);

    free(midbuf);

    PlayMidi(midifile);
    replay = looping;
}
#endif

#include <mmreg.h>

// @ȉMPAHeaderInfo\[XMPAHeader.cpp甲
const DWORD dwBitRates[2][3][15] =
{
	{	// MPEG 1
		{0,32,64,96,128,160,192,224,256,288,320,352,384,416,448,},	// Layer1
		{0,32,48,56, 64, 80, 96,112,128,160,192,224,256,320,384,},	// Layer2
		{0,32,40,48, 56, 64, 80, 96,112,128,160,192,224,256,320,}	// Layer3
	},
	{	// MPEG 2, 2.5		
		{0,32,48,56,64,80,96,112,128,144,160,176,192,224,256,},		// Layer1
		{0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,},			// Layer2
		{0,8,16,24,32,40,48,56,64,80,96,112,128,144,160,}			// Layer3
	}
};
const DWORD dwSamplingRates[4][3] = 
{ 
	{11025, 12000, 8000,  },	// MPEG 2.5
	{0,     0,     0,     },	// reserved
	{22050, 24000, 16000, },	// MPEG 2
	{44100, 48000, 32000  }		// MPEG 1
};

void I_PlaySong(musicinfo_t* music, int looping)
{
    int     idmus = 0x1A53554D; // "MUS"0x1A
    int     idsmf = 0x6468544D; // "MThd"
    int     idwav = 0x46464952; // "RIFF"
    byte*   buf = NULL;
    int     size, tics;
    byte*   src;
    int     tagver = 0;
    int     mpgver;
    int     layer;
    int     bitrate;
    int     samplerate;
    int     padding;
    int     channel;
    DWORD   dword;
    WORD    word;

    DM_UnloadMusic();

    if (*(int*)music->data == idmus)
        size = MusToMidi(music->data, &buf, &tics);
    else if (*(int*)music->data == idsmf)
    {
        size = W_LumpLength(music->lumpnum);
        buf = malloc(size);
	    memcpy(buf, music->data, size);
    }

    if (buf)
    {
        if (DM_LoadSMF(buf, size))
            DM_PlayMusic(looping);
        return;
    }

    if (*(int*)music->data == idwav)
    {
        size = W_LumpLength(music->lumpnum);
        buf = malloc(size);
	    memcpy(buf, music->data, size);
        if (DM_LoadWAV(buf, size))
            DM_PlayMusic(looping);
        return;
    }

    src = (byte*)music->data;
    size = W_LumpLength(music->lumpnum);

    if (src[size-128] == 'T' && src[size-127] == 'A' && src[size-126] == 'G')
    {
        size -= 128;
        tagver = 1;
    }
    if (src[0] == 'I' && src[1] == 'D' && src[2] == '3')
    {
        int tagsize = ((src[6] << 21) | (src[7] << 14) | (src[8] << 7) | (src[9])) + 10;
        size -= tagsize;
        src += tagsize;
        tagver += 2;
    }
    if (!tagver)
        return;
    if (!(src[0] == 0xFF && (src[1]>>5) == 0x07))
        return;
    if (src[1] & 0x10 && src[1] & 0x08)
        mpgver = 10;
    else if (src[1] & 0x10)
        mpgver = 20;
    else if (!(src[1] & 0x08))
        mpgver = 25;
    else
        return;
    switch (src[1] >> 1 & 0x03)
    {
    case 1:
        layer = 3;
        break;
    case 2:
        layer = 2;
        break;
    case 3:
        layer = 1;
        break;
    default:
        return;
    }
    bitrate = dwBitRates[mpgver/10-1][layer-1][src[2]>>4];
    samplerate = dwSamplingRates[(src[1]>>3)&0x03][(src[2]>>2)&0x03];
    padding = src[2] >> 1 & 0x01;
	channel = (src[3] >> 6) == 3 ? 1 : 2;
    if (mpgver != 10 || layer != 3)
    {
        //MessageBox(NULL, L"MPEG1 Layer3 ȊOMP3t@C͓ǂ߂܂", szAppName, MB_OK);
        return;
    }

    buf = (byte*)malloc(size + 70);
    memcpy(buf, "RIFF", 4);
    dword = size + 62;
    memcpy(buf+4, &dword, 4);
    memcpy(buf+8, "WAVE", 4);
    memcpy(buf+12, "fmt ", 4);
    dword = 30;
    memcpy(buf+16, &dword, 4);
    word = WAVE_FORMAT_MPEGLAYER3;
    memcpy(buf+20, &word, 2);
    word = channel;
    memcpy(buf+22, &word, 2);
    dword = samplerate;
    memcpy(buf+24, &dword, 4);
    dword = bitrate * 125;
    memcpy(buf+28, &dword, 4);
    word = 1;
    memcpy(buf+32, &word, 2);
    word = 0;
    memcpy(buf+34, &word, 2);
    word = MPEGLAYER3_WFX_EXTRA_BYTES;
    memcpy(buf+36, &word, 2);
    word = MPEGLAYER3_ID_MPEG;
    memcpy(buf+38, &word, 2);
    dword = padding ? MPEGLAYER3_FLAG_PADDING_ON : MPEGLAYER3_FLAG_PADDING_OFF;
    memcpy(buf+40, &dword, 4);
    word = 144 * bitrate * 1000 / samplerate + padding;
    memcpy(buf+44, &word, 2);
    word = 1;
    memcpy(buf+46, &word, 2);
    word = 0;
    memcpy(buf+48, &word, 2);
    memcpy(buf+50, "fact", 4);
    dword = 4;
    memcpy(buf+54, &dword, 4);
    dword = size / (144 * bitrate * 1000 / samplerate + padding) * 1152;
    memcpy(buf+58, &dword, 4);
    memcpy(buf+62, "data", 4);
    dword = size;
    memcpy(buf+66, &dword, 4);
    memcpy(buf+70, src, size);

    if (DM_LoadWAV(buf, size + 70))
        DM_PlayMusic(looping);
}

void I_PauseSong (void/*int handle*/)
{
    //PauseMidi();
    DM_PauseMusic();
}

void I_ResumeSong (void/*int handle*/)
{
    //ResumeMidi();
    DM_ResumeMusic();
}

void I_StopSong(void/*int handle*/)
{
    //StopMidi();
    DM_StopMusic();
}

void I_SetMusicVolume(int volume)
{
    DM_SetMasterVolume(volume);
}
