#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <windows.h>
#include "doomtype.h"
#include "i_system.h"
#include "doomdef.h"
#include "i_video.h"
#include "i_sound.h"
#include "d_main.h"
#include "m_misc.h"

int mb_used = 64/*6*/;

byte* I_ZoneBase(int* size)
{
    *size = mb_used*1024*1024;
    return (byte *)malloc(*size);
}

ticcmd_t	emptycmd;
ticcmd_t* I_BaseTiccmd(void)
{
    return &emptycmd;
}

int  I_GetTime (void)
{/*
    struct timeval	tp;
    struct timezone	tzp;
    int			newtics;
    static int		basetime=0;
  
    gettimeofday(&tp, &tzp);
    if (!basetime)
	basetime = tp.tv_sec;
    newtics = (tp.tv_sec-basetime)*TICRATE + tp.tv_usec*TICRATE/1000000;
    return newtics;
	*/
	int			currtime;
	int			newtics;
	static int	basetime=0;

	currtime = timeGetTime();
    if (!basetime)
       basetime = currtime;
    newtics = (int)((currtime-basetime)*(TICRATE/1000.0f));
    return newtics;
}

void I_Init (void)
{
    I_InitSound();
    I_InitGraphics();
}

extern int gametic;
extern int framecount;

void I_Quit (void)
{
    //D_QuitNetGame ();
    I_ShutdownSound();
    I_ShutdownMusic();
    M_SaveDefaults ();
    I_ShutdownGraphics();
    I_Debug("\ngametic = %d\nframecount = %d\n", gametic, framecount);
    PostQuitMessage(0);
    //exit(0);
}

void I_WaitVBL(int count)
{
    int newtic, oldtic;

    oldtic = I_GetTime();
    while (count--)
    {
        while (1)
        {
            //D_Display();
            newtic = I_GetTime();
            if (newtic > oldtic)
            {
                oldtic = newtic;
                break;
            }
        }
        I_UpdateSound();
        I_SubmitSound();
    }
}

extern int  screenwidth;
extern int  screenheight;
extern int  buttonstate;
int         mousewalk;

// @}EXQUAKE\[X(IN_MouseMove()[in_win.c])Q
void I_StartTic (void)
{
    static int  centerx=0;
    static int  centery=0;
    POINT       currpos;
    int         mx, my;
    event_t     event;

    if (!centerx || !centery)
    {
        centerx = screenwidth/2;
        centery = screenheight/2;
		SetCursorPos(centerx, centery); // @ꂪƁA-warp IvVgɃvC[̏pxĂ܂
    }

    GetCursorPos(&currpos);
    mx = currpos.x - centerx;
    my = centery - currpos.y;

    if (!mousewalk)
        my = 0;

    if (mx || my)
	{
        event.type = ev_mouse;
        event.data1 = buttonstate;
        event.data2 = mx<<2;
        event.data3 = my<<2;
        D_PostEvent(&event);
		SetCursorPos(centerx, centery);
	}
}

int     debugout;
char    debugname[] = "debug.txt";

void I_Debug(char* msg,...)
{
    FILE*	fp;
    va_list	argptr;

    if (!debugout)
        return;
    fp = fopen(debugname, "a");
    va_start(argptr, msg);
    vfprintf(fp, msg, argptr);
    va_end(argptr);
    fclose(fp);
}

void I_Error(char* msg, ...)
{
    FILE*	fp;
    va_list argptr;

    fp = fopen(debugname, "a");
    fprintf(fp, "\nError: ");
    va_start(argptr, msg);
    vfprintf(fp, msg, argptr);
    va_end(argptr);
    fclose(fp);
    //exit(-1);
    I_Quit();
}
