#include <windows.h>
#include <gl\gl.h>
#include "i_system.h"

extern HDC hDC;
HGLRC hRC = NULL;
int	glvers;
extern int screenwidth;
extern int screenheight;
int fixedratio;
int viewportwidth;
byte* capscr;

void I_InitGraphics(void)
{
	int nPixelFormat;
	PIXELFORMATDESCRIPTOR pfd = {
	sizeof(PIXELFORMATDESCRIPTOR),  // Size of this structure
	1,                              // Version of this structure    
	PFD_DRAW_TO_WINDOW |            // Draw to Window (not to bitmap)
	PFD_SUPPORT_OPENGL |		    // Support OpenGL calls in window
	PFD_DOUBLEBUFFER,               // Double buffered
	PFD_TYPE_RGBA,                  // RGBA Color mode
	24,                             // Want 24bit color 
	0,0,0,0,0,0,                    // Not used to select mode
	0,0,                            // Not used to select mode
	0,0,0,0,0,                      // Not used to select mode
	32,                             // Size of depth buffer
	0/*1*/,                         // @cStencilBits
	0,                              // Not used to select mode
	0, // PFD_MAIN_PLANE,           // Draw in main plane
	0,                              // Not used to select mode
	0,0,0 };
    char* glstring;

    BOOL (WINAPI *wglSwapIntervalEXT)(int) = NULL;
	
	nPixelFormat = ChoosePixelFormat(hDC, &pfd);
	SetPixelFormat(hDC, nPixelFormat, &pfd);
	hRC = wglCreateContext(hDC);
	wglMakeCurrent(hDC, hRC);
    if (fixedratio && (screenwidth*3/4 > screenheight))
    {
        viewportwidth = screenheight*4/3;
	    glViewport((screenwidth-viewportwidth)/2, 0, viewportwidth, screenheight);
    }
    else
        viewportwidth = screenwidth;

    glstring = (char *)glGetString(GL_VERSION);
    I_Debug("\nGL_VERSION:\t%s\n", glstring);
    glvers = atoi(glstring); // @擪10ilӖ镔܂łϊ(uANSI C/C++ TvQ)
    glstring = (char *)glGetString(GL_VENDOR);
    I_Debug("GL_VENDOR:\t%s\n", glstring);
    glstring = (char *)glGetString(GL_RENDERER);
    I_Debug("GL_RENDERER:\t%s\n", glstring);

    glstring = (char *)glGetString(GL_EXTENSIONS);
    //glstring = (char *)wglGetExtensionsStringARB();
    //I_Debug("GL_EXTENSIONS:\t%s\n", glstring);
    if (strstr(glstring, "WGL_EXT_swap_control"))
    {
        wglSwapIntervalEXT = (BOOL(WINAPI*)(int))wglGetProcAddress("wglSwapIntervalEXT");
        if(wglSwapIntervalEXT)
        {
            I_Debug("wglSwapIntervalEXT̎擾ɐ");
            wglSwapIntervalEXT(1);
        }
    }

	glEnable(GL_CULL_FACE);
    glEnable(GL_DEPTH_TEST);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_BLEND);
	glBlendFunc(GL_SRC_ALPHA, GL_ONE_MINUS_SRC_ALPHA);
    glEnable(GL_ALPHA_TEST);
    glAlphaFunc(GL_NOTEQUAL, 0);
    //glEnable(GL_STENCIL_TEST);
    //glClearStencil(0); @ftHg

    capscr = malloc(4*screenwidth*screenheight);
    glReadBuffer(GL_FRONT);
}

void I_ShutdownGraphics(void)
{
    if (hRC)
    {
	    wglMakeCurrent(hDC, NULL);
	    wglDeleteContext(hRC);
	    hRC = NULL;
    }
}

void I_FinishUpdate (void)
{
    glFlush(); // @tearing?
	SwapBuffers(hDC);
    //glFinish();
}

//
// I_SetPalette
//
void I_SetPalette (byte* palette)
{
    //UploadNewPalette(X_cmap, palette);
}

void I_ReadScreen(void)
{
    int reducedpitch = viewportwidth/4*4;
    int x = (screenwidth - reducedpitch)/2;

    // @ŏ̓̈̓}jAɂ̓EBhEWɂ鍶̍WƂȂĂ
    glReadPixels(x, 0/*screenheight*/, reducedpitch, screenheight, GL_RGBA, GL_UNSIGNED_BYTE, capscr);
}
